/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.AbstractRedisProcessorCreator;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;

public final class StringsRedisProcessorsCreator
extends AbstractRedisProcessorCreator {
    Map<Command, Processor> getProcessors(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.bind(Command.APPEND, this.wrap(exchange -> redisClient.append(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getStringValue((Exchange)exchange))));
        this.bind(Command.DECR, this.wrap(exchange -> redisClient.decr(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.DECRBY, this.wrap(exchange -> redisClient.decrby(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getLongValue((Exchange)exchange))));
        this.bind(Command.GET, this.wrap(exchange -> redisClient.get(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.GETBIT, this.wrap(exchange -> redisClient.getbit(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getOffset((Exchange)exchange))));
        this.bind(Command.GETRANGE, this.wrap(exchange -> redisClient.getrange(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getStart((Exchange)exchange), exchangeConverter.getEnd((Exchange)exchange))));
        this.bind(Command.GETSET, this.wrap(exchange -> redisClient.getset(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.INCR, this.wrap(exchange -> redisClient.incr(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.INCRBY, this.wrap(exchange -> redisClient.incrby(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getLongValue((Exchange)exchange))));
        this.bind(Command.MGET, this.wrap(exchange -> redisClient.mget(exchangeConverter.getFields((Exchange)exchange))));
        this.bind(Command.MSET, exchange -> redisClient.mset(exchangeConverter.getValuesAsMap(exchange)));
        this.bind(Command.MSETNX, exchange -> redisClient.msetnx(exchangeConverter.getValuesAsMap(exchange)));
        this.bind(Command.SET, exchange -> redisClient.set(exchangeConverter.getKey(exchange), exchangeConverter.getValue(exchange)));
        this.bind(Command.SETBIT, exchange -> redisClient.setbit(exchangeConverter.getKey(exchange), exchangeConverter.getOffset(exchange), exchangeConverter.getBooleanValue(exchange)));
        this.bind(Command.SETEX, exchange -> redisClient.setex(exchangeConverter.getKey(exchange), exchangeConverter.getValue(exchange), exchangeConverter.getTimeout(exchange), TimeUnit.SECONDS));
        this.bind(Command.SETNX, this.wrap(exchange -> redisClient.setnx(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.SETRANGE, exchange -> redisClient.setex(exchangeConverter.getKey(exchange), exchangeConverter.getValue(exchange), exchangeConverter.getOffset(exchange)));
        this.bind(Command.STRLEN, this.wrap(exchange -> redisClient.strlen(exchangeConverter.getKey((Exchange)exchange))));
        return this.result;
    }
}

