/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.AbstractRedisProcessorCreator;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;

public final class KeysRedisProcessorsCreator
extends AbstractRedisProcessorCreator {
    Map<Command, Processor> getProcessors(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.bind(Command.DEL, exchange -> redisClient.del(exchangeConverter.getKeys(exchange)));
        this.bind(Command.EXISTS, this.wrap(exchange -> redisClient.exists(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.EXPIRE, this.wrap(exchange -> redisClient.expire(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getTimeout((Exchange)exchange))));
        this.bind(Command.EXPIREAT, this.wrap(exchange -> redisClient.expireat(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getTimestamp((Exchange)exchange))));
        this.bind(Command.KEYS, this.wrap(exchange -> redisClient.keys(exchangeConverter.getPattern((Exchange)exchange))));
        this.bind(Command.MOVE, this.wrap(exchange -> redisClient.move(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getDb((Exchange)exchange))));
        this.bind(Command.PERSIST, this.wrap(exchange -> redisClient.persist(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.PEXPIRE, this.wrap(exchange -> redisClient.pexpire(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getTimeout((Exchange)exchange))));
        this.bind(Command.PEXPIREAT, this.wrap(exchange -> redisClient.pexpireat(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getTimestamp((Exchange)exchange))));
        this.bind(Command.RANDOMKEY, this.wrap(exchange -> redisClient.randomkey()));
        this.bind(Command.RENAME, exchange -> redisClient.rename(exchangeConverter.getKey(exchange), exchangeConverter.getStringValue(exchange)));
        this.bind(Command.RENAMENX, this.wrap(exchange -> redisClient.renamenx(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getStringValue((Exchange)exchange))));
        this.bind(Command.SORT, this.wrap(exchange -> redisClient.sort(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.TTL, this.wrap(exchange -> redisClient.ttl(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.TYPE, this.wrap(exchange -> redisClient.type(exchangeConverter.getKey((Exchange)exchange))));
        return this.result;
    }
}

