/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

@ManagedResource(description="SpringCache based message id repository")
public class SpringCacheIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private final CacheManager manager;
    private final String cacheName;
    private Cache cache;

    public SpringCacheIdempotentRepository(CacheManager manager, String cacheName) {
        this.manager = manager;
        this.cacheName = cacheName;
        this.cache = null;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        return this.cache.putIfAbsent((Object)key, (Object)true) == null;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.cache.get((Object)key) != null;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cache.evict((Object)key);
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    public boolean confirm(String key) {
        return true;
    }

    protected void doStart() throws Exception {
        if (this.cache == null) {
            this.cache = this.manager.getCache(this.cacheName);
        }
    }

    protected void doStop() throws Exception {
        this.cache = null;
    }
}

