/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.springboot;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.sql.SqlComponent;
import org.apache.camel.component.sql.springboot.SqlComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SqlComponentConfiguration.class})
public class SqlComponentAutoConfiguration {
    @Bean(name={"sql-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={SqlComponent.class})
    public SqlComponent configureSqlComponent(CamelContext camelContext, SqlComponentConfiguration configuration) throws Exception {
        SqlComponent component = new SqlComponent();
        component.setCamelContext(camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Class<?> paramClass = value.getClass();
            if (!paramClass.getName().endsWith("NestedConfiguration")) continue;
            Class nestedClass = null;
            try {
                nestedClass = (Class)paramClass.getDeclaredField("CAMEL_NESTED_CLASS").get(null);
                HashMap nestedParameters = new HashMap();
                IntrospectionSupport.getProperties(value, nestedParameters, null, (boolean)false);
                Object nestedProperty = nestedClass.newInstance();
                IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), nestedProperty, nestedParameters);
                entry.setValue(nestedProperty);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)component, parameters);
        return component;
    }
}

