/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.stored.SqlStoredEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlStoredComponent
extends DefaultComponent {
    private DataSource dataSource;

    protected Endpoint createEndpoint(String uri, String template, Map<String, Object> parameters) throws Exception {
        DataSource target = null;
        DataSource ds = (DataSource)this.resolveAndRemoveReferenceParameter(parameters, "dataSource", DataSource.class);
        if (ds != null) {
            target = ds;
        }
        if (target == null) {
            target = this.dataSource;
        }
        if (target == null) {
            Set dataSources = this.getCamelContext().getRegistry().findByType(DataSource.class);
            if (dataSources.size() > 1) {
                throw new IllegalArgumentException("Multiple DataSources found in the registry and no explicit configuration provided");
            }
            if (dataSources.size() == 1) {
                target = dataSources.stream().findFirst().orElse(null);
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(target);
        SqlStoredEndpoint endpoint = new SqlStoredEndpoint(uri, this, jdbcTemplate);
        endpoint.setTemplate(template);
        return endpoint;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

