/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.function.Suppliers;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW[({].*&&.*[)}]");
    private static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/configurer/";
    private volatile GeneratedPropertyConfigurer componentPropertyConfigurer;
    private volatile GeneratedPropertyConfigurer endpointPropertyConfigurer;
    private final List<Supplier<ComponentExtension>> extensions = new ArrayList<Supplier<ComponentExtension>>();
    private CamelContext camelContext;
    @Metadata(label="advanced", description="Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities")
    private boolean basicPropertyBinding;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        return UnsafeUriCharactersEncoder.encode((String)uri);
    }

    public Endpoint createEndpoint(String uri, Map<String, Object> properties) throws Exception {
        Map parameters;
        org.apache.camel.util.ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String encodedUri = this.preProcessUri(uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        if (properties != null) {
            parameters.putAll(properties);
        }
        parameters.remove("hash");
        this.validateURI(uri, path, parameters);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        boolean basic = this.getAndRemoveParameter(parameters, "basicPropertyBinding", Boolean.TYPE, this.basicPropertyBinding);
        if (endpoint instanceof DefaultEndpoint) {
            ((DefaultEndpoint)endpoint).setBasicPropertyBinding(basic);
        }
        endpoint.configureProperties(parameters);
        if (this.useIntrospectionOnEndpoint()) {
            this.setProperties(endpoint, parameters);
        }
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public Endpoint createEndpoint(String uri) throws Exception {
        Map parameters;
        org.apache.camel.util.ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String encodedUri = this.preProcessUri(uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        URISupport.resolveRawParameterValues((Map)parameters);
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        endpoint.setCamelContext(this.getCamelContext());
        boolean basic = this.getAndRemoveParameter(parameters, "basicPropertyBinding", Boolean.TYPE, this.basicPropertyBinding);
        if (endpoint instanceof DefaultEndpoint) {
            ((DefaultEndpoint)endpoint).setBasicPropertyBinding(basic);
        }
        endpoint.configureProperties(parameters);
        if (this.useIntrospectionOnEndpoint()) {
            this.setProperties(endpoint, parameters);
        }
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public boolean useRawUri() {
        return false;
    }

    public boolean isBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map param = parameters;
        if (optionPrefix != null) {
            param = PropertiesHelper.extractProperties(parameters, (String)optionPrefix);
        }
        if (param.size() > 0) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + param + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Matcher m;
        if (uri.contains("&&") && !(m = RAW_PATTERN.matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    protected void doInit() throws Exception {
        org.apache.camel.spi.annotations.Component ann = (org.apache.camel.spi.annotations.Component)org.apache.camel.util.ObjectHelper.getAnnotation((Object)((Object)this), org.apache.camel.spi.annotations.Component.class);
        if (ann != null) {
            String name = ann.value();
            if (name.contains(",")) {
                name = StringHelper.before((String)name, (String)",");
            }
            try {
                this.log.trace("Discovering optional component property configurer class for component: {}", (Object)name);
                Optional clazz = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH).findOptionalClass(name + "-component", null);
                clazz.ifPresent(c -> {
                    this.componentPropertyConfigurer = ObjectHelper.newInstance(c, GeneratedPropertyConfigurer.class);
                });
                if (this.log.isDebugEnabled() && this.componentPropertyConfigurer != null) {
                    this.log.debug("Discovered component property configurer: {} -> {}", (Object)name, (Object)this.componentPropertyConfigurer);
                }
                this.log.trace("Discovering optional endpoint property configurer class for component: {}", (Object)name);
                clazz = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH).findOptionalClass(name + "-endpoint", null);
                clazz.ifPresent(c -> {
                    this.endpointPropertyConfigurer = ObjectHelper.newInstance(c, GeneratedPropertyConfigurer.class);
                });
                if (this.log.isDebugEnabled() && this.endpointPropertyConfigurer != null) {
                    this.log.debug("Discovered endpoint property configurer: {} -> {}", (Object)name, (Object)this.endpointPropertyConfigurer);
                }
            }
            catch (NoFactoryAvailableException noFactoryAvailableException) {
                // empty catch block
            }
        }
    }

    protected void doStart() throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
    }

    protected void doStop() throws Exception {
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        this.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected void setProperties(CamelContext camelContext, Object bean, Map<String, Object> parameters) throws Exception {
        boolean basic;
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        boolean bl = basic = this.basicPropertyBinding || "true".equals(parameters.getOrDefault("basicPropertyBinding", "false"));
        if (basic) {
            PropertyBindingSupport.build().withPlaceholder(false).withNesting(false).withDeepNesting(false).withReference(false).bind(camelContext, bean, parameters);
        } else {
            PropertyConfigurer configurer = null;
            if (bean instanceof Component) {
                configurer = this.getComponentPropertyConfigurer();
            } else if (bean instanceof Endpoint) {
                configurer = this.getEndpointPropertyConfigurer();
            } else if (bean instanceof PropertyConfigurerAware) {
                configurer = ((PropertyConfigurerAware)bean).getPropertyConfigurer(bean);
            }
            PropertyBindingSupport.build().withConfigurer(configurer).bind(camelContext, bean, parameters);
        }
    }

    public PropertyConfigurer getComponentPropertyConfigurer() {
        return this.componentPropertyConfigurer;
    }

    public PropertyConfigurer getEndpointPropertyConfigurer() {
        return this.endpointPropertyConfigurer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value != null) {
            return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
        }
        value = defaultValue;
        if (value == null) {
            return null;
        }
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        if (EndpointHelper.isReferenceParameter(value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
        }
        return (T)this.getCamelContext().getTypeConverter().convertTo(type, (Object)value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), value, elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    protected void registerExtension(ComponentExtension extension) {
        this.extensions.add(() -> extension);
    }

    protected void registerExtension(Supplier<ComponentExtension> supplier) {
        this.extensions.add(Suppliers.memorize(supplier));
    }

    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        return this.extensions.stream().map(Supplier::get).map(Object::getClass).collect(Collectors.toList());
    }

    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        return this.extensions.stream().map(Supplier::get).filter(extensionType::isInstance).findFirst().map(extensionType::cast).map(e -> (ComponentExtension)Component.trySetComponent((Object)e, (Component)this)).map(e -> (ComponentExtension)CamelContextAware.trySetCamelContext((Object)e, (CamelContext)this.getCamelContext()));
    }
}

