/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.support.DefaultLRUCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LRUCacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LRUCacheFactory.class);
    private static volatile LRUCacheFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LRUCacheFactory getInstance() {
        if (instance != null) return instance;
        Class<LRUCacheFactory> clazz = LRUCacheFactory.class;
        synchronized (LRUCacheFactory.class) {
            if (instance != null) return instance;
            instance = LRUCacheFactory.createLRUCacheFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static LRUCacheFactory createLRUCacheFactory() {
        block14: {
            try {
                ClassLoader classLoader = LRUCacheFactory.class.getClassLoader();
                URL url = classLoader.getResource("META-INF/services/org/apache/camel/lru-cache-factory");
                if (url == null) break block14;
                Properties props = new Properties();
                try (InputStream is = url.openStream();){
                    props.load(is);
                }
                String clazzName = props.getProperty("class");
                Class<?> clazz = classLoader.loadClass(clazzName);
                Object factory = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (LRUCacheFactory)factory;
            }
            catch (Throwable t) {
                LOGGER.warn("Error creating LRUCacheFactory", t);
            }
        }
        return new DefaultLRUCacheFactory();
    }

    public static <K, V> Map<K, V> newLRUCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        return LRUCacheFactory.getInstance().createLRUCache(maximumCacheSize, onEvict);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public abstract <K, V> Map<K, V> createLRUCache(int var1);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, Consumer<V> var2);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, int var2);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, int var2, boolean var3);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1, int var2);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1, int var2, boolean var3);

    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1);

    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1, int var2);

    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1, int var2, boolean var3);
}

