/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.util.ObjectHelper;

public final class CamelContextHelper {
    public static final String MODEL_DOCUMENTATION_PREFIX = "org/apache/camel/model/";

    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, (Object)endpoint));
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull((Object)context, (String)"camelContext");
        return (T)context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T tryConvertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull((Object)context, (String)"camelContext");
        return (T)context.getTypeConverter().tryConvertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return (T)context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookupByName(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return (T)context.getRegistry().lookupByNameAndType(name, beanType);
    }

    public static <T> T lookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        return CamelContextHelper.tryConvertTo(context, beanType, CamelContextHelper.lookup(context, name));
    }

    public static <T> T findByType(CamelContext camelContext, Class<T> type) {
        Set set = camelContext.getRegistry().findByType(type);
        if (set.size() == 1) {
            return (T)set.iterator().next();
        }
        return null;
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        if (answer == null) {
            throw new NoSuchBeanException(name);
        }
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        if (answer == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return answer;
    }

    public static <T> T mandatoryLookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        Object value = CamelContextHelper.lookup(context, name);
        if (value == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return CamelContextHelper.convertTo(context, beanType, value);
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String injectionPointName, boolean mandatory) {
        Endpoint endpoint = ObjectHelper.isNotEmpty((Object)uri) ? camelContext.getEndpoint(uri) : (mandatory ? CamelContextHelper.mandatoryLookup(camelContext, injectionPointName, Endpoint.class) : CamelContextHelper.lookup(camelContext, injectionPointName, Endpoint.class));
        return endpoint;
    }

    public static int getMaximumCachePoolSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumCachePoolSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumEndpointCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumEndpointCacheSize")) != null) {
            try {
                int size = Integer.parseInt(s);
                if (size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumSimpleCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumSimpleCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumTransformerCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumTransformerCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumValidatorCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumValidatorCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static String parseText(CamelContext camelContext, String text) throws Exception {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    public static Integer parseInteger(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Integer)camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Long parseLong(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Long)camelContext.getTypeConverter().mandatoryConvertTo(Long.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a Long.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Long.", e);
            }
        }
        return null;
    }

    public static Double parseDouble(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Double)camelContext.getTypeConverter().mandatoryConvertTo(Double.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Boolean parseBoolean(CamelContext camelContext, String text) {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("true") || s.equals("false")) {
                return "true".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (s.equals(text)) {
                throw new IllegalArgumentException("Error parsing [" + s + "] as a Boolean.");
            }
            throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Boolean.");
        }
        return null;
    }

    public static int getRouteStartupOrder(CamelContext camelContext, String routeId) {
        for (RouteStartupOrder order : ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getRouteStartupOrder()) {
            if (!order.getRoute().getId().equals(routeId)) continue;
            return order.getStartupOrder();
        }
        return 0;
    }

    public static Properties getCamelPropertiesWithPrefix(String prefix, CamelContext camelContext) {
        Properties answer = new Properties();
        Map camelProperties = camelContext.getGlobalOptions();
        if (camelProperties != null) {
            for (Map.Entry entry : camelProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(prefix)) continue;
                answer.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return answer;
    }

    public static String getRouteId(NamedNode node) {
        NamedNode parent;
        for (parent = node; parent != null && parent.getParent() != null; parent = parent.getParent()) {
        }
        return parent != null ? parent.getId() : null;
    }
}

