/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class PropertyConfigurerHelper {
    private PropertyConfigurerHelper() {
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context, Object target) {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull((Object)context, (String)"context");
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            Component component = (Component)target;
            ServiceHelper.initService((Object)target);
            configurer = component.getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(context, target.getClass());
        }
        return configurer;
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context, Class<?> targetType) {
        String[] names;
        ObjectHelper.notNull(targetType, (String)"targetType");
        ObjectHelper.notNull((Object)context, (String)"context");
        if (targetType.getName().endsWith("Component")) {
            Object name = StringHelper.before((String)targetType.getSimpleName(), (String)"Component");
            name = StringHelper.camelCaseToDash((String)name) + "-component";
            return PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer((String)name, context);
        }
        if (targetType.getName().endsWith("Language")) {
            Object name = StringHelper.before((String)targetType.getSimpleName(), (String)"Language");
            name = StringHelper.camelCaseToDash((String)name) + "-language";
            return PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer((String)name, context);
        }
        if (targetType.getName().endsWith("DataFormat")) {
            Object name = StringHelper.before((String)targetType.getSimpleName(), (String)"DataFormat");
            name = StringHelper.camelCaseToDash((String)name) + "-dataformat";
            return PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer((String)name, context);
        }
        if (targetType.isAnonymousClass()) {
            return null;
        }
        for (String n : names = new String[]{targetType.getName(), targetType.getSimpleName(), targetType.getName() + "-configurer", targetType.getSimpleName() + "-configurer"}) {
            PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(n, context);
            if (configurer == null) continue;
            return configurer;
        }
        return null;
    }

    public static <T> T resolvePropertyConfigurer(CamelContext context, Object target, Class<T> type) {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull((Object)context, (String)"context");
        PropertyConfigurer configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(context, target);
        if (type.isInstance(configurer)) {
            return type.cast(configurer);
        }
        return null;
    }
}

