/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.ExchangeRestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSwaggerProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerProcessor.class);
    private final BeanConfig swaggerConfig;
    private final RestSwaggerSupport support;
    private final RestConfiguration configuration;

    public RestSwaggerProcessor(Map<String, Object> parameters, RestConfiguration configuration) {
        this.configuration = configuration;
        this.support = new RestSwaggerSupport();
        this.swaggerConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this.support.initSwagger(this.swaggerConfig, parameters);
    }

    public void process(Exchange exchange) throws Exception {
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getIn().getHeader("Accept", String.class);
        ExchangeRestApiResponseAdapter adapter = new ExchangeRestApiResponseAdapter(exchange);
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith("/swagger.json")) {
            json = true;
            route = route.substring(0, route.length() - 13);
        } else if (route != null && route.endsWith("/swagger.yaml")) {
            yaml = true;
            route = route.substring(0, route.length() - 13);
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        try {
            this.support.renderResourceListing(exchange.getContext(), adapter, this.swaggerConfig, json, yaml, exchange.getIn().getHeaders(), exchange.getContext().getClassResolver(), this.configuration);
        }
        catch (Exception e) {
            LOG.warn("Error rendering Swagger API due {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

