/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.model.Model;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.RestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerReader;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSwaggerSupport {
    static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HEADER_HOST = "Host";
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerSupport.class);
    private RestSwaggerReader reader = new RestSwaggerReader();
    private boolean cors;

    public void initSwagger(BeanConfig swaggerConfig, Map<String, Object> config) {
        String s = (String)config.get("swagger.version");
        if (s != null) {
            swaggerConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            swaggerConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            swaggerConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            swaggerConfig.setSchemes(schemes);
        } else {
            swaggerConfig.setSchemes(new String[]{"http"});
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        Info info = new Info();
        info.setVersion(version);
        info.setTitle(title);
        info.setDescription(description);
        info.setTermsOfService(termsOfService);
        if (licenseName != null || licenseUrl != null) {
            License license = new License();
            license.setName(licenseName);
            license.setUrl(licenseUrl);
            info.setLicense(license);
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = new Contact();
            contact.setName(contactName);
            contact.setUrl(contactUrl);
            contact.setEmail(contactEmail);
            info.setContact(contact);
        }
        swaggerConfig.setInfo(info);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext) throws Exception {
        Model model = (Model)camelContext.getExtension(Model.class);
        List rests = model.getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        String originalXml = ecc.getModelToXMLDumper().dumpModelAsXml(camelContext, (NamedNode)def);
        String changedXml = ecc.getModelToXMLDumper().dumpModelAsXml(camelContext, (NamedNode)def, true, true);
        if (!Objects.equals(originalXml, changedXml)) {
            InputStream isxml = (InputStream)camelContext.getTypeConverter().convertTo(InputStream.class, (Object)changedXml);
            def = (RestsDefinition)ecc.getXMLRoutesDefinitionLoader().loadRestsDefinition(camelContext, isxml);
            if (def != null) {
                rests = def.getRests();
            }
        }
        return rests;
    }

    public void renderResourceListing(CamelContext camelContext, RestApiResponseAdapter response, BeanConfig swaggerConfig, boolean json, boolean yaml, Map<String, Object> headers, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        List<RestDefinition> rests;
        LOG.trace("renderResourceListing");
        ObjectMapper mapper = Json.mapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.cors) {
            RestSwaggerSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        if ((rests = this.getRestDefinitions(camelContext)) != null) {
            Map apiProperties;
            Map map = apiProperties = configuration.getApiProperties() != null ? configuration.getApiProperties() : new HashMap();
            if (json) {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.json", "application/json"));
                Swagger swagger = this.reader.read(camelContext, rests, swaggerConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestSwaggerSupport.setupXForwardedHeaders(swagger, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                byte[] bytes = mapper.writeValueAsBytes((Object)swagger);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            } else {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.yaml", "text/yaml"));
                Swagger swagger = this.reader.read(camelContext, rests, swaggerConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestSwaggerSupport.setupXForwardedHeaders(swagger, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                byte[] jsonData = mapper.writeValueAsBytes((Object)swagger);
                JsonNode node = mapper.readTree(jsonData);
                byte[] bytes = Yaml.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)node);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            }
        } else {
            response.noContent();
        }
    }

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }

    static void setupXForwardedHeaders(Swagger swagger, Map<String, Object> headers) {
        String proto;
        String forwardedHost;
        String forwardedPrefix;
        String host = (String)headers.get(HEADER_HOST);
        if (ObjectHelper.isNotEmpty((String)host)) {
            swagger.setHost(host);
        }
        if (ObjectHelper.isNotEmpty((String)(forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX)))) {
            swagger.setBasePath(URISupport.joinPaths((String[])new String[]{forwardedPrefix, swagger.getBasePath()}));
        }
        if (ObjectHelper.isNotEmpty((String)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
            swagger.setHost(forwardedHost);
        }
        if (ObjectHelper.isNotEmpty((String)(proto = (String)headers.get(HEADER_X_FORWARDED_PROTO)))) {
            String[] schemes;
            for (String scheme : schemes = proto.split(",")) {
                String trimmedScheme = scheme.trim();
                if (!ObjectHelper.isNotEmpty((String)trimmedScheme)) continue;
                swagger.addScheme(Scheme.forValue((String)trimmedScheme));
            }
        }
    }
}

