/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import org.apache.camel.util.FileUtil;

public final class SwaggerHelper {
    private SwaggerHelper() {
    }

    public static String buildUrl(String path1, String path2) {
        String s1 = FileUtil.stripTrailingSeparator((String)path1);
        String s2 = FileUtil.stripLeadingSeparator((String)path2);
        if (s1 != null && s2 != null) {
            return s1 + "/" + s2;
        }
        if (path1 != null) {
            return path1;
        }
        return path2;
    }

    public static void clearVendorExtensions(Swagger swagger) {
        if (swagger.getVendorExtensions() != null) {
            swagger.getVendorExtensions().clear();
        }
        if (swagger.getDefinitions() != null) {
            for (Model model : swagger.getDefinitions().values()) {
                if (model.getVendorExtensions() == null) continue;
                model.getVendorExtensions().clear();
            }
        }
        if (swagger.getPaths() != null) {
            for (Path path : swagger.getPaths().values()) {
                if (path.getVendorExtensions() != null) {
                    path.getVendorExtensions().clear();
                }
                for (Operation op : path.getOperations()) {
                    if (op.getVendorExtensions() == null) continue;
                    op.getVendorExtensions().clear();
                }
            }
        }
    }
}

