/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean updateFile(Path path, String newdata) throws IOException {
        return FileUtil.updateFile(path, newdata != null ? newdata.getBytes() : null);
    }

    public static boolean updateFile(Path path, String newdata, Charset encoding) throws IOException {
        return FileUtil.updateFile(path, newdata != null ? newdata.getBytes(encoding) : null);
    }

    public static boolean updateFile(Path path, byte[] newdata) throws IOException {
        if (newdata == null) {
            if (!Files.exists(path, new LinkOption[0])) {
                return false;
            }
            Files.delete(path);
            return true;
        }
        byte[] olddata = new byte[]{};
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
            olddata = Files.readAllBytes(path);
        }
        if (Arrays.equals(olddata, newdata)) {
            return false;
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, newdata, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return true;
    }

    public static void updateFile(Path from, Path to) throws IOException {
        FileUtil.updateFile(to, Files.readAllBytes(from));
    }
}

