/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.camel.tooling.util.FileUtil;

public final class PackageHelper {
    public static final String JSON_SUFIX = ".json";

    private PackageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(isr);
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            isr.close();
            in.close();
        }
    }

    public static String loadText(File file) throws IOException {
        return PackageHelper.loadText(file.toPath());
    }

    public static String loadText(Path file) throws IOException {
        return PackageHelper.loadText(Files.newInputStream(file, new OpenOption[0]));
    }

    public static void writeText(File file, String text) throws IOException {
        FileUtil.updateFile(file.toPath(), text);
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static Map<String, String> parseAsMap(String data) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (data != null) {
            String[] lines;
            for (String line : lines = data.split("\n")) {
                int idx = line.indexOf(61);
                if (idx == -1) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                value = value.trim().replace("\n", "");
                answer.put(key.trim(), value);
            }
        }
        return answer;
    }

    public static Set<File> findJsonFiles(File rootDir, Set<File> files) {
        PackageHelper.findJsonFiles(rootDir.toPath()).forEach(p -> files.add(p.toFile()));
        return files;
    }

    public static Stream<Path> findJsonFiles(Path rootDir) {
        return PackageHelper.walk(rootDir).filter(p -> p.getFileName().toString().endsWith(JSON_SUFIX));
    }

    public static Stream<Path> walk(Path rootDir) {
        try {
            if (Files.isDirectory(rootDir, new LinkOption[0])) {
                return Files.walk(rootDir, new FileVisitOption[0]);
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asName(Path file) {
        String name = file.getFileName().toString();
        if (name.endsWith(JSON_SUFIX)) {
            return name.substring(0, name.length() - JSON_SUFIX.length());
        }
        return name;
    }

    public static File findCamelCoreDirectory(File dir) {
        return PackageHelper.findCamelDirectory(dir, "core/camel-core-engine");
    }

    public static File findCamelCoreModelDirectory(File dir) {
        return PackageHelper.findCamelDirectory(dir, "core/camel-core-model");
    }

    public static File findCamelDirectory(File dir, String path) {
        if (dir == null) {
            return null;
        }
        Path p = dir.toPath().resolve(path);
        if (Files.isDirectory(p, new LinkOption[0])) {
            return p.toFile();
        }
        return PackageHelper.findCamelDirectory(dir.getParentFile(), path);
    }

    public static String getSchemaKind(String json) {
        int e;
        int s;
        int i = json.indexOf("\"kind\"");
        if (i >= 0 && (s = json.indexOf("\"", i + 6)) >= 0 && (e = json.indexOf("\"", s + 1)) >= 0) {
            return json.substring(s + 1, e);
        }
        return null;
    }
}

