/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;

public final class StringQuoteHelper {
    private StringQuoteHelper() {
    }

    public static String doubleQuote(String text) {
        return StringQuoteHelper.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return StringQuoteHelper.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String[] splitSafeQuote(String input, char separator) {
        return StringQuoteHelper.splitSafeQuote(input, separator, true, false);
    }

    public static String[] splitSafeQuote(String input, char separator, boolean trim) {
        return StringQuoteHelper.splitSafeQuote(input, separator, trim, false);
    }

    public static String[] splitSafeQuote(String input, char separator, boolean trim, boolean keepQuotes) {
        if (input == null) {
            return null;
        }
        if (input.indexOf(separator) == -1) {
            if (input.length() > 1) {
                boolean doubleQuoted;
                char ch = input.charAt(0);
                char ch2 = input.charAt(input.length() - 1);
                boolean singleQuoted = ch == '\'' && ch2 == '\'';
                boolean bl = doubleQuoted = ch == '\"' && ch2 == '\"';
                if (!keepQuotes && (singleQuoted || doubleQuoted)) {
                    input = input.substring(1, input.length() - 1);
                }
            }
            return new String[]{trim ? input.trim() : input};
        }
        ArrayList<Object> answer = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean skipLeadingWhitespace = true;
        for (int i = 0; i < input.length(); ++i) {
            String text;
            boolean last;
            char ch = input.charAt(i);
            char prev = i > 0 ? input.charAt(i - 1) : (char)'\u0000';
            boolean isQuoting = singleQuoted || doubleQuoted;
            boolean bl = last = i == input.length() - 1;
            if (!doubleQuoted && ch == '\'') {
                if (singleQuoted && prev == ch && sb.length() == 0) {
                    if (keepQuotes) {
                        answer.add("''");
                    } else {
                        answer.add("");
                    }
                }
                if (last) {
                    if (!singleQuoted || sb.length() <= 0) break;
                    text = sb.toString();
                    if (keepQuotes) {
                        answer.add(text + "'");
                    } else {
                        answer.add(text);
                    }
                    sb.setLength(0);
                    break;
                }
                boolean bl2 = singleQuoted = !singleQuoted;
                if (!keepQuotes) continue;
                sb.append(ch);
                continue;
            }
            if (!singleQuoted && ch == '\"') {
                if (doubleQuoted && prev == ch && sb.length() == 0) {
                    if (keepQuotes) {
                        answer.add("\"");
                    } else {
                        answer.add("");
                    }
                }
                if (last) {
                    if (!doubleQuoted || sb.length() <= 0) break;
                    text = sb.toString();
                    if (keepQuotes) {
                        answer.add(text + "\"");
                    } else {
                        answer.add(text);
                    }
                    sb.setLength(0);
                    break;
                }
                boolean bl3 = doubleQuoted = !doubleQuoted;
                if (!keepQuotes) continue;
                sb.append(ch);
                continue;
            }
            if (!isQuoting && separator != ' ' && ch == ' ') {
                if (skipLeadingWhitespace) {
                    continue;
                }
            } else if (!isQuoting && ch == separator) {
                if (sb.length() <= 0) continue;
                text = sb.toString();
                if (trim) {
                    text = text.trim();
                }
                answer.add(text);
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            String text = sb.toString();
            if (trim) {
                text = text.trim();
            }
            answer.add(text);
        }
        return answer.toArray(new String[answer.size()]);
    }
}

