/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.deflater;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="gzipdeflater")
public class GzipDeflaterDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    public String getDataFormatName() {
        return "gzipdeflater";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        GZIPOutputStream zipOutput = new GZIPOutputStream(stream);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, zipOutput});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, zipOutput});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        GZIPInputStream unzipInput = null;
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            unzipInput = new GZIPInputStream(inputStream);
            IOHelper.copy((InputStream)unzipInput, (OutputStream)osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{osb, unzipInput, inputStream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{osb, unzipInput, inputStream});
        return object;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

