/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.springboot.CamelRequestHandlerMapping;
import org.apache.camel.component.platform.http.springboot.PlatformHttpComponentConfiguration;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpEngine;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(name={"org.apache.camel.component.servlet.springboot.PlatformHttpComponentAutoConfiguration", "org.apache.camel.component.servlet.springboot.PlatformHttpComponentConverter"})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, PlatformHttpComponentConfiguration.class, WebMvcProperties.class})
public class SpringBootPlatformHttpAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootPlatformHttpAutoConfiguration.class);

    @Bean(name={"platform-http-engine"})
    @ConditionalOnMissingBean(value={PlatformHttpEngine.class})
    public PlatformHttpEngine springBootPlatformHttpEngine(Environment env, List<Executor> executors) {
        if (executors == null || executors.isEmpty()) {
            throw new RuntimeException("No Executor configured");
        }
        executors.forEach(e -> LOG.debug("Analyzing executor: {}", (Object)e.getClass().getName()));
        boolean virtualThreadsEnabled = Boolean.parseBoolean(env.getProperty("spring.threads.virtual.enabled", "false"));
        Executor executor = executors.stream().filter(e -> {
            try {
                return Class.forName("org.springframework.security.task.DelegatingSecurityContextAsyncTaskExecutor").isInstance(e);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }).findAny().orElseGet(() -> {
            if (virtualThreadsEnabled) {
                return executors.stream().filter(e -> e instanceof SimpleAsyncTaskExecutor).findFirst().orElseGet(() -> executors.stream().filter(e -> e instanceof ThreadPoolTaskExecutor).findFirst().orElseThrow(() -> new RuntimeException("No SimpleAsyncTaskExecutor or ThreadPoolTaskExecutor configured")));
            }
            return executors.stream().filter(e -> e instanceof ThreadPoolTaskExecutor || e instanceof SimpleAsyncTaskExecutor).findFirst().orElseThrow(() -> new RuntimeException("No ThreadPoolTaskExecutor, SimpleAsyncTaskExecutor or DelegatingSecurityContextAsyncTaskExecutor configured"));
        });
        if (Boolean.parseBoolean(env.getProperty("spring.threads.virtual.enabled", "false"))) {
            LOG.info("Virtual threads enabled - using executor: {} for platform-http", (Object)executor.getClass().getName());
        } else {
            LOG.debug("Using executor: {}", (Object)executor.getClass().getName());
        }
        int port = Integer.parseInt(env.getProperty("server.port", "8080"));
        return new SpringBootPlatformHttpEngine(port, executor);
    }

    @Bean
    @DependsOn(value={"configurePlatformHttpComponent"})
    public CamelRequestHandlerMapping platformHttpEngineRequestMapping(PlatformHttpEngine engine, CamelContext camelContext) {
        PlatformHttpComponent component = (PlatformHttpComponent)camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        CamelRequestHandlerMapping answer = new CamelRequestHandlerMapping(component, engine);
        return answer;
    }
}

