/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot.actuate.metrics.undertow;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentManager;
import java.util.Collections;
import org.apache.camel.component.platform.http.springboot.actuate.metrics.undertow.UndertowComponents;
import org.apache.camel.component.platform.http.springboot.actuate.metrics.undertow.UndertowMetrics;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.xnio.XnioWorker;

public class UndertowMetricsBinder
implements ApplicationListener<ApplicationStartedEvent>,
DisposableBean {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;
    private volatile UndertowMetrics undertowMetrics;

    public UndertowMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public UndertowMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void destroy() {
        if (this.undertowMetrics != null) {
            this.undertowMetrics.close();
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        UndertowComponents undertowComponents = this.findUndertowComponents((ApplicationContext)applicationContext);
        if (undertowComponents != null) {
            this.undertowMetrics = new UndertowMetrics(undertowComponents.xnioWorker(), undertowComponents.sessionManager(), undertowComponents.deployment(), this.tags);
            this.undertowMetrics.bindTo(this.meterRegistry);
        }
    }

    private UndertowComponents findUndertowComponents(ApplicationContext applicationContext) {
        WebServerApplicationContext webServerApplicationContext;
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = (webServerApplicationContext = (WebServerApplicationContext)applicationContext).getWebServer()) instanceof UndertowServletWebServer) {
            UndertowServletWebServer undertowServletWebServer = (UndertowServletWebServer)webServer;
            Undertow undertow = undertowServletWebServer.getUndertow();
            XnioWorker xnioWorker = undertowServletWebServer.getUndertow().getWorker();
            DeploymentManager deploymentManager = undertowServletWebServer.getDeploymentManager();
            return new UndertowComponents(xnioWorker, deploymentManager.getDeployment().getSessionManager(), deploymentManager.getDeployment(), undertow);
        }
        return null;
    }
}

