// $ANTLR 3.2 Sep 23, 2009 12:02:23 /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2014-09-07 15:28:57

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.Permission;
    import org.apache.cassandra.auth.DataResource;
    import org.apache.cassandra.auth.IResource;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.functions.FunctionCall;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class CqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "K_USE", "K_SELECT", "K_DISTINCT", "K_COUNT", "K_AS", "K_FROM", "K_WHERE", "K_ORDER", "K_BY", "K_LIMIT", "K_ALLOW", "K_FILTERING", "K_WRITETIME", "K_TTL", "INTEGER", "K_AND", "K_ASC", "K_DESC", "K_INSERT", "K_INTO", "K_VALUES", "K_IF", "K_NOT", "K_EXISTS", "K_USING", "K_TIMESTAMP", "K_UPDATE", "K_SET", "K_DELETE", "K_BEGIN", "K_UNLOGGED", "K_COUNTER", "K_BATCH", "K_APPLY", "K_CREATE", "K_KEYSPACE", "K_WITH", "K_COLUMNFAMILY", "K_STATIC", "K_PRIMARY", "K_KEY", "K_COMPACT", "K_STORAGE", "K_CLUSTERING", "K_TYPE", "K_CUSTOM", "K_INDEX", "IDENT", "K_ON", "STRING_LITERAL", "K_KEYS", "K_TRIGGER", "K_DROP", "K_ALTER", "K_ADD", "K_RENAME", "K_TO", "K_TRUNCATE", "K_GRANT", "K_REVOKE", "K_LIST", "K_OF", "K_NORECURSIVE", "K_MODIFY", "K_AUTHORIZE", "K_ALL", "K_PERMISSIONS", "K_PERMISSION", "K_KEYSPACES", "K_USER", "K_SUPERUSER", "K_NOSUPERUSER", "K_USERS", "K_PASSWORD", "QUOTED_NAME", "FLOAT", "BOOLEAN", "UUID", "HEXNUMBER", "K_NAN", "K_INFINITY", "K_NULL", "QMARK", "K_TOKEN", "K_IN", "K_CONTAINS", "K_FROZEN", "K_ASCII", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_DECIMAL", "K_DOUBLE", "K_FLOAT", "K_INET", "K_INT", "K_TEXT", "K_UUID", "K_VARCHAR", "K_VARINT", "K_TIMEUUID", "K_MAP", "K_TUPLE", "S", "E", "L", "C", "T", "F", "R", "O", "M", "A", "W", "H", "N", "D", "K", "Y", "I", "U", "P", "G", "B", "X", "V", "Z", "J", "Q", "DIGIT", "LETTER", "HEX", "EXPONENT", "WS", "COMMENT", "MULTILINE_COMMENT", "';'", "'('", "')'", "','", "'\\*'", "'.'", "'['", "']'", "'-'", "'{'", "':'", "'}'", "'='", "'+'", "'<'", "'<='", "'>'", "'>='"
    };
    public static final int EXPONENT=136;
    public static final int K_PERMISSIONS=70;
    public static final int LETTER=134;
    public static final int K_INT=99;
    public static final int K_PERMISSION=71;
    public static final int K_CREATE=38;
    public static final int K_CLUSTERING=47;
    public static final int K_WRITETIME=16;
    public static final int K_INFINITY=84;
    public static final int K_EXISTS=27;
    public static final int EOF=-1;
    public static final int K_PRIMARY=43;
    public static final int K_AUTHORIZE=68;
    public static final int K_VALUES=24;
    public static final int K_USE=4;
    public static final int K_DISTINCT=6;
    public static final int T__148=148;
    public static final int STRING_LITERAL=53;
    public static final int T__147=147;
    public static final int K_GRANT=62;
    public static final int T__149=149;
    public static final int K_ON=52;
    public static final int K_USING=28;
    public static final int K_ADD=58;
    public static final int K_ASC=20;
    public static final int K_CUSTOM=49;
    public static final int K_KEY=44;
    public static final int K_KEYS=54;
    public static final int COMMENT=138;
    public static final int T__154=154;
    public static final int K_TRUNCATE=61;
    public static final int T__155=155;
    public static final int T__156=156;
    public static final int T__157=157;
    public static final int T__150=150;
    public static final int K_ORDER=11;
    public static final int T__151=151;
    public static final int HEXNUMBER=82;
    public static final int T__152=152;
    public static final int K_OF=65;
    public static final int K_ALL=69;
    public static final int T__153=153;
    public static final int D=120;
    public static final int E=108;
    public static final int F=112;
    public static final int G=126;
    public static final int K_COUNT=7;
    public static final int K_KEYSPACE=39;
    public static final int K_TYPE=48;
    public static final int A=116;
    public static final int B=127;
    public static final int C=110;
    public static final int L=109;
    public static final int M=115;
    public static final int N=119;
    public static final int O=114;
    public static final int H=118;
    public static final int I=123;
    public static final int J=131;
    public static final int K_UPDATE=30;
    public static final int K=121;
    public static final int K_FILTERING=15;
    public static final int U=124;
    public static final int T=111;
    public static final int W=117;
    public static final int K_TEXT=100;
    public static final int V=129;
    public static final int Q=132;
    public static final int P=125;
    public static final int K_COMPACT=45;
    public static final int S=107;
    public static final int R=113;
    public static final int T__141=141;
    public static final int T__142=142;
    public static final int K_TTL=17;
    public static final int T__140=140;
    public static final int Y=122;
    public static final int T__145=145;
    public static final int X=128;
    public static final int T__146=146;
    public static final int T__143=143;
    public static final int Z=130;
    public static final int T__144=144;
    public static final int K_INDEX=50;
    public static final int K_INSERT=22;
    public static final int WS=137;
    public static final int K_NOT=26;
    public static final int K_RENAME=59;
    public static final int K_APPLY=37;
    public static final int K_INET=98;
    public static final int K_TUPLE=106;
    public static final int K_STORAGE=46;
    public static final int K_TIMESTAMP=29;
    public static final int K_NULL=85;
    public static final int K_AND=19;
    public static final int K_DESC=21;
    public static final int K_TOKEN=87;
    public static final int QMARK=86;
    public static final int K_UUID=101;
    public static final int K_BATCH=36;
    public static final int K_ASCII=91;
    public static final int UUID=81;
    public static final int K_LIST=64;
    public static final int K_DELETE=32;
    public static final int K_TO=60;
    public static final int K_BY=12;
    public static final int FLOAT=79;
    public static final int K_VARINT=103;
    public static final int K_FLOAT=97;
    public static final int K_SUPERUSER=74;
    public static final int K_DOUBLE=96;
    public static final int K_SELECT=5;
    public static final int K_LIMIT=13;
    public static final int K_BOOLEAN=94;
    public static final int K_ALTER=57;
    public static final int K_SET=31;
    public static final int K_TRIGGER=55;
    public static final int K_WHERE=10;
    public static final int QUOTED_NAME=78;
    public static final int MULTILINE_COMMENT=139;
    public static final int K_BLOB=93;
    public static final int BOOLEAN=80;
    public static final int K_UNLOGGED=34;
    public static final int HEX=135;
    public static final int K_INTO=23;
    public static final int K_PASSWORD=77;
    public static final int K_REVOKE=63;
    public static final int K_ALLOW=14;
    public static final int K_VARCHAR=102;
    public static final int IDENT=51;
    public static final int DIGIT=133;
    public static final int K_USERS=76;
    public static final int K_BEGIN=33;
    public static final int INTEGER=18;
    public static final int K_KEYSPACES=72;
    public static final int K_COUNTER=35;
    public static final int K_DECIMAL=95;
    public static final int K_CONTAINS=89;
    public static final int K_WITH=40;
    public static final int K_FROZEN=90;
    public static final int K_IN=88;
    public static final int K_NORECURSIVE=66;
    public static final int K_MAP=105;
    public static final int K_NAN=83;
    public static final int K_IF=25;
    public static final int K_FROM=9;
    public static final int K_STATIC=42;
    public static final int K_COLUMNFAMILY=41;
    public static final int K_MODIFY=67;
    public static final int K_DROP=56;
    public static final int K_NOSUPERUSER=75;
    public static final int K_AS=8;
    public static final int K_BIGINT=92;
    public static final int K_TIMEUUID=104;
    public static final int K_USER=73;

    // delegates
    // delegators


        public CqlParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public CqlParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CqlParser.tokenNames; }
    public String getGrammarFileName() { return "/tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


        private final List<String> recognitionErrors = new ArrayList<String>();
        private final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

        public static final Set<String> reservedTypeNames = new HashSet<String>()
        {{
            add("byte");
            add("smallint");
            add("complex");
            add("enum");
            add("date");
            add("interval");
            add("macaddr");
            add("bitstring");
        }};

        public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
        {
            AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
            bindVariables.add(name);
            return marker;
        }

        public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
        {
            AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
            bindVariables.add(name);
            return marker;
        }

        public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
        {
            Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
            bindVariables.add(name);
            return marker;
        }

        public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
        {
            Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
            bindVariables.add(name);
            return marker;
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException e)
        {
            String hdr = getErrorHeader(e);
            String msg = getErrorMessage(e, tokenNames);
            recognitionErrors.add(hdr + " " + msg);
        }

        public void addRecognitionError(String msg)
        {
            recognitionErrors.add(msg);
        }

        public List<String> getRecognitionErrors()
        {
            return recognitionErrors;
        }

        public void throwLastRecognitionError() throws SyntaxException
        {
            if (recognitionErrors.size() > 0)
                throw new SyntaxException(recognitionErrors.get((recognitionErrors.size()-1)));
        }

        public Map<String, String> convertPropertyMap(Maps.Literal map)
        {
            if (map == null || map.entries == null || map.entries.isEmpty())
                return Collections.<String, String>emptyMap();

            Map<String, String> res = new HashMap<String, String>(map.entries.size());

            for (Pair<Term.Raw, Term.Raw> entry : map.entries)
            {
                // Because the parser tries to be smart and recover on error (to
                // allow displaying more than one error I suppose), we have null
                // entries in there. Just skip those, a proper error will be thrown in the end.
                if (entry.left == null || entry.right == null)
                    break;

                if (!(entry.left instanceof Constants.Literal))
                {
                    String msg = "Invalid property name: " + entry.left;
                    if (entry.left instanceof AbstractMarker.Raw)
                        msg += " (bind variables are not supported in DDL queries)";
                    addRecognitionError(msg);
                    break;
                }
                if (!(entry.right instanceof Constants.Literal))
                {
                    String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
                    if (entry.right instanceof AbstractMarker.Raw)
                        msg += " (bind variables are not supported in DDL queries)";
                    addRecognitionError(msg);
                    break;
                }

                res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
            }

            return res;
        }

        public void addRawUpdate(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Operation.RawUpdate update)
        {
            for (Pair<ColumnIdentifier, Operation.RawUpdate> p : operations)
            {
                if (p.left.equals(key) && !p.right.isCompatibleWith(update))
                    addRecognitionError("Multiple incompatible setting of column " + key);
            }
            operations.add(Pair.create(key, update));
        }



    // $ANTLR start "query"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
    public final ParsedStatement query() throws RecognitionException {
        ParsedStatement stmnt = null;

        ParsedStatement st = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:5: (st= cqlStatement ( ';' )* EOF )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:7: st= cqlStatement ( ';' )* EOF
            {
            pushFollow(FOLLOW_cqlStatement_in_query72);
            st=cqlStatement();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:23: ( ';' )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==140) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:24: ';'
            	    {
            	    match(input,140,FOLLOW_140_in_query75); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_query79); 
             stmnt = st; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmnt;
    }
    // $ANTLR end "query"


    // $ANTLR start "cqlStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:219:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement | st25= createTypeStatement | st26= alterTypeStatement | st27= dropTypeStatement );
    public final ParsedStatement cqlStatement() throws RecognitionException {
        ParsedStatement stmt = null;

        SelectStatement.RawStatement st1 = null;

        UpdateStatement.ParsedInsert st2 = null;

        UpdateStatement.ParsedUpdate st3 = null;

        BatchStatement.Parsed st4 = null;

        DeleteStatement.Parsed st5 = null;

        UseStatement st6 = null;

        TruncateStatement st7 = null;

        CreateKeyspaceStatement st8 = null;

        CreateTableStatement.RawStatement st9 = null;

        CreateIndexStatement st10 = null;

        DropKeyspaceStatement st11 = null;

        DropTableStatement st12 = null;

        DropIndexStatement st13 = null;

        AlterTableStatement st14 = null;

        AlterKeyspaceStatement st15 = null;

        GrantStatement st16 = null;

        RevokeStatement st17 = null;

        ListPermissionsStatement st18 = null;

        CreateUserStatement st19 = null;

        AlterUserStatement st20 = null;

        DropUserStatement st21 = null;

        ListUsersStatement st22 = null;

        CreateTriggerStatement st23 = null;

        DropTriggerStatement st24 = null;

        CreateTypeStatement st25 = null;

        AlterTypeStatement st26 = null;

        DropTypeStatement st27 = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:5: (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement | st25= createTypeStatement | st26= alterTypeStatement | st27= dropTypeStatement )
            int alt2=27;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:7: st1= selectStatement
                    {
                    pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
                    st1=selectStatement();

                    state._fsp--;

                     stmt = st1; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:7: st2= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
                    st2=insertStatement();

                    state._fsp--;

                     stmt = st2; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:7: st3= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
                    st3=updateStatement();

                    state._fsp--;

                     stmt = st3; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:7: st4= batchStatement
                    {
                    pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
                    st4=batchStatement();

                    state._fsp--;

                     stmt = st4; 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:7: st5= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
                    st5=deleteStatement();

                    state._fsp--;

                     stmt = st5; 

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:226:7: st6= useStatement
                    {
                    pushFollow(FOLLOW_useStatement_in_cqlStatement239);
                    st6=useStatement();

                    state._fsp--;

                     stmt = st6; 

                    }
                    break;
                case 7 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:7: st7= truncateStatement
                    {
                    pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
                    st7=truncateStatement();

                    state._fsp--;

                     stmt = st7; 

                    }
                    break;
                case 8 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:228:7: st8= createKeyspaceStatement
                    {
                    pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
                    st8=createKeyspaceStatement();

                    state._fsp--;

                     stmt = st8; 

                    }
                    break;
                case 9 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:229:7: st9= createTableStatement
                    {
                    pushFollow(FOLLOW_createTableStatement_in_cqlStatement307);
                    st9=createTableStatement();

                    state._fsp--;

                     stmt = st9; 

                    }
                    break;
                case 10 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:230:7: st10= createIndexStatement
                    {
                    pushFollow(FOLLOW_createIndexStatement_in_cqlStatement326);
                    st10=createIndexStatement();

                    state._fsp--;

                     stmt = st10; 

                    }
                    break;
                case 11 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:7: st11= dropKeyspaceStatement
                    {
                    pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement345);
                    st11=dropKeyspaceStatement();

                    state._fsp--;

                     stmt = st11; 

                    }
                    break;
                case 12 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:232:7: st12= dropTableStatement
                    {
                    pushFollow(FOLLOW_dropTableStatement_in_cqlStatement363);
                    st12=dropTableStatement();

                    state._fsp--;

                     stmt = st12; 

                    }
                    break;
                case 13 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:233:7: st13= dropIndexStatement
                    {
                    pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement384);
                    st13=dropIndexStatement();

                    state._fsp--;

                     stmt = st13; 

                    }
                    break;
                case 14 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:7: st14= alterTableStatement
                    {
                    pushFollow(FOLLOW_alterTableStatement_in_cqlStatement405);
                    st14=alterTableStatement();

                    state._fsp--;

                     stmt = st14; 

                    }
                    break;
                case 15 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:235:7: st15= alterKeyspaceStatement
                    {
                    pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement425);
                    st15=alterKeyspaceStatement();

                    state._fsp--;

                     stmt = st15; 

                    }
                    break;
                case 16 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:7: st16= grantStatement
                    {
                    pushFollow(FOLLOW_grantStatement_in_cqlStatement442);
                    st16=grantStatement();

                    state._fsp--;

                     stmt = st16; 

                    }
                    break;
                case 17 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:7: st17= revokeStatement
                    {
                    pushFollow(FOLLOW_revokeStatement_in_cqlStatement467);
                    st17=revokeStatement();

                    state._fsp--;

                     stmt = st17; 

                    }
                    break;
                case 18 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: st18= listPermissionsStatement
                    {
                    pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement491);
                    st18=listPermissionsStatement();

                    state._fsp--;

                     stmt = st18; 

                    }
                    break;
                case 19 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: st19= createUserStatement
                    {
                    pushFollow(FOLLOW_createUserStatement_in_cqlStatement506);
                    st19=createUserStatement();

                    state._fsp--;

                     stmt = st19; 

                    }
                    break;
                case 20 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: st20= alterUserStatement
                    {
                    pushFollow(FOLLOW_alterUserStatement_in_cqlStatement526);
                    st20=alterUserStatement();

                    state._fsp--;

                     stmt = st20; 

                    }
                    break;
                case 21 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:7: st21= dropUserStatement
                    {
                    pushFollow(FOLLOW_dropUserStatement_in_cqlStatement547);
                    st21=dropUserStatement();

                    state._fsp--;

                     stmt = st21; 

                    }
                    break;
                case 22 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:7: st22= listUsersStatement
                    {
                    pushFollow(FOLLOW_listUsersStatement_in_cqlStatement569);
                    st22=listUsersStatement();

                    state._fsp--;

                     stmt = st22; 

                    }
                    break;
                case 23 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:243:7: st23= createTriggerStatement
                    {
                    pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement590);
                    st23=createTriggerStatement();

                    state._fsp--;

                     stmt = st23; 

                    }
                    break;
                case 24 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: st24= dropTriggerStatement
                    {
                    pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement607);
                    st24=dropTriggerStatement();

                    state._fsp--;

                     stmt = st24; 

                    }
                    break;
                case 25 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:245:7: st25= createTypeStatement
                    {
                    pushFollow(FOLLOW_createTypeStatement_in_cqlStatement626);
                    st25=createTypeStatement();

                    state._fsp--;

                     stmt = st25; 

                    }
                    break;
                case 26 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:246:7: st26= alterTypeStatement
                    {
                    pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement646);
                    st26=alterTypeStatement();

                    state._fsp--;

                     stmt = st26; 

                    }
                    break;
                case 27 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:7: st27= dropTypeStatement
                    {
                    pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement667);
                    st27=dropTypeStatement();

                    state._fsp--;

                     stmt = st27; 

                    }
                    break;

            }
             if (stmt != null) stmt.setBoundVariables(bindVariables); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "cqlStatement"


    // $ANTLR start "useStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:253:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
    public final UseStatement useStatement() throws RecognitionException {
        UseStatement stmt = null;

        String ks = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:5: ( K_USE ks= keyspaceName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:7: K_USE ks= keyspaceName
            {
            match(input,K_USE,FOLLOW_K_USE_in_useStatement702); 
            pushFollow(FOLLOW_keyspaceName_in_useStatement706);
            ks=keyspaceName();

            state._fsp--;

             stmt = new UseStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "useStatement"


    // $ANTLR start "selectStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
    public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
        SelectStatement.RawStatement expr = null;

        List<RawSelector> sclause = null;

        ColumnIdentifier c = null;

        CFName cf = null;

        List<Relation> wclause = null;

        Term.Raw rows = null;



                boolean isDistinct = false;
                boolean isCount = false;
                ColumnIdentifier countAlias = null;
                Term.Raw limit = null;
                Map<ColumnIdentifier, Boolean> orderings = new LinkedHashMap<ColumnIdentifier, Boolean>();
                boolean allowFiltering = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:5: ( K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:7: K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
            {
            match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement740); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:16: ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) )
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==K_DISTINCT||LA5_0==K_AS||(LA5_0>=K_FILTERING && LA5_0<=K_TTL)||LA5_0==K_VALUES||LA5_0==K_EXISTS||LA5_0==K_TIMESTAMP||LA5_0==K_COUNTER||LA5_0==K_STATIC||(LA5_0>=K_KEY && LA5_0<=K_CUSTOM)||LA5_0==IDENT||(LA5_0>=K_KEYS && LA5_0<=K_TRIGGER)||LA5_0==K_LIST||(LA5_0>=K_ALL && LA5_0<=QUOTED_NAME)||LA5_0==K_TOKEN||LA5_0==K_CONTAINS||(LA5_0>=K_ASCII && LA5_0<=K_MAP)||LA5_0==144) ) {
                alt5=1;
            }
            else if ( (LA5_0==K_COUNT) ) {
                int LA5_2 = input.LA(2);

                if ( (LA5_2==141) ) {
                    alt5=2;
                }
                else if ( ((LA5_2>=K_AS && LA5_2<=K_FROM)||LA5_2==143||LA5_2==145) ) {
                    alt5=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 5, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }
            switch (alt5) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:18: ( K_DISTINCT )? sclause= selectClause
                    {
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:18: ( K_DISTINCT )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0==K_DISTINCT) ) {
                        int LA3_1 = input.LA(2);

                        if ( ((LA3_1>=K_DISTINCT && LA3_1<=K_COUNT)||(LA3_1>=K_FILTERING && LA3_1<=K_TTL)||LA3_1==K_VALUES||LA3_1==K_EXISTS||LA3_1==K_TIMESTAMP||LA3_1==K_COUNTER||LA3_1==K_STATIC||(LA3_1>=K_KEY && LA3_1<=K_CUSTOM)||LA3_1==IDENT||(LA3_1>=K_KEYS && LA3_1<=K_TRIGGER)||LA3_1==K_LIST||(LA3_1>=K_ALL && LA3_1<=QUOTED_NAME)||LA3_1==K_TOKEN||LA3_1==K_CONTAINS||(LA3_1>=K_ASCII && LA3_1<=K_MAP)||LA3_1==144) ) {
                            alt3=1;
                        }
                        else if ( (LA3_1==K_AS) ) {
                            int LA3_4 = input.LA(3);

                            if ( (LA3_4==K_AS) ) {
                                int LA3_5 = input.LA(4);

                                if ( ((LA3_5>=K_DISTINCT && LA3_5<=K_AS)||(LA3_5>=K_FILTERING && LA3_5<=K_TTL)||LA3_5==K_VALUES||LA3_5==K_EXISTS||LA3_5==K_TIMESTAMP||LA3_5==K_COUNTER||LA3_5==K_STATIC||(LA3_5>=K_KEY && LA3_5<=K_CUSTOM)||LA3_5==IDENT||(LA3_5>=K_KEYS && LA3_5<=K_TRIGGER)||LA3_5==K_LIST||(LA3_5>=K_ALL && LA3_5<=QUOTED_NAME)||LA3_5==K_CONTAINS||(LA3_5>=K_ASCII && LA3_5<=K_MAP)) ) {
                                    alt3=1;
                                }
                            }
                            else if ( (LA3_4==K_FROM||LA3_4==141||LA3_4==143||LA3_4==145) ) {
                                alt3=1;
                            }
                        }
                    }
                    switch (alt3) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:20: K_DISTINCT
                            {
                            match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectStatement746); 
                             isDistinct = true; 

                            }
                            break;

                    }

                    pushFollow(FOLLOW_selectClause_in_selectStatement755);
                    sclause=selectClause();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? )
                    {
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? )
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:19: K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )?
                    {
                    match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement775); 
                    match(input,141,FOLLOW_141_in_selectStatement777); 
                    pushFollow(FOLLOW_selectCountClause_in_selectStatement781);
                    sclause=selectCountClause();

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_selectStatement783); 
                     isCount = true; 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:81: ( K_AS c= cident )?
                    int alt4=2;
                    int LA4_0 = input.LA(1);

                    if ( (LA4_0==K_AS) ) {
                        alt4=1;
                    }
                    switch (alt4) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:82: K_AS c= cident
                            {
                            match(input,K_AS,FOLLOW_K_AS_in_selectStatement788); 
                            pushFollow(FOLLOW_cident_in_selectStatement792);
                            c=cident();

                            state._fsp--;

                             countAlias = c; 

                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement807); 
            pushFollow(FOLLOW_columnFamilyName_in_selectStatement811);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:7: ( K_WHERE wclause= whereClause )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==K_WHERE) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:9: K_WHERE wclause= whereClause
                    {
                    match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement821); 
                    pushFollow(FOLLOW_whereClause_in_selectStatement825);
                    wclause=whereClause();

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==K_ORDER) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
                    {
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement838); 
                    match(input,K_BY,FOLLOW_K_BY_in_selectStatement840); 
                    pushFollow(FOLLOW_orderByClause_in_selectStatement842);
                    orderByClause(orderings);

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:47: ( ',' orderByClause[orderings] )*
                    loop7:
                    do {
                        int alt7=2;
                        int LA7_0 = input.LA(1);

                        if ( (LA7_0==143) ) {
                            alt7=1;
                        }


                        switch (alt7) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:49: ',' orderByClause[orderings]
                    	    {
                    	    match(input,143,FOLLOW_143_in_selectStatement847); 
                    	    pushFollow(FOLLOW_orderByClause_in_selectStatement849);
                    	    orderByClause(orderings);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);


                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:277:7: ( K_LIMIT rows= intValue )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==K_LIMIT) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:277:9: K_LIMIT rows= intValue
                    {
                    match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement866); 
                    pushFollow(FOLLOW_intValue_in_selectStatement870);
                    rows=intValue();

                    state._fsp--;

                     limit = rows; 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:278:7: ( K_ALLOW K_FILTERING )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==K_ALLOW) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:278:9: K_ALLOW K_FILTERING
                    {
                    match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement885); 
                    match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement887); 
                     allowFiltering = true; 

                    }
                    break;

            }


                      SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
                                                                                         isDistinct,
                                                                                         isCount,
                                                                                         countAlias,
                                                                                         allowFiltering);
                      expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectStatement"


    // $ANTLR start "selectClause"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:289:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
    public final List<RawSelector> selectClause() throws RecognitionException {
        List<RawSelector> expr = null;

        RawSelector t1 = null;

        RawSelector tN = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:290:5: (t1= selector ( ',' tN= selector )* | '\\*' )
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( ((LA12_0>=K_DISTINCT && LA12_0<=K_AS)||(LA12_0>=K_FILTERING && LA12_0<=K_TTL)||LA12_0==K_VALUES||LA12_0==K_EXISTS||LA12_0==K_TIMESTAMP||LA12_0==K_COUNTER||LA12_0==K_STATIC||(LA12_0>=K_KEY && LA12_0<=K_CUSTOM)||LA12_0==IDENT||(LA12_0>=K_KEYS && LA12_0<=K_TRIGGER)||LA12_0==K_LIST||(LA12_0>=K_ALL && LA12_0<=QUOTED_NAME)||LA12_0==K_TOKEN||LA12_0==K_CONTAINS||(LA12_0>=K_ASCII && LA12_0<=K_MAP)) ) {
                alt12=1;
            }
            else if ( (LA12_0==144) ) {
                alt12=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }
            switch (alt12) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:290:7: t1= selector ( ',' tN= selector )*
                    {
                    pushFollow(FOLLOW_selector_in_selectClause924);
                    t1=selector();

                    state._fsp--;

                     expr = new ArrayList<RawSelector>(); expr.add(t1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:290:76: ( ',' tN= selector )*
                    loop11:
                    do {
                        int alt11=2;
                        int LA11_0 = input.LA(1);

                        if ( (LA11_0==143) ) {
                            alt11=1;
                        }


                        switch (alt11) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:290:77: ',' tN= selector
                    	    {
                    	    match(input,143,FOLLOW_143_in_selectClause929); 
                    	    pushFollow(FOLLOW_selector_in_selectClause933);
                    	    tN=selector();

                    	    state._fsp--;

                    	     expr.add(tN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);


                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:291:7: '\\*'
                    {
                    match(input,144,FOLLOW_144_in_selectClause945); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectClause"


    // $ANTLR start "selector"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:294:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= cident )? ;
    public final RawSelector selector() throws RecognitionException {
        RawSelector s = null;

        Selectable us = null;

        ColumnIdentifier c = null;


         ColumnIdentifier alias = null; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:5: (us= unaliasedSelector ( K_AS c= cident )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:7: us= unaliasedSelector ( K_AS c= cident )?
            {
            pushFollow(FOLLOW_unaliasedSelector_in_selector978);
            us=unaliasedSelector();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:28: ( K_AS c= cident )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==K_AS) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:29: K_AS c= cident
                    {
                    match(input,K_AS,FOLLOW_K_AS_in_selector981); 
                    pushFollow(FOLLOW_cident_in_selector985);
                    c=cident();

                    state._fsp--;

                     alias = c; 

                    }
                    break;

            }

             s = new RawSelector(us, alias); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "selector"


    // $ANTLR start "unaliasedSelector"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:1: unaliasedSelector returns [Selectable s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* ;
    public final Selectable unaliasedSelector() throws RecognitionException {
        Selectable s = null;

        ColumnIdentifier c = null;

        String f = null;

        List<Selectable> args = null;

        ColumnIdentifier fi = null;


         Selectable tmp = null; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:5: ( (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )*
            {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs )
            int alt14=4;
            alt14 = dfa14.predict(input);
            switch (alt14) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:10: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_unaliasedSelector1026);
                    c=cident();

                    state._fsp--;

                     tmp = c; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:10: K_WRITETIME '(' c= cident ')'
                    {
                    match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector1072); 
                    match(input,141,FOLLOW_141_in_unaliasedSelector1074); 
                    pushFollow(FOLLOW_cident_in_unaliasedSelector1078);
                    c=cident();

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_unaliasedSelector1080); 
                     tmp = new Selectable.WritetimeOrTTL(c, true); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:303:10: K_TTL '(' c= cident ')'
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1106); 
                    match(input,141,FOLLOW_141_in_unaliasedSelector1114); 
                    pushFollow(FOLLOW_cident_in_unaliasedSelector1118);
                    c=cident();

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_unaliasedSelector1120); 
                     tmp = new Selectable.WritetimeOrTTL(c, false); 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:10: f= functionName args= selectionFunctionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_unaliasedSelector1148);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152);
                    args=selectionFunctionArgs();

                    state._fsp--;

                     tmp = new Selectable.WithFunction(f, args); 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:10: ( '.' fi= cident )*
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==145) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:12: '.' fi= cident
            	    {
            	    match(input,145,FOLLOW_145_in_unaliasedSelector1167); 
            	    pushFollow(FOLLOW_cident_in_unaliasedSelector1171);
            	    fi=cident();

            	    state._fsp--;

            	     tmp = new Selectable.WithFieldSelection(tmp, fi); 

            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);

             s = tmp; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "unaliasedSelector"


    // $ANTLR start "selectionFunctionArgs"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:1: selectionFunctionArgs returns [List<Selectable> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
    public final List<Selectable> selectionFunctionArgs() throws RecognitionException {
        List<Selectable> a = null;

        Selectable s1 = null;

        Selectable sn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0==141) ) {
                int LA17_1 = input.LA(2);

                if ( (LA17_1==142) ) {
                    alt17=1;
                }
                else if ( ((LA17_1>=K_DISTINCT && LA17_1<=K_AS)||(LA17_1>=K_FILTERING && LA17_1<=K_TTL)||LA17_1==K_VALUES||LA17_1==K_EXISTS||LA17_1==K_TIMESTAMP||LA17_1==K_COUNTER||LA17_1==K_STATIC||(LA17_1>=K_KEY && LA17_1<=K_CUSTOM)||LA17_1==IDENT||(LA17_1>=K_KEYS && LA17_1<=K_TRIGGER)||LA17_1==K_LIST||(LA17_1>=K_ALL && LA17_1<=QUOTED_NAME)||LA17_1==K_TOKEN||LA17_1==K_CONTAINS||(LA17_1>=K_ASCII && LA17_1<=K_MAP)) ) {
                    alt17=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 17, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }
            switch (alt17) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:7: '(' ')'
                    {
                    match(input,141,FOLLOW_141_in_selectionFunctionArgs1199); 
                    match(input,142,FOLLOW_142_in_selectionFunctionArgs1201); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:310:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
                    {
                    match(input,141,FOLLOW_141_in_selectionFunctionArgs1211); 
                    pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215);
                    s1=unaliasedSelector();

                    state._fsp--;

                     List<Selectable> args = new ArrayList<Selectable>(); args.add(s1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:311:11: ( ',' sn= unaliasedSelector )*
                    loop16:
                    do {
                        int alt16=2;
                        int LA16_0 = input.LA(1);

                        if ( (LA16_0==143) ) {
                            alt16=1;
                        }


                        switch (alt16) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:311:13: ',' sn= unaliasedSelector
                    	    {
                    	    match(input,143,FOLLOW_143_in_selectionFunctionArgs1231); 
                    	    pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235);
                    	    sn=unaliasedSelector();

                    	    state._fsp--;

                    	     args.add(sn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop16;
                        }
                    } while (true);

                    match(input,142,FOLLOW_142_in_selectionFunctionArgs1248); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "selectionFunctionArgs"


    // $ANTLR start "selectCountClause"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:315:1: selectCountClause returns [List<RawSelector> expr] : ( '\\*' | i= INTEGER );
    public final List<RawSelector> selectCountClause() throws RecognitionException {
        List<RawSelector> expr = null;

        Token i=null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:316:5: ( '\\*' | i= INTEGER )
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( (LA18_0==144) ) {
                alt18=1;
            }
            else if ( (LA18_0==INTEGER) ) {
                alt18=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }
            switch (alt18) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:316:7: '\\*'
                    {
                    match(input,144,FOLLOW_144_in_selectCountClause1271); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:7: i= INTEGER
                    {
                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectCountClause1293); 
                     if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")"); expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectCountClause"


    // $ANTLR start "whereClause"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:320:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
    public final List<Relation> whereClause() throws RecognitionException {
        List<Relation> clause = null;

         clause = new ArrayList<Relation>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:5: ( relation[$clause] ( K_AND relation[$clause] )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:7: relation[$clause] ( K_AND relation[$clause] )*
            {
            pushFollow(FOLLOW_relation_in_whereClause1329);
            relation(clause);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:25: ( K_AND relation[$clause] )*
            loop19:
            do {
                int alt19=2;
                int LA19_0 = input.LA(1);

                if ( (LA19_0==K_AND) ) {
                    alt19=1;
                }


                switch (alt19) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:26: K_AND relation[$clause]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_whereClause1333); 
            	    pushFollow(FOLLOW_relation_in_whereClause1335);
            	    relation(clause);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop19;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return clause;
    }
    // $ANTLR end "whereClause"


    // $ANTLR start "orderByClause"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:325:1: orderByClause[Map<ColumnIdentifier, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
    public final void orderByClause(Map<ColumnIdentifier, Boolean> orderings) throws RecognitionException {
        ColumnIdentifier c = null;



                ColumnIdentifier orderBy = null;
                boolean reversed = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:5: (c= cident ( K_ASC | K_DESC )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:7: c= cident ( K_ASC | K_DESC )?
            {
            pushFollow(FOLLOW_cident_in_orderByClause1366);
            c=cident();

            state._fsp--;

             orderBy = c; 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:33: ( K_ASC | K_DESC )?
            int alt20=3;
            int LA20_0 = input.LA(1);

            if ( (LA20_0==K_ASC) ) {
                alt20=1;
            }
            else if ( (LA20_0==K_DESC) ) {
                alt20=2;
            }
            switch (alt20) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:34: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1371); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:42: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1375); 
                     reversed = true; 

                    }
                    break;

            }

             orderings.put(c, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "orderByClause"


    // $ANTLR start "insertStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:1: insertStatement returns [UpdateStatement.ParsedInsert expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
    public final UpdateStatement.ParsedInsert insertStatement() throws RecognitionException {
        UpdateStatement.ParsedInsert expr = null;

        CFName cf = null;

        ColumnIdentifier c1 = null;

        ColumnIdentifier cn = null;

        Term.Raw v1 = null;

        Term.Raw vn = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<ColumnIdentifier> columnNames  = new ArrayList<ColumnIdentifier>();
                List<Term.Raw> values = new ArrayList<Term.Raw>();
                boolean ifNotExists = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
            {
            match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1413); 
            match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1415); 
            pushFollow(FOLLOW_columnFamilyName_in_insertStatement1419);
            cf=columnFamilyName();

            state._fsp--;

            match(input,141,FOLLOW_141_in_insertStatement1431); 
            pushFollow(FOLLOW_cident_in_insertStatement1435);
            c1=cident();

            state._fsp--;

             columnNames.add(c1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:347:51: ( ',' cn= cident )*
            loop21:
            do {
                int alt21=2;
                int LA21_0 = input.LA(1);

                if ( (LA21_0==143) ) {
                    alt21=1;
                }


                switch (alt21) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:347:53: ',' cn= cident
            	    {
            	    match(input,143,FOLLOW_143_in_insertStatement1442); 
            	    pushFollow(FOLLOW_cident_in_insertStatement1446);
            	    cn=cident();

            	    state._fsp--;

            	     columnNames.add(cn); 

            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_insertStatement1453); 
            match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement1463); 
            match(input,141,FOLLOW_141_in_insertStatement1475); 
            pushFollow(FOLLOW_term_in_insertStatement1479);
            v1=term();

            state._fsp--;

             values.add(v1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:43: ( ',' vn= term )*
            loop22:
            do {
                int alt22=2;
                int LA22_0 = input.LA(1);

                if ( (LA22_0==143) ) {
                    alt22=1;
                }


                switch (alt22) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:45: ',' vn= term
            	    {
            	    match(input,143,FOLLOW_143_in_insertStatement1485); 
            	    pushFollow(FOLLOW_term_in_insertStatement1489);
            	    vn=term();

            	    state._fsp--;

            	     values.add(vn); 

            	    }
            	    break;

            	default :
            	    break loop22;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_insertStatement1496); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:351:9: ( K_IF K_NOT K_EXISTS )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==K_IF) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:351:11: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_insertStatement1509); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_insertStatement1511); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_insertStatement1513); 
                     ifNotExists = true; 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:9: ( usingClause[attrs] )?
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==K_USING) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:11: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_insertStatement1530);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }


                      expr = new UpdateStatement.ParsedInsert(cf,
                                                               attrs,
                                                               columnNames,
                                                               values,
                                                               ifNotExists);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "insertStatement"


    // $ANTLR start "usingClause"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
    public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClause1560); 
            pushFollow(FOLLOW_usingClauseObjective_in_usingClause1562);
            usingClauseObjective(attrs);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:43: ( K_AND usingClauseObjective[attrs] )*
            loop25:
            do {
                int alt25=2;
                int LA25_0 = input.LA(1);

                if ( (LA25_0==K_AND) ) {
                    alt25=1;
                }


                switch (alt25) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:45: K_AND usingClauseObjective[attrs]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_usingClause1567); 
            	    pushFollow(FOLLOW_usingClauseObjective_in_usingClause1569);
            	    usingClauseObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClause"


    // $ANTLR start "usingClauseObjective"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
    public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
        Term.Raw ts = null;

        Term.Raw t = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
            int alt26=2;
            int LA26_0 = input.LA(1);

            if ( (LA26_0==K_TIMESTAMP) ) {
                alt26=1;
            }
            else if ( (LA26_0==K_TTL) ) {
                alt26=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 26, 0, input);

                throw nvae;
            }
            switch (alt26) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:7: K_TIMESTAMP ts= intValue
                    {
                    match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591); 
                    pushFollow(FOLLOW_intValue_in_usingClauseObjective1595);
                    ts=intValue();

                    state._fsp--;

                     attrs.timestamp = ts; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:7: K_TTL t= intValue
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective1605); 
                    pushFollow(FOLLOW_intValue_in_usingClauseObjective1609);
                    t=intValue();

                    state._fsp--;

                     attrs.timeToLive = t; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseObjective"


    // $ANTLR start "updateStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:371:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )? ;
    public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
        UpdateStatement.ParsedUpdate expr = null;

        CFName cf = null;

        List<Relation> wclause = null;

        List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier, Operation.RawUpdate>>();
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )?
            {
            match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement1643); 
            pushFollow(FOLLOW_columnFamilyName_in_updateStatement1647);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:7: ( usingClause[attrs] )?
            int alt27=2;
            int LA27_0 = input.LA(1);

            if ( (LA27_0==K_USING) ) {
                alt27=1;
            }
            switch (alt27) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:9: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_updateStatement1657);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_SET,FOLLOW_K_SET_in_updateStatement1669); 
            pushFollow(FOLLOW_columnOperation_in_updateStatement1671);
            columnOperation(operations);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:41: ( ',' columnOperation[operations] )*
            loop28:
            do {
                int alt28=2;
                int LA28_0 = input.LA(1);

                if ( (LA28_0==143) ) {
                    alt28=1;
                }


                switch (alt28) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:42: ',' columnOperation[operations]
            	    {
            	    match(input,143,FOLLOW_143_in_updateStatement1675); 
            	    pushFollow(FOLLOW_columnOperation_in_updateStatement1677);
            	    columnOperation(operations);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);

            match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1688); 
            pushFollow(FOLLOW_whereClause_in_updateStatement1692);
            wclause=whereClause();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:386:7: ( K_IF conditions= updateConditions )?
            int alt29=2;
            int LA29_0 = input.LA(1);

            if ( (LA29_0==K_IF) ) {
                alt29=1;
            }
            switch (alt29) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:386:9: K_IF conditions= updateConditions
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_updateStatement1702); 
                    pushFollow(FOLLOW_updateConditions_in_updateStatement1706);
                    conditions=updateConditions();

                    state._fsp--;


                    }
                    break;

            }


                      return new UpdateStatement.ParsedUpdate(cf,
                                                              attrs,
                                                              operations,
                                                              wclause,
                                                              conditions == null ? Collections.<Pair<ColumnIdentifier, ColumnCondition.Raw>>emptyList() : conditions);
                 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "updateStatement"


    // $ANTLR start "updateConditions"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:396:1: updateConditions returns [List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
    public final List<Pair<ColumnIdentifier, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
        List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions = null;

         conditions = new ArrayList<Pair<ColumnIdentifier, ColumnCondition.Raw>>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
            {
            pushFollow(FOLLOW_columnCondition_in_updateConditions1747);
            columnCondition(conditions);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:35: ( K_AND columnCondition[conditions] )*
            loop30:
            do {
                int alt30=2;
                int LA30_0 = input.LA(1);

                if ( (LA30_0==K_AND) ) {
                    alt30=1;
                }


                switch (alt30) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:37: K_AND columnCondition[conditions]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_updateConditions1752); 
            	    pushFollow(FOLLOW_columnCondition_in_updateConditions1754);
            	    columnCondition(conditions);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop30;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return conditions;
    }
    // $ANTLR end "updateConditions"


    // $ANTLR start "deleteStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:402:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS | conditions= updateConditions ) )? ;
    public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
        DeleteStatement.Parsed expr = null;

        List<Operation.RawDeletion> dels = null;

        CFName cf = null;

        List<Relation> wclause = null;

        List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
                boolean ifExists = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS | conditions= updateConditions ) )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS | conditions= updateConditions ) )?
            {
            match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1791); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:16: (dels= deleteSelection )?
            int alt31=2;
            int LA31_0 = input.LA(1);

            if ( ((LA31_0>=K_DISTINCT && LA31_0<=K_AS)||(LA31_0>=K_FILTERING && LA31_0<=K_TTL)||LA31_0==K_VALUES||LA31_0==K_EXISTS||LA31_0==K_TIMESTAMP||LA31_0==K_COUNTER||LA31_0==K_STATIC||(LA31_0>=K_KEY && LA31_0<=K_CUSTOM)||LA31_0==IDENT||(LA31_0>=K_KEYS && LA31_0<=K_TRIGGER)||LA31_0==K_LIST||(LA31_0>=K_ALL && LA31_0<=QUOTED_NAME)||LA31_0==K_CONTAINS||(LA31_0>=K_ASCII && LA31_0<=K_MAP)) ) {
                alt31=1;
            }
            switch (alt31) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:18: dels= deleteSelection
                    {
                    pushFollow(FOLLOW_deleteSelection_in_deleteStatement1797);
                    dels=deleteSelection();

                    state._fsp--;

                     columnDeletions = dels; 

                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1810); 
            pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1814);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:417:7: ( usingClauseDelete[attrs] )?
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( (LA32_0==K_USING) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:417:9: usingClauseDelete[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1824);
                    usingClauseDelete(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1836); 
            pushFollow(FOLLOW_whereClause_in_deleteStatement1840);
            wclause=whereClause();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:7: ( K_IF ( K_EXISTS | conditions= updateConditions ) )?
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==K_IF) ) {
                alt34=1;
            }
            switch (alt34) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:9: K_IF ( K_EXISTS | conditions= updateConditions )
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_deleteStatement1850); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:14: ( K_EXISTS | conditions= updateConditions )
                    int alt33=2;
                    int LA33_0 = input.LA(1);

                    if ( (LA33_0==K_EXISTS) ) {
                        int LA33_1 = input.LA(2);

                        if ( (LA33_1==EOF||LA33_1==K_INSERT||LA33_1==K_UPDATE||LA33_1==K_DELETE||LA33_1==K_APPLY||LA33_1==140) ) {
                            alt33=1;
                        }
                        else if ( (LA33_1==146||LA33_1==152) ) {
                            alt33=2;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 33, 1, input);

                            throw nvae;
                        }
                    }
                    else if ( ((LA33_0>=K_DISTINCT && LA33_0<=K_AS)||(LA33_0>=K_FILTERING && LA33_0<=K_TTL)||LA33_0==K_VALUES||LA33_0==K_TIMESTAMP||LA33_0==K_COUNTER||LA33_0==K_STATIC||(LA33_0>=K_KEY && LA33_0<=K_CUSTOM)||LA33_0==IDENT||(LA33_0>=K_KEYS && LA33_0<=K_TRIGGER)||LA33_0==K_LIST||(LA33_0>=K_ALL && LA33_0<=QUOTED_NAME)||LA33_0==K_CONTAINS||(LA33_0>=K_ASCII && LA33_0<=K_MAP)) ) {
                        alt33=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 33, 0, input);

                        throw nvae;
                    }
                    switch (alt33) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:16: K_EXISTS
                            {
                            match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement1854); 
                             ifExists = true; 

                            }
                            break;
                        case 2 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:48: conditions= updateConditions
                            {
                            pushFollow(FOLLOW_updateConditions_in_deleteStatement1862);
                            conditions=updateConditions();

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }


                      return new DeleteStatement.Parsed(cf,
                                                        attrs,
                                                        columnDeletions,
                                                        wclause,
                                                        conditions == null ? Collections.<Pair<ColumnIdentifier, ColumnCondition.Raw>>emptyList() : conditions,
                                                        ifExists);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "deleteStatement"


    // $ANTLR start "deleteSelection"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:1: deleteSelection returns [List<Operation.RawDeletion> operations] : t1= deleteOp ( ',' tN= deleteOp )* ;
    public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
        List<Operation.RawDeletion> operations = null;

        Operation.RawDeletion t1 = null;

        Operation.RawDeletion tN = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:5: (t1= deleteOp ( ',' tN= deleteOp )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:7: t1= deleteOp ( ',' tN= deleteOp )*
            {
             operations = new ArrayList<Operation.RawDeletion>(); 
            pushFollow(FOLLOW_deleteOp_in_deleteSelection1909);
            t1=deleteOp();

            state._fsp--;

             operations.add(t1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:11: ( ',' tN= deleteOp )*
            loop35:
            do {
                int alt35=2;
                int LA35_0 = input.LA(1);

                if ( (LA35_0==143) ) {
                    alt35=1;
                }


                switch (alt35) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:12: ',' tN= deleteOp
            	    {
            	    match(input,143,FOLLOW_143_in_deleteSelection1924); 
            	    pushFollow(FOLLOW_deleteOp_in_deleteSelection1928);
            	    tN=deleteOp();

            	    state._fsp--;

            	     operations.add(tN); 

            	    }
            	    break;

            	default :
            	    break loop35;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return operations;
    }
    // $ANTLR end "deleteSelection"


    // $ANTLR start "deleteOp"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:436:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );
    public final Operation.RawDeletion deleteOp() throws RecognitionException {
        Operation.RawDeletion op = null;

        ColumnIdentifier c = null;

        Term.Raw t = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:5: (c= cident | c= cident '[' t= term ']' )
            int alt36=2;
            alt36 = dfa36.predict(input);
            switch (alt36) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1955);
                    c=cident();

                    state._fsp--;

                     op = new Operation.ColumnDeletion(c); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:7: c= cident '[' t= term ']'
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1982);
                    c=cident();

                    state._fsp--;

                    match(input,146,FOLLOW_146_in_deleteOp1984); 
                    pushFollow(FOLLOW_term_in_deleteOp1988);
                    t=term();

                    state._fsp--;

                    match(input,147,FOLLOW_147_in_deleteOp1990); 
                     op = new Operation.ElementDeletion(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "deleteOp"


    // $ANTLR start "usingClauseDelete"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:441:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
    public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
        Term.Raw ts = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:442:5: ( K_USING K_TIMESTAMP ts= intValue )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:442:7: K_USING K_TIMESTAMP ts= intValue
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete2010); 
            match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete2012); 
            pushFollow(FOLLOW_intValue_in_usingClauseDelete2016);
            ts=intValue();

            state._fsp--;

             attrs.timestamp = ts; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDelete"


    // $ANTLR start "batchStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
    public final BatchStatement.Parsed batchStatement() throws RecognitionException {
        BatchStatement.Parsed expr = null;

        ModificationStatement.Parsed s = null;



                BatchStatement.Type type = BatchStatement.Type.LOGGED;
                List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
                Attributes.Raw attrs = new Attributes.Raw();
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
            {
            match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement2050); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:7: ( K_UNLOGGED | K_COUNTER )?
            int alt37=3;
            int LA37_0 = input.LA(1);

            if ( (LA37_0==K_UNLOGGED) ) {
                alt37=1;
            }
            else if ( (LA37_0==K_COUNTER) ) {
                alt37=2;
            }
            switch (alt37) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:9: K_UNLOGGED
                    {
                    match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement2060); 
                     type = BatchStatement.Type.UNLOGGED; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:63: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement2066); 
                     type = BatchStatement.Type.COUNTER; 

                    }
                    break;

            }

            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2079); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:477:15: ( usingClause[attrs] )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==K_USING) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:477:17: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_batchStatement2083);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:11: (s= batchStatementObjective ( ';' )? )*
            loop40:
            do {
                int alt40=2;
                int LA40_0 = input.LA(1);

                if ( (LA40_0==K_INSERT||LA40_0==K_UPDATE||LA40_0==K_DELETE) ) {
                    alt40=1;
                }


                switch (alt40) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:13: s= batchStatementObjective ( ';' )?
            	    {
            	    pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2103);
            	    s=batchStatementObjective();

            	    state._fsp--;

            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:39: ( ';' )?
            	    int alt39=2;
            	    int LA39_0 = input.LA(1);

            	    if ( (LA39_0==140) ) {
            	        alt39=1;
            	    }
            	    switch (alt39) {
            	        case 1 :
            	            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:39: ';'
            	            {
            	            match(input,140,FOLLOW_140_in_batchStatement2105); 

            	            }
            	            break;

            	    }

            	     statements.add(s); 

            	    }
            	    break;

            	default :
            	    break loop40;
                }
            } while (true);

            match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2119); 
            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2121); 

                      return new BatchStatement.Parsed(type, attrs, statements);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "batchStatement"


    // $ANTLR start "batchStatementObjective"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:485:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement | u= updateStatement | d= deleteStatement );
    public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
        ModificationStatement.Parsed statement = null;

        UpdateStatement.ParsedInsert i = null;

        UpdateStatement.ParsedUpdate u = null;

        DeleteStatement.Parsed d = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:5: (i= insertStatement | u= updateStatement | d= deleteStatement )
            int alt41=3;
            switch ( input.LA(1) ) {
            case K_INSERT:
                {
                alt41=1;
                }
                break;
            case K_UPDATE:
                {
                alt41=2;
                }
                break;
            case K_DELETE:
                {
                alt41=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 41, 0, input);

                throw nvae;
            }

            switch (alt41) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:7: i= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2152);
                    i=insertStatement();

                    state._fsp--;

                     statement = i; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:487:7: u= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2165);
                    u=updateStatement();

                    state._fsp--;

                     statement = u; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:488:7: d= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2178);
                    d=deleteStatement();

                    state._fsp--;

                     statement = d; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return statement;
    }
    // $ANTLR end "batchStatementObjective"


    // $ANTLR start "createKeyspaceStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:491:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
    public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
        CreateKeyspaceStatement expr = null;

        String ks = null;



                KSPropDefs attrs = new KSPropDefs();
                boolean ifNotExists = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement2213); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2215); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:27: ( K_IF K_NOT K_EXISTS )?
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( (LA42_0==K_IF) ) {
                alt42=1;
            }
            switch (alt42) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:28: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement2218); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement2220); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement2222); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement2231);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement2239); 
            pushFollow(FOLLOW_properties_in_createKeyspaceStatement2241);
            properties(attrs);

            state._fsp--;

             expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createKeyspaceStatement"


    // $ANTLR start "createTableStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:503:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
    public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
        CreateTableStatement.RawStatement expr = null;

        CFName cf = null;


         boolean ifNotExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement2276); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement2278); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:31: ( K_IF K_NOT K_EXISTS )?
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( (LA43_0==K_IF) ) {
                alt43=1;
            }
            switch (alt43) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:32: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createTableStatement2281); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement2283); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement2285); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_columnFamilyName_in_createTableStatement2300);
            cf=columnFamilyName();

            state._fsp--;

             expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
            pushFollow(FOLLOW_cfamDefinition_in_createTableStatement2310);
            cfamDefinition(expr);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createTableStatement"


    // $ANTLR start "cfamDefinition"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:517:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
    public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            {
            match(input,141,FOLLOW_141_in_cfamDefinition2329); 
            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2331);
            cfamColumns(expr);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:29: ( ',' ( cfamColumns[expr] )? )*
            loop45:
            do {
                int alt45=2;
                int LA45_0 = input.LA(1);

                if ( (LA45_0==143) ) {
                    alt45=1;
                }


                switch (alt45) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:31: ',' ( cfamColumns[expr] )?
            	    {
            	    match(input,143,FOLLOW_143_in_cfamDefinition2336); 
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:35: ( cfamColumns[expr] )?
            	    int alt44=2;
            	    int LA44_0 = input.LA(1);

            	    if ( ((LA44_0>=K_DISTINCT && LA44_0<=K_AS)||(LA44_0>=K_FILTERING && LA44_0<=K_TTL)||LA44_0==K_VALUES||LA44_0==K_EXISTS||LA44_0==K_TIMESTAMP||LA44_0==K_COUNTER||(LA44_0>=K_STATIC && LA44_0<=K_CUSTOM)||LA44_0==IDENT||(LA44_0>=K_KEYS && LA44_0<=K_TRIGGER)||LA44_0==K_LIST||(LA44_0>=K_ALL && LA44_0<=QUOTED_NAME)||LA44_0==K_CONTAINS||(LA44_0>=K_ASCII && LA44_0<=K_MAP)) ) {
            	        alt44=1;
            	    }
            	    switch (alt44) {
            	        case 1 :
            	            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:35: cfamColumns[expr]
            	            {
            	            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2338);
            	            cfamColumns(expr);

            	            state._fsp--;


            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop45;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_cfamDefinition2345); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            int alt47=2;
            int LA47_0 = input.LA(1);

            if ( (LA47_0==K_WITH) ) {
                alt47=1;
            }
            switch (alt47) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition2355); 
                    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2357);
                    cfamProperty(expr);

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:35: ( K_AND cfamProperty[expr] )*
                    loop46:
                    do {
                        int alt46=2;
                        int LA46_0 = input.LA(1);

                        if ( (LA46_0==K_AND) ) {
                            alt46=1;
                        }


                        switch (alt46) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:37: K_AND cfamProperty[expr]
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition2362); 
                    	    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2364);
                    	    cfamProperty(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop46;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamDefinition"


    // $ANTLR start "cfamColumns"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= cident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' );
    public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        CQL3Type.Raw v = null;

        ColumnIdentifier c = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:5: (k= cident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' )
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( ((LA51_0>=K_DISTINCT && LA51_0<=K_AS)||(LA51_0>=K_FILTERING && LA51_0<=K_TTL)||LA51_0==K_VALUES||LA51_0==K_EXISTS||LA51_0==K_TIMESTAMP||LA51_0==K_COUNTER||LA51_0==K_STATIC||(LA51_0>=K_KEY && LA51_0<=K_CUSTOM)||LA51_0==IDENT||(LA51_0>=K_KEYS && LA51_0<=K_TRIGGER)||LA51_0==K_LIST||(LA51_0>=K_ALL && LA51_0<=QUOTED_NAME)||LA51_0==K_CONTAINS||(LA51_0>=K_ASCII && LA51_0<=K_MAP)) ) {
                alt51=1;
            }
            else if ( (LA51_0==K_PRIMARY) ) {
                alt51=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;
            }
            switch (alt51) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:7: k= cident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )?
                    {
                    pushFollow(FOLLOW_cident_in_cfamColumns2390);
                    k=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_cfamColumns2394);
                    v=comparatorType();

                    state._fsp--;

                     boolean isStatic=false; 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:61: ( K_STATIC )?
                    int alt48=2;
                    int LA48_0 = input.LA(1);

                    if ( (LA48_0==K_STATIC) ) {
                        alt48=1;
                    }
                    switch (alt48) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:62: K_STATIC
                            {
                            match(input,K_STATIC,FOLLOW_K_STATIC_in_cfamColumns2399); 
                            isStatic = true;

                            }
                            break;

                    }

                     expr.addDefinition(k, v, isStatic); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:524:9: ( K_PRIMARY K_KEY )?
                    int alt49=2;
                    int LA49_0 = input.LA(1);

                    if ( (LA49_0==K_PRIMARY) ) {
                        alt49=1;
                    }
                    switch (alt49) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:524:10: K_PRIMARY K_KEY
                            {
                            match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2416); 
                            match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2418); 
                             expr.addKeyAliases(Collections.singletonList(k)); 

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')'
                    {
                    match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2430); 
                    match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2432); 
                    match(input,141,FOLLOW_141_in_cfamColumns2434); 
                    pushFollow(FOLLOW_pkDef_in_cfamColumns2436);
                    pkDef(expr);

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:39: ( ',' c= cident )*
                    loop50:
                    do {
                        int alt50=2;
                        int LA50_0 = input.LA(1);

                        if ( (LA50_0==143) ) {
                            alt50=1;
                        }


                        switch (alt50) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:40: ',' c= cident
                    	    {
                    	    match(input,143,FOLLOW_143_in_cfamColumns2440); 
                    	    pushFollow(FOLLOW_cident_in_cfamColumns2444);
                    	    c=cident();

                    	    state._fsp--;

                    	     expr.addColumnAlias(c); 

                    	    }
                    	    break;

                    	default :
                    	    break loop50;
                        }
                    } while (true);

                    match(input,142,FOLLOW_142_in_cfamColumns2451); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamColumns"


    // $ANTLR start "pkDef"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:1: pkDef[CreateTableStatement.RawStatement expr] : (k= cident | '(' k1= cident ( ',' kn= cident )* ')' );
    public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        ColumnIdentifier k1 = null;

        ColumnIdentifier kn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:529:5: (k= cident | '(' k1= cident ( ',' kn= cident )* ')' )
            int alt53=2;
            int LA53_0 = input.LA(1);

            if ( ((LA53_0>=K_DISTINCT && LA53_0<=K_AS)||(LA53_0>=K_FILTERING && LA53_0<=K_TTL)||LA53_0==K_VALUES||LA53_0==K_EXISTS||LA53_0==K_TIMESTAMP||LA53_0==K_COUNTER||LA53_0==K_STATIC||(LA53_0>=K_KEY && LA53_0<=K_CUSTOM)||LA53_0==IDENT||(LA53_0>=K_KEYS && LA53_0<=K_TRIGGER)||LA53_0==K_LIST||(LA53_0>=K_ALL && LA53_0<=QUOTED_NAME)||LA53_0==K_CONTAINS||(LA53_0>=K_ASCII && LA53_0<=K_MAP)) ) {
                alt53=1;
            }
            else if ( (LA53_0==141) ) {
                alt53=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }
            switch (alt53) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:529:7: k= cident
                    {
                    pushFollow(FOLLOW_cident_in_pkDef2471);
                    k=cident();

                    state._fsp--;

                     expr.addKeyAliases(Collections.singletonList(k)); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:7: '(' k1= cident ( ',' kn= cident )* ')'
                    {
                    match(input,141,FOLLOW_141_in_pkDef2481); 
                     List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
                    pushFollow(FOLLOW_cident_in_pkDef2487);
                    k1=cident();

                    state._fsp--;

                     l.add(k1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:102: ( ',' kn= cident )*
                    loop52:
                    do {
                        int alt52=2;
                        int LA52_0 = input.LA(1);

                        if ( (LA52_0==143) ) {
                            alt52=1;
                        }


                        switch (alt52) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:104: ',' kn= cident
                    	    {
                    	    match(input,143,FOLLOW_143_in_pkDef2493); 
                    	    pushFollow(FOLLOW_cident_in_pkDef2497);
                    	    kn=cident();

                    	    state._fsp--;

                    	     l.add(kn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop52;
                        }
                    } while (true);

                    match(input,142,FOLLOW_142_in_pkDef2504); 
                     expr.addKeyAliases(l); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "pkDef"


    // $ANTLR start "cfamProperty"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:1: cfamProperty[CreateTableStatement.RawStatement expr] : ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' );
    public final void cfamProperty(CreateTableStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:534:5: ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' )
            int alt55=3;
            switch ( input.LA(1) ) {
            case K_DISTINCT:
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_STATIC:
            case K_KEY:
            case K_STORAGE:
            case K_TYPE:
            case K_CUSTOM:
            case IDENT:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt55=1;
                }
                break;
            case K_COMPACT:
                {
                int LA55_2 = input.LA(2);

                if ( (LA55_2==K_STORAGE) ) {
                    alt55=2;
                }
                else if ( (LA55_2==152) ) {
                    alt55=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 55, 2, input);

                    throw nvae;
                }
                }
                break;
            case K_CLUSTERING:
                {
                int LA55_3 = input.LA(2);

                if ( (LA55_3==K_ORDER) ) {
                    alt55=3;
                }
                else if ( (LA55_3==152) ) {
                    alt55=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 55, 3, input);

                    throw nvae;
                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 55, 0, input);

                throw nvae;
            }

            switch (alt55) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:534:7: property[expr.properties]
                    {
                    pushFollow(FOLLOW_property_in_cfamProperty2524);
                    property(expr.properties);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:535:7: K_COMPACT K_STORAGE
                    {
                    match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty2533); 
                    match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty2535); 
                     expr.setCompactStorage(); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')'
                    {
                    match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty2545); 
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty2547); 
                    match(input,K_BY,FOLLOW_K_BY_in_cfamProperty2549); 
                    match(input,141,FOLLOW_141_in_cfamProperty2551); 
                    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2553);
                    cfamOrdering(expr);

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:56: ( ',' cfamOrdering[expr] )*
                    loop54:
                    do {
                        int alt54=2;
                        int LA54_0 = input.LA(1);

                        if ( (LA54_0==143) ) {
                            alt54=1;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:57: ',' cfamOrdering[expr]
                    	    {
                    	    match(input,143,FOLLOW_143_in_cfamProperty2557); 
                    	    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2559);
                    	    cfamOrdering(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop54;
                        }
                    } while (true);

                    match(input,142,FOLLOW_142_in_cfamProperty2564); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamProperty"


    // $ANTLR start "cfamOrdering"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:539:1: cfamOrdering[CreateTableStatement.RawStatement expr] : k= cident ( K_ASC | K_DESC ) ;
    public final void cfamOrdering(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;


         boolean reversed=false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:5: (k= cident ( K_ASC | K_DESC ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:7: k= cident ( K_ASC | K_DESC )
            {
            pushFollow(FOLLOW_cident_in_cfamOrdering2592);
            k=cident();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:16: ( K_ASC | K_DESC )
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==K_ASC) ) {
                alt56=1;
            }
            else if ( (LA56_0==K_DESC) ) {
                alt56=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:17: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering2595); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:25: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering2599); 
                     reversed=true;

                    }
                    break;

            }

             expr.setOrdering(k, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamOrdering"


    // $ANTLR start "createTypeStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:545:1: createTypeStatement returns [CreateTypeStatement expr] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' ;
    public final CreateTypeStatement createTypeStatement() throws RecognitionException {
        CreateTypeStatement expr = null;

        UTName tn = null;


         boolean ifNotExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')'
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement2638); 
            match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement2640); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:23: ( K_IF K_NOT K_EXISTS )?
            int alt57=2;
            int LA57_0 = input.LA(1);

            if ( (LA57_0==K_IF) ) {
                alt57=1;
            }
            switch (alt57) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:24: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement2643); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement2645); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement2647); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_userTypeName_in_createTypeStatement2665);
            tn=userTypeName();

            state._fsp--;

             expr = new CreateTypeStatement(tn, ifNotExists); 
            match(input,141,FOLLOW_141_in_createTypeStatement2678); 
            pushFollow(FOLLOW_typeColumns_in_createTypeStatement2680);
            typeColumns(expr);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:32: ( ',' ( typeColumns[expr] )? )*
            loop59:
            do {
                int alt59=2;
                int LA59_0 = input.LA(1);

                if ( (LA59_0==143) ) {
                    alt59=1;
                }


                switch (alt59) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:34: ',' ( typeColumns[expr] )?
            	    {
            	    match(input,143,FOLLOW_143_in_createTypeStatement2685); 
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:38: ( typeColumns[expr] )?
            	    int alt58=2;
            	    int LA58_0 = input.LA(1);

            	    if ( ((LA58_0>=K_DISTINCT && LA58_0<=K_AS)||(LA58_0>=K_FILTERING && LA58_0<=K_TTL)||LA58_0==K_VALUES||LA58_0==K_EXISTS||LA58_0==K_TIMESTAMP||LA58_0==K_COUNTER||LA58_0==K_STATIC||(LA58_0>=K_KEY && LA58_0<=K_CUSTOM)||LA58_0==IDENT||(LA58_0>=K_KEYS && LA58_0<=K_TRIGGER)||LA58_0==K_LIST||(LA58_0>=K_ALL && LA58_0<=QUOTED_NAME)||LA58_0==K_CONTAINS||(LA58_0>=K_ASCII && LA58_0<=K_MAP)) ) {
            	        alt58=1;
            	    }
            	    switch (alt58) {
            	        case 1 :
            	            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:38: typeColumns[expr]
            	            {
            	            pushFollow(FOLLOW_typeColumns_in_createTypeStatement2687);
            	            typeColumns(expr);

            	            state._fsp--;


            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop59;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_createTypeStatement2694); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createTypeStatement"


    // $ANTLR start "typeColumns"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:559:1: typeColumns[CreateTypeStatement expr] : k= cident v= comparatorType ;
    public final void typeColumns(CreateTypeStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        CQL3Type.Raw v = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:5: (k= cident v= comparatorType )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:7: k= cident v= comparatorType
            {
            pushFollow(FOLLOW_cident_in_typeColumns2714);
            k=cident();

            state._fsp--;

            pushFollow(FOLLOW_comparatorType_in_typeColumns2718);
            v=comparatorType();

            state._fsp--;

             expr.addDefinition(k, v); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "typeColumns"


    // $ANTLR start "createIndexStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:564:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
    public final CreateIndexStatement createIndexStatement() throws RecognitionException {
        CreateIndexStatement expr = null;

        Token idxName=null;
        Token cls=null;
        CFName cf = null;

        IndexTarget id = null;



                IndexPropDefs props = new IndexPropDefs();
                boolean ifNotExists = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement2753); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:16: ( K_CUSTOM )?
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0==K_CUSTOM) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:17: K_CUSTOM
                    {
                    match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement2756); 
                     props.isCustom = true; 

                    }
                    break;

            }

            match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement2762); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:63: ( K_IF K_NOT K_EXISTS )?
            int alt61=2;
            int LA61_0 = input.LA(1);

            if ( (LA61_0==K_IF) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:64: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement2765); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement2767); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement2769); 
                     ifNotExists = true; 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:9: (idxName= IDENT )?
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==IDENT) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:10: idxName= IDENT
                    {
                    idxName=(Token)match(input,IDENT,FOLLOW_IDENT_in_createIndexStatement2787); 

                    }
                    break;

            }

            match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement2791); 
            pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement2795);
            cf=columnFamilyName();

            state._fsp--;

            match(input,141,FOLLOW_141_in_createIndexStatement2797); 
            pushFollow(FOLLOW_indexIdent_in_createIndexStatement2801);
            id=indexIdent();

            state._fsp--;

            match(input,142,FOLLOW_142_in_createIndexStatement2803); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:9: ( K_USING cls= STRING_LITERAL )?
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==K_USING) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:10: K_USING cls= STRING_LITERAL
                    {
                    match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement2814); 
                    cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement2818); 
                     props.customClass = (cls!=null?cls.getText():null); 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:9: ( K_WITH properties[props] )?
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0==K_WITH) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:10: K_WITH properties[props]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement2833); 
                    pushFollow(FOLLOW_properties_in_createIndexStatement2835);
                    properties(props);

                    state._fsp--;


                    }
                    break;

            }

             expr = new CreateIndexStatement(cf, (idxName!=null?idxName.getText():null), id, props, ifNotExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createIndexStatement"


    // $ANTLR start "indexIdent"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:1: indexIdent returns [IndexTarget id] : (c= cident | K_KEYS '(' c= cident ')' );
    public final IndexTarget indexIdent() throws RecognitionException {
        IndexTarget id = null;

        ColumnIdentifier c = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:5: (c= cident | K_KEYS '(' c= cident ')' )
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( ((LA65_0>=K_DISTINCT && LA65_0<=K_AS)||(LA65_0>=K_FILTERING && LA65_0<=K_TTL)||LA65_0==K_VALUES||LA65_0==K_EXISTS||LA65_0==K_TIMESTAMP||LA65_0==K_COUNTER||LA65_0==K_STATIC||(LA65_0>=K_KEY && LA65_0<=K_CUSTOM)||LA65_0==IDENT||LA65_0==K_TRIGGER||LA65_0==K_LIST||(LA65_0>=K_ALL && LA65_0<=QUOTED_NAME)||LA65_0==K_CONTAINS||(LA65_0>=K_ASCII && LA65_0<=K_MAP)) ) {
                alt65=1;
            }
            else if ( (LA65_0==K_KEYS) ) {
                int LA65_2 = input.LA(2);

                if ( (LA65_2==141) ) {
                    alt65=2;
                }
                else if ( (LA65_2==142) ) {
                    alt65=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 65, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 65, 0, input);

                throw nvae;
            }
            switch (alt65) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_indexIdent2869);
                    c=cident();

                    state._fsp--;

                     id = IndexTarget.of(c); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:7: K_KEYS '(' c= cident ')'
                    {
                    match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent2894); 
                    match(input,141,FOLLOW_141_in_indexIdent2896); 
                    pushFollow(FOLLOW_cident_in_indexIdent2900);
                    c=cident();

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_indexIdent2902); 
                     id = IndexTarget.keysOf(c); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "indexIdent"


    // $ANTLR start "createTriggerStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:586:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
    public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
        CreateTriggerStatement expr = null;

        Token cls=null;
        ColumnIdentifier name = null;

        CFName cf = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:5: ( K_CREATE K_TRIGGER (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:7: K_CREATE K_TRIGGER (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement2928); 
            match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement2930); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:26: (name= cident )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:27: name= cident
            {
            pushFollow(FOLLOW_cident_in_createTriggerStatement2935);
            name=cident();

            state._fsp--;


            }

            match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement2938); 
            pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement2942);
            cf=columnFamilyName();

            state._fsp--;

            match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement2944); 
            cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement2948); 
             expr = new CreateTriggerStatement(cf, name.toString(), (cls!=null?cls.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createTriggerStatement"


    // $ANTLR start "dropTriggerStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:594:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER (name= cident ) K_ON cf= columnFamilyName ;
    public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
        DropTriggerStatement expr = null;

        ColumnIdentifier name = null;

        CFName cf = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:598:5: ( K_DROP K_TRIGGER (name= cident ) K_ON cf= columnFamilyName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:598:7: K_DROP K_TRIGGER (name= cident ) K_ON cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement2979); 
            match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement2981); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:598:24: (name= cident )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:598:25: name= cident
            {
            pushFollow(FOLLOW_cident_in_dropTriggerStatement2986);
            name=cident();

            state._fsp--;


            }

            match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement2989); 
            pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement2993);
            cf=columnFamilyName();

            state._fsp--;

             expr = new DropTriggerStatement(cf, name.toString()); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropTriggerStatement"


    // $ANTLR start "alterKeyspaceStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:602:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
    public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
        AlterKeyspaceStatement expr = null;

        String ks = null;


         KSPropDefs attrs = new KSPropDefs(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:607:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:607:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement3033); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3035); 
            pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement3039);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement3049); 
            pushFollow(FOLLOW_properties_in_alterKeyspaceStatement3051);
            properties(attrs);

            state._fsp--;

             expr = new AlterKeyspaceStatement(ks, attrs); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterKeyspaceStatement"


    // $ANTLR start "alterTableStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:612:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
    public final AlterTableStatement alterTableStatement() throws RecognitionException {
        AlterTableStatement expr = null;

        CFName cf = null;

        ColumnIdentifier id = null;

        CQL3Type.Raw v = null;

        ColumnIdentifier id1 = null;

        ColumnIdentifier toId1 = null;

        ColumnIdentifier idn = null;

        ColumnIdentifier toIdn = null;



                AlterTableStatement.Type type = null;
                CFPropDefs props = new CFPropDefs();
                Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>();
                boolean isStatic = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3087); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3089); 
            pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement3093);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:627:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            int alt68=5;
            switch ( input.LA(1) ) {
            case K_ALTER:
                {
                alt68=1;
                }
                break;
            case K_ADD:
                {
                alt68=2;
                }
                break;
            case K_DROP:
                {
                alt68=3;
                }
                break;
            case K_WITH:
                {
                alt68=4;
                }
                break;
            case K_RENAME:
                {
                alt68=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;
            }

            switch (alt68) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:627:13: K_ALTER id= cident K_TYPE v= comparatorType
                    {
                    match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3107); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3111);
                    id=cident();

                    state._fsp--;

                    match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement3113); 
                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement3117);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ALTER; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:13: K_ADD id= cident v= comparatorType ( K_STATIC )?
                    {
                    match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement3133); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3139);
                    id=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement3143);
                    v=comparatorType();

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:48: ( K_STATIC )?
                    int alt66=2;
                    int LA66_0 = input.LA(1);

                    if ( (LA66_0==K_STATIC) ) {
                        alt66=1;
                    }
                    switch (alt66) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:49: K_STATIC
                            {
                             isStatic=true; 
                            match(input,K_STATIC,FOLLOW_K_STATIC_in_alterTableStatement3148); 

                            }
                            break;

                    }

                     type = AlterTableStatement.Type.ADD; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:13: K_DROP id= cident
                    {
                    match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement3166); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3171);
                    id=cident();

                    state._fsp--;

                     type = AlterTableStatement.Type.DROP; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:13: K_WITH properties[props]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement3211); 
                    pushFollow(FOLLOW_properties_in_alterTableStatement3214);
                    properties(props);

                    state._fsp--;

                     type = AlterTableStatement.Type.OPTS; 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:631:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
                    {
                    match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement3247); 
                     type = AlterTableStatement.Type.RENAME; 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3301);
                    id1=cident();

                    state._fsp--;

                    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3303); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3307);
                    toId1=cident();

                    state._fsp--;

                     renames.put(id1, toId1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:16: ( K_AND idn= cident K_TO toIdn= cident )*
                    loop67:
                    do {
                        int alt67=2;
                        int LA67_0 = input.LA(1);

                        if ( (LA67_0==K_AND) ) {
                            alt67=1;
                        }


                        switch (alt67) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:18: K_AND idn= cident K_TO toIdn= cident
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement3328); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement3332);
                    	    idn=cident();

                    	    state._fsp--;

                    	    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3334); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement3338);
                    	    toIdn=cident();

                    	    state._fsp--;

                    	     renames.put(idn, toIdn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop67;
                        }
                    } while (true);


                    }
                    break;

            }


                    expr = new AlterTableStatement(cf, type, id, v, props, renames, isStatic);
                

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterTableStatement"


    // $ANTLR start "alterTypeStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:1: alterTypeStatement returns [AlterTypeStatement expr] : K_ALTER K_TYPE name= userTypeName ( K_ALTER f= cident K_TYPE v= comparatorType | K_ADD f= cident v= comparatorType | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
    public final AlterTypeStatement alterTypeStatement() throws RecognitionException {
        AlterTypeStatement expr = null;

        UTName name = null;

        ColumnIdentifier f = null;

        CQL3Type.Raw v = null;

        ColumnIdentifier id1 = null;

        ColumnIdentifier toId1 = null;

        ColumnIdentifier idn = null;

        ColumnIdentifier toIdn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:5: ( K_ALTER K_TYPE name= userTypeName ( K_ALTER f= cident K_TYPE v= comparatorType | K_ADD f= cident v= comparatorType | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:7: K_ALTER K_TYPE name= userTypeName ( K_ALTER f= cident K_TYPE v= comparatorType | K_ADD f= cident v= comparatorType | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3384); 
            match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3386); 
            pushFollow(FOLLOW_userTypeName_in_alterTypeStatement3390);
            name=userTypeName();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:647:11: ( K_ALTER f= cident K_TYPE v= comparatorType | K_ADD f= cident v= comparatorType | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            int alt70=3;
            switch ( input.LA(1) ) {
            case K_ALTER:
                {
                alt70=1;
                }
                break;
            case K_ADD:
                {
                alt70=2;
                }
                break;
            case K_RENAME:
                {
                alt70=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;
            }

            switch (alt70) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:647:13: K_ALTER f= cident K_TYPE v= comparatorType
                    {
                    match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3404); 
                    pushFollow(FOLLOW_cident_in_alterTypeStatement3408);
                    f=cident();

                    state._fsp--;

                    match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3410); 
                    pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3414);
                    v=comparatorType();

                    state._fsp--;

                     expr = AlterTypeStatement.alter(name, f, v); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:648:13: K_ADD f= cident v= comparatorType
                    {
                    match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement3430); 
                    pushFollow(FOLLOW_cident_in_alterTypeStatement3436);
                    f=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3440);
                    v=comparatorType();

                    state._fsp--;

                     expr = AlterTypeStatement.addition(name, f, v); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:649:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
                    {
                    match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement3463); 
                     Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>(); 
                    pushFollow(FOLLOW_cident_in_alterTypeStatement3501);
                    id1=cident();

                    state._fsp--;

                    match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3503); 
                    pushFollow(FOLLOW_cident_in_alterTypeStatement3507);
                    toId1=cident();

                    state._fsp--;

                     renames.put(id1, toId1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:652:18: ( K_AND idn= cident K_TO toIdn= cident )*
                    loop69:
                    do {
                        int alt69=2;
                        int LA69_0 = input.LA(1);

                        if ( (LA69_0==K_AND) ) {
                            alt69=1;
                        }


                        switch (alt69) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:652:20: K_AND idn= cident K_TO toIdn= cident
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement3530); 
                    	    pushFollow(FOLLOW_cident_in_alterTypeStatement3534);
                    	    idn=cident();

                    	    state._fsp--;

                    	    match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3536); 
                    	    pushFollow(FOLLOW_cident_in_alterTypeStatement3540);
                    	    toIdn=cident();

                    	    state._fsp--;

                    	     renames.put(idn, toIdn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop69;
                        }
                    } while (true);

                     expr = AlterTypeStatement.renames(name, renames); 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterTypeStatement"


    // $ANTLR start "dropKeyspaceStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:658:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
    public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
        DropKeyspaceStatement ksp = null;

        String ks = null;


         boolean ifExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:663:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:663:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement3607); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3609); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:663:25: ( K_IF K_EXISTS )?
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==K_IF) ) {
                alt71=1;
            }
            switch (alt71) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:663:26: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement3612); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement3614); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement3623);
            ks=keyspaceName();

            state._fsp--;

             ksp = new DropKeyspaceStatement(ks, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ksp;
    }
    // $ANTLR end "dropKeyspaceStatement"


    // $ANTLR start "dropTableStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
    public final DropTableStatement dropTableStatement() throws RecognitionException {
        DropTableStatement stmt = null;

        CFName cf = null;


         boolean ifExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement3657); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3659); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:29: ( K_IF K_EXISTS )?
            int alt72=2;
            int LA72_0 = input.LA(1);

            if ( (LA72_0==K_IF) ) {
                alt72=1;
            }
            switch (alt72) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:30: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement3662); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement3664); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement3673);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new DropTableStatement(cf, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropTableStatement"


    // $ANTLR start "dropTypeStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:1: dropTypeStatement returns [DropTypeStatement stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
    public final DropTypeStatement dropTypeStatement() throws RecognitionException {
        DropTypeStatement stmt = null;

        UTName name = null;


         boolean ifExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement3707); 
            match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement3709); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:21: ( K_IF K_EXISTS )?
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==K_IF) ) {
                alt73=1;
            }
            switch (alt73) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:22: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement3712); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement3714); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_userTypeName_in_dropTypeStatement3723);
            name=userTypeName();

            state._fsp--;

             stmt = new DropTypeStatement(name, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropTypeStatement"


    // $ANTLR start "dropIndexStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
    public final DropIndexStatement dropIndexStatement() throws RecognitionException {
        DropIndexStatement expr = null;

        IndexName index = null;


         boolean ifExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement3757); 
            match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement3759); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:22: ( K_IF K_EXISTS )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==K_IF) ) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:23: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement3762); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement3764); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_indexName_in_dropIndexStatement3773);
            index=indexName();

            state._fsp--;

             expr = new DropIndexStatement(index, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropIndexStatement"


    // $ANTLR start "truncateStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:691:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
    public final TruncateStatement truncateStatement() throws RecognitionException {
        TruncateStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:695:5: ( K_TRUNCATE cf= columnFamilyName )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:695:7: K_TRUNCATE cf= columnFamilyName
            {
            match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement3804); 
            pushFollow(FOLLOW_columnFamilyName_in_truncateStatement3808);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new TruncateStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "truncateStatement"


    // $ANTLR start "grantStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:698:1: grantStatement returns [GrantStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO username ;
    public final GrantStatement grantStatement() throws RecognitionException {
        GrantStatement stmt = null;

        Set<Permission> permissionOrAll1 = null;

        IResource resource2 = null;

        CqlParser.username_return username3 = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:5: ( K_GRANT permissionOrAll K_ON resource K_TO username )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:7: K_GRANT permissionOrAll K_ON resource K_TO username
            {
            match(input,K_GRANT,FOLLOW_K_GRANT_in_grantStatement3833); 
            pushFollow(FOLLOW_permissionOrAll_in_grantStatement3845);
            permissionOrAll1=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_grantStatement3853); 
            pushFollow(FOLLOW_resource_in_grantStatement3865);
            resource2=resource();

            state._fsp--;

            match(input,K_TO,FOLLOW_K_TO_in_grantStatement3873); 
            pushFollow(FOLLOW_username_in_grantStatement3885);
            username3=username();

            state._fsp--;

             stmt = new GrantStatement(permissionOrAll1, resource2, (username3!=null?input.toString(username3.start,username3.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "grantStatement"


    // $ANTLR start "revokeStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:711:1: revokeStatement returns [RevokeStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM username ;
    public final RevokeStatement revokeStatement() throws RecognitionException {
        RevokeStatement stmt = null;

        Set<Permission> permissionOrAll4 = null;

        IResource resource5 = null;

        CqlParser.username_return username6 = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:715:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM username )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:715:7: K_REVOKE permissionOrAll K_ON resource K_FROM username
            {
            match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeStatement3916); 
            pushFollow(FOLLOW_permissionOrAll_in_revokeStatement3928);
            permissionOrAll4=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_revokeStatement3936); 
            pushFollow(FOLLOW_resource_in_revokeStatement3948);
            resource5=resource();

            state._fsp--;

            match(input,K_FROM,FOLLOW_K_FROM_in_revokeStatement3956); 
            pushFollow(FOLLOW_username_in_revokeStatement3968);
            username6=username();

            state._fsp--;

             stmt = new RevokeStatement(permissionOrAll4, resource5, (username6!=null?input.toString(username6.start,username6.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "revokeStatement"


    // $ANTLR start "listPermissionsStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:724:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? ;
    public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
        ListPermissionsStatement stmt = null;

        IResource resource7 = null;

        CqlParser.username_return username8 = null;

        Set<Permission> permissionOrAll9 = null;



                IResource resource = null;
                String username = null;
                boolean recursive = true;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )?
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement4006); 
            pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement4018);
            permissionOrAll9=permissionOrAll();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:7: ( K_ON resource )?
            int alt75=2;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==K_ON) ) {
                alt75=1;
            }
            switch (alt75) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:9: K_ON resource
                    {
                    match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement4028); 
                    pushFollow(FOLLOW_resource_in_listPermissionsStatement4030);
                    resource7=resource();

                    state._fsp--;

                     resource = resource7; 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:733:7: ( K_OF username )?
            int alt76=2;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==K_OF) ) {
                alt76=1;
            }
            switch (alt76) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:733:9: K_OF username
                    {
                    match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement4045); 
                    pushFollow(FOLLOW_username_in_listPermissionsStatement4047);
                    username8=username();

                    state._fsp--;

                     username = (username8!=null?input.toString(username8.start,username8.stop):null); 

                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:7: ( K_NORECURSIVE )?
            int alt77=2;
            int LA77_0 = input.LA(1);

            if ( (LA77_0==K_NORECURSIVE) ) {
                alt77=1;
            }
            switch (alt77) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:9: K_NORECURSIVE
                    {
                    match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4062); 
                     recursive = false; 

                    }
                    break;

            }

             stmt = new ListPermissionsStatement(permissionOrAll9, resource, username, recursive); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listPermissionsStatement"


    // $ANTLR start "permission"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:738:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) ;
    public final Permission permission() throws RecognitionException {
        Permission perm = null;

        Token p=null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:739:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:739:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE )
            {
            p=(Token)input.LT(1);
            if ( input.LA(1)==K_SELECT||input.LA(1)==K_CREATE||(input.LA(1)>=K_DROP && input.LA(1)<=K_ALTER)||(input.LA(1)>=K_MODIFY && input.LA(1)<=K_AUTHORIZE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perm;
    }
    // $ANTLR end "permission"


    // $ANTLR start "permissionOrAll"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:743:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? );
    public final Set<Permission> permissionOrAll() throws RecognitionException {
        Set<Permission> perms = null;

        Permission p = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:744:5: ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? )
            int alt80=2;
            int LA80_0 = input.LA(1);

            if ( (LA80_0==K_ALL) ) {
                alt80=1;
            }
            else if ( (LA80_0==K_SELECT||LA80_0==K_CREATE||(LA80_0>=K_DROP && LA80_0<=K_ALTER)||(LA80_0>=K_MODIFY && LA80_0<=K_AUTHORIZE)) ) {
                alt80=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;
            }
            switch (alt80) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:744:7: K_ALL ( K_PERMISSIONS )?
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll4147); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:744:13: ( K_PERMISSIONS )?
                    int alt78=2;
                    int LA78_0 = input.LA(1);

                    if ( (LA78_0==K_PERMISSIONS) ) {
                        alt78=1;
                    }
                    switch (alt78) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:744:15: K_PERMISSIONS
                            {
                            match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll4151); 

                            }
                            break;

                    }

                     perms = Permission.ALL_DATA; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:7: p= permission ( K_PERMISSION )?
                    {
                    pushFollow(FOLLOW_permission_in_permissionOrAll4172);
                    p=permission();

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:20: ( K_PERMISSION )?
                    int alt79=2;
                    int LA79_0 = input.LA(1);

                    if ( (LA79_0==K_PERMISSION) ) {
                        alt79=1;
                    }
                    switch (alt79) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:22: K_PERMISSION
                            {
                            match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll4176); 

                            }
                            break;

                    }

                     perms = EnumSet.of(p); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perms;
    }
    // $ANTLR end "permissionOrAll"


    // $ANTLR start "resource"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:748:1: resource returns [IResource res] : r= dataResource ;
    public final IResource resource() throws RecognitionException {
        IResource res = null;

        DataResource r = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:5: (r= dataResource )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:7: r= dataResource
            {
            pushFollow(FOLLOW_dataResource_in_resource4204);
            r=dataResource();

            state._fsp--;

             res = r; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "resource"


    // $ANTLR start "dataResource"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
    public final DataResource dataResource() throws RecognitionException {
        DataResource res = null;

        String ks = null;

        CFName cf = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
            int alt82=3;
            switch ( input.LA(1) ) {
            case K_ALL:
                {
                int LA82_1 = input.LA(2);

                if ( (LA82_1==K_KEYSPACES) ) {
                    alt82=1;
                }
                else if ( (LA82_1==EOF||LA82_1==K_FROM||LA82_1==K_TO||(LA82_1>=K_OF && LA82_1<=K_NORECURSIVE)||LA82_1==140||LA82_1==145) ) {
                    alt82=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 82, 1, input);

                    throw nvae;
                }
                }
                break;
            case K_KEYSPACE:
                {
                alt82=2;
                }
                break;
            case K_DISTINCT:
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_COLUMNFAMILY:
            case K_STATIC:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case IDENT:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt82=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;
            }

            switch (alt82) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:7: K_ALL K_KEYSPACES
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_dataResource4227); 
                    match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource4229); 
                     res = DataResource.root(); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:7: K_KEYSPACE ks= keyspaceName
                    {
                    match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource4239); 
                    pushFollow(FOLLOW_keyspaceName_in_dataResource4245);
                    ks=keyspaceName();

                    state._fsp--;

                     res = DataResource.keyspace(ks); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
                    {
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:7: ( K_COLUMNFAMILY )?
                    int alt81=2;
                    int LA81_0 = input.LA(1);

                    if ( (LA81_0==K_COLUMNFAMILY) ) {
                        alt81=1;
                    }
                    switch (alt81) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:9: K_COLUMNFAMILY
                            {
                            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource4257); 

                            }
                            break;

                    }

                    pushFollow(FOLLOW_columnFamilyName_in_dataResource4266);
                    cf=columnFamilyName();

                    state._fsp--;

                     res = DataResource.columnFamily(cf.getKeyspace(), cf.getColumnFamily()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "dataResource"


    // $ANTLR start "createUserStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:1: createUserStatement returns [CreateUserStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final CreateUserStatement createUserStatement() throws RecognitionException {
        CreateUserStatement stmt = null;

        CqlParser.username_return username10 = null;



                UserOptions opts = new UserOptions();
                boolean superuser = false;
                boolean ifNotExists = false;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:768:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:768:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement4306); 
            match(input,K_USER,FOLLOW_K_USER_in_createUserStatement4308); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:768:23: ( K_IF K_NOT K_EXISTS )?
            int alt83=2;
            int LA83_0 = input.LA(1);

            if ( (LA83_0==K_IF) ) {
                alt83=1;
            }
            switch (alt83) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:768:24: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createUserStatement4311); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement4313); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement4315); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_username_in_createUserStatement4321);
            username10=username();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:769:7: ( K_WITH userOptions[opts] )?
            int alt84=2;
            int LA84_0 = input.LA(1);

            if ( (LA84_0==K_WITH) ) {
                alt84=1;
            }
            switch (alt84) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:769:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement4331); 
                    pushFollow(FOLLOW_userOptions_in_createUserStatement4333);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt85=3;
            int LA85_0 = input.LA(1);

            if ( (LA85_0==K_SUPERUSER) ) {
                alt85=1;
            }
            else if ( (LA85_0==K_NOSUPERUSER) ) {
                alt85=2;
            }
            switch (alt85) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement4347); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement4353); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new CreateUserStatement((username10!=null?input.toString(username10.start,username10.stop):null), opts, superuser, ifNotExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "createUserStatement"


    // $ANTLR start "alterUserStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:1: alterUserStatement returns [AlterUserStatement stmt] : K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final AlterUserStatement alterUserStatement() throws RecognitionException {
        AlterUserStatement stmt = null;

        CqlParser.username_return username11 = null;



                UserOptions opts = new UserOptions();
                Boolean superuser = null;
            
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:782:5: ( K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:782:7: K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement4398); 
            match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement4400); 
            pushFollow(FOLLOW_username_in_alterUserStatement4402);
            username11=username();

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:783:7: ( K_WITH userOptions[opts] )?
            int alt86=2;
            int LA86_0 = input.LA(1);

            if ( (LA86_0==K_WITH) ) {
                alt86=1;
            }
            switch (alt86) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:783:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement4412); 
                    pushFollow(FOLLOW_userOptions_in_alterUserStatement4414);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt87=3;
            int LA87_0 = input.LA(1);

            if ( (LA87_0==K_SUPERUSER) ) {
                alt87=1;
            }
            else if ( (LA87_0==K_NOSUPERUSER) ) {
                alt87=2;
            }
            switch (alt87) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement4428); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement4434); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new AlterUserStatement((username11!=null?input.toString(username11.start,username11.stop):null), opts, superuser); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "alterUserStatement"


    // $ANTLR start "dropUserStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:788:1: dropUserStatement returns [DropUserStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? username ;
    public final DropUserStatement dropUserStatement() throws RecognitionException {
        DropUserStatement stmt = null;

        CqlParser.username_return username12 = null;


         boolean ifExists = false; 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:5: ( K_DROP K_USER ( K_IF K_EXISTS )? username )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:7: K_DROP K_USER ( K_IF K_EXISTS )? username
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement4479); 
            match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement4481); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:21: ( K_IF K_EXISTS )?
            int alt88=2;
            int LA88_0 = input.LA(1);

            if ( (LA88_0==K_IF) ) {
                alt88=1;
            }
            switch (alt88) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:22: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement4484); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement4486); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_username_in_dropUserStatement4492);
            username12=username();

            state._fsp--;

             stmt = new DropUserStatement((username12!=null?input.toString(username12.start,username12.stop):null), ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropUserStatement"


    // $ANTLR start "listUsersStatement"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:796:1: listUsersStatement returns [ListUsersStatement stmt] : K_LIST K_USERS ;
    public final ListUsersStatement listUsersStatement() throws RecognitionException {
        ListUsersStatement stmt = null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:5: ( K_LIST K_USERS )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:7: K_LIST K_USERS
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement4517); 
            match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement4519); 
             stmt = new ListUsersStatement(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listUsersStatement"


    // $ANTLR start "userOptions"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:803:1: userOptions[UserOptions opts] : userOption[opts] ;
    public final void userOptions(UserOptions opts) throws RecognitionException {
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:804:5: ( userOption[opts] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:804:7: userOption[opts]
            {
            pushFollow(FOLLOW_userOption_in_userOptions4539);
            userOption(opts);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOptions"


    // $ANTLR start "userOption"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:807:1: userOption[UserOptions opts] : k= K_PASSWORD v= STRING_LITERAL ;
    public final void userOption(UserOptions opts) throws RecognitionException {
        Token k=null;
        Token v=null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:808:5: (k= K_PASSWORD v= STRING_LITERAL )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:808:7: k= K_PASSWORD v= STRING_LITERAL
            {
            k=(Token)match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userOption4560); 
            v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userOption4564); 
             opts.put((k!=null?k.getText():null), (v!=null?v.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOption"


    // $ANTLR start "cident"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:1: cident returns [ColumnIdentifier id] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final ColumnIdentifier cident() throws RecognitionException {
        ColumnIdentifier id = null;

        Token t=null;
        String k = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt89=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt89=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt89=2;
                }
                break;
            case K_DISTINCT:
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_STATIC:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt89=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;
            }

            switch (alt89) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident4593); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident4618); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:817:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cident4637);
                    k=unreserved_keyword();

                    state._fsp--;

                     id = new ColumnIdentifier(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "cident"


    // $ANTLR start "keyspaceName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:1: keyspaceName returns [String id] : cfOrKsName[name, true] ;
    public final String keyspaceName() throws RecognitionException {
        String id = null;

         CFName name = new CFName(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:823:5: ( cfOrKsName[name, true] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:823:7: cfOrKsName[name, true]
            {
            pushFollow(FOLLOW_cfOrKsName_in_keyspaceName4670);
            cfOrKsName(name, true);

            state._fsp--;

             id = name.getKeyspace(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "keyspaceName"


    // $ANTLR start "indexName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:826:1: indexName returns [IndexName name] : ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false] ;
    public final IndexName indexName() throws RecognitionException {
        IndexName name = null;

         name = new IndexName(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:5: ( ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:7: ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false]
            {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:7: ( idxOrKsName[name, true] '.' )?
            int alt90=2;
            alt90 = dfa90.predict(input);
            switch (alt90) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:8: idxOrKsName[name, true] '.'
                    {
                    pushFollow(FOLLOW_idxOrKsName_in_indexName4704);
                    idxOrKsName(name, true);

                    state._fsp--;

                    match(input,145,FOLLOW_145_in_indexName4707); 

                    }
                    break;

            }

            pushFollow(FOLLOW_idxOrKsName_in_indexName4711);
            idxOrKsName(name, false);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "indexName"


    // $ANTLR start "idxOrKsName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:831:1: idxOrKsName[IndexName name, boolean isKs] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final void idxOrKsName(IndexName name, boolean isKs) throws RecognitionException {
        Token t=null;
        String k = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt91=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt91=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt91=2;
                }
                break;
            case K_DISTINCT:
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_STATIC:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt91=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;
            }

            switch (alt91) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxOrKsName4732); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setIndex((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:833:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxOrKsName4757); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setIndex((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:834:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_idxOrKsName4776);
                    k=unreserved_keyword();

                    state._fsp--;

                     if (isKs) name.setKeyspace(k, false); else name.setIndex(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "idxOrKsName"


    // $ANTLR start "columnFamilyName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:837:1: columnFamilyName returns [CFName name] : ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] ;
    public final CFName columnFamilyName() throws RecognitionException {
        CFName name = null;

         name = new CFName(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:5: ( ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:7: ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false]
            {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:7: ( cfOrKsName[name, true] '.' )?
            int alt92=2;
            alt92 = dfa92.predict(input);
            switch (alt92) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:8: cfOrKsName[name, true] '.'
                    {
                    pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4809);
                    cfOrKsName(name, true);

                    state._fsp--;

                    match(input,145,FOLLOW_145_in_columnFamilyName4812); 

                    }
                    break;

            }

            pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4816);
            cfOrKsName(name, false);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "columnFamilyName"


    // $ANTLR start "userTypeName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:1: userTypeName returns [UTName name] : (ks= cident '.' )? ut= non_type_ident ;
    public final UTName userTypeName() throws RecognitionException {
        UTName name = null;

        ColumnIdentifier ks = null;

        ColumnIdentifier ut = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:5: ( (ks= cident '.' )? ut= non_type_ident )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:7: (ks= cident '.' )? ut= non_type_ident
            {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:7: (ks= cident '.' )?
            int alt93=2;
            switch ( input.LA(1) ) {
                case IDENT:
                    {
                    int LA93_1 = input.LA(2);

                    if ( (LA93_1==145) ) {
                        alt93=1;
                    }
                    }
                    break;
                case QUOTED_NAME:
                    {
                    int LA93_2 = input.LA(2);

                    if ( (LA93_2==145) ) {
                        alt93=1;
                    }
                    }
                    break;
                case K_DISTINCT:
                case K_AS:
                case K_FILTERING:
                case K_VALUES:
                case K_EXISTS:
                case K_STATIC:
                case K_COMPACT:
                case K_STORAGE:
                case K_CLUSTERING:
                case K_TYPE:
                case K_CUSTOM:
                case K_KEYS:
                case K_TRIGGER:
                case K_LIST:
                case K_ALL:
                case K_PERMISSIONS:
                case K_PERMISSION:
                case K_KEYSPACES:
                case K_USER:
                case K_SUPERUSER:
                case K_NOSUPERUSER:
                case K_USERS:
                case K_PASSWORD:
                case K_CONTAINS:
                case K_MAP:
                    {
                    int LA93_3 = input.LA(2);

                    if ( (LA93_3==145) ) {
                        alt93=1;
                    }
                    }
                    break;
                case K_COUNT:
                case K_WRITETIME:
                case K_TTL:
                case K_TIMESTAMP:
                case K_COUNTER:
                case K_ASCII:
                case K_BIGINT:
                case K_BLOB:
                case K_BOOLEAN:
                case K_DECIMAL:
                case K_DOUBLE:
                case K_FLOAT:
                case K_INET:
                case K_INT:
                case K_TEXT:
                case K_UUID:
                case K_VARCHAR:
                case K_VARINT:
                case K_TIMEUUID:
                    {
                    alt93=1;
                    }
                    break;
                case K_KEY:
                    {
                    int LA93_5 = input.LA(2);

                    if ( (LA93_5==145) ) {
                        alt93=1;
                    }
                    }
                    break;
            }

            switch (alt93) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:8: ks= cident '.'
                    {
                    pushFollow(FOLLOW_cident_in_userTypeName4841);
                    ks=cident();

                    state._fsp--;

                    match(input,145,FOLLOW_145_in_userTypeName4843); 

                    }
                    break;

            }

            pushFollow(FOLLOW_non_type_ident_in_userTypeName4849);
            ut=non_type_ident();

            state._fsp--;

             return new UTName(ks, ut); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "userTypeName"


    // $ANTLR start "cfOrKsName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:1: cfOrKsName[CFName name, boolean isKs] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final void cfOrKsName(CFName name, boolean isKs) throws RecognitionException {
        Token t=null;
        String k = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt94=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt94=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt94=2;
                }
                break;
            case K_DISTINCT:
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_STATIC:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt94=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;
            }

            switch (alt94) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfOrKsName4871); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setColumnFamily((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:848:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfOrKsName4896); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setColumnFamily((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cfOrKsName4915);
                    k=unreserved_keyword();

                    state._fsp--;

                     if (isKs) name.setKeyspace(k, false); else name.setColumnFamily(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfOrKsName"


    // $ANTLR start "constant"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:852:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) );
    public final Constants.Literal constant() throws RecognitionException {
        Constants.Literal constant = null;

        Token t=null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:5: (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) )
            int alt96=7;
            switch ( input.LA(1) ) {
            case STRING_LITERAL:
                {
                alt96=1;
                }
                break;
            case INTEGER:
                {
                alt96=2;
                }
                break;
            case FLOAT:
                {
                alt96=3;
                }
                break;
            case BOOLEAN:
                {
                alt96=4;
                }
                break;
            case UUID:
                {
                alt96=5;
                }
                break;
            case HEXNUMBER:
                {
                alt96=6;
                }
                break;
            case K_NAN:
            case K_INFINITY:
            case 148:
                {
                alt96=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;
            }

            switch (alt96) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:7: t= STRING_LITERAL
                    {
                    t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant4940); 
                     constant = Constants.Literal.string((t!=null?t.getText():null)); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant4952); 
                     constant = Constants.Literal.integer((t!=null?t.getText():null)); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:855:7: t= FLOAT
                    {
                    t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant4971); 
                     constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:856:7: t= BOOLEAN
                    {
                    t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant4992); 
                     constant = Constants.Literal.bool((t!=null?t.getText():null)); 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:7: t= UUID
                    {
                    t=(Token)match(input,UUID,FOLLOW_UUID_in_constant5011); 
                     constant = Constants.Literal.uuid((t!=null?t.getText():null)); 

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:7: t= HEXNUMBER
                    {
                    t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant5033); 
                     constant = Constants.Literal.hex((t!=null?t.getText():null)); 

                    }
                    break;
                case 7 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:7: ( '-' )? t= ( K_NAN | K_INFINITY )
                    {
                     String sign=""; 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:27: ( '-' )?
                    int alt95=2;
                    int LA95_0 = input.LA(1);

                    if ( (LA95_0==148) ) {
                        alt95=1;
                    }
                    switch (alt95) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:28: '-'
                            {
                            match(input,148,FOLLOW_148_in_constant5051); 
                            sign = "-"; 

                            }
                            break;

                    }

                    t=(Token)input.LT(1);
                    if ( (input.LA(1)>=K_NAN && input.LA(1)<=K_INFINITY) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     constant = Constants.Literal.floatingPoint(sign + (t!=null?t.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return constant;
    }
    // $ANTLR end "constant"


    // $ANTLR start "mapLiteral"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:862:1: mapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
    public final Maps.Literal mapLiteral() throws RecognitionException {
        Maps.Literal map = null;

        Term.Raw k1 = null;

        Term.Raw v1 = null;

        Term.Raw kn = null;

        Term.Raw vn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
            {
            match(input,149,FOLLOW_149_in_mapLiteral5089); 
             List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( (LA98_0==K_DISTINCT||LA98_0==K_AS||LA98_0==K_FILTERING||LA98_0==INTEGER||LA98_0==K_VALUES||LA98_0==K_EXISTS||LA98_0==K_TIMESTAMP||LA98_0==K_COUNTER||LA98_0==K_STATIC||(LA98_0>=K_COMPACT && LA98_0<=K_CUSTOM)||LA98_0==IDENT||(LA98_0>=STRING_LITERAL && LA98_0<=K_TRIGGER)||LA98_0==K_LIST||(LA98_0>=K_ALL && LA98_0<=K_PASSWORD)||(LA98_0>=FLOAT && LA98_0<=K_TOKEN)||LA98_0==K_CONTAINS||(LA98_0>=K_ASCII && LA98_0<=K_MAP)||LA98_0==141||LA98_0==146||(LA98_0>=148 && LA98_0<=150)) ) {
                alt98=1;
            }
            switch (alt98) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
                    {
                    pushFollow(FOLLOW_term_in_mapLiteral5107);
                    k1=term();

                    state._fsp--;

                    match(input,150,FOLLOW_150_in_mapLiteral5109); 
                    pushFollow(FOLLOW_term_in_mapLiteral5113);
                    v1=term();

                    state._fsp--;

                     m.add(Pair.create(k1, v1)); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:65: ( ',' kn= term ':' vn= term )*
                    loop97:
                    do {
                        int alt97=2;
                        int LA97_0 = input.LA(1);

                        if ( (LA97_0==143) ) {
                            alt97=1;
                        }


                        switch (alt97) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:67: ',' kn= term ':' vn= term
                    	    {
                    	    match(input,143,FOLLOW_143_in_mapLiteral5119); 
                    	    pushFollow(FOLLOW_term_in_mapLiteral5123);
                    	    kn=term();

                    	    state._fsp--;

                    	    match(input,150,FOLLOW_150_in_mapLiteral5125); 
                    	    pushFollow(FOLLOW_term_in_mapLiteral5129);
                    	    vn=term();

                    	    state._fsp--;

                    	     m.add(Pair.create(kn, vn)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop97;
                        }
                    } while (true);


                    }
                    break;

            }

            match(input,151,FOLLOW_151_in_mapLiteral5145); 
             map = new Maps.Literal(m); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return map;
    }
    // $ANTLR end "mapLiteral"


    // $ANTLR start "setOrMapLiteral"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:868:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* );
    public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
        Term.Raw value = null;

        Term.Raw v = null;

        Term.Raw kn = null;

        Term.Raw vn = null;

        Term.Raw tn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:869:5: ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* )
            int alt101=2;
            int LA101_0 = input.LA(1);

            if ( (LA101_0==150) ) {
                alt101=1;
            }
            else if ( (LA101_0==143||LA101_0==151) ) {
                alt101=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 101, 0, input);

                throw nvae;
            }
            switch (alt101) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:869:7: ':' v= term ( ',' kn= term ':' vn= term )*
                    {
                    match(input,150,FOLLOW_150_in_setOrMapLiteral5169); 
                    pushFollow(FOLLOW_term_in_setOrMapLiteral5173);
                    v=term();

                    state._fsp--;

                     List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:11: ( ',' kn= term ':' vn= term )*
                    loop99:
                    do {
                        int alt99=2;
                        int LA99_0 = input.LA(1);

                        if ( (LA99_0==143) ) {
                            alt99=1;
                        }


                        switch (alt99) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:13: ',' kn= term ':' vn= term
                    	    {
                    	    match(input,143,FOLLOW_143_in_setOrMapLiteral5189); 
                    	    pushFollow(FOLLOW_term_in_setOrMapLiteral5193);
                    	    kn=term();

                    	    state._fsp--;

                    	    match(input,150,FOLLOW_150_in_setOrMapLiteral5195); 
                    	    pushFollow(FOLLOW_term_in_setOrMapLiteral5199);
                    	    vn=term();

                    	    state._fsp--;

                    	     m.add(Pair.create(kn, vn)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop99;
                        }
                    } while (true);

                     value = new Maps.Literal(m); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:872:7: ( ',' tn= term )*
                    {
                     List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:873:11: ( ',' tn= term )*
                    loop100:
                    do {
                        int alt100=2;
                        int LA100_0 = input.LA(1);

                        if ( (LA100_0==143) ) {
                            alt100=1;
                        }


                        switch (alt100) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:873:13: ',' tn= term
                    	    {
                    	    match(input,143,FOLLOW_143_in_setOrMapLiteral5234); 
                    	    pushFollow(FOLLOW_term_in_setOrMapLiteral5238);
                    	    tn=term();

                    	    state._fsp--;

                    	     s.add(tn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop100;
                        }
                    } while (true);

                     value = new Sets.Literal(s); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "setOrMapLiteral"


    // $ANTLR start "collectionLiteral"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:877:1: collectionLiteral returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
    public final Term.Raw collectionLiteral() throws RecognitionException {
        Term.Raw value = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;

        Term.Raw t = null;

        Term.Raw v = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:878:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
            int alt104=3;
            int LA104_0 = input.LA(1);

            if ( (LA104_0==146) ) {
                alt104=1;
            }
            else if ( (LA104_0==149) ) {
                int LA104_2 = input.LA(2);

                if ( (LA104_2==151) ) {
                    alt104=3;
                }
                else if ( (LA104_2==K_DISTINCT||LA104_2==K_AS||LA104_2==K_FILTERING||LA104_2==INTEGER||LA104_2==K_VALUES||LA104_2==K_EXISTS||LA104_2==K_TIMESTAMP||LA104_2==K_COUNTER||LA104_2==K_STATIC||(LA104_2>=K_COMPACT && LA104_2<=K_CUSTOM)||LA104_2==IDENT||(LA104_2>=STRING_LITERAL && LA104_2<=K_TRIGGER)||LA104_2==K_LIST||(LA104_2>=K_ALL && LA104_2<=K_PASSWORD)||(LA104_2>=FLOAT && LA104_2<=K_TOKEN)||LA104_2==K_CONTAINS||(LA104_2>=K_ASCII && LA104_2<=K_MAP)||LA104_2==141||LA104_2==146||(LA104_2>=148 && LA104_2<=150)) ) {
                    alt104=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 104, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;
            }
            switch (alt104) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:878:7: '[' (t1= term ( ',' tn= term )* )? ']'
                    {
                    match(input,146,FOLLOW_146_in_collectionLiteral5272); 
                     List<Term.Raw> l = new ArrayList<Term.Raw>(); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:11: (t1= term ( ',' tn= term )* )?
                    int alt103=2;
                    int LA103_0 = input.LA(1);

                    if ( (LA103_0==K_DISTINCT||LA103_0==K_AS||LA103_0==K_FILTERING||LA103_0==INTEGER||LA103_0==K_VALUES||LA103_0==K_EXISTS||LA103_0==K_TIMESTAMP||LA103_0==K_COUNTER||LA103_0==K_STATIC||(LA103_0>=K_COMPACT && LA103_0<=K_CUSTOM)||LA103_0==IDENT||(LA103_0>=STRING_LITERAL && LA103_0<=K_TRIGGER)||LA103_0==K_LIST||(LA103_0>=K_ALL && LA103_0<=K_PASSWORD)||(LA103_0>=FLOAT && LA103_0<=K_TOKEN)||LA103_0==K_CONTAINS||(LA103_0>=K_ASCII && LA103_0<=K_MAP)||LA103_0==141||LA103_0==146||(LA103_0>=148 && LA103_0<=150)) ) {
                        alt103=1;
                    }
                    switch (alt103) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:13: t1= term ( ',' tn= term )*
                            {
                            pushFollow(FOLLOW_term_in_collectionLiteral5290);
                            t1=term();

                            state._fsp--;

                             l.add(t1); 
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:36: ( ',' tn= term )*
                            loop102:
                            do {
                                int alt102=2;
                                int LA102_0 = input.LA(1);

                                if ( (LA102_0==143) ) {
                                    alt102=1;
                                }


                                switch (alt102) {
                            	case 1 :
                            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:38: ',' tn= term
                            	    {
                            	    match(input,143,FOLLOW_143_in_collectionLiteral5296); 
                            	    pushFollow(FOLLOW_term_in_collectionLiteral5300);
                            	    tn=term();

                            	    state._fsp--;

                            	     l.add(tn); 

                            	    }
                            	    break;

                            	default :
                            	    break loop102;
                                }
                            } while (true);


                            }
                            break;

                    }

                    match(input,147,FOLLOW_147_in_collectionLiteral5316); 
                     value = new Lists.Literal(l); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:881:7: '{' t= term v= setOrMapLiteral[t] '}'
                    {
                    match(input,149,FOLLOW_149_in_collectionLiteral5326); 
                    pushFollow(FOLLOW_term_in_collectionLiteral5330);
                    t=term();

                    state._fsp--;

                    pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral5334);
                    v=setOrMapLiteral(t);

                    state._fsp--;

                     value = v; 
                    match(input,151,FOLLOW_151_in_collectionLiteral5339); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:7: '{' '}'
                    {
                    match(input,149,FOLLOW_149_in_collectionLiteral5357); 
                    match(input,151,FOLLOW_151_in_collectionLiteral5359); 
                     value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "collectionLiteral"


    // $ANTLR start "usertypeLiteral"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= cident ':' v1= term ( ',' kn= cident ':' vn= term )* '}' ;
    public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
        UserTypes.Literal ut = null;

        ColumnIdentifier k1 = null;

        Term.Raw v1 = null;

        ColumnIdentifier kn = null;

        Term.Raw vn = null;


         Map<ColumnIdentifier, Term.Raw> m = new HashMap<ColumnIdentifier, Term.Raw>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:5: ( '{' k1= cident ':' v1= term ( ',' kn= cident ':' vn= term )* '}' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:7: '{' k1= cident ':' v1= term ( ',' kn= cident ':' vn= term )* '}'
            {
            match(input,149,FOLLOW_149_in_usertypeLiteral5403); 
            pushFollow(FOLLOW_cident_in_usertypeLiteral5407);
            k1=cident();

            state._fsp--;

            match(input,150,FOLLOW_150_in_usertypeLiteral5409); 
            pushFollow(FOLLOW_term_in_usertypeLiteral5413);
            v1=term();

            state._fsp--;

             m.put(k1, v1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:52: ( ',' kn= cident ':' vn= term )*
            loop105:
            do {
                int alt105=2;
                int LA105_0 = input.LA(1);

                if ( (LA105_0==143) ) {
                    alt105=1;
                }


                switch (alt105) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:54: ',' kn= cident ':' vn= term
            	    {
            	    match(input,143,FOLLOW_143_in_usertypeLiteral5419); 
            	    pushFollow(FOLLOW_cident_in_usertypeLiteral5423);
            	    kn=cident();

            	    state._fsp--;

            	    match(input,150,FOLLOW_150_in_usertypeLiteral5425); 
            	    pushFollow(FOLLOW_term_in_usertypeLiteral5429);
            	    vn=term();

            	    state._fsp--;

            	     m.put(kn, vn); 

            	    }
            	    break;

            	default :
            	    break loop105;
                }
            } while (true);

            match(input,151,FOLLOW_151_in_usertypeLiteral5436); 

            }

             ut = new UserTypes.Literal(m); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ut;
    }
    // $ANTLR end "usertypeLiteral"


    // $ANTLR start "tupleLiteral"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:894:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
    public final Tuples.Literal tupleLiteral() throws RecognitionException {
        Tuples.Literal tt = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;


         List<Term.Raw> l = new ArrayList<Term.Raw>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:5: ( '(' t1= term ( ',' tn= term )* ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:7: '(' t1= term ( ',' tn= term )* ')'
            {
            match(input,141,FOLLOW_141_in_tupleLiteral5473); 
            pushFollow(FOLLOW_term_in_tupleLiteral5477);
            t1=term();

            state._fsp--;

             l.add(t1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:34: ( ',' tn= term )*
            loop106:
            do {
                int alt106=2;
                int LA106_0 = input.LA(1);

                if ( (LA106_0==143) ) {
                    alt106=1;
                }


                switch (alt106) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:36: ',' tn= term
            	    {
            	    match(input,143,FOLLOW_143_in_tupleLiteral5483); 
            	    pushFollow(FOLLOW_term_in_tupleLiteral5487);
            	    tn=term();

            	    state._fsp--;

            	     l.add(tn); 

            	    }
            	    break;

            	default :
            	    break loop106;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_tupleLiteral5494); 

            }

             tt = new Tuples.Literal(l); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return tt;
    }
    // $ANTLR end "tupleLiteral"


    // $ANTLR start "value"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:900:1: value returns [Term.Raw value] : (c= constant | l= collectionLiteral | u= usertypeLiteral | t= tupleLiteral | K_NULL | ':' id= cident | QMARK );
    public final Term.Raw value() throws RecognitionException {
        Term.Raw value = null;

        Constants.Literal c = null;

        Term.Raw l = null;

        UserTypes.Literal u = null;

        Tuples.Literal t = null;

        ColumnIdentifier id = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:901:5: (c= constant | l= collectionLiteral | u= usertypeLiteral | t= tupleLiteral | K_NULL | ':' id= cident | QMARK )
            int alt107=7;
            alt107 = dfa107.predict(input);
            switch (alt107) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:901:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_value5517);
                    c=constant();

                    state._fsp--;

                     value = c; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:7: l= collectionLiteral
                    {
                    pushFollow(FOLLOW_collectionLiteral_in_value5539);
                    l=collectionLiteral();

                    state._fsp--;

                     value = l; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:903:7: u= usertypeLiteral
                    {
                    pushFollow(FOLLOW_usertypeLiteral_in_value5552);
                    u=usertypeLiteral();

                    state._fsp--;

                     value = u; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:7: t= tupleLiteral
                    {
                    pushFollow(FOLLOW_tupleLiteral_in_value5567);
                    t=tupleLiteral();

                    state._fsp--;

                     value = t; 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:905:7: K_NULL
                    {
                    match(input,K_NULL,FOLLOW_K_NULL_in_value5583); 
                     value = Constants.NULL_LITERAL; 

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:906:7: ':' id= cident
                    {
                    match(input,150,FOLLOW_150_in_value5607); 
                    pushFollow(FOLLOW_cident_in_value5611);
                    id=cident();

                    state._fsp--;

                     value = newBindVariables(id); 

                    }
                    break;
                case 7 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:907:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_value5628); 
                     value = newBindVariables(null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "value"


    // $ANTLR start "intValue"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:910:1: intValue returns [Term.Raw value] : ( | t= INTEGER | ':' id= cident | QMARK );
    public final Term.Raw intValue() throws RecognitionException {
        Term.Raw value = null;

        Token t=null;
        ColumnIdentifier id = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:911:5: ( | t= INTEGER | ':' id= cident | QMARK )
            int alt108=4;
            switch ( input.LA(1) ) {
            case EOF:
            case K_WHERE:
            case K_ALLOW:
            case K_AND:
            case K_INSERT:
            case K_UPDATE:
            case K_SET:
            case K_DELETE:
            case K_APPLY:
            case 140:
                {
                alt108=1;
                }
                break;
            case INTEGER:
                {
                alt108=2;
                }
                break;
            case 150:
                {
                alt108=3;
                }
                break;
            case QMARK:
                {
                alt108=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 108, 0, input);

                throw nvae;
            }

            switch (alt108) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:912:5: 
                    {
                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:912:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue5674); 
                     value = Constants.Literal.integer((t!=null?t.getText():null)); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:913:7: ':' id= cident
                    {
                    match(input,150,FOLLOW_150_in_intValue5688); 
                    pushFollow(FOLLOW_cident_in_intValue5692);
                    id=cident();

                    state._fsp--;

                     value = newBindVariables(id); 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:914:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_intValue5702); 
                     value = newBindVariables(null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "intValue"


    // $ANTLR start "functionName"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:917:1: functionName returns [String s] : (f= IDENT | u= unreserved_function_keyword | K_TOKEN );
    public final String functionName() throws RecognitionException {
        String s = null;

        Token f=null;
        String u = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:918:5: (f= IDENT | u= unreserved_function_keyword | K_TOKEN )
            int alt109=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt109=1;
                }
                break;
            case K_DISTINCT:
            case K_AS:
            case K_FILTERING:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_STATIC:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_CONTAINS:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt109=2;
                }
                break;
            case K_TOKEN:
                {
                alt109=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 109, 0, input);

                throw nvae;
            }

            switch (alt109) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:918:7: f= IDENT
                    {
                    f=(Token)match(input,IDENT,FOLLOW_IDENT_in_functionName5735); 
                     s = (f!=null?f.getText():null); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:919:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_functionName5769);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     s = u; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:920:7: K_TOKEN
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_functionName5779); 
                     s = "token"; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "functionName"


    // $ANTLR start "functionArgs"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:923:1: functionArgs returns [List<Term.Raw> a] : ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' );
    public final List<Term.Raw> functionArgs() throws RecognitionException {
        List<Term.Raw> a = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:5: ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' )
            int alt111=2;
            int LA111_0 = input.LA(1);

            if ( (LA111_0==141) ) {
                int LA111_1 = input.LA(2);

                if ( (LA111_1==142) ) {
                    alt111=1;
                }
                else if ( (LA111_1==K_DISTINCT||LA111_1==K_AS||LA111_1==K_FILTERING||LA111_1==INTEGER||LA111_1==K_VALUES||LA111_1==K_EXISTS||LA111_1==K_TIMESTAMP||LA111_1==K_COUNTER||LA111_1==K_STATIC||(LA111_1>=K_COMPACT && LA111_1<=K_CUSTOM)||LA111_1==IDENT||(LA111_1>=STRING_LITERAL && LA111_1<=K_TRIGGER)||LA111_1==K_LIST||(LA111_1>=K_ALL && LA111_1<=K_PASSWORD)||(LA111_1>=FLOAT && LA111_1<=K_TOKEN)||LA111_1==K_CONTAINS||(LA111_1>=K_ASCII && LA111_1<=K_MAP)||LA111_1==141||LA111_1==146||(LA111_1>=148 && LA111_1<=150)) ) {
                    alt111=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 111, 0, input);

                throw nvae;
            }
            switch (alt111) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:7: '(' ')'
                    {
                    match(input,141,FOLLOW_141_in_functionArgs5824); 
                    match(input,142,FOLLOW_142_in_functionArgs5826); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:925:7: '(' t1= term ( ',' tn= term )* ')'
                    {
                    match(input,141,FOLLOW_141_in_functionArgs5836); 
                    pushFollow(FOLLOW_term_in_functionArgs5840);
                    t1=term();

                    state._fsp--;

                     List<Term.Raw> args = new ArrayList<Term.Raw>(); args.add(t1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:926:11: ( ',' tn= term )*
                    loop110:
                    do {
                        int alt110=2;
                        int LA110_0 = input.LA(1);

                        if ( (LA110_0==143) ) {
                            alt110=1;
                        }


                        switch (alt110) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:926:13: ',' tn= term
                    	    {
                    	    match(input,143,FOLLOW_143_in_functionArgs5856); 
                    	    pushFollow(FOLLOW_term_in_functionArgs5860);
                    	    tn=term();

                    	    state._fsp--;

                    	     args.add(tn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop110;
                        }
                    } while (true);

                    match(input,142,FOLLOW_142_in_functionArgs5874); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "functionArgs"


    // $ANTLR start "term"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:930:1: term returns [Term.Raw term] : (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term );
    public final Term.Raw term() throws RecognitionException {
        Term.Raw term = null;

        Term.Raw v = null;

        String f = null;

        List<Term.Raw> args = null;

        CQL3Type.Raw c = null;

        Term.Raw t = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:931:5: (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term )
            int alt112=3;
            alt112 = dfa112.predict(input);
            switch (alt112) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:931:7: v= value
                    {
                    pushFollow(FOLLOW_value_in_term5899);
                    v=value();

                    state._fsp--;

                     term = v; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:932:7: f= functionName args= functionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_term5936);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_functionArgs_in_term5940);
                    args=functionArgs();

                    state._fsp--;

                     term = new FunctionCall.Raw(f, args); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:933:7: '(' c= comparatorType ')' t= term
                    {
                    match(input,141,FOLLOW_141_in_term5950); 
                    pushFollow(FOLLOW_comparatorType_in_term5954);
                    c=comparatorType();

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_term5956); 
                    pushFollow(FOLLOW_term_in_term5960);
                    t=term();

                    state._fsp--;

                     term = new TypeCast(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return term;
    }
    // $ANTLR end "term"


    // $ANTLR start "columnOperation"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:936:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );
    public final void columnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations) throws RecognitionException {
        Token sig=null;
        Token i=null;
        ColumnIdentifier key = null;

        Term.Raw t = null;

        ColumnIdentifier c = null;

        Term.Raw k = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:5: (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term )
            int alt114=4;
            alt114 = dfa114.predict(input);
            switch (alt114) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:7: key= cident '=' t= term ( '+' c= cident )?
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation5983);
                    key=cident();

                    state._fsp--;

                    match(input,152,FOLLOW_152_in_columnOperation5985); 
                    pushFollow(FOLLOW_term_in_columnOperation5989);
                    t=term();

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:29: ( '+' c= cident )?
                    int alt113=2;
                    int LA113_0 = input.LA(1);

                    if ( (LA113_0==153) ) {
                        alt113=1;
                    }
                    switch (alt113) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:30: '+' c= cident
                            {
                            match(input,153,FOLLOW_153_in_columnOperation5992); 
                            pushFollow(FOLLOW_cident_in_columnOperation5996);
                            c=cident();

                            state._fsp--;


                            }
                            break;

                    }


                              if (c == null)
                              {
                                  addRawUpdate(operations, key, new Operation.SetValue(t));
                              }
                              else
                              {
                                  if (!key.equals(c))
                                      addRecognitionError("Only expressions of the form X = <value> + X are supported.");
                                  addRawUpdate(operations, key, new Operation.Prepend(t));
                              }
                          

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:950:7: key= cident '=' c= cident sig= ( '+' | '-' ) t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation6017);
                    key=cident();

                    state._fsp--;

                    match(input,152,FOLLOW_152_in_columnOperation6019); 
                    pushFollow(FOLLOW_cident_in_columnOperation6023);
                    c=cident();

                    state._fsp--;

                    sig=(Token)input.LT(1);
                    if ( input.LA(1)==148||input.LA(1)==153 ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    pushFollow(FOLLOW_term_in_columnOperation6037);
                    t=term();

                    state._fsp--;


                              if (!key.equals(c))
                                  addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
                              addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
                          

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:956:7: key= cident '=' c= cident i= INTEGER
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation6055);
                    key=cident();

                    state._fsp--;

                    match(input,152,FOLLOW_152_in_columnOperation6057); 
                    pushFollow(FOLLOW_cident_in_columnOperation6061);
                    c=cident();

                    state._fsp--;

                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_columnOperation6065); 

                              // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
                              if (!key.equals(c))
                                  // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
                                  addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
                              addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
                          

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:964:7: key= cident '[' k= term ']' '=' t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation6083);
                    key=cident();

                    state._fsp--;

                    match(input,146,FOLLOW_146_in_columnOperation6085); 
                    pushFollow(FOLLOW_term_in_columnOperation6089);
                    k=term();

                    state._fsp--;

                    match(input,147,FOLLOW_147_in_columnOperation6091); 
                    match(input,152,FOLLOW_152_in_columnOperation6093); 
                    pushFollow(FOLLOW_term_in_columnOperation6097);
                    t=term();

                    state._fsp--;


                              addRawUpdate(operations, key, new Operation.SetElement(k, t));
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "columnOperation"


    // $ANTLR start "columnCondition"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:1: columnCondition[List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions] : (key= cident '=' t= term | key= cident '[' element= term ']' '=' t= term );
    public final void columnCondition(List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions) throws RecognitionException {
        ColumnIdentifier key = null;

        Term.Raw t = null;

        Term.Raw element = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:972:5: (key= cident '=' t= term | key= cident '[' element= term ']' '=' t= term )
            int alt115=2;
            alt115 = dfa115.predict(input);
            switch (alt115) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:972:7: key= cident '=' t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnCondition6130);
                    key=cident();

                    state._fsp--;

                    match(input,152,FOLLOW_152_in_columnCondition6132); 
                    pushFollow(FOLLOW_term_in_columnCondition6136);
                    t=term();

                    state._fsp--;

                     conditions.add(Pair.create(key, ColumnCondition.Raw.simpleEqual(t))); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:973:7: key= cident '[' element= term ']' '=' t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnCondition6148);
                    key=cident();

                    state._fsp--;

                    match(input,146,FOLLOW_146_in_columnCondition6150); 
                    pushFollow(FOLLOW_term_in_columnCondition6154);
                    element=term();

                    state._fsp--;

                    match(input,147,FOLLOW_147_in_columnCondition6156); 
                    match(input,152,FOLLOW_152_in_columnCondition6158); 
                    pushFollow(FOLLOW_term_in_columnCondition6162);
                    t=term();

                    state._fsp--;

                     conditions.add(Pair.create(key, ColumnCondition.Raw.collectionEqual(t, element))); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "columnCondition"


    // $ANTLR start "properties"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
    public final void properties(PropertyDefinitions props) throws RecognitionException {
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:977:5: ( property[props] ( K_AND property[props] )* )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:977:7: property[props] ( K_AND property[props] )*
            {
            pushFollow(FOLLOW_property_in_properties6183);
            property(props);

            state._fsp--;

            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:977:23: ( K_AND property[props] )*
            loop116:
            do {
                int alt116=2;
                int LA116_0 = input.LA(1);

                if ( (LA116_0==K_AND) ) {
                    alt116=1;
                }


                switch (alt116) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:977:24: K_AND property[props]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_properties6187); 
            	    pushFollow(FOLLOW_property_in_properties6189);
            	    property(props);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop116;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "properties"


    // $ANTLR start "property"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:980:1: property[PropertyDefinitions props] : k= cident '=' (simple= propertyValue | map= mapLiteral ) ;
    public final void property(PropertyDefinitions props) throws RecognitionException {
        ColumnIdentifier k = null;

        String simple = null;

        Maps.Literal map = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:5: (k= cident '=' (simple= propertyValue | map= mapLiteral ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:7: k= cident '=' (simple= propertyValue | map= mapLiteral )
            {
            pushFollow(FOLLOW_cident_in_property6212);
            k=cident();

            state._fsp--;

            match(input,152,FOLLOW_152_in_property6214); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:20: (simple= propertyValue | map= mapLiteral )
            int alt117=2;
            int LA117_0 = input.LA(1);

            if ( ((LA117_0>=K_DISTINCT && LA117_0<=K_AS)||(LA117_0>=K_FILTERING && LA117_0<=INTEGER)||LA117_0==K_VALUES||LA117_0==K_EXISTS||LA117_0==K_TIMESTAMP||LA117_0==K_COUNTER||LA117_0==K_STATIC||(LA117_0>=K_KEY && LA117_0<=K_CUSTOM)||(LA117_0>=STRING_LITERAL && LA117_0<=K_TRIGGER)||LA117_0==K_LIST||(LA117_0>=K_ALL && LA117_0<=K_PASSWORD)||(LA117_0>=FLOAT && LA117_0<=K_INFINITY)||LA117_0==K_CONTAINS||(LA117_0>=K_ASCII && LA117_0<=K_MAP)||LA117_0==148) ) {
                alt117=1;
            }
            else if ( (LA117_0==149) ) {
                alt117=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 117, 0, input);

                throw nvae;
            }
            switch (alt117) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:21: simple= propertyValue
                    {
                    pushFollow(FOLLOW_propertyValue_in_property6219);
                    simple=propertyValue();

                    state._fsp--;

                     try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:982:24: map= mapLiteral
                    {
                    pushFollow(FOLLOW_mapLiteral_in_property6248);
                    map=mapLiteral();

                    state._fsp--;

                     try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "property"


    // $ANTLR start "propertyValue"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:985:1: propertyValue returns [String str] : (c= constant | u= unreserved_keyword );
    public final String propertyValue() throws RecognitionException {
        String str = null;

        Constants.Literal c = null;

        String u = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:986:5: (c= constant | u= unreserved_keyword )
            int alt118=2;
            int LA118_0 = input.LA(1);

            if ( (LA118_0==INTEGER||LA118_0==STRING_LITERAL||(LA118_0>=FLOAT && LA118_0<=K_INFINITY)||LA118_0==148) ) {
                alt118=1;
            }
            else if ( ((LA118_0>=K_DISTINCT && LA118_0<=K_AS)||(LA118_0>=K_FILTERING && LA118_0<=K_TTL)||LA118_0==K_VALUES||LA118_0==K_EXISTS||LA118_0==K_TIMESTAMP||LA118_0==K_COUNTER||LA118_0==K_STATIC||(LA118_0>=K_KEY && LA118_0<=K_CUSTOM)||(LA118_0>=K_KEYS && LA118_0<=K_TRIGGER)||LA118_0==K_LIST||(LA118_0>=K_ALL && LA118_0<=K_PASSWORD)||LA118_0==K_CONTAINS||(LA118_0>=K_ASCII && LA118_0<=K_MAP)) ) {
                alt118=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 118, 0, input);

                throw nvae;
            }
            switch (alt118) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:986:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_propertyValue6277);
                    c=constant();

                    state._fsp--;

                     str = c.getRawText(); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:7: u= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_propertyValue6299);
                    u=unreserved_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "propertyValue"


    // $ANTLR start "relationType"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:990:1: relationType returns [Relation.Type op] : ( '=' | '<' | '<=' | '>' | '>=' );
    public final Relation.Type relationType() throws RecognitionException {
        Relation.Type op = null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:991:5: ( '=' | '<' | '<=' | '>' | '>=' )
            int alt119=5;
            switch ( input.LA(1) ) {
            case 152:
                {
                alt119=1;
                }
                break;
            case 154:
                {
                alt119=2;
                }
                break;
            case 155:
                {
                alt119=3;
                }
                break;
            case 156:
                {
                alt119=4;
                }
                break;
            case 157:
                {
                alt119=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;
            }

            switch (alt119) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:991:7: '='
                    {
                    match(input,152,FOLLOW_152_in_relationType6322); 
                     op = Relation.Type.EQ; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:992:7: '<'
                    {
                    match(input,154,FOLLOW_154_in_relationType6333); 
                     op = Relation.Type.LT; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:993:7: '<='
                    {
                    match(input,155,FOLLOW_155_in_relationType6344); 
                     op = Relation.Type.LTE; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:994:7: '>'
                    {
                    match(input,156,FOLLOW_156_in_relationType6354); 
                     op = Relation.Type.GT; 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:995:7: '>='
                    {
                    match(input,157,FOLLOW_157_in_relationType6365); 
                     op = Relation.Type.GTE; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "relationType"


    // $ANTLR start "relation"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:998:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term | name= cident K_IN marker= inMarker | name= cident K_IN inValues= singleColumnInValues | name= cident K_CONTAINS ( K_KEY )? t= term | ids= tupleOfIdentifiers ( K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples ) | type= relationType literal= tupleLiteral | type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
    public final void relation(List<Relation> clauses) throws RecognitionException {
        ColumnIdentifier name = null;

        Relation.Type type = null;

        Term.Raw t = null;

        List<ColumnIdentifier> l = null;

        AbstractMarker.INRaw marker = null;

        List<Term.Raw> inValues = null;

        List<ColumnIdentifier> ids = null;

        Tuples.INRaw tupleInMarker = null;

        List<Tuples.Literal> literals = null;

        List<Tuples.Raw> markers = null;

        Tuples.Literal literal = null;

        Tuples.Raw tupleMarker = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:999:5: (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term | name= cident K_IN marker= inMarker | name= cident K_IN inValues= singleColumnInValues | name= cident K_CONTAINS ( K_KEY )? t= term | ids= tupleOfIdentifiers ( K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples ) | type= relationType literal= tupleLiteral | type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
            int alt123=7;
            alt123 = dfa123.predict(input);
            switch (alt123) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:999:7: name= cident type= relationType t= term
                    {
                    pushFollow(FOLLOW_cident_in_relation6387);
                    name=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_relationType_in_relation6391);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation6395);
                    t=term();

                    state._fsp--;

                     clauses.add(new SingleColumnRelation(name, type, t)); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1000:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation6405); 
                    pushFollow(FOLLOW_tupleOfIdentifiers_in_relation6409);
                    l=tupleOfIdentifiers();

                    state._fsp--;

                    pushFollow(FOLLOW_relationType_in_relation6413);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation6417);
                    t=term();

                    state._fsp--;


                                for (ColumnIdentifier id : l)
                                    clauses.add(new SingleColumnRelation(id, type, t, true));
                            

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1005:7: name= cident K_IN marker= inMarker
                    {
                    pushFollow(FOLLOW_cident_in_relation6437);
                    name=cident();

                    state._fsp--;

                    match(input,K_IN,FOLLOW_K_IN_in_relation6439); 
                    pushFollow(FOLLOW_inMarker_in_relation6443);
                    marker=inMarker();

                    state._fsp--;

                     clauses.add(new SingleColumnRelation(name, Relation.Type.IN, marker)); 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1007:7: name= cident K_IN inValues= singleColumnInValues
                    {
                    pushFollow(FOLLOW_cident_in_relation6463);
                    name=cident();

                    state._fsp--;

                    match(input,K_IN,FOLLOW_K_IN_in_relation6465); 
                    pushFollow(FOLLOW_singleColumnInValues_in_relation6469);
                    inValues=singleColumnInValues();

                    state._fsp--;

                     clauses.add(SingleColumnRelation.createInRelation(name, inValues)); 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1009:7: name= cident K_CONTAINS ( K_KEY )? t= term
                    {
                    pushFollow(FOLLOW_cident_in_relation6489);
                    name=cident();

                    state._fsp--;

                    match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_relation6491); 
                     Relation.Type rt = Relation.Type.CONTAINS; 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1009:77: ( K_KEY )?
                    int alt120=2;
                    int LA120_0 = input.LA(1);

                    if ( (LA120_0==K_KEY) ) {
                        alt120=1;
                    }
                    switch (alt120) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1009:78: K_KEY
                            {
                            match(input,K_KEY,FOLLOW_K_KEY_in_relation6496); 
                             rt = Relation.Type.CONTAINS_KEY; 

                            }
                            break;

                    }

                    pushFollow(FOLLOW_term_in_relation6512);
                    t=term();

                    state._fsp--;

                     clauses.add(new SingleColumnRelation(name, rt, t)); 

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1011:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples ) | type= relationType literal= tupleLiteral | type= relationType tupleMarker= markerForTuple )
                    {
                    pushFollow(FOLLOW_tupleOfIdentifiers_in_relation6524);
                    ids=tupleOfIdentifiers();

                    state._fsp--;

                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:7: ( K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples ) | type= relationType literal= tupleLiteral | type= relationType tupleMarker= markerForTuple )
                    int alt122=3;
                    switch ( input.LA(1) ) {
                    case K_IN:
                        {
                        alt122=1;
                        }
                        break;
                    case 152:
                        {
                        int LA122_2 = input.LA(2);

                        if ( (LA122_2==141) ) {
                            alt122=2;
                        }
                        else if ( (LA122_2==QMARK||LA122_2==150) ) {
                            alt122=3;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 122, 2, input);

                            throw nvae;
                        }
                        }
                        break;
                    case 154:
                        {
                        int LA122_3 = input.LA(2);

                        if ( (LA122_3==141) ) {
                            alt122=2;
                        }
                        else if ( (LA122_3==QMARK||LA122_3==150) ) {
                            alt122=3;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 122, 3, input);

                            throw nvae;
                        }
                        }
                        break;
                    case 155:
                        {
                        int LA122_4 = input.LA(2);

                        if ( (LA122_4==QMARK||LA122_4==150) ) {
                            alt122=3;
                        }
                        else if ( (LA122_4==141) ) {
                            alt122=2;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 122, 4, input);

                            throw nvae;
                        }
                        }
                        break;
                    case 156:
                        {
                        int LA122_5 = input.LA(2);

                        if ( (LA122_5==QMARK||LA122_5==150) ) {
                            alt122=3;
                        }
                        else if ( (LA122_5==141) ) {
                            alt122=2;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 122, 5, input);

                            throw nvae;
                        }
                        }
                        break;
                    case 157:
                        {
                        int LA122_6 = input.LA(2);

                        if ( (LA122_6==141) ) {
                            alt122=2;
                        }
                        else if ( (LA122_6==QMARK||LA122_6==150) ) {
                            alt122=3;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 122, 6, input);

                            throw nvae;
                        }
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 122, 0, input);

                        throw nvae;
                    }

                    switch (alt122) {
                        case 1 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:9: K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples )
                            {
                            match(input,K_IN,FOLLOW_K_IN_in_relation6534); 
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1013:11: ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples )
                            int alt121=4;
                            int LA121_0 = input.LA(1);

                            if ( (LA121_0==141) ) {
                                switch ( input.LA(2) ) {
                                case 142:
                                    {
                                    alt121=1;
                                    }
                                    break;
                                case 141:
                                    {
                                    alt121=3;
                                    }
                                    break;
                                case QMARK:
                                case 150:
                                    {
                                    alt121=4;
                                    }
                                    break;
                                default:
                                    NoViableAltException nvae =
                                        new NoViableAltException("", 121, 1, input);

                                    throw nvae;
                                }

                            }
                            else if ( (LA121_0==QMARK||LA121_0==150) ) {
                                alt121=2;
                            }
                            else {
                                NoViableAltException nvae =
                                    new NoViableAltException("", 121, 0, input);

                                throw nvae;
                            }
                            switch (alt121) {
                                case 1 :
                                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1013:13: '(' ')'
                                    {
                                    match(input,141,FOLLOW_141_in_relation6548); 
                                    match(input,142,FOLLOW_142_in_relation6550); 
                                     clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); 

                                    }
                                    break;
                                case 2 :
                                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1015:13: tupleInMarker= inMarkerForTuple
                                    {
                                    pushFollow(FOLLOW_inMarkerForTuple_in_relation6582);
                                    tupleInMarker=inMarkerForTuple();

                                    state._fsp--;

                                     clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); 

                                    }
                                    break;
                                case 3 :
                                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1017:13: literals= tupleOfTupleLiterals
                                    {
                                    pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation6616);
                                    literals=tupleOfTupleLiterals();

                                    state._fsp--;


                                                      clauses.add(MultiColumnRelation.createInRelation(ids, literals));
                                                  

                                    }
                                    break;
                                case 4 :
                                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1021:13: markers= tupleOfMarkersForTuples
                                    {
                                    pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation6650);
                                    markers=tupleOfMarkersForTuples();

                                    state._fsp--;

                                     clauses.add(MultiColumnRelation.createInRelation(ids, markers)); 

                                    }
                                    break;

                            }


                            }
                            break;
                        case 2 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1024:9: type= relationType literal= tupleLiteral
                            {
                            pushFollow(FOLLOW_relationType_in_relation6692);
                            type=relationType();

                            state._fsp--;

                            pushFollow(FOLLOW_tupleLiteral_in_relation6696);
                            literal=tupleLiteral();

                            state._fsp--;


                                          clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
                                      

                            }
                            break;
                        case 3 :
                            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1028:9: type= relationType tupleMarker= markerForTuple
                            {
                            pushFollow(FOLLOW_relationType_in_relation6722);
                            type=relationType();

                            state._fsp--;

                            pushFollow(FOLLOW_markerForTuple_in_relation6726);
                            tupleMarker=markerForTuple();

                            state._fsp--;

                             clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); 

                            }
                            break;

                    }


                    }
                    break;
                case 7 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1031:7: '(' relation[$clauses] ')'
                    {
                    match(input,141,FOLLOW_141_in_relation6756); 
                    pushFollow(FOLLOW_relation_in_relation6758);
                    relation(clauses);

                    state._fsp--;

                    match(input,142,FOLLOW_142_in_relation6761); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "relation"


    // $ANTLR start "inMarker"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1034:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= cident );
    public final AbstractMarker.INRaw inMarker() throws RecognitionException {
        AbstractMarker.INRaw marker = null;

        ColumnIdentifier name = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1035:5: ( QMARK | ':' name= cident )
            int alt124=2;
            int LA124_0 = input.LA(1);

            if ( (LA124_0==QMARK) ) {
                alt124=1;
            }
            else if ( (LA124_0==150) ) {
                alt124=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 124, 0, input);

                throw nvae;
            }
            switch (alt124) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1035:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_inMarker6782); 
                     marker = newINBindVariables(null); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1036:7: ':' name= cident
                    {
                    match(input,150,FOLLOW_150_in_inMarker6792); 
                    pushFollow(FOLLOW_cident_in_inMarker6796);
                    name=cident();

                    state._fsp--;

                     marker = newINBindVariables(name); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return marker;
    }
    // $ANTLR end "inMarker"


    // $ANTLR start "tupleOfIdentifiers"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1039:1: tupleOfIdentifiers returns [List<ColumnIdentifier> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
    public final List<ColumnIdentifier> tupleOfIdentifiers() throws RecognitionException {
        List<ColumnIdentifier> ids = null;

        ColumnIdentifier n1 = null;

        ColumnIdentifier ni = null;


         ids = new ArrayList<ColumnIdentifier>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1041:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1041:7: '(' n1= cident ( ',' ni= cident )* ')'
            {
            match(input,141,FOLLOW_141_in_tupleOfIdentifiers6828); 
            pushFollow(FOLLOW_cident_in_tupleOfIdentifiers6832);
            n1=cident();

            state._fsp--;

             ids.add(n1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1041:39: ( ',' ni= cident )*
            loop125:
            do {
                int alt125=2;
                int LA125_0 = input.LA(1);

                if ( (LA125_0==143) ) {
                    alt125=1;
                }


                switch (alt125) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1041:40: ',' ni= cident
            	    {
            	    match(input,143,FOLLOW_143_in_tupleOfIdentifiers6837); 
            	    pushFollow(FOLLOW_cident_in_tupleOfIdentifiers6841);
            	    ni=cident();

            	    state._fsp--;

            	     ids.add(ni); 

            	    }
            	    break;

            	default :
            	    break loop125;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_tupleOfIdentifiers6847); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ids;
    }
    // $ANTLR end "tupleOfIdentifiers"


    // $ANTLR start "singleColumnInValues"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1044:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
    public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
        List<Term.Raw> terms = null;

        Term.Raw t1 = null;

        Term.Raw ti = null;


         terms = new ArrayList<Term.Raw>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:7: '(' (t1= term ( ',' ti= term )* )? ')'
            {
            match(input,141,FOLLOW_141_in_singleColumnInValues6877); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:11: (t1= term ( ',' ti= term )* )?
            int alt127=2;
            int LA127_0 = input.LA(1);

            if ( (LA127_0==K_DISTINCT||LA127_0==K_AS||LA127_0==K_FILTERING||LA127_0==INTEGER||LA127_0==K_VALUES||LA127_0==K_EXISTS||LA127_0==K_TIMESTAMP||LA127_0==K_COUNTER||LA127_0==K_STATIC||(LA127_0>=K_COMPACT && LA127_0<=K_CUSTOM)||LA127_0==IDENT||(LA127_0>=STRING_LITERAL && LA127_0<=K_TRIGGER)||LA127_0==K_LIST||(LA127_0>=K_ALL && LA127_0<=K_PASSWORD)||(LA127_0>=FLOAT && LA127_0<=K_TOKEN)||LA127_0==K_CONTAINS||(LA127_0>=K_ASCII && LA127_0<=K_MAP)||LA127_0==141||LA127_0==146||(LA127_0>=148 && LA127_0<=150)) ) {
                alt127=1;
            }
            switch (alt127) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:13: t1= term ( ',' ti= term )*
                    {
                    pushFollow(FOLLOW_term_in_singleColumnInValues6885);
                    t1=term();

                    state._fsp--;

                     terms.add(t1); 
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:43: ( ',' ti= term )*
                    loop126:
                    do {
                        int alt126=2;
                        int LA126_0 = input.LA(1);

                        if ( (LA126_0==143) ) {
                            alt126=1;
                        }


                        switch (alt126) {
                    	case 1 :
                    	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:44: ',' ti= term
                    	    {
                    	    match(input,143,FOLLOW_143_in_singleColumnInValues6890); 
                    	    pushFollow(FOLLOW_term_in_singleColumnInValues6894);
                    	    ti=term();

                    	    state._fsp--;

                    	     terms.add(ti); 

                    	    }
                    	    break;

                    	default :
                    	    break loop126;
                        }
                    } while (true);


                    }
                    break;

            }

            match(input,142,FOLLOW_142_in_singleColumnInValues6903); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return terms;
    }
    // $ANTLR end "singleColumnInValues"


    // $ANTLR start "tupleOfTupleLiterals"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1049:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
    public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
        List<Tuples.Literal> literals = null;

        Tuples.Literal t1 = null;

        Tuples.Literal ti = null;


         literals = new ArrayList<>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
            {
            match(input,141,FOLLOW_141_in_tupleOfTupleLiterals6933); 
            pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals6937);
            t1=tupleLiteral();

            state._fsp--;

             literals.add(t1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:50: ( ',' ti= tupleLiteral )*
            loop128:
            do {
                int alt128=2;
                int LA128_0 = input.LA(1);

                if ( (LA128_0==143) ) {
                    alt128=1;
                }


                switch (alt128) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:51: ',' ti= tupleLiteral
            	    {
            	    match(input,143,FOLLOW_143_in_tupleOfTupleLiterals6942); 
            	    pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals6946);
            	    ti=tupleLiteral();

            	    state._fsp--;

            	     literals.add(ti); 

            	    }
            	    break;

            	default :
            	    break loop128;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_tupleOfTupleLiterals6952); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return literals;
    }
    // $ANTLR end "tupleOfTupleLiterals"


    // $ANTLR start "markerForTuple"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1054:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= cident );
    public final Tuples.Raw markerForTuple() throws RecognitionException {
        Tuples.Raw marker = null;

        ColumnIdentifier name = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1055:5: ( QMARK | ':' name= cident )
            int alt129=2;
            int LA129_0 = input.LA(1);

            if ( (LA129_0==QMARK) ) {
                alt129=1;
            }
            else if ( (LA129_0==150) ) {
                alt129=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 129, 0, input);

                throw nvae;
            }
            switch (alt129) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1055:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_markerForTuple6973); 
                     marker = newTupleBindVariables(null); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1056:7: ':' name= cident
                    {
                    match(input,150,FOLLOW_150_in_markerForTuple6983); 
                    pushFollow(FOLLOW_cident_in_markerForTuple6987);
                    name=cident();

                    state._fsp--;

                     marker = newTupleBindVariables(name); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return marker;
    }
    // $ANTLR end "markerForTuple"


    // $ANTLR start "tupleOfMarkersForTuples"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1059:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
    public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
        List<Tuples.Raw> markers = null;

        Tuples.Raw m1 = null;

        Tuples.Raw mi = null;


         markers = new ArrayList<Tuples.Raw>(); 
        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1061:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1061:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
            {
            match(input,141,FOLLOW_141_in_tupleOfMarkersForTuples7019); 
            pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7023);
            m1=markerForTuple();

            state._fsp--;

             markers.add(m1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1061:51: ( ',' mi= markerForTuple )*
            loop130:
            do {
                int alt130=2;
                int LA130_0 = input.LA(1);

                if ( (LA130_0==143) ) {
                    alt130=1;
                }


                switch (alt130) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1061:52: ',' mi= markerForTuple
            	    {
            	    match(input,143,FOLLOW_143_in_tupleOfMarkersForTuples7028); 
            	    pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7032);
            	    mi=markerForTuple();

            	    state._fsp--;

            	     markers.add(mi); 

            	    }
            	    break;

            	default :
            	    break loop130;
                }
            } while (true);

            match(input,142,FOLLOW_142_in_tupleOfMarkersForTuples7038); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return markers;
    }
    // $ANTLR end "tupleOfMarkersForTuples"


    // $ANTLR start "inMarkerForTuple"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1064:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= cident );
    public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
        Tuples.INRaw marker = null;

        ColumnIdentifier name = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1065:5: ( QMARK | ':' name= cident )
            int alt131=2;
            int LA131_0 = input.LA(1);

            if ( (LA131_0==QMARK) ) {
                alt131=1;
            }
            else if ( (LA131_0==150) ) {
                alt131=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 131, 0, input);

                throw nvae;
            }
            switch (alt131) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1065:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple7059); 
                     marker = newTupleINBindVariables(null); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1066:7: ':' name= cident
                    {
                    match(input,150,FOLLOW_150_in_inMarkerForTuple7069); 
                    pushFollow(FOLLOW_cident_in_inMarkerForTuple7073);
                    name=cident();

                    state._fsp--;

                     marker = newTupleINBindVariables(name); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return marker;
    }
    // $ANTLR end "inMarkerForTuple"


    // $ANTLR start "comparatorType"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1069:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type | c= collection_type | tt= tuple_type | id= userTypeName | K_FROZEN '<' f= comparatorType '>' | s= STRING_LITERAL );
    public final CQL3Type.Raw comparatorType() throws RecognitionException {
        CQL3Type.Raw t = null;

        Token s=null;
        CQL3Type n = null;

        CQL3Type.Raw c = null;

        CQL3Type.Raw tt = null;

        UTName id = null;

        CQL3Type.Raw f = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1070:5: (n= native_type | c= collection_type | tt= tuple_type | id= userTypeName | K_FROZEN '<' f= comparatorType '>' | s= STRING_LITERAL )
            int alt132=6;
            alt132 = dfa132.predict(input);
            switch (alt132) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1070:7: n= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_comparatorType7098);
                    n=native_type();

                    state._fsp--;

                     t = CQL3Type.Raw.from(n); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1071:7: c= collection_type
                    {
                    pushFollow(FOLLOW_collection_type_in_comparatorType7114);
                    c=collection_type();

                    state._fsp--;

                     t = c; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1072:7: tt= tuple_type
                    {
                    pushFollow(FOLLOW_tuple_type_in_comparatorType7126);
                    tt=tuple_type();

                    state._fsp--;

                     t = tt; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1073:7: id= userTypeName
                    {
                    pushFollow(FOLLOW_userTypeName_in_comparatorType7142);
                    id=userTypeName();

                    state._fsp--;

                     t = CQL3Type.Raw.userType(id); 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1074:7: K_FROZEN '<' f= comparatorType '>'
                    {
                    match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType7154); 
                    match(input,154,FOLLOW_154_in_comparatorType7156); 
                    pushFollow(FOLLOW_comparatorType_in_comparatorType7160);
                    f=comparatorType();

                    state._fsp--;

                    match(input,156,FOLLOW_156_in_comparatorType7162); 

                            try {
                                t = CQL3Type.Raw.frozen(f);
                            } catch (InvalidRequestException e) {
                                addRecognitionError(e.getMessage());
                            }
                          

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:7: s= STRING_LITERAL
                    {
                    s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType7180); 

                            try {
                                t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
                            } catch (SyntaxException e) {
                                addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            } catch (ConfigurationException e) {
                                addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            }
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "comparatorType"


    // $ANTLR start "native_type"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1094:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID );
    public final CQL3Type native_type() throws RecognitionException {
        CQL3Type t = null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1095:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID )
            int alt133=16;
            switch ( input.LA(1) ) {
            case K_ASCII:
                {
                alt133=1;
                }
                break;
            case K_BIGINT:
                {
                alt133=2;
                }
                break;
            case K_BLOB:
                {
                alt133=3;
                }
                break;
            case K_BOOLEAN:
                {
                alt133=4;
                }
                break;
            case K_COUNTER:
                {
                alt133=5;
                }
                break;
            case K_DECIMAL:
                {
                alt133=6;
                }
                break;
            case K_DOUBLE:
                {
                alt133=7;
                }
                break;
            case K_FLOAT:
                {
                alt133=8;
                }
                break;
            case K_INET:
                {
                alt133=9;
                }
                break;
            case K_INT:
                {
                alt133=10;
                }
                break;
            case K_TEXT:
                {
                alt133=11;
                }
                break;
            case K_TIMESTAMP:
                {
                alt133=12;
                }
                break;
            case K_UUID:
                {
                alt133=13;
                }
                break;
            case K_VARCHAR:
                {
                alt133=14;
                }
                break;
            case K_VARINT:
                {
                alt133=15;
                }
                break;
            case K_TIMEUUID:
                {
                alt133=16;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }

            switch (alt133) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1095:7: K_ASCII
                    {
                    match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type7209); 
                     t = CQL3Type.Native.ASCII; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1096:7: K_BIGINT
                    {
                    match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type7223); 
                     t = CQL3Type.Native.BIGINT; 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:7: K_BLOB
                    {
                    match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type7236); 
                     t = CQL3Type.Native.BLOB; 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1098:7: K_BOOLEAN
                    {
                    match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type7251); 
                     t = CQL3Type.Native.BOOLEAN; 

                    }
                    break;
                case 5 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:7: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type7263); 
                     t = CQL3Type.Native.COUNTER; 

                    }
                    break;
                case 6 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1100:7: K_DECIMAL
                    {
                    match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type7275); 
                     t = CQL3Type.Native.DECIMAL; 

                    }
                    break;
                case 7 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1101:7: K_DOUBLE
                    {
                    match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type7287); 
                     t = CQL3Type.Native.DOUBLE; 

                    }
                    break;
                case 8 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1102:7: K_FLOAT
                    {
                    match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type7300); 
                     t = CQL3Type.Native.FLOAT; 

                    }
                    break;
                case 9 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1103:7: K_INET
                    {
                    match(input,K_INET,FOLLOW_K_INET_in_native_type7314); 
                     t = CQL3Type.Native.INET;

                    }
                    break;
                case 10 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1104:7: K_INT
                    {
                    match(input,K_INT,FOLLOW_K_INT_in_native_type7329); 
                     t = CQL3Type.Native.INT; 

                    }
                    break;
                case 11 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1105:7: K_TEXT
                    {
                    match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type7345); 
                     t = CQL3Type.Native.TEXT; 

                    }
                    break;
                case 12 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:7: K_TIMESTAMP
                    {
                    match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type7360); 
                     t = CQL3Type.Native.TIMESTAMP; 

                    }
                    break;
                case 13 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1107:7: K_UUID
                    {
                    match(input,K_UUID,FOLLOW_K_UUID_in_native_type7370); 
                     t = CQL3Type.Native.UUID; 

                    }
                    break;
                case 14 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1108:7: K_VARCHAR
                    {
                    match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type7385); 
                     t = CQL3Type.Native.VARCHAR; 

                    }
                    break;
                case 15 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1109:7: K_VARINT
                    {
                    match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type7397); 
                     t = CQL3Type.Native.VARINT; 

                    }
                    break;
                case 16 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1110:7: K_TIMEUUID
                    {
                    match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type7410); 
                     t = CQL3Type.Native.TIMEUUID; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "native_type"


    // $ANTLR start "collection_type"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1113:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
    public final CQL3Type.Raw collection_type() throws RecognitionException {
        CQL3Type.Raw pt = null;

        CQL3Type.Raw t1 = null;

        CQL3Type.Raw t2 = null;

        CQL3Type.Raw t = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
            int alt134=3;
            switch ( input.LA(1) ) {
            case K_MAP:
                {
                alt134=1;
                }
                break;
            case K_LIST:
                {
                alt134=2;
                }
                break;
            case K_SET:
                {
                alt134=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 134, 0, input);

                throw nvae;
            }

            switch (alt134) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
                    {
                    match(input,K_MAP,FOLLOW_K_MAP_in_collection_type7434); 
                    match(input,154,FOLLOW_154_in_collection_type7437); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type7441);
                    t1=comparatorType();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_collection_type7443); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type7447);
                    t2=comparatorType();

                    state._fsp--;

                    match(input,156,FOLLOW_156_in_collection_type7449); 
                     try {
                                // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
                                if (t1 != null && t2 != null)
                                    pt = CQL3Type.Raw.map(t1, t2);
                              } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1120:7: K_LIST '<' t= comparatorType '>'
                    {
                    match(input,K_LIST,FOLLOW_K_LIST_in_collection_type7467); 
                    match(input,154,FOLLOW_154_in_collection_type7469); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type7473);
                    t=comparatorType();

                    state._fsp--;

                    match(input,156,FOLLOW_156_in_collection_type7475); 
                     try { if (t != null) pt = CQL3Type.Raw.list(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:7: K_SET '<' t= comparatorType '>'
                    {
                    match(input,K_SET,FOLLOW_K_SET_in_collection_type7493); 
                    match(input,154,FOLLOW_154_in_collection_type7496); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type7500);
                    t=comparatorType();

                    state._fsp--;

                    match(input,156,FOLLOW_156_in_collection_type7502); 
                     try { if (t != null) pt = CQL3Type.Raw.set(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return pt;
    }
    // $ANTLR end "collection_type"


    // $ANTLR start "tuple_type"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1126:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
    public final CQL3Type.Raw tuple_type() throws RecognitionException {
        CQL3Type.Raw t = null;

        CQL3Type.Raw t1 = null;

        CQL3Type.Raw tn = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1127:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1127:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
            {
            match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type7533); 
            match(input,154,FOLLOW_154_in_tuple_type7535); 
             List<CQL3Type.Raw> types = new ArrayList<>(); 
            pushFollow(FOLLOW_comparatorType_in_tuple_type7550);
            t1=comparatorType();

            state._fsp--;

             types.add(t1); 
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1128:47: ( ',' tn= comparatorType )*
            loop135:
            do {
                int alt135=2;
                int LA135_0 = input.LA(1);

                if ( (LA135_0==143) ) {
                    alt135=1;
                }


                switch (alt135) {
            	case 1 :
            	    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1128:48: ',' tn= comparatorType
            	    {
            	    match(input,143,FOLLOW_143_in_tuple_type7555); 
            	    pushFollow(FOLLOW_comparatorType_in_tuple_type7559);
            	    tn=comparatorType();

            	    state._fsp--;

            	     types.add(tn); 

            	    }
            	    break;

            	default :
            	    break loop135;
                }
            } while (true);

            match(input,156,FOLLOW_156_in_tuple_type7571); 
             try { t = CQL3Type.Raw.tuple(types); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "tuple_type"

    public static class username_return extends ParserRuleReturnScope {
    };

    // $ANTLR start "username"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1132:1: username : ( IDENT | STRING_LITERAL );
    public final CqlParser.username_return username() throws RecognitionException {
        CqlParser.username_return retval = new CqlParser.username_return();
        retval.start = input.LT(1);

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1133:5: ( IDENT | STRING_LITERAL )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
            {
            if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "username"


    // $ANTLR start "non_type_ident"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1139:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT | t= QUOTED_NAME | k= basic_unreserved_keyword | kk= K_KEY );
    public final ColumnIdentifier non_type_ident() throws RecognitionException {
        ColumnIdentifier id = null;

        Token t=null;
        Token kk=null;
        String k = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:5: (t= IDENT | t= QUOTED_NAME | k= basic_unreserved_keyword | kk= K_KEY )
            int alt136=4;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt136=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt136=2;
                }
                break;
            case K_DISTINCT:
            case K_AS:
            case K_FILTERING:
            case K_VALUES:
            case K_EXISTS:
            case K_STATIC:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_TYPE:
            case K_CUSTOM:
            case K_KEYS:
            case K_TRIGGER:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_CONTAINS:
            case K_MAP:
                {
                alt136=3;
                }
                break;
            case K_KEY:
                {
                alt136=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 136, 0, input);

                throw nvae;
            }

            switch (alt136) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident7623); 
                     if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident7654); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1142:7: k= basic_unreserved_keyword
                    {
                    pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident7679);
                    k=basic_unreserved_keyword();

                    state._fsp--;

                     id = new ColumnIdentifier(k, false); 

                    }
                    break;
                case 4 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1143:7: kk= K_KEY
                    {
                    kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident7691); 
                     id = new ColumnIdentifier((kk!=null?kk.getText():null), false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "non_type_ident"


    // $ANTLR start "unreserved_keyword"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1146:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) );
    public final String unreserved_keyword() throws RecognitionException {
        String str = null;

        Token k=null;
        String u = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1147:5: (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) )
            int alt137=2;
            int LA137_0 = input.LA(1);

            if ( (LA137_0==K_DISTINCT||LA137_0==K_AS||LA137_0==K_FILTERING||LA137_0==K_VALUES||LA137_0==K_EXISTS||LA137_0==K_TIMESTAMP||LA137_0==K_COUNTER||LA137_0==K_STATIC||(LA137_0>=K_COMPACT && LA137_0<=K_CUSTOM)||(LA137_0>=K_KEYS && LA137_0<=K_TRIGGER)||LA137_0==K_LIST||(LA137_0>=K_ALL && LA137_0<=K_PASSWORD)||LA137_0==K_CONTAINS||(LA137_0>=K_ASCII && LA137_0<=K_MAP)) ) {
                alt137=1;
            }
            else if ( (LA137_0==K_COUNT||(LA137_0>=K_WRITETIME && LA137_0<=K_TTL)||LA137_0==K_KEY) ) {
                alt137=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 137, 0, input);

                throw nvae;
            }
            switch (alt137) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1147:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword7734);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY )
                    {
                    k=(Token)input.LT(1);
                    if ( input.LA(1)==K_COUNT||(input.LA(1)>=K_WRITETIME && input.LA(1)<=K_TTL)||input.LA(1)==K_KEY ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     str = (k!=null?k.getText():null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_keyword"


    // $ANTLR start "unreserved_function_keyword"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1151:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword | t= native_type );
    public final String unreserved_function_keyword() throws RecognitionException {
        String str = null;

        String u = null;

        CQL3Type t = null;


        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1152:5: (u= basic_unreserved_keyword | t= native_type )
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==K_DISTINCT||LA138_0==K_AS||LA138_0==K_FILTERING||LA138_0==K_VALUES||LA138_0==K_EXISTS||LA138_0==K_STATIC||(LA138_0>=K_COMPACT && LA138_0<=K_CUSTOM)||(LA138_0>=K_KEYS && LA138_0<=K_TRIGGER)||LA138_0==K_LIST||(LA138_0>=K_ALL && LA138_0<=K_PASSWORD)||LA138_0==K_CONTAINS||LA138_0==K_MAP) ) {
                alt138=1;
            }
            else if ( (LA138_0==K_TIMESTAMP||LA138_0==K_COUNTER||(LA138_0>=K_ASCII && LA138_0<=K_TIMEUUID)) ) {
                alt138=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;
            }
            switch (alt138) {
                case 1 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1152:7: u= basic_unreserved_keyword
                    {
                    pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword7789);
                    u=basic_unreserved_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;
                case 2 :
                    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1153:7: t= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_unreserved_function_keyword7801);
                    t=native_type();

                    state._fsp--;

                     str = t.toString(); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_function_keyword"


    // $ANTLR start "basic_unreserved_keyword"
    // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1156:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC ) ;
    public final String basic_unreserved_keyword() throws RecognitionException {
        String str = null;

        Token k=null;

        try {
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1157:5: (k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC ) )
            // /tmp/tmp.M01EQBB8Qw/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1157:7: k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC )
            {
            k=(Token)input.LT(1);
            if ( input.LA(1)==K_DISTINCT||input.LA(1)==K_AS||input.LA(1)==K_FILTERING||input.LA(1)==K_VALUES||input.LA(1)==K_EXISTS||input.LA(1)==K_STATIC||(input.LA(1)>=K_COMPACT && input.LA(1)<=K_CUSTOM)||(input.LA(1)>=K_KEYS && input.LA(1)<=K_TRIGGER)||input.LA(1)==K_LIST||(input.LA(1)>=K_ALL && input.LA(1)<=K_PASSWORD)||input.LA(1)==K_CONTAINS||input.LA(1)==K_MAP ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             str = (k!=null?k.getText():null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "basic_unreserved_keyword"

    // Delegated rules


    protected DFA2 dfa2 = new DFA2(this);
    protected DFA14 dfa14 = new DFA14(this);
    protected DFA36 dfa36 = new DFA36(this);
    protected DFA90 dfa90 = new DFA90(this);
    protected DFA92 dfa92 = new DFA92(this);
    protected DFA107 dfa107 = new DFA107(this);
    protected DFA112 dfa112 = new DFA112(this);
    protected DFA114 dfa114 = new DFA114(this);
    protected DFA115 dfa115 = new DFA115(this);
    protected DFA123 dfa123 = new DFA123(this);
    protected DFA132 dfa132 = new DFA132(this);
    static final String DFA2_eotS =
        "\40\uffff";
    static final String DFA2_eofS =
        "\40\uffff";
    static final String DFA2_minS =
        "\1\4\7\uffff\3\47\2\uffff\1\5\22\uffff";
    static final String DFA2_maxS =
        "\1\100\7\uffff\3\111\2\uffff\1\114\22\uffff";
    static final String DFA2_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\3\uffff\1\20\1\21\1\uffff\1"+
        "\10\1\11\1\23\1\27\1\31\1\12\1\13\1\14\1\15\1\25\1\30\1\33\1\16"+
        "\1\17\1\24\1\32\1\26\1\22";
    static final String DFA2_specialS =
        "\40\uffff}>";
    static final String[] DFA2_transitionS = {
            "\1\6\1\1\20\uffff\1\2\7\uffff\1\3\1\uffff\1\5\1\4\4\uffff\1"+
            "\10\21\uffff\1\11\1\12\3\uffff\1\7\1\13\1\14\1\15",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\16\1\uffff\1\17\6\uffff\1\22\2\23\4\uffff\1\21\21\uffff"+
            "\1\20",
            "\1\24\1\uffff\1\25\6\uffff\1\31\1\uffff\1\26\4\uffff\1\30\21"+
            "\uffff\1\27",
            "\1\33\1\uffff\1\32\6\uffff\1\35\30\uffff\1\34",
            "",
            "",
            "\1\37\40\uffff\1\37\21\uffff\2\37\11\uffff\3\37\6\uffff\1\36",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
    static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
    static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
    static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
    static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
    static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
    static final short[][] DFA2_transition;

    static {
        int numStates = DFA2_transitionS.length;
        DFA2_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
        }
    }

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = DFA2_eot;
            this.eof = DFA2_eof;
            this.min = DFA2_min;
            this.max = DFA2_max;
            this.accept = DFA2_accept;
            this.special = DFA2_special;
            this.transition = DFA2_transition;
        }
        public String getDescription() {
            return "219:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement | st25= createTypeStatement | st26= alterTypeStatement | st27= dropTypeStatement );";
        }
    }
    static final String DFA14_eotS =
        "\31\uffff";
    static final String DFA14_eofS =
        "\31\uffff";
    static final String DFA14_minS =
        "\1\6\1\10\1\uffff\23\10\3\uffff";
    static final String DFA14_maxS =
        "\1\151\1\u0091\1\uffff\23\u0091\3\uffff";
    static final String DFA14_acceptS =
        "\2\uffff\1\1\23\uffff\1\4\1\2\1\3";
    static final String DFA14_specialS =
        "\31\uffff}>";
    static final String[] DFA14_transitionS = {
            "\1\3\1\2\1\3\6\uffff\1\3\1\24\1\25\6\uffff\1\3\2\uffff\1\3\1"+
            "\uffff\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\2\5\3\1\uffff"+
            "\1\1\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\10\uffff\1\26"+
            "\1\uffff\1\3\1\uffff\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15"+
            "\1\16\1\20\1\21\1\22\1\23\1\3",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\26\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\27\2\2\1\uffff\1\2",
            "\2\2\u0083\uffff\1\30\2\2\1\uffff\1\2",
            "",
            "",
            ""
    };

    static final short[] DFA14_eot = DFA.unpackEncodedString(DFA14_eotS);
    static final short[] DFA14_eof = DFA.unpackEncodedString(DFA14_eofS);
    static final char[] DFA14_min = DFA.unpackEncodedStringToUnsignedChars(DFA14_minS);
    static final char[] DFA14_max = DFA.unpackEncodedStringToUnsignedChars(DFA14_maxS);
    static final short[] DFA14_accept = DFA.unpackEncodedString(DFA14_acceptS);
    static final short[] DFA14_special = DFA.unpackEncodedString(DFA14_specialS);
    static final short[][] DFA14_transition;

    static {
        int numStates = DFA14_transitionS.length;
        DFA14_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA14_transition[i] = DFA.unpackEncodedString(DFA14_transitionS[i]);
        }
    }

    class DFA14 extends DFA {

        public DFA14(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 14;
            this.eot = DFA14_eot;
            this.eof = DFA14_eof;
            this.min = DFA14_min;
            this.max = DFA14_max;
            this.accept = DFA14_accept;
            this.special = DFA14_special;
            this.transition = DFA14_transition;
        }
        public String getDescription() {
            return "301:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs )";
        }
    }
    static final String DFA36_eotS =
        "\27\uffff";
    static final String DFA36_eofS =
        "\27\uffff";
    static final String DFA36_minS =
        "\1\6\24\11\2\uffff";
    static final String DFA36_maxS =
        "\1\151\24\u0092\2\uffff";
    static final String DFA36_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA36_specialS =
        "\27\uffff}>";
    static final String[] DFA36_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\12\uffff\1\3\1\uffff"+
            "\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22"+
            "\1\23\1\3",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "\1\26\u0085\uffff\1\26\2\uffff\1\25",
            "",
            ""
    };

    static final short[] DFA36_eot = DFA.unpackEncodedString(DFA36_eotS);
    static final short[] DFA36_eof = DFA.unpackEncodedString(DFA36_eofS);
    static final char[] DFA36_min = DFA.unpackEncodedStringToUnsignedChars(DFA36_minS);
    static final char[] DFA36_max = DFA.unpackEncodedStringToUnsignedChars(DFA36_maxS);
    static final short[] DFA36_accept = DFA.unpackEncodedString(DFA36_acceptS);
    static final short[] DFA36_special = DFA.unpackEncodedString(DFA36_specialS);
    static final short[][] DFA36_transition;

    static {
        int numStates = DFA36_transitionS.length;
        DFA36_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA36_transition[i] = DFA.unpackEncodedString(DFA36_transitionS[i]);
        }
    }

    class DFA36 extends DFA {

        public DFA36(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 36;
            this.eot = DFA36_eot;
            this.eof = DFA36_eof;
            this.min = DFA36_min;
            this.max = DFA36_max;
            this.accept = DFA36_accept;
            this.special = DFA36_special;
            this.transition = DFA36_transition;
        }
        public String getDescription() {
            return "436:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );";
        }
    }
    static final String DFA90_eotS =
        "\27\uffff";
    static final String DFA90_eofS =
        "\1\uffff\24\25\2\uffff";
    static final String DFA90_minS =
        "\1\6\24\u008c\2\uffff";
    static final String DFA90_maxS =
        "\1\151\24\u0091\2\uffff";
    static final String DFA90_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA90_specialS =
        "\27\uffff}>";
    static final String[] DFA90_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\12\uffff\1\3\1\uffff"+
            "\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22"+
            "\1\23\1\3",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "\1\25\4\uffff\1\26",
            "",
            ""
    };

    static final short[] DFA90_eot = DFA.unpackEncodedString(DFA90_eotS);
    static final short[] DFA90_eof = DFA.unpackEncodedString(DFA90_eofS);
    static final char[] DFA90_min = DFA.unpackEncodedStringToUnsignedChars(DFA90_minS);
    static final char[] DFA90_max = DFA.unpackEncodedStringToUnsignedChars(DFA90_maxS);
    static final short[] DFA90_accept = DFA.unpackEncodedString(DFA90_acceptS);
    static final short[] DFA90_special = DFA.unpackEncodedString(DFA90_specialS);
    static final short[][] DFA90_transition;

    static {
        int numStates = DFA90_transitionS.length;
        DFA90_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA90_transition[i] = DFA.unpackEncodedString(DFA90_transitionS[i]);
        }
    }

    class DFA90 extends DFA {

        public DFA90(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 90;
            this.eot = DFA90_eot;
            this.eof = DFA90_eof;
            this.min = DFA90_min;
            this.max = DFA90_max;
            this.accept = DFA90_accept;
            this.special = DFA90_special;
            this.transition = DFA90_transition;
        }
        public String getDescription() {
            return "828:7: ( idxOrKsName[name, true] '.' )?";
        }
    }
    static final String DFA92_eotS =
        "\27\uffff";
    static final String DFA92_eofS =
        "\1\uffff\24\25\2\uffff";
    static final String DFA92_minS =
        "\1\6\24\11\2\uffff";
    static final String DFA92_maxS =
        "\1\151\24\u0091\2\uffff";
    static final String DFA92_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA92_specialS =
        "\27\uffff}>";
    static final String[] DFA92_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\12\uffff\1\3\1\uffff"+
            "\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22"+
            "\1\23\1\3",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\17\uffff\5\25\4\uffff\2\25\111\uffff\2\25\3\uffff\1\26",
            "",
            ""
    };

    static final short[] DFA92_eot = DFA.unpackEncodedString(DFA92_eotS);
    static final short[] DFA92_eof = DFA.unpackEncodedString(DFA92_eofS);
    static final char[] DFA92_min = DFA.unpackEncodedStringToUnsignedChars(DFA92_minS);
    static final char[] DFA92_max = DFA.unpackEncodedStringToUnsignedChars(DFA92_maxS);
    static final short[] DFA92_accept = DFA.unpackEncodedString(DFA92_acceptS);
    static final short[] DFA92_special = DFA.unpackEncodedString(DFA92_specialS);
    static final short[][] DFA92_transition;

    static {
        int numStates = DFA92_transitionS.length;
        DFA92_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA92_transition[i] = DFA.unpackEncodedString(DFA92_transitionS[i]);
        }
    }

    class DFA92 extends DFA {

        public DFA92(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 92;
            this.eot = DFA92_eot;
            this.eof = DFA92_eof;
            this.min = DFA92_min;
            this.max = DFA92_max;
            this.accept = DFA92_accept;
            this.special = DFA92_special;
            this.transition = DFA92_transition;
        }
        public String getDescription() {
            return "839:7: ( cfOrKsName[name, true] '.' )?";
        }
    }
    static final String DFA107_eotS =
        "\33\uffff";
    static final String DFA107_eofS =
        "\33\uffff";
    static final String DFA107_minS =
        "\1\22\2\uffff\1\6\4\uffff\1\u008d\1\uffff\21\u008d";
    static final String DFA107_maxS =
        "\1\u0096\2\uffff\1\u0097\4\uffff\1\u0096\1\uffff\21\u0096";
    static final String DFA107_acceptS =
        "\1\uffff\1\1\1\2\1\uffff\1\4\1\5\1\6\1\7\1\uffff\1\3\21\uffff";
    static final String DFA107_specialS =
        "\33\uffff}>";
    static final String[] DFA107_transitionS = {
            "\1\1\42\uffff\1\1\31\uffff\6\1\1\5\1\7\66\uffff\1\4\4\uffff"+
            "\1\2\1\uffff\1\1\1\3\1\6",
            "",
            "",
            "\1\12\1\11\1\12\6\uffff\1\12\2\11\1\2\5\uffff\1\12\2\uffff"+
            "\1\12\1\uffff\1\26\5\uffff\1\17\6\uffff\1\12\1\uffff\1\11\5"+
            "\12\1\uffff\1\10\1\uffff\1\2\2\12\10\uffff\1\12\4\uffff\11\12"+
            "\1\11\11\2\1\uffff\1\12\1\uffff\1\13\1\14\1\15\1\16\1\20\1\21"+
            "\1\22\1\23\1\24\1\25\1\27\1\30\1\31\1\32\1\12\43\uffff\1\2\4"+
            "\uffff\1\2\1\uffff\4\2",
            "",
            "",
            "",
            "",
            "\1\2\10\uffff\1\11",
            "",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11",
            "\1\2\10\uffff\1\11"
    };

    static final short[] DFA107_eot = DFA.unpackEncodedString(DFA107_eotS);
    static final short[] DFA107_eof = DFA.unpackEncodedString(DFA107_eofS);
    static final char[] DFA107_min = DFA.unpackEncodedStringToUnsignedChars(DFA107_minS);
    static final char[] DFA107_max = DFA.unpackEncodedStringToUnsignedChars(DFA107_maxS);
    static final short[] DFA107_accept = DFA.unpackEncodedString(DFA107_acceptS);
    static final short[] DFA107_special = DFA.unpackEncodedString(DFA107_specialS);
    static final short[][] DFA107_transition;

    static {
        int numStates = DFA107_transitionS.length;
        DFA107_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA107_transition[i] = DFA.unpackEncodedString(DFA107_transitionS[i]);
        }
    }

    class DFA107 extends DFA {

        public DFA107(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 107;
            this.eot = DFA107_eot;
            this.eof = DFA107_eof;
            this.min = DFA107_min;
            this.max = DFA107_max;
            this.accept = DFA107_accept;
            this.special = DFA107_special;
            this.transition = DFA107_transition;
        }
        public String getDescription() {
            return "900:1: value returns [Term.Raw value] : (c= constant | l= collectionLiteral | u= usertypeLiteral | t= tupleLiteral | K_NULL | ':' id= cident | QMARK );";
        }
    }
    static final String DFA112_eotS =
        "\56\uffff";
    static final String DFA112_eofS =
        "\32\uffff\1\1\1\uffff\22\31";
    static final String DFA112_minS =
        "\1\6\1\uffff\1\6\1\uffff\1\u008e\24\u008d\1\uffff\2\6\22\12";
    static final String DFA112_maxS =
        "\1\u0096\1\uffff\1\u0096\1\uffff\1\u008f\1\u0091\1\u009a\20\u0091"+
        "\1\u009a\1\u0091\1\uffff\1\u0099\1\u0096\22\u0099";
    static final String DFA112_acceptS =
        "\1\uffff\1\1\1\uffff\1\2\25\uffff\1\3\24\uffff";
    static final String DFA112_specialS =
        "\56\uffff}>";
    static final String[] DFA112_transitionS = {
            "\1\3\1\uffff\1\3\6\uffff\1\3\2\uffff\1\1\5\uffff\1\3\2\uffff"+
            "\1\3\1\uffff\1\3\5\uffff\1\3\6\uffff\1\3\2\uffff\5\3\1\uffff"+
            "\1\3\1\uffff\1\1\2\3\10\uffff\1\3\4\uffff\11\3\1\uffff\10\1"+
            "\1\3\1\uffff\1\3\1\uffff\17\3\43\uffff\1\2\4\uffff\1\1\1\uffff"+
            "\3\1",
            "",
            "\1\30\1\31\1\30\6\uffff\1\30\2\31\1\1\5\uffff\1\30\2\uffff"+
            "\1\30\1\uffff\1\22\1\uffff\1\31\3\uffff\1\13\6\uffff\1\30\1"+
            "\uffff\1\31\5\30\1\uffff\1\5\1\uffff\1\4\2\30\10\uffff\1\27"+
            "\4\uffff\11\30\1\31\11\1\1\uffff\1\30\1\31\1\7\1\10\1\11\1\12"+
            "\1\14\1\15\1\16\1\17\1\20\1\21\1\23\1\24\1\25\1\26\1\6\1\31"+
            "\42\uffff\1\1\4\uffff\1\1\1\uffff\3\1",
            "",
            "\1\32\1\1",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31\10\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31\10\uffff\1\31",
            "\1\1\1\31\2\uffff\1\31",
            "",
            "\1\31\1\uffff\1\31\1\uffff\2\1\1\uffff\2\1\1\31\2\uffff\1\31"+
            "\1\1\2\uffff\1\1\1\uffff\1\31\1\1\1\uffff\1\31\1\uffff\1\31"+
            "\1\1\1\uffff\1\1\2\uffff\1\31\1\uffff\1\1\4\uffff\1\31\2\uffff"+
            "\5\31\1\uffff\1\31\1\uffff\3\31\10\uffff\1\31\4\uffff\11\31"+
            "\1\uffff\11\31\1\uffff\1\31\1\uffff\17\31\42\uffff\1\1\1\31"+
            "\2\1\2\uffff\1\31\1\1\2\31\1\33\1\1\1\uffff\1\1",
            "\1\35\1\31\1\35\6\uffff\1\35\2\31\1\1\5\uffff\1\35\2\uffff"+
            "\1\35\1\uffff\1\51\5\uffff\1\42\6\uffff\1\35\1\uffff\1\31\5"+
            "\35\1\uffff\1\34\1\uffff\1\1\2\35\10\uffff\1\35\4\uffff\11\35"+
            "\1\31\11\1\1\uffff\1\35\1\uffff\1\36\1\37\1\40\1\41\1\43\1\44"+
            "\1\45\1\46\1\47\1\50\1\52\1\53\1\54\1\55\1\35\43\uffff\1\1\4"+
            "\uffff\1\1\1\uffff\3\1",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31",
            "\2\31\1\uffff\2\31\4\uffff\1\31\2\uffff\1\31\2\uffff\1\31\4"+
            "\uffff\1\31\1\uffff\1\31\4\uffff\1\31\146\uffff\1\31\1\1\2\31"+
            "\3\uffff\1\31\2\uffff\2\31\1\uffff\1\31"
    };

    static final short[] DFA112_eot = DFA.unpackEncodedString(DFA112_eotS);
    static final short[] DFA112_eof = DFA.unpackEncodedString(DFA112_eofS);
    static final char[] DFA112_min = DFA.unpackEncodedStringToUnsignedChars(DFA112_minS);
    static final char[] DFA112_max = DFA.unpackEncodedStringToUnsignedChars(DFA112_maxS);
    static final short[] DFA112_accept = DFA.unpackEncodedString(DFA112_acceptS);
    static final short[] DFA112_special = DFA.unpackEncodedString(DFA112_specialS);
    static final short[][] DFA112_transition;

    static {
        int numStates = DFA112_transitionS.length;
        DFA112_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA112_transition[i] = DFA.unpackEncodedString(DFA112_transitionS[i]);
        }
    }

    class DFA112 extends DFA {

        public DFA112(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 112;
            this.eot = DFA112_eot;
            this.eof = DFA112_eof;
            this.min = DFA112_min;
            this.max = DFA112_max;
            this.accept = DFA112_accept;
            this.special = DFA112_special;
            this.transition = DFA112_transition;
        }
        public String getDescription() {
            return "930:1: term returns [Term.Raw term] : (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term );";
        }
    }
    static final String DFA114_eotS =
        "\56\uffff";
    static final String DFA114_eofS =
        "\56\uffff";
    static final String DFA114_minS =
        "\1\6\24\u0092\1\6\2\uffff\24\22\2\uffff";
    static final String DFA114_maxS =
        "\1\151\24\u0098\1\u0096\2\uffff\24\u0099\2\uffff";
    static final String DFA114_acceptS =
        "\26\uffff\1\4\1\1\24\uffff\1\3\1\2";
    static final String DFA114_specialS =
        "\56\uffff}>";
    static final String[] DFA114_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\12\uffff\1\3\1\uffff"+
            "\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22"+
            "\1\23\1\3",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\31\1\53\1\31\6\uffff\1\31\2\53\1\27\5\uffff\1\31\2\uffff"+
            "\1\31\1\uffff\1\45\5\uffff\1\36\6\uffff\1\31\1\uffff\1\53\5"+
            "\31\1\uffff\1\30\1\uffff\1\27\2\31\10\uffff\1\31\4\uffff\11"+
            "\31\1\52\11\27\1\uffff\1\31\1\uffff\1\32\1\33\1\34\1\35\1\37"+
            "\1\40\1\41\1\42\1\43\1\44\1\46\1\47\1\50\1\51\1\31\43\uffff"+
            "\1\27\4\uffff\1\27\1\uffff\3\27",
            "",
            "",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\172\uffff\1\27\6\uffff\1\55\4\uffff\1\55",
            "\1\54\u0081\uffff\1\55\4\uffff\1\55",
            "\1\54\u0081\uffff\1\55\4\uffff\1\55",
            "",
            ""
    };

    static final short[] DFA114_eot = DFA.unpackEncodedString(DFA114_eotS);
    static final short[] DFA114_eof = DFA.unpackEncodedString(DFA114_eofS);
    static final char[] DFA114_min = DFA.unpackEncodedStringToUnsignedChars(DFA114_minS);
    static final char[] DFA114_max = DFA.unpackEncodedStringToUnsignedChars(DFA114_maxS);
    static final short[] DFA114_accept = DFA.unpackEncodedString(DFA114_acceptS);
    static final short[] DFA114_special = DFA.unpackEncodedString(DFA114_specialS);
    static final short[][] DFA114_transition;

    static {
        int numStates = DFA114_transitionS.length;
        DFA114_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA114_transition[i] = DFA.unpackEncodedString(DFA114_transitionS[i]);
        }
    }

    class DFA114 extends DFA {

        public DFA114(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 114;
            this.eot = DFA114_eot;
            this.eof = DFA114_eof;
            this.min = DFA114_min;
            this.max = DFA114_max;
            this.accept = DFA114_accept;
            this.special = DFA114_special;
            this.transition = DFA114_transition;
        }
        public String getDescription() {
            return "936:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );";
        }
    }
    static final String DFA115_eotS =
        "\27\uffff";
    static final String DFA115_eofS =
        "\27\uffff";
    static final String DFA115_minS =
        "\1\6\24\u0092\2\uffff";
    static final String DFA115_maxS =
        "\1\151\24\u0098\2\uffff";
    static final String DFA115_acceptS =
        "\25\uffff\1\1\1\2";
    static final String DFA115_specialS =
        "\27\uffff}>";
    static final String[] DFA115_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\12\uffff\1\3\1\uffff"+
            "\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22"+
            "\1\23\1\3",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "",
            ""
    };

    static final short[] DFA115_eot = DFA.unpackEncodedString(DFA115_eotS);
    static final short[] DFA115_eof = DFA.unpackEncodedString(DFA115_eofS);
    static final char[] DFA115_min = DFA.unpackEncodedStringToUnsignedChars(DFA115_minS);
    static final char[] DFA115_max = DFA.unpackEncodedStringToUnsignedChars(DFA115_maxS);
    static final short[] DFA115_accept = DFA.unpackEncodedString(DFA115_acceptS);
    static final short[] DFA115_special = DFA.unpackEncodedString(DFA115_specialS);
    static final short[][] DFA115_transition;

    static {
        int numStates = DFA115_transitionS.length;
        DFA115_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA115_transition[i] = DFA.unpackEncodedString(DFA115_transitionS[i]);
        }
    }

    class DFA115 extends DFA {

        public DFA115(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 115;
            this.eot = DFA115_eot;
            this.eof = DFA115_eof;
            this.min = DFA115_min;
            this.max = DFA115_max;
            this.accept = DFA115_accept;
            this.special = DFA115_special;
            this.transition = DFA115_transition;
        }
        public String getDescription() {
            return "970:1: columnCondition[List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions] : (key= cident '=' t= term | key= cident '[' element= term ']' '=' t= term );";
        }
    }
    static final String DFA123_eotS =
        "\62\uffff";
    static final String DFA123_eofS =
        "\62\uffff";
    static final String DFA123_minS =
        "\1\6\24\130\1\uffff\1\6\1\uffff\1\126\1\uffff\24\130\4\uffff";
    static final String DFA123_maxS =
        "\1\u008d\24\u009d\1\uffff\1\u008d\1\uffff\1\u0096\1\uffff\24\u009d"+
        "\4\uffff";
    static final String DFA123_acceptS =
        "\25\uffff\1\2\1\uffff\1\1\1\uffff\1\5\24\uffff\1\7\1\3\1\4\1\6";
    static final String DFA123_specialS =
        "\62\uffff}>";
    static final String[] DFA123_transitionS = {
            "\1\3\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\6\uffff\1\3\1\uffff\1\24\5\3\1\uffff\1\1"+
            "\2\uffff\2\3\10\uffff\1\3\4\uffff\11\3\1\2\10\uffff\1\25\1\uffff"+
            "\1\3\1\uffff\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1"+
            "\20\1\21\1\22\1\23\1\3\43\uffff\1\26",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "\1\30\1\31\76\uffff\1\27\1\uffff\4\27",
            "",
            "\1\34\1\55\1\34\6\uffff\1\34\2\55\6\uffff\1\34\2\uffff\1\34"+
            "\1\uffff\1\50\5\uffff\1\41\6\uffff\1\34\1\uffff\1\55\5\34\1"+
            "\uffff\1\32\2\uffff\2\34\10\uffff\1\34\4\uffff\11\34\1\33\10"+
            "\uffff\1\56\1\uffff\1\34\1\uffff\1\35\1\36\1\37\1\40\1\42\1"+
            "\43\1\44\1\45\1\46\1\47\1\51\1\52\1\53\1\54\1\34\43\uffff\1"+
            "\56",
            "",
            "\1\57\66\uffff\1\60\10\uffff\1\57",
            "",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "\2\56\64\uffff\2\61\10\uffff\1\56\1\uffff\4\56",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA123_eot = DFA.unpackEncodedString(DFA123_eotS);
    static final short[] DFA123_eof = DFA.unpackEncodedString(DFA123_eofS);
    static final char[] DFA123_min = DFA.unpackEncodedStringToUnsignedChars(DFA123_minS);
    static final char[] DFA123_max = DFA.unpackEncodedStringToUnsignedChars(DFA123_maxS);
    static final short[] DFA123_accept = DFA.unpackEncodedString(DFA123_acceptS);
    static final short[] DFA123_special = DFA.unpackEncodedString(DFA123_specialS);
    static final short[][] DFA123_transition;

    static {
        int numStates = DFA123_transitionS.length;
        DFA123_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA123_transition[i] = DFA.unpackEncodedString(DFA123_transitionS[i]);
        }
    }

    class DFA123 extends DFA {

        public DFA123(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 123;
            this.eot = DFA123_eot;
            this.eof = DFA123_eof;
            this.min = DFA123_min;
            this.max = DFA123_max;
            this.accept = DFA123_accept;
            this.special = DFA123_special;
            this.transition = DFA123_transition;
        }
        public String getDescription() {
            return "998:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term | name= cident K_IN marker= inMarker | name= cident K_IN inValues= singleColumnInValues | name= cident K_CONTAINS ( K_KEY )? t= term | ids= tupleOfIdentifiers ( K_IN ( '(' ')' | tupleInMarker= inMarkerForTuple | literals= tupleOfTupleLiterals | markers= tupleOfMarkersForTuples ) | type= relationType literal= tupleLiteral | type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );";
        }
    }
    static final String DFA132_eotS =
        "\31\uffff";
    static final String DFA132_eofS =
        "\1\uffff\20\30\2\25\6\uffff";
    static final String DFA132_minS =
        "\1\6\22\52\6\uffff";
    static final String DFA132_maxS =
        "\1\152\22\u009c\6\uffff";
    static final String DFA132_acceptS =
        "\23\uffff\1\2\1\3\1\4\1\5\1\6\1\1";
    static final String DFA132_specialS =
        "\31\uffff}>";
    static final String[] DFA132_transitionS = {
            "\3\25\6\uffff\3\25\6\uffff\1\25\2\uffff\1\25\1\uffff\1\14\1"+
            "\uffff\1\23\3\uffff\1\5\6\uffff\1\25\1\uffff\6\25\1\uffff\1"+
            "\25\1\uffff\1\27\2\25\10\uffff\1\22\4\uffff\12\25\12\uffff\1"+
            "\25\1\26\1\1\1\2\1\3\1\4\1\6\1\7\1\10\1\11\1\12\1\13\1\15\1"+
            "\16\1\17\1\20\1\21\1\24",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\30\140\uffff\1\30\1\uffff\2\30\1\uffff\1\25\12\uffff\1\30",
            "\2\25\140\uffff\1\25\1\uffff\2\25\1\uffff\1\25\10\uffff\1\23"+
            "\1\uffff\1\25",
            "\2\25\140\uffff\1\25\1\uffff\2\25\1\uffff\1\25\10\uffff\1\23"+
            "\1\uffff\1\25",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA132_eot = DFA.unpackEncodedString(DFA132_eotS);
    static final short[] DFA132_eof = DFA.unpackEncodedString(DFA132_eofS);
    static final char[] DFA132_min = DFA.unpackEncodedStringToUnsignedChars(DFA132_minS);
    static final char[] DFA132_max = DFA.unpackEncodedStringToUnsignedChars(DFA132_maxS);
    static final short[] DFA132_accept = DFA.unpackEncodedString(DFA132_acceptS);
    static final short[] DFA132_special = DFA.unpackEncodedString(DFA132_specialS);
    static final short[][] DFA132_transition;

    static {
        int numStates = DFA132_transitionS.length;
        DFA132_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA132_transition[i] = DFA.unpackEncodedString(DFA132_transitionS[i]);
        }
    }

    class DFA132 extends DFA {

        public DFA132(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 132;
            this.eot = DFA132_eot;
            this.eof = DFA132_eof;
            this.min = DFA132_min;
            this.max = DFA132_max;
            this.accept = DFA132_accept;
            this.special = DFA132_special;
            this.transition = DFA132_transition;
        }
        public String getDescription() {
            return "1069:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type | c= collection_type | tt= tuple_type | id= userTypeName | K_FROZEN '<' f= comparatorType '>' | s= STRING_LITERAL );";
        }
    }
 

    public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_140_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createTableStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement326 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement405 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement425 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_grantStatement_in_cqlStatement442 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_revokeStatement_in_cqlStatement467 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement491 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createUserStatement_in_cqlStatement506 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement526 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement547 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement569 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement590 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement607 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement626 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement646 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement667 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USE_in_useStatement702 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_keyspaceName_in_useStatement706 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SELECT_in_selectStatement740 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000010000L});
    public static final BitSet FOLLOW_K_DISTINCT_in_selectStatement746 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000010000L});
    public static final BitSet FOLLOW_selectClause_in_selectStatement755 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_COUNT_in_selectStatement775 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_selectStatement777 = new BitSet(new long[]{0x0000000000040000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_selectCountClause_in_selectStatement781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_selectStatement783 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_K_AS_in_selectStatement788 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_selectStatement792 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_FROM_in_selectStatement807 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_selectStatement811 = new BitSet(new long[]{0x0000000000006C02L});
    public static final BitSet FOLLOW_K_WHERE_in_selectStatement821 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_whereClause_in_selectStatement825 = new BitSet(new long[]{0x0000000000006802L});
    public static final BitSet FOLLOW_K_ORDER_in_selectStatement838 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_K_BY_in_selectStatement840 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement842 = new BitSet(new long[]{0x0000000000006002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_selectStatement847 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement849 = new BitSet(new long[]{0x0000000000006002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_K_LIMIT_in_selectStatement866 = new BitSet(new long[]{0x0000000000044000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_intValue_in_selectStatement870 = new BitSet(new long[]{0x0000000000004002L});
    public static final BitSet FOLLOW_K_ALLOW_in_selectStatement885 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_K_FILTERING_in_selectStatement887 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selector_in_selectClause924 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_selectClause929 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L});
    public static final BitSet FOLLOW_selector_in_selectClause933 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_144_in_selectClause945 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unaliasedSelector_in_selector978 = new BitSet(new long[]{0x0000000000000102L});
    public static final BitSet FOLLOW_K_AS_in_selector981 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_selector985 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector1026 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector1072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_unaliasedSelector1074 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector1078 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_unaliasedSelector1080 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_unaliasedSelector1114 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector1118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_unaliasedSelector1120 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_functionName_in_unaliasedSelector1148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_145_in_unaliasedSelector1167 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector1171 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_141_in_selectionFunctionArgs1199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_selectionFunctionArgs1201 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_selectionFunctionArgs1211 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L});
    public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_selectionFunctionArgs1231 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L});
    public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_selectionFunctionArgs1248 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_144_in_selectCountClause1271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_selectCountClause1293 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relation_in_whereClause1329 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_whereClause1333 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_relation_in_whereClause1335 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_cident_in_orderByClause1366 = new BitSet(new long[]{0x0000000000300002L});
    public static final BitSet FOLLOW_K_ASC_in_orderByClause1371 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_orderByClause1375 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INSERT_in_insertStatement1413 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_K_INTO_in_insertStatement1415 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1419 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_insertStatement1431 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_insertStatement1435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_insertStatement1442 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_insertStatement1446 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_insertStatement1453 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_K_VALUES_in_insertStatement1463 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_insertStatement1475 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_insertStatement1479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_insertStatement1485 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_insertStatement1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_insertStatement1496 = new BitSet(new long[]{0x0000000012000002L});
    public static final BitSet FOLLOW_K_IF_in_insertStatement1509 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_insertStatement1511 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_insertStatement1513 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_usingClause_in_insertStatement1530 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USING_in_usingClause1560 = new BitSet(new long[]{0x0000000020020000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1562 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_usingClause1567 = new BitSet(new long[]{0x0000000020020000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1569 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591 = new BitSet(new long[]{0x0000000000040000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_intValue_in_usingClauseObjective1595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective1605 = new BitSet(new long[]{0x0000000000040000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_intValue_in_usingClauseObjective1609 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UPDATE_in_updateStatement1643 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_updateStatement1647 = new BitSet(new long[]{0x0000000090000000L});
    public static final BitSet FOLLOW_usingClause_in_updateStatement1657 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_K_SET_in_updateStatement1669 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1671 = new BitSet(new long[]{0x0000000000000400L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_updateStatement1675 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1677 = new BitSet(new long[]{0x0000000000000400L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_K_WHERE_in_updateStatement1688 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement1692 = new BitSet(new long[]{0x0000000002000002L});
    public static final BitSet FOLLOW_K_IF_in_updateStatement1702 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_updateConditions_in_updateStatement1706 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_columnCondition_in_updateConditions1747 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_updateConditions1752 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnCondition_in_updateConditions1754 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1791 = new BitSet(new long[]{0x00CBF408290383C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_deleteSelection_in_deleteStatement1797 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_FROM_in_deleteStatement1810 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1814 = new BitSet(new long[]{0x0000000010000400L});
    public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1824 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1836 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement1840 = new BitSet(new long[]{0x0000000002000002L});
    public static final BitSet FOLLOW_K_IF_in_deleteStatement1850 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement1854 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateConditions_in_deleteStatement1862 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1909 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_deleteSelection1924 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1928 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_cident_in_deleteOp1955 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_deleteOp1982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_deleteOp1984 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_deleteOp1988 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_147_in_deleteOp1990 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USING_in_usingClauseDelete2010 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete2012 = new BitSet(new long[]{0x0000000000040000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_intValue_in_usingClauseDelete2016 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BEGIN_in_batchStatement2050 = new BitSet(new long[]{0x0000001C00000000L});
    public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement2060 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_COUNTER_in_batchStatement2066 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement2079 = new BitSet(new long[]{0x0000002150400000L});
    public static final BitSet FOLLOW_usingClause_in_batchStatement2083 = new BitSet(new long[]{0x0000002140400000L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2103 = new BitSet(new long[]{0x0000002140400000L,0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_140_in_batchStatement2105 = new BitSet(new long[]{0x0000002140400000L});
    public static final BitSet FOLLOW_K_APPLY_in_batchStatement2119 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement2121 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2152 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2165 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2178 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement2213 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2215 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement2218 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement2220 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement2222 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement2231 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement2239 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_properties_in_createKeyspaceStatement2241 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createTableStatement2276 = new BitSet(new long[]{0x0000020000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement2278 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_createTableStatement2281 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_createTableStatement2283 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement2285 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement2300 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement2310 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_cfamDefinition2329 = new BitSet(new long[]{0x00CBFC08290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2331 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_cfamDefinition2336 = new BitSet(new long[]{0x00CBFC08290381C0L,0x000003FFFA007FE1L,0x000000000000C000L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2338 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_cfamDefinition2345 = new BitSet(new long[]{0x0000010000000002L});
    public static final BitSet FOLLOW_K_WITH_in_cfamDefinition2355 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2357 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_cfamDefinition2362 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2364 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_cident_in_cfamColumns2390 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_cfamColumns2394 = new BitSet(new long[]{0x00000C0000000002L});
    public static final BitSet FOLLOW_K_STATIC_in_cfamColumns2399 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2416 = new BitSet(new long[]{0x0000100000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2418 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2430 = new BitSet(new long[]{0x0000100000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_cfamColumns2434 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_pkDef_in_cfamColumns2436 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_cfamColumns2440 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_cfamColumns2444 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_cfamColumns2451 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_pkDef2471 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_pkDef2481 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_pkDef2487 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_pkDef2493 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_pkDef2497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_pkDef2504 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_cfamProperty2524 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty2533 = new BitSet(new long[]{0x0000400000000000L});
    public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty2535 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty2545 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_K_ORDER_in_cfamProperty2547 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_K_BY_in_cfamProperty2549 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_cfamProperty2551 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2553 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_cfamProperty2557 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2559 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_cfamProperty2564 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_cfamOrdering2592 = new BitSet(new long[]{0x0000000000300000L});
    public static final BitSet FOLLOW_K_ASC_in_cfamOrdering2595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_cfamOrdering2599 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement2638 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement2640 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_createTypeStatement2643 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_createTypeStatement2645 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement2647 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_userTypeName_in_createTypeStatement2665 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_createTypeStatement2678 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2680 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_createTypeStatement2685 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L,0x000000000000C000L});
    public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2687 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_createTypeStatement2694 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_typeColumns2714 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_typeColumns2718 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement2753 = new BitSet(new long[]{0x0006000000000000L});
    public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement2756 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement2762 = new BitSet(new long[]{0x0018000002000000L});
    public static final BitSet FOLLOW_K_IF_in_createIndexStatement2765 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_createIndexStatement2767 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement2769 = new BitSet(new long[]{0x0018000000000000L});
    public static final BitSet FOLLOW_IDENT_in_createIndexStatement2787 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_K_ON_in_createIndexStatement2791 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement2795 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_createIndexStatement2797 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_indexIdent_in_createIndexStatement2801 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_createIndexStatement2803 = new BitSet(new long[]{0x0000010010000002L});
    public static final BitSet FOLLOW_K_USING_in_createIndexStatement2814 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement2818 = new BitSet(new long[]{0x0000010000000002L});
    public static final BitSet FOLLOW_K_WITH_in_createIndexStatement2833 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_properties_in_createIndexStatement2835 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_indexIdent2869 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_KEYS_in_indexIdent2894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_indexIdent2896 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_indexIdent2900 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_indexIdent2902 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement2928 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement2930 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_createTriggerStatement2935 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_K_ON_in_createTriggerStatement2938 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement2942 = new BitSet(new long[]{0x0000000010000000L});
    public static final BitSet FOLLOW_K_USING_in_createTriggerStatement2944 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement2948 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement2979 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement2981 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_dropTriggerStatement2986 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement2989 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement2993 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement3033 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3035 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement3039 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement3049 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement3051 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3087 = new BitSet(new long[]{0x0000020000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3089 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement3093 = new BitSet(new long[]{0x0F00010000000000L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3107 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3111 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement3113 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3117 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ADD_in_alterTableStatement3133 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3139 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3143 = new BitSet(new long[]{0x0000040000000002L});
    public static final BitSet FOLLOW_K_STATIC_in_alterTableStatement3148 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_alterTableStatement3166 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3171 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WITH_in_alterTableStatement3211 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_properties_in_alterTableStatement3214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement3247 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3301 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement3303 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3307 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_alterTableStatement3328 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3332 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement3334 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3338 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3384 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3386 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement3390 = new BitSet(new long[]{0x0E00000000000000L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3404 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3408 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3410 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3414 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement3430 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3436 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3440 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement3463 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3501 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3503 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3507 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_alterTypeStatement3530 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3534 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3536 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_alterTypeStatement3540 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement3607 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3609 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement3612 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement3614 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement3623 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropTableStatement3657 = new BitSet(new long[]{0x0000020000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3659 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_dropTableStatement3662 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement3664 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement3673 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement3707 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement3709 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_dropTypeStatement3712 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement3714 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement3723 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement3757 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement3759 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_K_IF_in_dropIndexStatement3762 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement3764 = new BitSet(new long[]{0x00CBF4082B0381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_indexName_in_dropIndexStatement3773 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement3804 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement3808 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_GRANT_in_grantStatement3833 = new BitSet(new long[]{0x0300004000000020L,0x0000000000000038L});
    public static final BitSet FOLLOW_permissionOrAll_in_grantStatement3845 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_K_ON_in_grantStatement3853 = new BitSet(new long[]{0x00CBF688290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_resource_in_grantStatement3865 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_K_TO_in_grantStatement3873 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_grantStatement3885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_REVOKE_in_revokeStatement3916 = new BitSet(new long[]{0x0300004000000020L,0x0000000000000038L});
    public static final BitSet FOLLOW_permissionOrAll_in_revokeStatement3928 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_K_ON_in_revokeStatement3936 = new BitSet(new long[]{0x00CBF688290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_resource_in_revokeStatement3948 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_FROM_in_revokeStatement3956 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_revokeStatement3968 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement4006 = new BitSet(new long[]{0x0300004000000020L,0x0000000000000038L});
    public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement4018 = new BitSet(new long[]{0x0010000000000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement4028 = new BitSet(new long[]{0x00CBF688290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_resource_in_listPermissionsStatement4030 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement4045 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_listPermissionsStatement4047 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000004L});
    public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4062 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_permission4098 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_permissionOrAll4147 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
    public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll4151 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_permission_in_permissionOrAll4172 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000080L});
    public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll4176 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dataResource_in_resource4204 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_dataResource4227 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource4229 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource4239 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_keyspaceName_in_dataResource4245 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource4257 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_columnFamilyName_in_dataResource4266 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createUserStatement4306 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_K_USER_in_createUserStatement4308 = new BitSet(new long[]{0x0028000002000000L});
    public static final BitSet FOLLOW_K_IF_in_createUserStatement4311 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_NOT_in_createUserStatement4313 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement4315 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_createUserStatement4321 = new BitSet(new long[]{0x0000010000000002L,0x0000000000000C00L});
    public static final BitSet FOLLOW_K_WITH_in_createUserStatement4331 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_userOptions_in_createUserStatement4333 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000C00L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement4347 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement4353 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement4398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_K_USER_in_alterUserStatement4400 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_alterUserStatement4402 = new BitSet(new long[]{0x0000010000000002L,0x0000000000000C00L});
    public static final BitSet FOLLOW_K_WITH_in_alterUserStatement4412 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_userOptions_in_alterUserStatement4414 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000C00L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement4428 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement4434 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropUserStatement4479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_K_USER_in_dropUserStatement4481 = new BitSet(new long[]{0x0028000002000000L});
    public static final BitSet FOLLOW_K_IF_in_dropUserStatement4484 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement4486 = new BitSet(new long[]{0x0028000000000000L});
    public static final BitSet FOLLOW_username_in_dropUserStatement4492 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listUsersStatement4517 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_K_USERS_in_listUsersStatement4519 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userOption_in_userOptions4539 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PASSWORD_in_userOption4560 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_userOption4564 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cident4593 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cident4618 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cident4637 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_keyspaceName4670 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_idxOrKsName_in_indexName4704 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_145_in_indexName4707 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_idxOrKsName_in_indexName4711 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_idxOrKsName4732 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_idxOrKsName4757 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_idxOrKsName4776 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4809 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_145_in_columnFamilyName4812 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4816 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_userTypeName4841 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_145_in_userTypeName4843 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_non_type_ident_in_userTypeName4849 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cfOrKsName4871 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cfOrKsName4896 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cfOrKsName4915 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_constant4940 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_constant4952 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_in_constant4971 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BOOLEAN_in_constant4992 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUID_in_constant5011 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEXNUMBER_in_constant5033 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_148_in_constant5051 = new BitSet(new long[]{0x0000000000000000L,0x0000000000180000L});
    public static final BitSet FOLLOW_set_in_constant5060 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_149_in_mapLiteral5089 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000F42000L});
    public static final BitSet FOLLOW_term_in_mapLiteral5107 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_150_in_mapLiteral5109 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_mapLiteral5113 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000808000L});
    public static final BitSet FOLLOW_143_in_mapLiteral5119 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_mapLiteral5123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_150_in_mapLiteral5125 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_mapLiteral5129 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000808000L});
    public static final BitSet FOLLOW_151_in_mapLiteral5145 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_setOrMapLiteral5169 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_setOrMapLiteral5173 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_setOrMapLiteral5189 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_setOrMapLiteral5193 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_150_in_setOrMapLiteral5195 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_setOrMapLiteral5199 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_setOrMapLiteral5234 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_setOrMapLiteral5238 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_146_in_collectionLiteral5272 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x00000000007C2000L});
    public static final BitSet FOLLOW_term_in_collectionLiteral5290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000088000L});
    public static final BitSet FOLLOW_143_in_collectionLiteral5296 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_collectionLiteral5300 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000088000L});
    public static final BitSet FOLLOW_147_in_collectionLiteral5316 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_149_in_collectionLiteral5326 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_collectionLiteral5330 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000C08000L});
    public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral5334 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_151_in_collectionLiteral5339 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_149_in_collectionLiteral5357 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_151_in_collectionLiteral5359 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_149_in_usertypeLiteral5403 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_usertypeLiteral5407 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_150_in_usertypeLiteral5409 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_usertypeLiteral5413 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000808000L});
    public static final BitSet FOLLOW_143_in_usertypeLiteral5419 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_usertypeLiteral5423 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_150_in_usertypeLiteral5425 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_usertypeLiteral5429 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000808000L});
    public static final BitSet FOLLOW_151_in_usertypeLiteral5436 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_tupleLiteral5473 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_tupleLiteral5477 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_tupleLiteral5483 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_tupleLiteral5487 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_tupleLiteral5494 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_value5517 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionLiteral_in_value5539 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_usertypeLiteral_in_value5552 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_tupleLiteral_in_value5567 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NULL_in_value5583 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_value5607 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_value5611 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_value5628 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_intValue5674 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_intValue5688 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_intValue5692 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_intValue5702 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_functionName5735 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_functionName5769 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_functionName5779 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_functionArgs5824 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_functionArgs5826 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_functionArgs5836 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_functionArgs5840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_functionArgs5856 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_functionArgs5860 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_functionArgs5874 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_value_in_term5899 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_functionName_in_term5936 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_functionArgs_in_term5940 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_term5950 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_term5954 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_term5956 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_term5960 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation5983 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnOperation5985 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnOperation5989 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_153_in_columnOperation5992 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_columnOperation5996 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation6017 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnOperation6019 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_columnOperation6023 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002100000L});
    public static final BitSet FOLLOW_set_in_columnOperation6027 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnOperation6037 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation6055 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnOperation6057 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_columnOperation6061 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_INTEGER_in_columnOperation6065 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation6083 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_columnOperation6085 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnOperation6089 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_147_in_columnOperation6091 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnOperation6093 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnOperation6097 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnCondition6130 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnCondition6132 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnCondition6136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnCondition6148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_columnCondition6150 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnCondition6154 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_147_in_columnCondition6156 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_columnCondition6158 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_columnCondition6162 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_properties6183 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_K_AND_in_properties6187 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_property_in_properties6189 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_cident_in_property6212 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_152_in_property6214 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFA1FFFE1L,0x0000000000300000L});
    public static final BitSet FOLLOW_propertyValue_in_property6219 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_mapLiteral_in_property6248 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_propertyValue6277 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue6299 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_152_in_relationType6322 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_154_in_relationType6333 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_155_in_relationType6344 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_156_in_relationType6354 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_157_in_relationType6365 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation6387 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000003D000000L});
    public static final BitSet FOLLOW_relationType_in_relation6391 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_relation6395 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_relation6405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation6409 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000003D000000L});
    public static final BitSet FOLLOW_relationType_in_relation6413 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_relation6417 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation6437 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_K_IN_in_relation6439 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_inMarker_in_relation6443 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation6463 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_K_IN_in_relation6465 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_singleColumnInValues_in_relation6469 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation6489 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_K_CONTAINS_in_relation6491 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_K_KEY_in_relation6496 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_relation6512 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation6524 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L,0x000000003D000000L});
    public static final BitSet FOLLOW_K_IN_in_relation6534 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000402000L});
    public static final BitSet FOLLOW_141_in_relation6548 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_relation6550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_inMarkerForTuple_in_relation6582 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation6616 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation6650 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relationType_in_relation6692 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_tupleLiteral_in_relation6696 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relationType_in_relation6722 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_markerForTuple_in_relation6726 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_relation6756 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA807FE1L,0x0000000000002000L});
    public static final BitSet FOLLOW_relation_in_relation6758 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_142_in_relation6761 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_inMarker6782 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_inMarker6792 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_inMarker6796 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_tupleOfIdentifiers6828 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers6832 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_tupleOfIdentifiers6837 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers6841 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_tupleOfIdentifiers6847 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_singleColumnInValues6877 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000746000L});
    public static final BitSet FOLLOW_term_in_singleColumnInValues6885 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_singleColumnInValues6890 = new BitSet(new long[]{0x00EBF408290781C0L,0x000003FFFAFFFFE1L,0x0000000000742000L});
    public static final BitSet FOLLOW_term_in_singleColumnInValues6894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_singleColumnInValues6903 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_tupleOfTupleLiterals6933 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals6937 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_tupleOfTupleLiterals6942 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals6946 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_tupleOfTupleLiterals6952 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_markerForTuple6973 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_markerForTuple6983 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_markerForTuple6987 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_tupleOfMarkersForTuples7019 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7023 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_143_in_tupleOfMarkersForTuples7028 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000400000L});
    public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7032 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000000C000L});
    public static final BitSet FOLLOW_142_in_tupleOfMarkersForTuples7038 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple7059 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_150_in_inMarkerForTuple7069 = new BitSet(new long[]{0x00CBF408290381C0L,0x000003FFFA007FE1L});
    public static final BitSet FOLLOW_cident_in_inMarkerForTuple7073 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_comparatorType7098 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collection_type_in_comparatorType7114 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_tuple_type_in_comparatorType7126 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userTypeName_in_comparatorType7142 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_FROZEN_in_comparatorType7154 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_154_in_comparatorType7156 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_comparatorType7160 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_156_in_comparatorType7162 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType7180 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ASCII_in_native_type7209 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BIGINT_in_native_type7223 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BLOB_in_native_type7236 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BOOLEAN_in_native_type7251 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COUNTER_in_native_type7263 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DECIMAL_in_native_type7275 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DOUBLE_in_native_type7287 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_FLOAT_in_native_type7300 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INET_in_native_type7314 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INT_in_native_type7329 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TEXT_in_native_type7345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type7360 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UUID_in_native_type7370 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARCHAR_in_native_type7385 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARINT_in_native_type7397 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMEUUID_in_native_type7410 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_MAP_in_collection_type7434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_154_in_collection_type7437 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_collection_type7441 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_collection_type7443 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_collection_type7447 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_156_in_collection_type7449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_collection_type7467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_154_in_collection_type7469 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_collection_type7473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_156_in_collection_type7475 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SET_in_collection_type7493 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_154_in_collection_type7496 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_collection_type7500 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_156_in_collection_type7502 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TUPLE_in_tuple_type7533 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_154_in_tuple_type7535 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_tuple_type7550 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010008000L});
    public static final BitSet FOLLOW_143_in_tuple_type7555 = new BitSet(new long[]{0x00EBF408A90381C0L,0x000007FFFE007FE1L});
    public static final BitSet FOLLOW_comparatorType_in_tuple_type7559 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010008000L});
    public static final BitSet FOLLOW_156_in_tuple_type7571 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_username0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_non_type_ident7623 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident7654 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident7679 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_KEY_in_non_type_ident7691 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword7734 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_unreserved_keyword7750 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword7789 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword7801 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_basic_unreserved_keyword7839 = new BitSet(new long[]{0x0000000000000002L});

}