/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.FilteredRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.db.transform.UnfilteredRows;

final class Filter
extends Transformation {
    private final boolean filterEmpty;
    private final int nowInSec;

    public Filter(boolean filterEmpty, int nowInSec) {
        this.filterEmpty = filterEmpty;
        this.nowInSec = nowInSec;
    }

    protected RowIterator applyToPartition(BaseRowIterator iterator) {
        FilteredRows filtered;
        FilteredRows filteredRows = filtered = iterator instanceof UnfilteredRows ? new FilteredRows(this, (UnfilteredRows)iterator) : new FilteredRows((UnfilteredRowIterator)iterator, this);
        if (this.filterEmpty && Filter.closeIfEmpty(filtered)) {
            return null;
        }
        return filtered;
    }

    @Override
    protected Row applyToStatic(Row row) {
        if (row.isEmpty()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        return (row = row.purge(DeletionPurger.PURGE_ALL, this.nowInSec)) == null ? Rows.EMPTY_STATIC_ROW : row;
    }

    @Override
    protected Row applyToRow(Row row) {
        return row.purge(DeletionPurger.PURGE_ALL, this.nowInSec);
    }

    @Override
    protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
        return null;
    }

    private static boolean closeIfEmpty(BaseRowIterator<?> iter) {
        if (iter.isEmpty()) {
            iter.close();
            return true;
        }
        return false;
    }
}

