/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.functional.ThrowingConsumer;
import org.apache.causeway.commons.functional.ThrowingFunction;
import org.apache.causeway.commons.functional.ThrowingRunnable;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public interface Try<T> {
    public static <T> Try<T> empty() {
        return Try.success(null);
    }

    public static <T> Try<T> call(@NonNull Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        try {
            return Try.success(callable.call());
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }

    public static Try<Void> run(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        try {
            runnable.run();
            return Try.success(null);
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }

    public static <T> Success<T> success(@Nullable T value) {
        return new Success<T>(value);
    }

    public static <T> Failure<T> failure(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        return new Failure(throwable);
    }

    public boolean isSuccess();

    public boolean isFailure();

    public Optional<T> getValue();

    public Optional<Throwable> getFailure();

    public Try<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> var1);

    public Try<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> var1);

    public Try<T> ifFailure(@NonNull ThrowingConsumer<Throwable> var1);

    public Try<T> ifFailureFail();

    public Try<T> ifAbsentFail();

    public <R> Try<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> var1);

    public <R> Try<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> var1);

    public <R> Try<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> var1);

    public Try<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> var1);

    public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> var1);

    public Try<T> mapEmptyToFailure();

    public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> var1, @NonNull ThrowingFunction<Optional<T>, R> var2);

    public <R> Try<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> var1);

    public <R> Try<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> var1);

    public <R> Try<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> var1);

    public Try<T> accept(@NonNull ThrowingConsumer<Throwable> var1, @NonNull ThrowingConsumer<Optional<T>> var2);

    public <R> R fold(@NonNull ThrowingFunction<Throwable, R> var1, @NonNull ThrowingFunction<Optional<T>, R> var2);

    public <R> Try<R> thenCall(@NonNull Callable<R> var1);

    public Try<Void> thenRun(@NonNull ThrowingRunnable var1);

    public <R> Try<R> then(@NonNull Callable<? extends Try<R>> var1);

    public Try<T> orCall(@NonNull Callable<T> var1);

    @Nullable
    default public T valueAsNullableElseFail() {
        this.ifFailureFail();
        return this.getValue().orElse(null);
    }

    default public T valueAsNonNullElseFail() {
        this.ifFailureFail();
        return this.getValue().orElseThrow();
    }

    public static final class Success<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        private final T value;

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public Optional<T> getValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.empty();
        }

        @Override
        public Try<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> valueConsumer) {
            if (valueConsumer == null) {
                throw new NullPointerException("valueConsumer is marked non-null but is null");
            }
            try {
                valueConsumer.accept(this.getValue());
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> valueConsumer) {
            if (valueConsumer == null) {
                throw new NullPointerException("valueConsumer is marked non-null but is null");
            }
            try {
                valueConsumer.accept(this.getValue().orElse(null));
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Success<T> ifFailure(@NonNull ThrowingConsumer<Throwable> exceptionConsumer) {
            if (exceptionConsumer == null) {
                throw new NullPointerException("exceptionConsumer is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Success<T> ifFailureFail() {
            return this;
        }

        @Override
        public Success<T> ifAbsentFail() {
            if (this.value == null) {
                throw _Exceptions.noSuchElement();
            }
            return this;
        }

        @Override
        public <R> Try<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Try.call(() -> successMapper.apply(this.getValue()));
        }

        @Override
        public <R> Try<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Try.call(() -> successMapper.apply(this.getValue().orElse(null)));
        }

        @Override
        public <R> Try<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return this.getValue().map(value -> Try.call(() -> successMapper.apply(value))).orElseGet(Try::empty);
        }

        @Override
        public <R> Try<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            try {
                return successMapper.apply(this.getValue());
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public <R> Try<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            try {
                return successMapper.apply(this.getValue().orElse(null));
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public <R> Try<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            Object value = this.getValue().orElse(null);
            if (value == null) {
                return Try.empty();
            }
            try {
                return successMapper.apply(value);
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public Success<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> failureMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> recoveryMapper) {
            if (recoveryMapper == null) {
                throw new NullPointerException("recoveryMapper is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Try<T> mapEmptyToFailure() {
            return this.value != null ? this : Try.failure(_Exceptions.noSuchElement());
        }

        @Override
        public <R> Try<R> thenCall(@NonNull Callable<R> callable) {
            if (callable == null) {
                throw new NullPointerException("callable is marked non-null but is null");
            }
            return Try.call(callable);
        }

        @Override
        public Try<Void> thenRun(@NonNull ThrowingRunnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable is marked non-null but is null");
            }
            return Try.run(runnable);
        }

        @Override
        public <R> Try<R> then(@NonNull Callable<? extends Try<R>> next) {
            if (next == null) {
                throw new NullPointerException("next is marked non-null but is null");
            }
            try {
                return next.call();
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> orCall(@NonNull Callable<T> fallback) {
            if (fallback == null) {
                throw new NullPointerException("fallback is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Try<T> accept(@NonNull ThrowingConsumer<Throwable> failureConsumer, @NonNull ThrowingConsumer<Optional<T>> successConsumer) {
            if (failureConsumer == null) {
                throw new NullPointerException("failureConsumer is marked non-null but is null");
            }
            if (successConsumer == null) {
                throw new NullPointerException("successConsumer is marked non-null but is null");
            }
            try {
                successConsumer.accept(this.getValue());
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<Throwable, R> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return successMapper.apply(this.getValue());
        }

        @Override
        public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Either.right(successMapper.apply(this.getValue()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Success)) {
                return false;
            }
            Success other = (Success)o;
            Optional<T> this$value = this.getValue();
            Optional<T> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<T> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "Try.Success(value=" + this.getValue() + ")";
        }

        public Success(@Nullable T value) {
            this.value = value;
        }
    }

    public static final class Failure<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final Throwable throwable;

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public Optional<T> getValue() {
            return Optional.empty();
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.of(this.throwable);
        }

        @Override
        public Failure<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> valueConsumer) {
            if (valueConsumer == null) {
                throw new NullPointerException("valueConsumer is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Failure<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> valueConsumer) {
            if (valueConsumer == null) {
                throw new NullPointerException("valueConsumer is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Failure<T> ifFailure(@NonNull ThrowingConsumer<Throwable> exceptionConsumer) {
            if (exceptionConsumer == null) {
                throw new NullPointerException("exceptionConsumer is marked non-null but is null");
            }
            try {
                exceptionConsumer.accept(this.throwable);
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Failure<T> ifFailureFail() {
            throw this.throwable;
        }

        @Override
        public Failure<T> ifAbsentFail() {
            throw _Exceptions.noSuchElement();
        }

        @Override
        public <R> Failure<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public Failure<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> failureMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            try {
                return new Failure<T>(failureMapper.apply(this.throwable));
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> recoveryMapper) {
            if (recoveryMapper == null) {
                throw new NullPointerException("recoveryMapper is marked non-null but is null");
            }
            return Try.call(() -> recoveryMapper.apply(this.throwable));
        }

        @Override
        public Try<T> mapEmptyToFailure() {
            return this;
        }

        @Override
        public <R> Failure<R> thenCall(@NonNull Callable<R> callable) {
            if (callable == null) {
                throw new NullPointerException("callable is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public Try<Void> thenRun(@NonNull ThrowingRunnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable is marked non-null but is null");
            }
            return new Failure<Void>(this.throwable);
        }

        @Override
        public <R> Try<R> then(@NonNull Callable<? extends Try<R>> next) {
            if (next == null) {
                throw new NullPointerException("next is marked non-null but is null");
            }
            return new Failure<T>(this.throwable);
        }

        @Override
        public Try<T> orCall(@NonNull Callable<T> fallback) {
            if (fallback == null) {
                throw new NullPointerException("fallback is marked non-null but is null");
            }
            return Try.call(fallback);
        }

        @Override
        public Try<T> accept(@NonNull ThrowingConsumer<Throwable> failureConsumer, @NonNull ThrowingConsumer<Optional<T>> successConsumer) {
            if (failureConsumer == null) {
                throw new NullPointerException("failureConsumer is marked non-null but is null");
            }
            if (successConsumer == null) {
                throw new NullPointerException("successConsumer is marked non-null but is null");
            }
            try {
                failureConsumer.accept(this.throwable);
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<Throwable, R> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return failureMapper.apply(this.throwable);
        }

        @Override
        public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Either.left(failureMapper.apply(this.throwable));
        }

        @NonNull
        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        public String toString() {
            return "Try.Failure(throwable=" + this.getThrowable() + ")";
        }

        public Failure(@NonNull Throwable throwable) {
            if (throwable == null) {
                throw new NullPointerException("throwable is marked non-null but is null");
            }
            this.throwable = throwable;
        }
    }
}

