/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug;

import java.time.LocalDateTime;
import javax.swing.tree.MutableTreeNode;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.debug._IconResource;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.apache.causeway.commons.internal.debug.xray.XrayModel;
import org.apache.causeway.commons.internal.debug.xray.XrayUi;

final class _Xray {
    static void recordDebugLogEvent(_IconResource icon, String logMessage, Can<StackTraceElement> stackTrace) {
        if (!XrayUi.isXrayEnabled()) {
            return;
        }
        XrayModel.ThreadMemento threadId = XrayModel.ThreadMemento.fromCurrentThread();
        LocalDateTime timeStamp = LocalDateTime.now();
        XrayUi.updateModel(model -> {
            MutableTreeNode parentNode = model.getThreadNode(threadId);
            XrayDataModel.LogEntry logModel = model.addDataNode(parentNode, new XrayDataModel.LogEntry("debug-log", timeStamp, icon.getResourcePath(), _Strings.ellipsifyAtEnd(logMessage, 80, "..."), logMessage, XrayModel.Stickiness.CAN_DELETE_NODE));
            stackTrace.forEach(logModel.getData()::add);
        });
    }

    private _Xray() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

