/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.delegate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.causeway.commons.internal.reflection._ClassCache;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.springframework.util.ClassUtils;

public final class _Delegate {
    public static <T> T createProxy(Class<T> bluePrint, Object delegate) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(bluePrint, (ClassLoader)bluePrint.getClassLoader());
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ifcs, (InvocationHandler)new DelegatingInvocationHandler(delegate));
    }

    private _Delegate() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class DelegatingInvocationHandler
    implements InvocationHandler {
        final Object delegate;
        final _ClassCache classCache = _ClassCache.getInstance();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return "Proxy(" + this.delegate.toString() + ")";
            }
            try {
                _GenericResolver.ResolvedMethod delegateMethod = this.classCache.lookupResolvedMethodElseFail(this.delegate.getClass(), method.getName(), method.getParameterTypes());
                return delegateMethod.method().invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        public DelegatingInvocationHandler(Object delegate) {
            this.delegate = delegate;
        }
    }
}

