/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.binding;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.binding.Bindable;
import org.apache.causeway.commons.binding.ChangeListener;
import org.apache.causeway.commons.binding.InvalidationListener;
import org.apache.causeway.commons.binding.Observable;
import org.apache.causeway.commons.internal.binding.InternalBidirectionalBinding;
import org.apache.causeway.commons.internal.binding.InternalUtil;
import org.apache.causeway.commons.internal.binding._Bindables;
import org.apache.causeway.commons.internal.binding._Observables;
import org.apache.causeway.commons.internal.exceptions._Exceptions;

public abstract class _BindableAbstract<T>
implements Bindable<T> {
    private T value;
    private Observable<? extends T> observable = null;
    private InvalidationListener invalidationListener = null;
    private boolean valid = true;
    private InternalUtil<T> util = null;
    @NonNull
    private UnaryOperator<T> valueRefiner = UnaryOperator.identity();
    @NonNull
    private UnaryOperator<T> valueGuard = UnaryOperator.identity();

    public _BindableAbstract() {
    }

    public _BindableAbstract(T initialValue) {
        this.value = initialValue;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.util = InternalUtil.addListener(this.util, this, listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.util = InternalUtil.removeListener(this.util, listener);
    }

    @Override
    public void addListener(ChangeListener<? super T> listener) {
        this.util = InternalUtil.addListener(this.util, this, listener);
    }

    @Override
    public void removeListener(ChangeListener<? super T> listener) {
        this.util = InternalUtil.removeListener(this.util, listener);
    }

    @Override
    public void bindBidirectional(Bindable<T> other) {
        InternalBidirectionalBinding.bind(this, other);
    }

    @Override
    public void unbindBidirectional(Bindable<T> other) {
        InternalBidirectionalBinding.unbind(this, other);
    }

    @Override
    public T getValue() {
        this.valid = true;
        T val = this.observable == null ? this.value : this.observable.getValue();
        return (T)this.valueRefiner.apply(val);
    }

    @Override
    public void setValue(T proposedNewValue) {
        if (this.isBound()) {
            throw _Exceptions.unrecoverable("Cannot set value on a bound bindable.");
        }
        Object newValue = this.valueGuard.apply(proposedNewValue);
        if (this.value != newValue) {
            this.value = newValue;
            this.markInvalid();
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(@NonNull Observable<? extends T> newObservable) {
        if (newObservable == null) {
            throw new NullPointerException("newObservable is marked non-null but is null");
        }
        if (!newObservable.equals(this.observable)) {
            this.unbind();
            this.observable = newObservable;
            if (this.invalidationListener == null) {
                this.invalidationListener = new WeakInvalidationListener(this);
            }
            this.observable.addListener(this.invalidationListener);
            this.markInvalid();
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.getValue();
            this.observable.removeListener(this.invalidationListener);
            this.observable = null;
        }
    }

    protected void fireValueChanged() {
        InternalUtil.fireValueChanged(this.util);
    }

    protected void onInvalidated() {
    }

    @Override
    public <R> Observable<R> map(Function<T, R> forwardMapper) {
        _Observables.LazyObservable newBindable = _Observables.lazy(() -> forwardMapper.apply(this.getValue()));
        this.addListener((Observable<? super T> e, ? super T o, ? super T n) -> newBindable.setValue(forwardMapper.apply(n)));
        return newBindable;
    }

    @Override
    public <R> Bindable<R> mapToBindable(Function<T, R> forwardMapper, Function<R, T> reverseMapper) {
        AtomicBoolean isForwardUpdating = new AtomicBoolean();
        AtomicBoolean isReverseUpdating = new AtomicBoolean();
        _BindableAbstract newBindable = _Bindables.forValue(forwardMapper.apply(this.getValue()));
        this.addListener((Observable<? super T> e, ? super T o, ? super T n) -> {
            if (isReverseUpdating.get()) {
                return;
            }
            try {
                isForwardUpdating.set(true);
                newBindable.setValue(forwardMapper.apply(n));
            }
            finally {
                isForwardUpdating.set(false);
            }
        });
        newBindable.addListener((Observable<? super T> e, ? super T o, ? super T n) -> {
            if (isForwardUpdating.get()) {
                return;
            }
            try {
                isReverseUpdating.set(true);
                this.setValue(reverseMapper.apply(n));
            }
            finally {
                isReverseUpdating.set(false);
            }
        });
        return newBindable;
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.onInvalidated();
            this.fireValueChanged();
        }
    }

    public void setValueRefiner(@NonNull UnaryOperator<T> valueRefiner) {
        if (valueRefiner == null) {
            throw new NullPointerException("valueRefiner is marked non-null but is null");
        }
        this.valueRefiner = valueRefiner;
    }

    public void setValueGuard(@NonNull UnaryOperator<T> valueGuard) {
        if (valueGuard == null) {
            throw new NullPointerException("valueGuard is marked non-null but is null");
        }
        this.valueGuard = valueGuard;
    }

    private static class WeakInvalidationListener
    implements InvalidationListener,
    InternalUtil.WeakListener {
        private final WeakReference<_BindableAbstract<?>> wref;

        public WeakInvalidationListener(_BindableAbstract<?> ref) {
            this.wref = new WeakReference(ref);
        }

        @Override
        public void invalidated(Observable<?> observable) {
            _BindableAbstract ref = (_BindableAbstract)this.wref.get();
            if (ref == null) {
                observable.removeListener(this);
            } else {
                ref.markInvalid();
            }
        }

        @Override
        public boolean isNoLongerReferenced() {
            return this.wref.get() == null;
        }
    }
}

