/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class _Probe {
    private static final Logger log = LogManager.getLogger(_Probe.class);
    private final long maxCalls;
    private final MaxCallsReachedAction maxAction;
    private PrintStream out = System.out;
    private String label = "Probe";
    private String indentLiteral = "  ";
    private String emphasisFormat = "__PROBE__ %s";
    private boolean silenced = false;
    private final LongAdder counter = new LongAdder();
    private final LongAdder nanoCounter = new LongAdder();
    private int currentIndent = 0;
    private static final Map<String, String> abbreviations = Map.of("org.apache.causeway", "~", "core", "c", "applib", "alib", "metamodel", "mm", "runtime", "rt", "viewer", "vw");

    private _Probe(long maxCalls, MaxCallsReachedAction maxAction) {
        this.maxCalls = maxCalls;
        this.maxAction = maxAction;
    }

    public static _Probe maxCallsThenIgnore(long max) {
        return _Probe.of(max, MaxCallsReachedAction.IGNORE);
    }

    public static _Probe maxCallsThenExit(long max) {
        return _Probe.of(max, MaxCallsReachedAction.SYSTEM_EXIT);
    }

    public static _Probe maxCallsThenExitWithStacktrace(long max) {
        return _Probe.of(max, MaxCallsReachedAction.SYSTEM_EXIT_WITH_STACKTRACE);
    }

    public static _Probe unlimited() {
        return _Probe.of(0x7FFFFFFFFFFFFFFEL, MaxCallsReachedAction.IGNORE);
    }

    private static _Probe of(long maxCalls, MaxCallsReachedAction maxAction) {
        return new _Probe(maxCalls, maxAction);
    }

    public _Probe out(PrintStream out) {
        this.out = out;
        return this;
    }

    public _Probe label(String label) {
        this.label = label;
        return this;
    }

    public _Probe indentLiteral(String indentLiteral) {
        this.indentLiteral = indentLiteral;
        return this;
    }

    public _Probe emphasisFormat(String emphasisFormat) {
        this.emphasisFormat = emphasisFormat;
        return this;
    }

    public _Probe silence() {
        this.silenced = true;
        return this;
    }

    public void println(int indent, CharSequence chars) {
        if (this.counter.longValue() < this.maxCalls) {
            this.counter.increment();
            if (!this.silenced) {
                this.print_line(indent, chars);
            }
            return;
        }
        switch (this.maxAction) {
            case IGNORE: {
                return;
            }
            case SYSTEM_EXIT: {
                this.counter.increment();
                this.print_line(indent, chars);
                System.exit(0);
                return;
            }
            case SYSTEM_EXIT_WITH_STACKTRACE: {
                this.counter.increment();
                this.print_line(indent, chars);
                _Exceptions.dumpStackTrace(this.out, 0, 1000);
                System.exit(0);
                return;
            }
        }
    }

    public void println(CharSequence chars) {
        this.println(this.currentIndent, chars);
    }

    public void println(int indent, String format, Object ... args) {
        this.println(indent, String.format(format, args));
    }

    public void println(String format, Object ... args) {
        this.println(this.currentIndent, format, args);
    }

    public void warnNotImplementedYet(String format, Object ... args) {
        String warnMsg = String.format(format, args);
        PrintStream restore_out = this.out;
        this.out = System.err;
        this.println("WARN NotImplementedYet %s", warnMsg);
        _Probe.errOut("-------------------------------------", new Object[0]);
        _Exceptions.dumpStackTrace(System.err, 1, 12);
        _Probe.errOut("-------------------------------------", new Object[0]);
        this.out = restore_out;
    }

    public void run(Runnable runnable) {
        long t0 = System.nanoTime();
        runnable.run();
        long nanos = System.nanoTime() - t0;
        this.nanoCounter.add(nanos);
        this.println("total runtime %d ms", this.nanoCounter.longValue() / 1000000L);
    }

    public static void entryPoint(EntryPoint entryPoint, String description) {
        if (log.isDebugEnabled()) {
            log.debug("entering {}: {}", (Object)entryPoint.name(), (Object)description);
        }
    }

    public static String currentThreadId() {
        Thread ct = Thread.currentThread();
        return String.format("Thread[%s (%d)])", ct.getName(), ct.getId());
    }

    public static void sysOut(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static void errOut(String format, Object ... args) {
        System.err.println(String.format(format, args));
    }

    public static String compact(Class<?> cls) {
        String[] name = new String[]{cls.getName()};
        abbreviations.forEach((k, v) -> {
            if (name[0].startsWith((String)k)) {
                name[0] = v + name[0].substring(k.length());
            }
        });
        return _Strings.splitThenStream(name[0], ".").map(part -> _Strings.nonEmpty(abbreviations.get(part)).orElse((String)part)).collect(Collectors.joining("."));
    }

    private void print_line(int indent, CharSequence chars) {
        long counterValue = this.counter.longValue();
        for (int i = 0; i < indent; ++i) {
            this.out.print(this.indentLiteral);
        }
        String message = "[" + this.label + " " + counterValue + "] " + chars;
        this.out.println(String.format(this.emphasisFormat, message));
    }

    public static enum MaxCallsReachedAction {
        IGNORE,
        SYSTEM_EXIT,
        SYSTEM_EXIT_WITH_STACKTRACE;

    }

    public static enum EntryPoint {
        USER_INTERACTION;

    }
}

