/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.ioc;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _SingletonBeanProvider {
    @NonNull
    private final String id;
    @NonNull
    private final Class<?> beanClass;
    @NonNull
    private final Supplier<?> beanProvider;

    public static <T> _SingletonBeanProvider forTestingLazy(String logicalTypeName, Class<T> beanClass, Supplier<T> beanProvider) {
        return _SingletonBeanProvider.of(logicalTypeName, beanClass, beanProvider);
    }

    public static <T> _SingletonBeanProvider forTestingLazy(Class<T> beanClass, Supplier<T> beanProvider) {
        return _SingletonBeanProvider.of(beanClass.getName(), beanClass, beanProvider);
    }

    public static <T> _SingletonBeanProvider forTesting(T bean) {
        return _SingletonBeanProvider.of(bean.getClass().getName(), bean.getClass(), () -> bean);
    }

    public Optional<?> lookupInstance() {
        return Optional.ofNullable(this.beanProvider.get());
    }

    public Object getInstanceElseFail() {
        return this.lookupInstance().orElseThrow(() -> _Exceptions.noSuchElement("Cannot create bean instance for name '%s' (with required type %s)", this.id, this.beanClass.getName()));
    }

    public boolean isCandidateFor(@Nullable Class<?> requiredType) {
        if (requiredType == null) {
            return false;
        }
        return requiredType.isAssignableFrom(this.beanClass);
    }

    public static Predicate<_SingletonBeanProvider> satisfying(Class<?> requiredType) {
        return singletonProvider -> singletonProvider.isCandidateFor(requiredType);
    }

    private _SingletonBeanProvider(@NonNull String id, @NonNull Class<?> beanClass, @NonNull Supplier<?> beanProvider) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (beanClass == null) {
            throw new NullPointerException("beanClass is marked non-null but is null");
        }
        if (beanProvider == null) {
            throw new NullPointerException("beanProvider is marked non-null but is null");
        }
        this.id = id;
        this.beanClass = beanClass;
        this.beanProvider = beanProvider;
    }

    public static _SingletonBeanProvider of(@NonNull String id, @NonNull Class<?> beanClass, @NonNull Supplier<?> beanProvider) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (beanClass == null) {
            throw new NullPointerException("beanClass is marked non-null but is null");
        }
        if (beanProvider == null) {
            throw new NullPointerException("beanProvider is marked non-null but is null");
        }
        return new _SingletonBeanProvider(id, beanClass, beanProvider);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @NonNull
    public Supplier<?> getBeanProvider() {
        return this.beanProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _SingletonBeanProvider)) {
            return false;
        }
        _SingletonBeanProvider other = (_SingletonBeanProvider)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<?> this$beanClass = this.getBeanClass();
        Class<?> other$beanClass = other.getBeanClass();
        return !(this$beanClass == null ? other$beanClass != null : !this$beanClass.equals(other$beanClass));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<?> $beanClass = this.getBeanClass();
        result = result * 59 + ($beanClass == null ? 43 : $beanClass.hashCode());
        return result;
    }

    public String toString() {
        return "_SingletonBeanProvider(id=" + this.getId() + ", beanClass=" + this.getBeanClass() + ")";
    }
}

