/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.PrintStream;
import java.util.ArrayList;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;

public interface DtoMapper<T> {
    public T read(@NonNull DataSource var1);

    public void write(@Nullable T var1, @NonNull DataSink var2);

    @Nullable
    default public T read(@Nullable String source) {
        if (source == null) {
            return null;
        }
        return this.read(DataSource.ofStringUtf8(source));
    }

    @Nullable
    default public String toString(@Nullable T dto) {
        if (dto == null) {
            return null;
        }
        ArrayList stringHolder = new ArrayList(1);
        this.write(dto, DataSink.ofStringUtf8Consumer(stringHolder::add));
        return (String)stringHolder.get(0);
    }

    default public Try<T> tryClone(@Nullable T dto) {
        return Try.call(() -> this.clone(dto));
    }

    default public T clone(@Nullable T dto) {
        if (dto == null) {
            return dto;
        }
        ArrayList bytesHolder = new ArrayList(1);
        this.write(dto, DataSink.ofByteArrayConsumer((ThrowingConsumer<byte[]>)((ThrowingConsumer)bytesHolder::add)));
        return this.read(DataSource.ofBytes((byte[])bytesHolder.get(0)));
    }

    default public void dump(@Nullable T dto, PrintStream out) {
        out.println(this.toString(dto));
    }
}

