/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.semantics;

import java.beans.Introspector;
import java.lang.reflect.RecordComponent;
import java.util.function.Predicate;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public enum AccessorSemantics {
    GET("get"),
    IS("is"),
    SET("set");

    private final String prefix;

    public String prefix(@Nullable String input) {
        return input != null ? this.prefix + input : this.prefix;
    }

    public boolean isPrefixOf(@Nullable String input) {
        return input != null ? input.startsWith(this.prefix) : false;
    }

    public static boolean isCandidateGetterName(@Nullable String name) {
        return GET.isPrefixOf(name) || IS.isPrefixOf(name);
    }

    public static boolean isBooleanGetter(_GenericResolver.ResolvedMethod method) {
        return IS.isPrefixOf(method.name()) && method.isNoArg() && !method.isStatic() && (method.returnType() == Boolean.TYPE || method.returnType() == Boolean.class);
    }

    public static boolean isNonBooleanGetter(_GenericResolver.ResolvedMethod method, Predicate<Class<?>> typeFilter) {
        return GET.isPrefixOf(method.name()) && method.isNoArg() && !method.isStatic() && typeFilter.test(method.returnType());
    }

    public static boolean isNonBooleanGetter(_GenericResolver.ResolvedMethod method, Class<?> expectedType) {
        return AccessorSemantics.isNonBooleanGetter(method, (Class<?> type) -> expectedType.isAssignableFrom(ClassUtils.resolvePrimitiveIfNecessary((Class)type)));
    }

    public static boolean isGetter(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isBooleanGetter(method) || AccessorSemantics.isNonBooleanGetter(method, (Class<?> type) -> type != Void.TYPE);
    }

    public static boolean isRecordComponentAccessor(_GenericResolver.ResolvedMethod method) {
        Class<?> recordClass = method.implementationClass();
        if (!recordClass.isRecord()) {
            return false;
        }
        for (RecordComponent recordComponent : recordClass.getRecordComponents()) {
            if (!method.name().equals(recordComponent.getName())) continue;
            return true;
        }
        return false;
    }

    public static String associationIdentifierFor(_GenericResolver.ResolvedMethod method) {
        String id = AccessorSemantics.isRecordComponentAccessor(method) ? method.name() : Introspector.decapitalize(_Strings.baseName(method.name()));
        return id;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private AccessorSemantics(String prefix) {
        this.prefix = prefix;
    }
}

