/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.apache.causeway.commons.semantics.AccessorSemantics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.ThrowingConsumer;

public final class _ClassCache
implements AutoCloseable {
    @Nullable
    private final ClassLoader classLoader;
    private final Map<Class<?>, ClassModel> inspectedTypes = new HashMap();

    public static _ClassCache getInstance() {
        return _Context.computeIfAbsent(_ClassCache.class, () -> new _ClassCache(_Context.getDefaultClassLoader()));
    }

    public static void invalidate() {
        _Context.put(_ClassCache.class, new _ClassCache(_Context.getDefaultClassLoader()), true);
    }

    public void add(Class<?> type) {
        this.classModel(type);
    }

    public boolean hasJaxbRootElementSemantics(Class<?> type) {
        return this.classModel(type).hasJaxbRootElementSemantics;
    }

    public <T> Stream<_GenericResolver.ResolvedConstructor> streamPublicConstructors(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.classModel(type).publicConstructorsByKey.values().stream());
    }

    public <T> Stream<_GenericResolver.ResolvedConstructor> streamPublicConstructorsWithInjectSemantics(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.classModel(type).constructorsWithInjectSemanticsByKey.values().stream());
    }

    public Optional<_GenericResolver.ResolvedConstructor> lookupPublicConstructor(Class<?> type, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.lookupConstructor(false, type, paramTypes));
    }

    public Stream<Method> streamPostConstructMethods(Class<?> type) {
        return this.classModel(type).postConstructMethodsByKey.values().stream().map(_GenericResolver.ResolvedMethod::method);
    }

    public Optional<_GenericResolver.ResolvedMethod> lookupPublicMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.findMethod(false, type, name, paramTypes));
    }

    public _GenericResolver.ResolvedMethod lookupPublicMethodElseFail(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupPublicMethod(type, name, paramTypes).orElseThrow(() -> _Exceptions.noSuchMethodException(type, name, paramTypes));
    }

    public Optional<_GenericResolver.ResolvedMethod> lookupResolvedMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.findMethod(true, type, name, paramTypes));
    }

    public _GenericResolver.ResolvedMethod lookupResolvedMethodElseFail(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupResolvedMethod(type, name, paramTypes).orElseThrow(() -> _Exceptions.noSuchMethodException(type, name, paramTypes));
    }

    public Stream<_GenericResolver.ResolvedMethod> streamPublicMethods(Class<?> type) {
        return this.classModel(type).publicMethodsByKey.values().stream();
    }

    public Stream<_GenericResolver.ResolvedMethod> streamResolvedMethods(Class<?> type) {
        return this.classModel(type).resolvedMethodsByKey.values().stream();
    }

    public _GenericResolver.ResolvedMethod findMethodUniquelyByNameOrFail(Class<?> type, String methodName) {
        Can matchingMethods = this.streamResolvedMethods(type).filter(method -> method.name().equals(methodName)).collect(Can.toCan());
        return matchingMethods.isCardinalityMultiple() ? (_GenericResolver.ResolvedMethod)matchingMethods.reduce(_GenericResolver.ResolvedMethod::mostSpecific).getSingleton().orElseThrow(() -> _Exceptions.illegalState("unable to determine most specific of methods %s", matchingMethods)) : (_GenericResolver.ResolvedMethod)matchingMethods.getSingleton().orElseThrow(() -> _Exceptions.noSuchMethodException(type, methodName, new Class[0]));
    }

    public Stream<Field> streamDeclaredFields(Class<?> type) {
        return this.classModel(type).declaredFields.stream();
    }

    public Optional<_GenericResolver.ResolvedMethod> getterForField(Class<?> type, Field field) {
        String capitalizedFieldName = _Strings.capitalize(field.getName());
        return Stream.of("get", "is").map(prefix -> prefix + capitalizedFieldName).map(methodName -> this.lookupResolvedMethod(type, (String)methodName, _Constants.emptyClasses).orElse(null)).filter(_NullSafe::isPresent).filter(resolvedMethod -> AccessorSemantics.isGetter(resolvedMethod)).findFirst();
    }

    public Optional<Field> fieldForGetter(Class<?> type, Method getterCandidate) {
        return Optional.ofNullable(_ClassCache.findFieldForGetter(getterCandidate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<_GenericResolver.ResolvedMethod> streamDeclaredMethodsHaving(Class<?> type, String attributeName, Predicate<_GenericResolver.ResolvedMethod> filter) {
        ClassModel classModel = this.classModel(type);
        Map<String, Can<_GenericResolver.ResolvedMethod>> map = classModel.declaredMethodsByAttribute;
        synchronized (map) {
            return classModel.declaredMethodsByAttribute.computeIfAbsent(attributeName, key -> classModel.resolvedMethodsByKey.values().stream().filter(filter).collect(Can.toCan())).stream();
        }
    }

    public _ClassCache setAttribute(Class<?> type, String attributeName, String value) {
        ClassModel classModel = this.classModel(type);
        classModel.attributeMap.put(attributeName, value);
        return this;
    }

    public Optional<String> lookupAttribute(Class<?> type, String attributeName) {
        ClassModel classModel = this.classModel(type);
        return Optional.ofNullable(classModel.attributeMap.get(attributeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            this.inspectedTypes.clear();
        }
    }

    public static boolean methodExcludeFilter(Method method) {
        return method.isBridge() || Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().equals(Object.class) || _Reflect.isNonFinalObjectMethod(method) && !_Reflect.isOverwrittenToString(method);
    }

    public static boolean methodIncludeFilter(Method method) {
        return !_ClassCache.methodExcludeFilter(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassModel classModel(Class<?> type) {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            return this.inspectedTypes.computeIfAbsent(type, this::inspectType);
        }
    }

    private Class<?> reloadType(Class<?> _type) {
        return Optional.ofNullable(this.classLoader).filter(cl -> !_type.isPrimitive()).filter(cl -> !_Reflect.isJavaApiClass(_type)).filter(cl -> !cl.equals(_type.getClassLoader())).map(cl -> Try.call(() -> Class.forName(_type.getName(), true, cl)).ifFailure((ThrowingConsumer<Throwable>)((ThrowingConsumer)e -> System.err.printf("ClassCache: reloading of type %s failed with %s%n", _type.getName(), e))).getValue().orElse(null)).orElse(_type);
    }

    private ClassModel inspectType(Class<?> _type) {
        Constructor<?>[] publicConstr;
        Class<?> type = this.reloadType(_type);
        ClassModel model = new ClassModel(Can.ofArray(type.getDeclaredFields()), _Annotations.isPresent(type, XmlRootElement.class));
        for (Constructor<?> constr : publicConstr = type.getConstructors()) {
            ConstructorKey key = ConstructorKey.of(type, constr);
            _GenericResolver.ResolvedConstructor resolvedConstr = _GenericResolver.resolveConstructor(constr, type);
            model.publicConstructorsByKey.put(key, resolvedConstr);
            if (!this.isInjectSemantics(constr)) continue;
            model.constructorsWithInjectSemanticsByKey.put(key, resolvedConstr);
        }
        _Reflect.streamAllMethods(type, true).filter(_ClassCache::methodIncludeFilter).map(method -> _GenericResolver.resolveMethod(method, type).orElse(null)).filter(_NullSafe::isPresent).forEach(resolved -> {
            MethodKey key = MethodKey.of(type, resolved.method());
            _GenericResolver.ResolvedMethod methodToKeep = _ClassCache.putIntoMapHonoringOverridingRelation(model.resolvedMethodsByKey, key, resolved);
            if (this.isPostConstruct(methodToKeep.method())) {
                model.postConstructMethodsByKey.put(key, methodToKeep);
            }
        });
        _NullSafe.stream(type.getMethods()).filter(_ClassCache::methodIncludeFilter).map(method -> _GenericResolver.resolveMethod(method, type).orElse(null)).filter(_NullSafe::isPresent).forEach(resolved -> {
            MethodKey key = MethodKey.of(type, resolved.method());
            _ClassCache.putIntoMapHonoringOverridingRelation(model.publicMethodsByKey, key, resolved);
        });
        return model;
    }

    private static _GenericResolver.ResolvedMethod putIntoMapHonoringOverridingRelation(Map<MethodKey, _GenericResolver.ResolvedMethod> map, MethodKey key, _GenericResolver.ResolvedMethod method) {
        _GenericResolver.ResolvedMethod methodWithSameKey = map.get(key);
        _GenericResolver.ResolvedMethod methodToKeep = methodWithSameKey == null ? method : methodWithSameKey.mostSpecific(method);
        map.put(key, methodToKeep);
        Can weaklySame = map.values().stream().filter(m -> _GenericResolver.ResolvedMethod.methodsWeaklySame(methodToKeep, m)).collect(Can.toCan());
        if (weaklySame.isCardinalityMultiple()) {
            map.values().removeIf(weaklySame::contains);
            _GenericResolver.ResolvedMethod winner = (_GenericResolver.ResolvedMethod)weaklySame.reduce(_GenericResolver.ResolvedMethod::mostSpecific).getSingletonOrFail();
            MethodKey winnerKey = MethodKey.of(winner.implementationClass(), winner.method());
            map.put(winnerKey, winner);
            return winner;
        }
        return methodToKeep;
    }

    private boolean isInjectSemantics(Constructor<?> con) {
        return _Annotations.synthesize(con, Inject.class).isPresent() || _Annotations.synthesize(con, Autowired.class).map(annot -> annot.required()).orElse(false) != false;
    }

    private boolean isPostConstruct(Method method) {
        return Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0 ? _Annotations.synthesize(method, PostConstruct.class).isPresent() : false;
    }

    private _GenericResolver.ResolvedConstructor lookupConstructor(boolean includeDeclaredConstructors, Class<?> type, Class<?>[] paramTypes) {
        ClassModel model = this.classModel(type);
        ConstructorKey key = ConstructorKey.of(type, _Arrays.emptyToNull(paramTypes));
        _GenericResolver.ResolvedConstructor publicConstructor = model.publicConstructorsByKey.get(key);
        return publicConstructor;
    }

    @Nullable
    private _GenericResolver.ResolvedMethod findMethod(boolean includeDeclaredMethods, Class<?> type, String name, Class<?>[] requiredParamTypes) {
        ClassModel model = this.classModel(type);
        _GenericResolver.ResolvedMethod publicMethod = model.publicMethodsByKey.values().stream().filter(m -> m.name().equals(name)).filter(m -> _Reflect.methodSignatureAssignableTo(m.paramTypes(), requiredParamTypes)).findFirst().orElse(null);
        if (publicMethod != null) {
            return publicMethod;
        }
        if (includeDeclaredMethods) {
            _GenericResolver.ResolvedMethod resolvedMethod = model.resolvedMethodsByKey.values().stream().filter(m -> m.name().equals(name)).filter(m -> _Reflect.methodSignatureAssignableTo(m.paramTypes(), requiredParamTypes)).findFirst().orElse(null);
            return resolvedMethod;
        }
        return null;
    }

    private static Field findFieldForGetter(Method getterCandidate) {
        if (ReflectionUtils.isObjectMethod((Method)getterCandidate)) {
            return null;
        }
        String fieldNameCandidate = _ClassCache.fieldNameForGetter(getterCandidate);
        if (fieldNameCandidate == null) {
            return null;
        }
        Class<?> declaringClass = getterCandidate.getDeclaringClass();
        return ReflectionUtils.findField(declaringClass, (String)fieldNameCandidate);
    }

    private static String fieldNameForGetter(Method getter) {
        if (getter.getParameterCount() > 0) {
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            return null;
        }
        String methodName = getter.getName();
        String fieldName = null;
        if (methodName.startsWith("is") && methodName.length() > 2) {
            fieldName = methodName.substring(2);
        } else if (methodName.startsWith("get") && methodName.length() > 3) {
            fieldName = methodName.substring(3);
        } else {
            return null;
        }
        return _Strings.decapitalize(fieldName);
    }

    @Generated
    private _ClassCache(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static class ClassModel {
        private final Can<Field> declaredFields;
        private final Map<ConstructorKey, _GenericResolver.ResolvedConstructor> publicConstructorsByKey = new HashMap<ConstructorKey, _GenericResolver.ResolvedConstructor>();
        private final Map<ConstructorKey, _GenericResolver.ResolvedConstructor> constructorsWithInjectSemanticsByKey = new HashMap<ConstructorKey, _GenericResolver.ResolvedConstructor>();
        private final Map<MethodKey, _GenericResolver.ResolvedMethod> resolvedMethodsByKey = new HashMap<MethodKey, _GenericResolver.ResolvedMethod>();
        private final Map<MethodKey, _GenericResolver.ResolvedMethod> publicMethodsByKey = new HashMap<MethodKey, _GenericResolver.ResolvedMethod>();
        private final Map<MethodKey, _GenericResolver.ResolvedMethod> postConstructMethodsByKey = new HashMap<MethodKey, _GenericResolver.ResolvedMethod>();
        private final Map<String, Can<_GenericResolver.ResolvedMethod>> declaredMethodsByAttribute = new HashMap<String, Can<_GenericResolver.ResolvedMethod>>();
        private final Map<String, String> attributeMap = new ConcurrentHashMap<String, String>();
        private final boolean hasJaxbRootElementSemantics;

        @Generated
        public ClassModel(Can<Field> declaredFields, boolean hasJaxbRootElementSemantics) {
            this.declaredFields = declaredFields;
            this.hasJaxbRootElementSemantics = hasJaxbRootElementSemantics;
        }
    }

    private static final class ConstructorKey {
        private final Class<?> type;
        @Nullable
        private final Class<?>[] paramTypes;

        public static ConstructorKey of(Class<?> type, Constructor<?> constructor) {
            return ConstructorKey.of(type, _Arrays.emptyToNull(constructor.getParameterTypes()));
        }

        @Generated
        private ConstructorKey(Class<?> type, @Nullable Class<?>[] paramTypes) {
            this.type = type;
            this.paramTypes = paramTypes;
        }

        @Generated
        public static ConstructorKey of(Class<?> type, @Nullable Class<?>[] paramTypes) {
            return new ConstructorKey(type, paramTypes);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorKey)) {
                return false;
            }
            ConstructorKey other = (ConstructorKey)o;
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return Arrays.deepEquals(this.paramTypes, other.paramTypes);
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.paramTypes);
            return result;
        }
    }

    private static final class MethodKey {
        private final Class<?> implementingClass;
        private final String name;
        @Nullable
        private final Class<?>[] paramTypes;

        public static MethodKey of(Class<?> type, Method method) {
            return MethodKey.of(type, method.getName(), _Arrays.emptyToNull(method.getParameterTypes()));
        }

        @Generated
        private MethodKey(Class<?> implementingClass, String name, @Nullable Class<?>[] paramTypes) {
            this.implementingClass = implementingClass;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        @Generated
        public static MethodKey of(Class<?> implementingClass, String name, @Nullable Class<?>[] paramTypes) {
            return new MethodKey(implementingClass, name, paramTypes);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)o;
            Class<?> this$implementingClass = this.implementingClass;
            Class<?> other$implementingClass = other.implementingClass;
            if (this$implementingClass == null ? other$implementingClass != null : !this$implementingClass.equals(other$implementingClass)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return Arrays.deepEquals(this.paramTypes, other.paramTypes);
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $implementingClass = this.implementingClass;
            result = result * 59 + ($implementingClass == null ? 43 : $implementingClass.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.paramTypes);
            return result;
        }
    }
}

