/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.springframework.lang.Nullable;

public final class _Generics {
    public static Stream<Class<?>> streamGenericTypeArgumentsOf(@NonNull Class<?> owner, @NonNull Type genericType) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (genericType == null) {
            throw new NullPointerException("genericType is marked non-null but is null");
        }
        return genericType instanceof ParameterizedType ? Stream.of(((ParameterizedType)genericType).getActualTypeArguments()).flatMap(type -> _Generics.streamClassesOfType(owner, type)) : Stream.empty();
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOf(@NonNull Class<?> owner, @Nullable Type[] genericTypes) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        return _NullSafe.stream(genericTypes).flatMap(type -> _Generics.streamGenericTypeArgumentsOf(owner, type));
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfType(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return _Generics.streamGenericTypeArgumentsOfType(cls, cls);
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfType(@NonNull Class<?> cls, @NonNull Class<?> stopAtSuperClass) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (stopAtSuperClass == null) {
            throw new NullPointerException("stopAtSuperClass is marked non-null but is null");
        }
        Type superClass = _Generics.genericUpCast(cls, stopAtSuperClass);
        if (superClass instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)superClass;
            Type[] typeArgs = pt.getActualTypeArguments();
            int typeArgCount = _NullSafe.size(typeArgs);
            Can<Class> extractedGenericTypes = Can.ofArray(typeArgs).map(typeArg -> _Generics.typeToClass(typeArg));
            return extractedGenericTypes.size() == typeArgCount ? extractedGenericTypes.stream() : Stream.empty();
        }
        return Stream.empty();
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfField(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return _Generics.streamGenericTypeArgumentsOf(field.getDeclaringClass(), field.getGenericType());
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfMethodParameterTypes(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return _Generics.streamGenericTypeArgumentsOf(method.getDeclaringClass(), method.getGenericParameterTypes());
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfMethodReturnType(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return _Generics.streamGenericTypeArgumentsOf(method.getDeclaringClass(), method.getGenericReturnType());
    }

    public static Stream<Class<?>> streamGenericTypeArgumentsOfParameter(@NonNull Parameter param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return _Generics.streamGenericTypeArgumentsOf(param.getDeclaringExecutable().getDeclaringClass(), param.getParameterizedType());
    }

    private static Stream<Class<?>> streamClassesOfType(Class<?> owner, Type type) {
        Type genericSuperclass;
        if (type instanceof Class) {
            return Stream.of((Class)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return Stream.concat(Stream.of(wildcardType.getLowerBounds()), Stream.of(wildcardType.getUpperBounds())).flatMap(x -> _Generics.streamClassesOfType(owner, x));
        }
        if (type instanceof TypeVariable && (genericSuperclass = owner.getGenericSuperclass()) instanceof ParameterizedType) {
            ParameterizedType parameterizedTypeOfSuperclass = (ParameterizedType)genericSuperclass;
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (parameterizedTypeOfSuperclass.getRawType() == genericDeclaration) {
                return Stream.of(parameterizedTypeOfSuperclass.getActualTypeArguments()).flatMap(actualType -> _Generics.streamClassesOfType(owner, actualType));
            }
        }
        return Stream.empty();
    }

    @Nullable
    private static Class<?> typeToClass(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return _Generics.typeToClass(pType.getRawType());
        }
        return null;
    }

    private static Type genericUpCast(@NonNull Class<?> cls, @NonNull Class<?> stopAtSuperClass) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (stopAtSuperClass == null) {
            throw new NullPointerException("stopAtSuperClass is marked non-null but is null");
        }
        Type superClass = cls.getGenericSuperclass();
        if (cls.equals(stopAtSuperClass)) {
            superClass = cls.getGenericSuperclass();
        }
        while (superClass instanceof ParameterizedType && stopAtSuperClass != ((ParameterizedType)superClass).getRawType()) {
            superClass = ((Class)((ParameterizedType)superClass).getRawType()).getGenericSuperclass();
        }
        return superClass;
    }
}

