/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBContextFactory;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.codec._DocumentFactories;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.functions._Functions;
import org.apache.causeway.commons.internal.reflection._ClassCache;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.apache.causeway.commons.io.DtoMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingFunction;

public final class JaxbUtils {
    private static final JAXBContextFactory JAXB_CONTEXT_FACTORY = new org.glassfish.jaxb.runtime.v2.JAXBContextFactory();
    private static final Map<String, Object> JAXB_CONTEXT_FACTORY_PROPS = Collections.emptyMap();
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = _Maps.newConcurrentHashMap();

    public static <T> DtoMapper<T> mapperFor(final @NonNull Class<T> mappedType, JaxbCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        final JaxbOptions opts = JaxbUtils.createOptions(customizers);
        final JAXBContext jaxbContext = opts.jaxbContext(mappedType);
        return new DtoMapper<T>(){

            @Override
            public T read(DataSource source) {
                return source.tryReadAll(is -> Try.call(() -> opts.unmarshal(jaxbContext, mappedType, (InputStream)is))).ifFailureFail().getValue().orElseThrow();
            }

            @Override
            public void write(T dto, DataSink sink) {
                if (dto == null) {
                    return;
                }
                sink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> Try.run(() -> opts.marshal(jaxbContext, dto, (OutputStream)os))));
            }
        };
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, JaxbCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return JaxbUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, JaxbCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> {
            JaxbOptions opts = JaxbUtils.createOptions(customizers);
            return Try.call(() -> opts.unmarshal(mappedType, (InputStream)is)).mapFailure((ThrowingFunction<Throwable, Throwable>)((ThrowingFunction)cause -> JaxbUtils.verboseException("unmarshalling XML", mappedType, cause)));
        });
    }

    public static <T> void write(@Nullable T pojo, @NonNull DataSink sink, JaxbCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        JaxbOptions opts = JaxbUtils.createOptions(customizers);
        try {
            sink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> opts.marshal(pojo, (OutputStream)os)));
        }
        catch (Exception cause) {
            throw JaxbUtils.verboseException("marshalling domain object to XML", pojo.getClass(), cause);
        }
    }

    @Nullable
    public static <T> String toStringUtf8(@Nullable T pojo, JaxbCustomizer ... customizers) {
        if (pojo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JaxbUtils.write(pojo, DataSink.ofStringUtf8Consumer(sb), customizers);
        String xml = sb.toString();
        if (JaxbUtils.isFormattedOutput(customizers)) {
            return JaxbUtils.prettyPrint(customizers, xml);
        }
        return xml;
    }

    private static String prettyPrint(JaxbCustomizer[] customizers, String xml) {
        String string;
        block8: {
            TransformerFactory transformerFactory = _DocumentFactories.transformerFactory();
            transformerFactory.setAttribute("indent-number", 4);
            JaxbUtils.apply(customizers, transformerFactory);
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamSource xsltSource = new StreamSource(JaxbUtils.class.getResourceAsStream("prettyprint.xslt"));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            Writer writer = xmlOutput.getWriter();
            try {
                string = writer.toString();
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TransformerException e) {
                    return xml;
                }
            }
            writer.close();
        }
        return string;
    }

    private static void apply(JaxbCustomizer[] customizers, TransformerFactory transformerFactory) {
        for (JaxbCustomizer customizer : customizers) {
            if (!(customizer instanceof TransformerFactoryCustomizer)) continue;
            TransformerFactoryCustomizer transformerFactoryCustomizer = (TransformerFactoryCustomizer)customizer;
            transformerFactoryCustomizer.apply(transformerFactory);
        }
    }

    private static boolean isFormattedOutput(JaxbCustomizer[] customizers) {
        JaxbOptions.JaxbOptionsBuilder builder = JaxbOptions.builder();
        for (JaxbCustomizer customizer : customizers) {
            customizer.apply(builder);
        }
        JaxbOptions jaxbOptions = builder.build();
        boolean formattedOutput = jaxbOptions.formattedOutput;
        return formattedOutput;
    }

    private static JaxbOptions createOptions(JaxbCustomizer ... customizers) {
        JaxbOptions.JaxbOptionsBuilder opts = JaxbOptions.builder();
        for (JaxbCustomizer customizer : customizers) {
            opts = Optional.ofNullable((JaxbOptions.JaxbOptionsBuilder)customizer.apply(opts)).orElse(opts);
        }
        return opts.build();
    }

    public static void generateSchema(@NonNull JAXBContext jaxbContext, DataSink dataSink) {
        if (jaxbContext == null) {
            throw new NullPointerException("jaxbContext is marked non-null but is null");
        }
        dataSink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> {
            SchemaOutputResolver schemaOutputResolver = new SchemaOutputResolver((OutputStream)os){
                final /* synthetic */ OutputStream val$os;
                {
                    this.val$os = outputStream;
                }

                public Result createOutput(String namespaceURI, String suggestedFileName) {
                    return new StreamResult(this.val$os);
                }
            };
            jaxbContext.generateSchema(schemaOutputResolver);
        }));
    }

    public static JAXBContext jaxbContextFor(@NonNull Class<?> primaryClass, Class<?> ... additionalClassesToBeBound) {
        if (primaryClass == null) {
            throw new NullPointerException("primaryClass is marked non-null but is null");
        }
        return JaxbUtils.contextOf(_Arrays.combine(primaryClass, additionalClassesToBeBound));
    }

    public static JAXBContext jaxbContextFor(Class<?> dtoClass, boolean useCache) {
        return useCache ? jaxbContextByClass.computeIfAbsent(dtoClass, xva$0 -> JaxbUtils.contextOf(xva$0)) : JaxbUtils.contextOf(dtoClass);
    }

    private static <T> JAXBContext contextOf(Class<?> ... classesToBeBound) {
        try {
            return JAXB_CONTEXT_FACTORY.createContext((Class[])JaxbUtils.open(classesToBeBound), JAXB_CONTEXT_FACTORY_PROPS);
        }
        catch (Exception e) {
            String msg = String.format("obtaining JAXBContext for classes (to be bound) {%s}", _NullSafe.stream(classesToBeBound).map(Class::getName).collect(Collectors.joining(", ")));
            throw JaxbUtils.verboseException(msg, classesToBeBound[0], e);
        }
    }

    private static Class<?>[] open(Class<?>[] classes) throws JAXBException {
        Module coreModule = JAXB_CONTEXT_FACTORY.getClass().getModule();
        Module rtModule = JAXBContextFactory.class.getModule();
        if (rtModule == coreModule || !rtModule.isNamed()) {
            return classes;
        }
        for (Class<?> cls : classes) {
            Class<?> jaxbClass = cls.isArray() ? cls.getComponentType() : cls;
            Module classModule = jaxbClass.getModule();
            if (!classModule.isNamed() || "java.base".equals(classModule.getName())) continue;
            String packageName = jaxbClass.getPackageName();
            if (classModule.isOpen(packageName, rtModule)) {
                classModule.addOpens(packageName, coreModule);
                continue;
            }
            throw new JAXBException(MessageFormat.format("Package {0} with class {1} defined in a module {2} must be open to at least {3} module.", packageName, jaxbClass.getName(), classModule.getName(), rtModule.getName()));
        }
        return classes;
    }

    private static RuntimeException verboseException(String doingWhat, @Nullable Class<?> dtoClass, Throwable cause) {
        String dtoClassName = Optional.ofNullable(dtoClass).map(Class::getName).orElse("unknown");
        if (JaxbUtils.isIllegalAnnotationsException(cause)) {
            try {
                List errors = (List)_Casts.uncheckedCast(cause.getClass().getMethod("getErrors", new Class[0]).invoke((Object)cause, new Object[0]));
                if (_NullSafe.size(errors) > 0) {
                    return _Exceptions.unrecoverable(cause, "Error %s, due to illegal annotations on object class '%s'; %d error(s) reported: %s", doingWhat, dtoClassName, errors.size(), errors.stream().map(Throwable::getMessage).collect(Collectors.joining("; ")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _Exceptions.unrecoverable(cause, "Error %s; object class is '%s'", doingWhat, dtoClassName);
    }

    private static boolean isIllegalAnnotationsException(Throwable cause) {
        return "com.sun.xml.bind.v2.runtime.IllegalAnnotationsException".equals(cause.getClass().getName());
    }

    @Generated
    private JaxbUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface JaxbCustomizer
    extends UnaryOperator<JaxbOptions.JaxbOptionsBuilder> {
    }

    public static class JaxbOptions {
        private final boolean useContextCache;
        private final boolean allowMissingRootElement;
        private final boolean formattedOutput;
        private final Map<String, Object> properties;
        @NonNull
        private final Consumer<Marshaller> marshallerConfigurer;
        @NonNull
        private final Consumer<Unmarshaller> unmarshallerConfigurer;
        @Nullable
        private final JAXBContext jaxbContextOverride;

        public static JaxbOptions defaults() {
            return JaxbOptions.builder().build();
        }

        private boolean shouldMissingXmlRootElementBeHandledOn(Class<?> mappedType) {
            return this.isAllowMissingRootElement() && !_ClassCache.getInstance().hasJaxbRootElementSemantics(mappedType);
        }

        private JAXBContext jaxbContext(Class<?> mappedType) {
            return this.jaxbContextOverride != null ? this.jaxbContextOverride : JaxbUtils.jaxbContextFor(mappedType, this.useContextCache);
        }

        private Marshaller marshaller(JAXBContext jaxbContext, Class<?> mappedType) {
            Marshaller marshaller = jaxbContext.createMarshaller();
            if (this.properties != null) {
                for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                    marshaller.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.isFormattedOutput()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            return marshaller;
        }

        private Unmarshaller unmarshaller(JAXBContext jaxbContext, Class<?> mappedType) {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (this.properties != null) {
                for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                    unmarshaller.setProperty(entry.getKey(), entry.getValue());
                }
            }
            return unmarshaller;
        }

        private <T> T unmarshal(Unmarshaller unmarshaller, Class<T> mappedType, InputStream is) {
            this.unmarshallerConfigurer.accept(unmarshaller);
            return (T)(this.shouldMissingXmlRootElementBeHandledOn(mappedType) ? this.unmarshalTypesafe(unmarshaller, mappedType, is) : _Casts.castTo(mappedType, unmarshaller.unmarshal(is)).orElseGet(() -> this.unmarshalTypesafe(unmarshaller, mappedType, is)));
        }

        private <T> T unmarshalTypesafe(Unmarshaller unmarshaller, Class<T> mappedType, InputStream is) {
            XMLStreamReader xsr = _DocumentFactories.xmlInputFactory().createXMLStreamReader(is);
            JAXBElement userElement = unmarshaller.unmarshal(xsr, mappedType);
            return (T)userElement.getValue();
        }

        private <T> void marshal(Marshaller marshaller, T pojo, OutputStream os) {
            this.marshallerConfigurer.accept(marshaller);
            Class<?> mappedType = pojo.getClass();
            if (this.shouldMissingXmlRootElementBeHandledOn(mappedType)) {
                QName qName = new QName("", mappedType.getSimpleName());
                JAXBElement jaxbElement = new JAXBElement(qName, mappedType, null, pojo);
                marshaller.marshal((Object)jaxbElement, os);
            } else {
                marshaller.marshal(pojo, os);
            }
        }

        private <T> T unmarshal(JAXBContext jaxbContext, Class<T> mappedType, InputStream is) {
            return this.unmarshal(this.unmarshaller(jaxbContext, mappedType), mappedType, is);
        }

        private <T> void marshal(JAXBContext jaxbContext, T pojo, OutputStream os) {
            Class<?> mappedType = pojo.getClass();
            this.marshal(this.marshaller(jaxbContext, mappedType), pojo, os);
        }

        private <T> T unmarshal(Class<T> mappedType, InputStream is) {
            return this.unmarshal(this.jaxbContext(mappedType), mappedType, is);
        }

        private <T> void marshal(T pojo, OutputStream os) {
            Class<?> mappedType = pojo.getClass();
            this.marshal(this.jaxbContext(mappedType), pojo, os);
        }

        @Generated
        private static boolean $default$useContextCache() {
            return true;
        }

        @Generated
        private static boolean $default$allowMissingRootElement() {
            return false;
        }

        @Generated
        private static boolean $default$formattedOutput() {
            return true;
        }

        @Generated
        private static Consumer<Marshaller> $default$marshallerConfigurer() {
            return _Functions.noopConsumer();
        }

        @Generated
        private static Consumer<Unmarshaller> $default$unmarshallerConfigurer() {
            return _Functions.noopConsumer();
        }

        @Generated
        JaxbOptions(boolean useContextCache, boolean allowMissingRootElement, boolean formattedOutput, Map<String, Object> properties, @NonNull Consumer<Marshaller> marshallerConfigurer, @NonNull Consumer<Unmarshaller> unmarshallerConfigurer, @Nullable JAXBContext jaxbContextOverride) {
            if (marshallerConfigurer == null) {
                throw new NullPointerException("marshallerConfigurer is marked non-null but is null");
            }
            if (unmarshallerConfigurer == null) {
                throw new NullPointerException("unmarshallerConfigurer is marked non-null but is null");
            }
            this.useContextCache = useContextCache;
            this.allowMissingRootElement = allowMissingRootElement;
            this.formattedOutput = formattedOutput;
            this.properties = properties;
            this.marshallerConfigurer = marshallerConfigurer;
            this.unmarshallerConfigurer = unmarshallerConfigurer;
            this.jaxbContextOverride = jaxbContextOverride;
        }

        @Generated
        public static JaxbOptionsBuilder builder() {
            return new JaxbOptionsBuilder();
        }

        @Generated
        public boolean isUseContextCache() {
            return this.useContextCache;
        }

        @Generated
        public boolean isAllowMissingRootElement() {
            return this.allowMissingRootElement;
        }

        @Generated
        public boolean isFormattedOutput() {
            return this.formattedOutput;
        }

        @Generated
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @NonNull
        @Generated
        public Consumer<Marshaller> getMarshallerConfigurer() {
            return this.marshallerConfigurer;
        }

        @NonNull
        @Generated
        public Consumer<Unmarshaller> getUnmarshallerConfigurer() {
            return this.unmarshallerConfigurer;
        }

        @Nullable
        @Generated
        public JAXBContext getJaxbContextOverride() {
            return this.jaxbContextOverride;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JaxbOptions)) {
                return false;
            }
            JaxbOptions other = (JaxbOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseContextCache() != other.isUseContextCache()) {
                return false;
            }
            if (this.isAllowMissingRootElement() != other.isAllowMissingRootElement()) {
                return false;
            }
            if (this.isFormattedOutput() != other.isFormattedOutput()) {
                return false;
            }
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            Consumer<Marshaller> this$marshallerConfigurer = this.getMarshallerConfigurer();
            Consumer<Marshaller> other$marshallerConfigurer = other.getMarshallerConfigurer();
            if (this$marshallerConfigurer == null ? other$marshallerConfigurer != null : !this$marshallerConfigurer.equals(other$marshallerConfigurer)) {
                return false;
            }
            Consumer<Unmarshaller> this$unmarshallerConfigurer = this.getUnmarshallerConfigurer();
            Consumer<Unmarshaller> other$unmarshallerConfigurer = other.getUnmarshallerConfigurer();
            if (this$unmarshallerConfigurer == null ? other$unmarshallerConfigurer != null : !this$unmarshallerConfigurer.equals(other$unmarshallerConfigurer)) {
                return false;
            }
            JAXBContext this$jaxbContextOverride = this.getJaxbContextOverride();
            JAXBContext other$jaxbContextOverride = other.getJaxbContextOverride();
            return !(this$jaxbContextOverride == null ? other$jaxbContextOverride != null : !this$jaxbContextOverride.equals(other$jaxbContextOverride));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JaxbOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseContextCache() ? 79 : 97);
            result = result * 59 + (this.isAllowMissingRootElement() ? 79 : 97);
            result = result * 59 + (this.isFormattedOutput() ? 79 : 97);
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            Consumer<Marshaller> $marshallerConfigurer = this.getMarshallerConfigurer();
            result = result * 59 + ($marshallerConfigurer == null ? 43 : $marshallerConfigurer.hashCode());
            Consumer<Unmarshaller> $unmarshallerConfigurer = this.getUnmarshallerConfigurer();
            result = result * 59 + ($unmarshallerConfigurer == null ? 43 : $unmarshallerConfigurer.hashCode());
            JAXBContext $jaxbContextOverride = this.getJaxbContextOverride();
            result = result * 59 + ($jaxbContextOverride == null ? 43 : $jaxbContextOverride.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JaxbUtils.JaxbOptions(useContextCache=" + this.isUseContextCache() + ", allowMissingRootElement=" + this.isAllowMissingRootElement() + ", formattedOutput=" + this.isFormattedOutput() + ", properties=" + this.getProperties() + ", marshallerConfigurer=" + this.getMarshallerConfigurer() + ", unmarshallerConfigurer=" + this.getUnmarshallerConfigurer() + ", jaxbContextOverride=" + this.getJaxbContextOverride() + ")";
        }

        @Generated
        public static class JaxbOptionsBuilder {
            @Generated
            private boolean useContextCache$set;
            @Generated
            private boolean useContextCache$value;
            @Generated
            private boolean allowMissingRootElement$set;
            @Generated
            private boolean allowMissingRootElement$value;
            @Generated
            private boolean formattedOutput$set;
            @Generated
            private boolean formattedOutput$value;
            @Generated
            private ArrayList<String> properties$key;
            @Generated
            private ArrayList<Object> properties$value;
            @Generated
            private boolean marshallerConfigurer$set;
            @Generated
            private Consumer<Marshaller> marshallerConfigurer$value;
            @Generated
            private boolean unmarshallerConfigurer$set;
            @Generated
            private Consumer<Unmarshaller> unmarshallerConfigurer$value;
            @Generated
            private JAXBContext jaxbContextOverride;

            @Generated
            JaxbOptionsBuilder() {
            }

            @Generated
            public JaxbOptionsBuilder useContextCache(boolean useContextCache) {
                this.useContextCache$value = useContextCache;
                this.useContextCache$set = true;
                return this;
            }

            @Generated
            public JaxbOptionsBuilder allowMissingRootElement(boolean allowMissingRootElement) {
                this.allowMissingRootElement$value = allowMissingRootElement;
                this.allowMissingRootElement$set = true;
                return this;
            }

            @Generated
            public JaxbOptionsBuilder formattedOutput(boolean formattedOutput) {
                this.formattedOutput$value = formattedOutput;
                this.formattedOutput$set = true;
                return this;
            }

            @Generated
            public JaxbOptionsBuilder property(String propertyKey, Object propertyValue) {
                if (this.properties$key == null) {
                    this.properties$key = new ArrayList();
                    this.properties$value = new ArrayList();
                }
                this.properties$key.add(propertyKey);
                this.properties$value.add(propertyValue);
                return this;
            }

            @Generated
            public JaxbOptionsBuilder properties(Map<? extends String, ? extends Object> properties) {
                if (properties == null) {
                    throw new NullPointerException("properties cannot be null");
                }
                if (this.properties$key == null) {
                    this.properties$key = new ArrayList();
                    this.properties$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : properties.entrySet()) {
                    this.properties$key.add($lombokEntry.getKey());
                    this.properties$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public JaxbOptionsBuilder clearProperties() {
                if (this.properties$key != null) {
                    this.properties$key.clear();
                    this.properties$value.clear();
                }
                return this;
            }

            @Generated
            public JaxbOptionsBuilder marshallerConfigurer(@NonNull Consumer<Marshaller> marshallerConfigurer) {
                if (marshallerConfigurer == null) {
                    throw new NullPointerException("marshallerConfigurer is marked non-null but is null");
                }
                this.marshallerConfigurer$value = marshallerConfigurer;
                this.marshallerConfigurer$set = true;
                return this;
            }

            @Generated
            public JaxbOptionsBuilder unmarshallerConfigurer(@NonNull Consumer<Unmarshaller> unmarshallerConfigurer) {
                if (unmarshallerConfigurer == null) {
                    throw new NullPointerException("unmarshallerConfigurer is marked non-null but is null");
                }
                this.unmarshallerConfigurer$value = unmarshallerConfigurer;
                this.unmarshallerConfigurer$set = true;
                return this;
            }

            @Generated
            public JaxbOptionsBuilder jaxbContextOverride(@Nullable JAXBContext jaxbContextOverride) {
                this.jaxbContextOverride = jaxbContextOverride;
                return this;
            }

            @Generated
            public JaxbOptions build() {
                Map<Object, Object> properties;
                switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                    case 0: {
                        properties = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                        break;
                    }
                    default: {
                        properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                            properties.put(this.properties$key.get($i), this.properties$value.get($i));
                        }
                        properties = Collections.unmodifiableMap(properties);
                    }
                }
                boolean useContextCache$value = this.useContextCache$value;
                if (!this.useContextCache$set) {
                    useContextCache$value = JaxbOptions.$default$useContextCache();
                }
                boolean allowMissingRootElement$value = this.allowMissingRootElement$value;
                if (!this.allowMissingRootElement$set) {
                    allowMissingRootElement$value = JaxbOptions.$default$allowMissingRootElement();
                }
                boolean formattedOutput$value = this.formattedOutput$value;
                if (!this.formattedOutput$set) {
                    formattedOutput$value = JaxbOptions.$default$formattedOutput();
                }
                Consumer<Marshaller> marshallerConfigurer$value = this.marshallerConfigurer$value;
                if (!this.marshallerConfigurer$set) {
                    marshallerConfigurer$value = JaxbOptions.$default$marshallerConfigurer();
                }
                Consumer<Unmarshaller> unmarshallerConfigurer$value = this.unmarshallerConfigurer$value;
                if (!this.unmarshallerConfigurer$set) {
                    unmarshallerConfigurer$value = JaxbOptions.$default$unmarshallerConfigurer();
                }
                return new JaxbOptions(useContextCache$value, allowMissingRootElement$value, formattedOutput$value, properties, marshallerConfigurer$value, unmarshallerConfigurer$value, this.jaxbContextOverride);
            }

            @Generated
            public String toString() {
                return "JaxbUtils.JaxbOptions.JaxbOptionsBuilder(useContextCache$value=" + this.useContextCache$value + ", allowMissingRootElement$value=" + this.allowMissingRootElement$value + ", formattedOutput$value=" + this.formattedOutput$value + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ", marshallerConfigurer$value=" + this.marshallerConfigurer$value + ", unmarshallerConfigurer$value=" + this.unmarshallerConfigurer$value + ", jaxbContextOverride=" + this.jaxbContextOverride + ")";
            }
        }
    }

    public static interface TransformerFactoryCustomizer
    extends JaxbCustomizer {
        @Override
        public void apply(TransformerFactory var1);
    }
}

