/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.functional.IndexedConsumer;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._PrimitiveCollections;
import org.apache.causeway.commons.internal.primitives._Longs;
import org.springframework.lang.Nullable;

public final class GraphUtils {
    public static <T> GraphKernel kernelForAdjacency(Can<T> nodes, BiPredicate<T, T> adjaciency) {
        GraphKernel kernel = new GraphKernel(nodes.size(), ImmutableEnumSet.noneOf(GraphKernel.GraphCharacteristic.class));
        int m = nodes.size() - 1;
        int n = nodes.size();
        for (int i = 0; i < m; ++i) {
            T a = nodes.getElseFail(i);
            for (int j = i; j < n; ++j) {
                T b = nodes.getElseFail(j);
                if (adjaciency.test(a, b)) {
                    kernel.addEdge(i, j);
                }
                if (!adjaciency.test(b, a)) continue;
                kernel.addEdge(j, i);
            }
        }
        return kernel;
    }

    @Generated
    private GraphUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class GraphKernel {
        private final ImmutableEnumSet<GraphCharacteristic> characteristics;
        private final int nodeCount;
        private final List<_PrimitiveCollections.IntList> adjacencyList;

        public GraphKernel(int nodeCount, @NonNull ImmutableEnumSet<GraphCharacteristic> characteristics) {
            if (characteristics == null) {
                throw new NullPointerException("characteristics is marked non-null but is null");
            }
            this.characteristics = characteristics;
            this.nodeCount = nodeCount;
            this.adjacencyList = new ArrayList<_PrimitiveCollections.IntList>(nodeCount);
            for (int i = 0; i < nodeCount; ++i) {
                this.adjacencyList.add(new _PrimitiveCollections.IntList());
            }
        }

        public boolean isUndirected() {
            return this.characteristics.contains(GraphCharacteristic.UNDIRECTED);
        }

        public int edgeCount() {
            return this.adjacencyList.stream().mapToInt(_PrimitiveCollections.IntList::size).sum();
        }

        public int neighborCount(int nodeIndex) {
            return this.isWithinBounds(nodeIndex) ? this.adjacencyList.get(nodeIndex).size() : 0;
        }

        public void addEdge(int u, int v) {
            this.assertBounds(u);
            this.assertBounds(v);
            this.adjacencyList.get(u).addUnique(v);
            if (this.isUndirected()) {
                this.adjacencyList.get(v).addUnique(u);
            }
        }

        public IntStream streamNeighbors(int nodeIndex) {
            this.assertBounds(nodeIndex);
            return this.adjacencyList.get(nodeIndex).stream();
        }

        public GraphKernel copy() {
            GraphKernel copy = new GraphKernel(this.nodeCount, this.characteristics);
            for (int u = 0; u < this.nodeCount; ++u) {
                for (int v : this.adjacencyList.get(u)) {
                    copy.addEdge(u, v);
                }
            }
            return copy;
        }

        public GraphKernel toUndirected() {
            GraphKernel copy = new GraphKernel(this.nodeCount, this.characteristics.add(GraphCharacteristic.UNDIRECTED));
            for (int u = 0; u < this.nodeCount; ++u) {
                for (int v : this.adjacencyList.get(u)) {
                    copy.addEdge(u, v);
                    copy.addEdge(v, u);
                }
            }
            return copy;
        }

        public GraphKernel subGraph(@Nullable int[] nodeIndexes) {
            _PrimitiveCollections.IntList pickedSubset = new _PrimitiveCollections.IntList(nodeIndexes);
            int subsize = pickedSubset.size();
            GraphKernel sub = new GraphKernel(subsize, this.characteristics);
            for (int i = 0; i < subsize; ++i) {
                int fromIndex = i;
                for (int v : this.adjacencyList.get(nodeIndexes[i])) {
                    pickedSubset.indexOf(v).ifPresent(toIndex -> sub.addEdge(fromIndex, toIndex));
                }
            }
            return sub;
        }

        public List<int[]> findWeaklyConnectedNodes() {
            GraphKernel undirectedGraph = this.isUndirected() ? this : this.toUndirected();
            List<_PrimitiveCollections.IntList> adjacencyList = new WeaklyConnectedNodesFinder().find(undirectedGraph);
            return adjacencyList.stream().filter(_PrimitiveCollections.IntList::isNotEmpty).map(_PrimitiveCollections.IntList::toArray).collect(Collectors.toList());
        }

        private void assertBounds(int nodeIndex) {
            if (!this.isWithinBounds(nodeIndex)) {
                throw new IndexOutOfBoundsException(nodeIndex);
            }
        }

        private boolean isWithinBounds(int nodeIndex) {
            return nodeIndex >= 0 && nodeIndex < this.nodeCount;
        }

        @Generated
        public int nodeCount() {
            return this.nodeCount;
        }

        public static enum GraphCharacteristic {
            UNDIRECTED;


            public static ImmutableEnumSet<GraphCharacteristic> directed() {
                return ImmutableEnumSet.noneOf(GraphCharacteristic.class);
            }

            public static ImmutableEnumSet<GraphCharacteristic> undirected() {
                return ImmutableEnumSet.of(UNDIRECTED);
            }
        }

        private class WeaklyConnectedNodesFinder {
            private WeaklyConnectedNodesFinder() {
            }

            List<_PrimitiveCollections.IntList> find(GraphKernel undirectedGraph) {
                _Assert.assertTrue(undirectedGraph.isUndirected());
                ArrayList<_PrimitiveCollections.IntList> connectedComponents = new ArrayList<_PrimitiveCollections.IntList>();
                boolean[] isVisited = new boolean[undirectedGraph.nodeCount()];
                for (int i = 0; i < undirectedGraph.nodeCount(); ++i) {
                    if (isVisited[i]) continue;
                    _PrimitiveCollections.IntList component = new _PrimitiveCollections.IntList();
                    this.findConnectedComponent(i, isVisited, component, undirectedGraph);
                    connectedComponents.add(component);
                }
                return connectedComponents;
            }

            private void findConnectedComponent(int src, boolean[] isVisited, _PrimitiveCollections.IntList component, GraphKernel undirectedGraph) {
                isVisited[src] = true;
                component.add(src);
                for (int v : undirectedGraph.adjacencyList.get(src)) {
                    if (isVisited[v]) continue;
                    this.findConnectedComponent(v, isVisited, component, undirectedGraph);
                }
            }
        }
    }

    public static class GraphBuilder<T> {
        private final Class<T> nodeType;
        private final ImmutableEnumSet<GraphKernel.GraphCharacteristic> characteristics;
        private final boolean isUndirected;
        private final Map<T, Integer> indexByNode;
        private final List<T> nodeList;
        private final _PrimitiveCollections.IntList fromNode = new _PrimitiveCollections.IntList(4);
        private final _PrimitiveCollections.IntList toNode = new _PrimitiveCollections.IntList(4);
        private final Map<Long, Object> edgeAttributeByPackedEdgeIndex;
        private Map<T, Integer> nodeIndexByNode = null;

        public static <T> GraphBuilder<T> directed(Class<T> nodeType) {
            return new GraphBuilder<T>(nodeType, GraphKernel.GraphCharacteristic.directed());
        }

        public static <T> GraphBuilder<T> undirected(Class<T> nodeType) {
            return new GraphBuilder<T>(nodeType, GraphKernel.GraphCharacteristic.undirected());
        }

        public GraphBuilder<T> addNode(@NonNull T node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            this.addNodeHonoringIndexMap(node);
            return this;
        }

        public GraphBuilder<T> addEdge(int fromIndex, int toIndex) {
            this.fromNode.add(fromIndex);
            this.toNode.add(toIndex);
            return this;
        }

        public GraphBuilder<T> addEdge(int fromIndex, int toIndex, @Nullable Object edgeAttribute) {
            long packedEdgeIndex;
            this.addEdge((T)fromIndex, (T)toIndex);
            long l = packedEdgeIndex = this.isUndirected ? _Longs.pack(Math.min(fromIndex, toIndex), Math.max(fromIndex, toIndex)) : _Longs.pack(fromIndex, toIndex);
            if (edgeAttribute != null) {
                this.edgeAttributeByPackedEdgeIndex.put(packedEdgeIndex, edgeAttribute);
            }
            return this;
        }

        public GraphBuilder<T> addEdge(T from, T to) {
            this.addEdge(from, to, null);
            return this;
        }

        public GraphBuilder<T> addEdge(T from, T to, @Nullable Object edgeAttribute) {
            int fromIndex = this.indexOfWithAdd(from);
            int toIndex = this.indexOfWithAdd(to);
            this.addEdge((T)fromIndex, (T)toIndex, edgeAttribute);
            return this;
        }

        public int nodeCount() {
            return this.nodeList.size();
        }

        public int edgeCount() {
            return this.fromNode.size();
        }

        private GraphBuilder(Class<T> nodeType, ImmutableEnumSet<GraphKernel.GraphCharacteristic> characteristics) {
            this.nodeType = nodeType;
            this.characteristics = characteristics;
            this.isUndirected = characteristics.contains(GraphKernel.GraphCharacteristic.UNDIRECTED);
            this.nodeList = new ArrayList<T>();
            this.indexByNode = new HashMap<T, Integer>();
            this.edgeAttributeByPackedEdgeIndex = new HashMap<Long, Object>();
        }

        public Graph<T> build() {
            GraphKernel kernel = new GraphKernel(this.nodeList.size(), this.characteristics);
            int edgeCount = this.edgeCount();
            for (int edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                kernel.addEdge(this.fromNode.get(edgeIndex), this.toNode.get(edgeIndex));
            }
            Graph<T> graph = new Graph<T>(kernel, Can.ofCollection(this.nodeList), Collections.unmodifiableMap(this.edgeAttributeByPackedEdgeIndex));
            return graph;
        }

        private Map<T, Integer> snapshotNodeIndexByNode() {
            HashMap nodeIndexByNode = new HashMap();
            this.nodeList.forEach(IndexedConsumer.zeroBased((i, node) -> nodeIndexByNode.put(node, i)));
            return nodeIndexByNode;
        }

        private int indexOfWithAdd(T node) {
            Integer nodeIndex;
            if (this.nodeIndexByNode == null) {
                this.nodeIndexByNode = this.snapshotNodeIndexByNode();
            }
            if ((nodeIndex = this.nodeIndexByNode.get(node)) != null) {
                return nodeIndex;
            }
            return this.addNodeHonoringIndexMap(node);
        }

        private int addNodeHonoringIndexMap(T node) {
            Integer nodeIndex = this.indexByNode.get(node);
            if (nodeIndex != null) {
                return nodeIndex;
            }
            int nextIndex = this.nodeList.size();
            this.indexByNode.put(node, nextIndex);
            this.nodeList.add(node);
            if (this.nodeIndexByNode != null) {
                this.nodeIndexByNode.put(node, nextIndex);
            }
            return nextIndex;
        }
    }

    public static final class Graph<T> {
        private final GraphKernel kernel;
        private final Can<T> nodes;
        private final Map<Long, Object> edgeAttributeByPackedEdgeIndex;

        public void visitNeighbors(int nodeIndex, @Nullable Consumer<T> nodeVisitor) {
            this.kernel().streamNeighbors(nodeIndex).forEach(neighborIndex -> nodeVisitor.accept(this.nodes.getElseFail(neighborIndex)));
        }

        public void visitNeighbors(int nodeIndex, @Nullable EdgeFilter edgeFilter, @Nullable Consumer<T> nodeVisitor) {
            if (nodeVisitor == null) {
                return;
            }
            IntStream stream = this.kernel().streamNeighbors(nodeIndex);
            stream = edgeFilter == null ? stream : stream.filter((int neighborIndex) -> edgeFilter.test(nodeIndex, neighborIndex));
            stream.forEach(neighborIndex -> nodeVisitor.accept(this.nodes.getElseFail(neighborIndex)));
        }

        public void visitEdges(int nodeIndex, @Nullable EdgeFilter edgeFilter, @Nullable EdgeConsumer<T> edgeConsumer) {
            if (edgeConsumer == null) {
                return;
            }
            T fromNode = this.nodes.getElseFail(nodeIndex);
            IntStream stream = this.kernel().streamNeighbors(nodeIndex);
            stream = edgeFilter == null ? stream : stream.filter((int neighborIndex) -> edgeFilter.test(nodeIndex, neighborIndex));
            stream.forEach(neighborIndex -> edgeConsumer.accept(nodeIndex, fromNode, neighborIndex, this.nodes.getElseFail(neighborIndex)));
        }

        public void visitNeighborsIndexed(int nodeIndex, @Nullable IndexedConsumer<T> nodeVisitor) {
            if (nodeVisitor == null) {
                return;
            }
            this.kernel().streamNeighbors(nodeIndex).forEach(neighborIndex -> nodeVisitor.accept(neighborIndex, this.nodes.getElseFail(neighborIndex)));
        }

        public <R> Graph<R> map(Function<T, R> nodeMapper) {
            Graph<R> graph = new Graph<R>(this.kernel, this.nodes.map(nodeMapper), this.edgeAttributeByPackedEdgeIndex());
            _Assert.assertEquals(this.kernel.nodeCount(), graph.nodes().size());
            return graph;
        }

        public Graph<T> filter(Predicate<T> filter) {
            if (this.nodes.isEmpty()) {
                return this;
            }
            Class nodeType = (Class)_Casts.uncheckedCast(this.nodes.getFirst().get().getClass());
            GraphBuilder builder = new GraphBuilder(nodeType, this.kernel().characteristics);
            boolean isUndirected = this.kernel().isUndirected();
            this.nodes.forEach(IndexedConsumer.zeroBased((nodeIndex, node) -> {
                if (filter.test(node)) {
                    builder.addNode(node);
                    this.visitNeighborsIndexed(nodeIndex, (neighborIndex, neighbor) -> {
                        if (isUndirected && neighborIndex < nodeIndex) {
                            return;
                        }
                        if (filter.test(neighbor)) {
                            Object edgeAttributes = this.edgeAttributeByPackedEdgeIndex().get(_Longs.pack(nodeIndex, neighborIndex));
                            if (edgeAttributes != null) {
                                builder.addEdge(node, neighbor, edgeAttributes);
                            } else {
                                builder.addEdge(node, neighbor);
                            }
                        }
                    });
                }
            }));
            return builder.build();
        }

        public Optional<Object> getEdgeAttribute(int fromIndex, int toIndex) {
            long packedEdgeIndex = this.kernel().isUndirected() ? _Longs.pack(Math.min(fromIndex, toIndex), Math.max(fromIndex, toIndex)) : _Longs.pack(fromIndex, toIndex);
            return Optional.ofNullable(this.edgeAttributeByPackedEdgeIndex.get(packedEdgeIndex));
        }

        public Graph<T> sorted(Comparator<T> nodeComparator) {
            Can<Object> sortedNodes = this.nodes.sorted(nodeComparator);
            _Assert.assertEquals((Object)this.nodes.size(), (Object)sortedNodes.size(), () -> "nodeComparator has reduced the number of nodes from the original node list");
            GraphBuilder builder = new GraphBuilder(null, this.kernel.characteristics);
            sortedNodes.forEach(builder::addNode);
            for (int nodeIndex = 0; nodeIndex < this.kernel.nodeCount(); ++nodeIndex) {
                this.visitEdges(nodeIndex, EdgeFilter.includeAll(), (i, a, j, b) -> builder.addEdge(a, b, this.getEdgeAttribute(i, j).orElse(null)));
            }
            return builder.build();
        }

        public String toString() {
            return this.toString(null, null);
        }

        public String toString(@Nullable Function<T, String> nodeFormatter) {
            return this.toString(NodeFormatter.of(nodeFormatter), null);
        }

        public String toString(@Nullable NodeFormatter<T> nodeFormatter, @Nullable Function<Object, String> edgeAttributeFormatter) {
            Function<Object, String> edgeAttributeFormat;
            boolean isDirected = !this.kernel().isUndirected();
            boolean hasEdgeAttributes = !this.edgeAttributeByPackedEdgeIndex.isEmpty();
            NodeFormatter nodeFormat = nodeFormatter != null ? nodeFormatter : NodeFormatter.of(null);
            Function<Object, String> function = edgeAttributeFormat = edgeAttributeFormatter != null ? edgeAttributeFormatter : edgeAttr -> "(" + String.valueOf(edgeAttr) + ")";
            EdgeFormatter<Object> edgeFormat = hasEdgeAttributes ? (isDirected ? (i, a, j, b, nf) -> String.format("%s -> %s%s", nf.format(i, a), nf.format(j, b), this.getEdgeAttribute(i, j).map(edgeAttributeFormat).map((? super T s) -> " " + s).orElse("")) : (i, a, j, b, nf) -> String.format("%s - %s%s", nf.format(i, a), nf.format(j, b), this.getEdgeAttribute(i, j).map(edgeAttributeFormat).map((? super T s) -> " " + s).orElse(""))) : (isDirected ? (i, a, j, b, nf) -> String.format("%s -> %s", nf.format(i, a), nf.format(j, b)) : (i, a, j, b, nf) -> String.format("%s - %s", nf.format(i, a), nf.format(j, b)));
            EdgeFilter filter = isDirected ? EdgeFilter.includeAll() : EdgeFilter.excludeToLessThanFrom();
            StringBuilder sb = new StringBuilder();
            for (int nodeIndex = 0; nodeIndex < this.kernel.nodeCount(); ++nodeIndex) {
                this.visitEdges(nodeIndex, filter, (i, a, j, b) -> sb.append(edgeFormat.format(i, a, j, b, nodeFormat)).append("\n"));
                if (this.kernel().neighborCount(nodeIndex) != 0) continue;
                sb.append(String.format("%s", nodeFormat.format(nodeIndex, this.nodes.getElseFail(nodeIndex)))).append("\n");
            }
            return sb.toString();
        }

        @Generated
        public Graph(GraphKernel kernel, Can<T> nodes, Map<Long, Object> edgeAttributeByPackedEdgeIndex) {
            this.kernel = kernel;
            this.nodes = nodes;
            this.edgeAttributeByPackedEdgeIndex = edgeAttributeByPackedEdgeIndex;
        }

        @Generated
        public GraphKernel kernel() {
            return this.kernel;
        }

        @Generated
        public Can<T> nodes() {
            return this.nodes;
        }

        @Generated
        public Map<Long, Object> edgeAttributeByPackedEdgeIndex() {
            return this.edgeAttributeByPackedEdgeIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Graph)) {
                return false;
            }
            Graph other = (Graph)o;
            GraphKernel this$kernel = this.kernel();
            GraphKernel other$kernel = other.kernel();
            if (this$kernel == null ? other$kernel != null : !this$kernel.equals(other$kernel)) {
                return false;
            }
            Can<T> this$nodes = this.nodes();
            Can<T> other$nodes = other.nodes();
            if (this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes)) {
                return false;
            }
            Map<Long, Object> this$edgeAttributeByPackedEdgeIndex = this.edgeAttributeByPackedEdgeIndex();
            Map<Long, Object> other$edgeAttributeByPackedEdgeIndex = other.edgeAttributeByPackedEdgeIndex();
            return !(this$edgeAttributeByPackedEdgeIndex == null ? other$edgeAttributeByPackedEdgeIndex != null : !((Object)this$edgeAttributeByPackedEdgeIndex).equals(other$edgeAttributeByPackedEdgeIndex));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphKernel $kernel = this.kernel();
            result = result * 59 + ($kernel == null ? 43 : $kernel.hashCode());
            Can<T> $nodes = this.nodes();
            result = result * 59 + ($nodes == null ? 43 : $nodes.hashCode());
            Map<Long, Object> $edgeAttributeByPackedEdgeIndex = this.edgeAttributeByPackedEdgeIndex();
            result = result * 59 + ($edgeAttributeByPackedEdgeIndex == null ? 43 : ((Object)$edgeAttributeByPackedEdgeIndex).hashCode());
            return result;
        }
    }

    @FunctionalInterface
    public static interface EdgeFormatter<T> {
        public String format(int var1, T var2, int var3, T var4, NodeFormatter<T> var5);
    }

    @FunctionalInterface
    public static interface NodeFormatter<T> {
        public String format(int var1, T var2);

        public static <T> NodeFormatter<T> of(@Nullable Function<T, String> toStringFunction) {
            return toStringFunction != null ? (i, node) -> (String)toStringFunction.apply(node) : (i, node) -> node.toString();
        }
    }

    @FunctionalInterface
    public static interface EdgeFunction<T, R> {
        public R apply(int var1, T var2, int var3, T var4);
    }

    @FunctionalInterface
    public static interface EdgeConsumer<T> {
        public void accept(int var1, T var2, int var3, T var4);
    }

    @FunctionalInterface
    public static interface EdgeFilter {
        public boolean test(int var1, int var2);

        public static EdgeFilter includeAll() {
            return (i, j) -> true;
        }

        public static EdgeFilter excludeToLessThanFrom() {
            return (i, j) -> j >= i;
        }
    }
}

