/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.util.function.ThrowingSupplier;

final class _Lazy_ThreadSafe<T>
implements _Lazy<T> {
    @Generated
    private final Object $lock = new Object[0];
    private final ThrowingSupplier<? extends T> supplier;
    private T value;
    private boolean memoized;
    private boolean getting;

    _Lazy_ThreadSafe(@NonNull ThrowingSupplier<? extends T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemoized() {
        Object object = this.$lock;
        synchronized (object) {
            return this.getting ? false : this.memoized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.$lock;
        synchronized (object) {
            this.guardAgainstRecursiveCall();
            this.memoized = false;
            this.value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.memoized) {
                return this.value;
            }
            this.guardAgainstRecursiveCall();
            this.getting = true;
            try {
                this.value = this.supplier.get();
            }
            finally {
                this.getting = false;
                this.memoized = true;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> getMemoized() {
        Object object = this.$lock;
        synchronized (object) {
            this.guardAgainstRecursiveCall();
            return Optional.ofNullable(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T value) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.memoized) {
                throw _Exceptions.illegalState("cannot set value '%s' on Lazy that has already memoized a value", String.valueOf(value));
            }
            this.guardAgainstRecursiveCall();
            this.memoized = true;
            this.value = value;
        }
    }

    private final void guardAgainstRecursiveCall() {
        if (this.getting) {
            throw _Exceptions.illegalState("recursive call of lazy getter detected", new Object[0]);
        }
    }
}

