/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableCollection;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Casts;
import org.springframework.lang.Nullable;

public final class _NullSafe {
    private _NullSafe() {
    }

    public static <T> Stream<T> stream(@Nullable T[] array) {
        return array != null ? Stream.of(array) : Stream.empty();
    }

    public static <T> Stream<T> streamNullable(@Nullable T nullable) {
        return nullable != null ? Stream.of(nullable) : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Can<T> can) {
        return can != null ? can.stream() : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Collection<T> coll) {
        return coll != null ? coll.stream() : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        if (iterable instanceof Can) {
            return ((Can)iterable).stream();
        }
        return iterable != null ? _NullSafe.stream(iterable.iterator()) : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Iterator<T> iterator) {
        return iterator != null ? StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false) : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Stream<T> stream) {
        return stream != null ? stream : Stream.empty();
    }

    public static <T> Stream<T> stream(@Nullable Enumeration<T> enumeration) {
        return enumeration != null ? StreamSupport.stream(_NullSafe.toSpliterator(enumeration), false) : Stream.empty();
    }

    private static <T> Spliterator<T> toSpliterator(final Enumeration<T> e) {
        return new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                }
            }
        };
    }

    public static Stream<?> streamAutodetect(@Nullable Object pojo) {
        if (pojo == null) {
            return Stream.empty();
        }
        if (pojo instanceof Collection) {
            return ((Collection)pojo).stream();
        }
        if (pojo instanceof ImmutableCollection) {
            return ((ImmutableCollection)pojo).stream();
        }
        if (pojo.getClass().isArray()) {
            if (Array.getLength(pojo) == 0) {
                return Stream.empty();
            }
            if (pojo instanceof Object[]) {
                return Stream.of((Object[])pojo);
            }
            if (pojo instanceof boolean[]) {
                return _NullSafe.primitiveStream((boolean[])pojo);
            }
            if (pojo instanceof byte[]) {
                return _NullSafe.primitiveStream((byte[])pojo);
            }
            if (pojo instanceof char[]) {
                return _NullSafe.primitiveStream((char[])pojo);
            }
            if (pojo instanceof double[]) {
                return _NullSafe.primitiveStream((double[])pojo);
            }
            if (pojo instanceof float[]) {
                return _NullSafe.primitiveStream((float[])pojo);
            }
            if (pojo instanceof int[]) {
                return _NullSafe.primitiveStream((int[])pojo);
            }
            if (pojo instanceof long[]) {
                return _NullSafe.primitiveStream((long[])pojo);
            }
            if (pojo instanceof short[]) {
                return _NullSafe.primitiveStream((short[])pojo);
            }
        }
        if (pojo instanceof Map) {
            return ((Map)pojo).values().stream();
        }
        if (pojo instanceof Iterable) {
            return _NullSafe.stream((Iterable)pojo);
        }
        if (pojo instanceof Enumeration) {
            return _NullSafe.stream((Enumeration)pojo);
        }
        return Stream.of(pojo);
    }

    private static Stream<Boolean> primitiveStream(boolean[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    private static Stream<Byte> primitiveStream(byte[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    private static Stream<Character> primitiveStream(char[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> Character.valueOf(array[s]));
    }

    private static Stream<Float> primitiveStream(float[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> Float.valueOf(array[s]));
    }

    private static Stream<Double> primitiveStream(double[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    private static Stream<Short> primitiveStream(short[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    private static Stream<Integer> primitiveStream(int[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    private static Stream<Long> primitiveStream(long[] array) {
        return IntStream.range(0, array.length).mapToObj(s -> array[s]);
    }

    public static boolean isPresent(@Nullable Object x) {
        return x != null;
    }

    public static boolean isAbsent(@Nullable Object x) {
        return x == null;
    }

    public static boolean isEmpty(@Nullable String x) {
        return x == null || x.length() == 0;
    }

    public static boolean isEmpty(@Nullable Can<?> x) {
        return x == null || x.size() == 0;
    }

    public static boolean isEmpty(@Nullable Collection<?> x) {
        return x == null || x.size() == 0;
    }

    public static boolean isEmpty(@Nullable Map<?, ?> x) {
        return x == null || x.size() == 0;
    }

    public static boolean isEmpty(@Nullable boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable short[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(@Nullable T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable EnumSet<?> enumSet) {
        return enumSet == null || enumSet.size() == 0;
    }

    public static boolean isEmpty(@Nullable ImmutableEnumSet<?> enumSet) {
        return enumSet == null || enumSet.size() == 0;
    }

    public static int size(@Nullable String x) {
        return x != null ? x.length() : 0;
    }

    public static int size(@Nullable Collection<?> x) {
        return x != null ? x.size() : 0;
    }

    public static int size(@Nullable Map<?, ?> x) {
        return x != null ? x.size() : 0;
    }

    public static int size(@Nullable boolean[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable byte[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable char[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable double[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable float[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable int[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable long[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable short[] array) {
        return array != null ? array.length : 0;
    }

    public static <T> int size(@Nullable T[] array) {
        return array != null ? array.length : 0;
    }

    public static int size(@Nullable EnumSet<?> enumSet) {
        return enumSet != null ? enumSet.size() : 0;
    }

    public static int size(@Nullable ImmutableEnumSet<?> enumSet) {
        return enumSet != null ? enumSet.size() : 0;
    }

    public static int sizeAutodetect(@Nullable Object pojo) {
        if (pojo == null) {
            return 0;
        }
        if (pojo instanceof Collection) {
            return ((Collection)pojo).size();
        }
        if (pojo instanceof ImmutableCollection) {
            return ((ImmutableCollection)pojo).size();
        }
        if (pojo.getClass().isArray()) {
            return Array.getLength(pojo);
        }
        if (pojo instanceof Map) {
            return ((Map)pojo).size();
        }
        return Math.toIntExact(_NullSafe.streamAutodetect(pojo).count());
    }

    public static String toNonNull(@Nullable String x) {
        return x != null ? x : "";
    }

    public static boolean[] toNonNull(@Nullable boolean[] array) {
        return array != null ? array : new boolean[]{};
    }

    public static byte[] toNonNull(@Nullable byte[] array) {
        return array != null ? array : new byte[]{};
    }

    public static char[] toNonNull(@Nullable char[] array) {
        return array != null ? array : new char[]{};
    }

    public static double[] toNonNull(@Nullable double[] array) {
        return array != null ? array : new double[]{};
    }

    public static float[] toNonNull(@Nullable float[] array) {
        return array != null ? array : new float[]{};
    }

    public static int[] toNonNull(@Nullable int[] array) {
        return array != null ? array : new int[]{};
    }

    public static long[] toNonNull(@Nullable long[] array) {
        return array != null ? array : new long[]{};
    }

    public static short[] toNonNull(@Nullable short[] array) {
        return array != null ? array : new short[]{};
    }

    public static <T> T[] toNonNull(@Nullable T[] array) {
        return array != null ? array : (Object[])_Casts.uncheckedCast(new Object[0]);
    }

    public static String toString(@Nullable Object obj) {
        return obj != null ? obj.toString() : null;
    }

    @Nullable
    public static final <K, V> V getOrDefault(@Nullable Map<K, V> map, @Nullable K key, @Nullable V defaultValue) {
        if (map == null || key == null) {
            return defaultValue;
        }
        return map.getOrDefault(key, defaultValue);
    }

    public static <K, V> Set<Map.Entry<K, V>> entrySet(@Nullable Map<K, V> map) {
        return map == null ? Collections.emptySet() : map.entrySet();
    }
}

