/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Multimaps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _Maps {
    private _Maps() {
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        mapPreservingOrder.put(k3, v3);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map<K, V> unmodifiable(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> mapPreservingOrder = _Maps.newLinkedHashMap();
        mapPreservingOrder.put(k1, v1);
        mapPreservingOrder.put(k2, v2);
        mapPreservingOrder.put(k3, v3);
        mapPreservingOrder.put(k4, v4);
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> unmodifiableEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (entries.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap mapPreservingOrder = _Maps.newLinkedHashMap();
        Stream.of(entries).forEach(entry -> mapPreservingOrder.put(entry.getKey(), entry.getValue()));
        return Collections.unmodifiableMap(mapPreservingOrder);
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    public static String toString(@Nullable Map<?, ?> map, @NonNull CharSequence delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        return map == null ? "" : map.entrySet().stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static <K, V> boolean toggleElement(@NonNull Map<K, V> map, @NonNull K key, @NonNull V value) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Object newValue = map.compute(key, (k, v) -> v == null ? value : null);
        return newValue != null;
    }

    public static <K, V0, V1> Map<K, V1> mapValues(@Nullable Map<K, V0> input, @NonNull Supplier<Map<K, V1>> mapFactory, @NonNull Function<V0, V1> valueMapper) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        if (valueMapper == null) {
            throw new NullPointerException("valueMapper is marked non-null but is null");
        }
        Map resultMap = mapFactory.get();
        if (input == null || input.isEmpty()) {
            return resultMap;
        }
        input.forEach((k, v) -> resultMap.put(k, valueMapper.apply(v)));
        return resultMap;
    }

    public static <K, V> Map<K, V> filterKeys(@Nullable Map<K, V> input, @NonNull Predicate<K> keyFilter, @NonNull Supplier<Map<K, V>> factory) {
        if (keyFilter == null) {
            throw new NullPointerException("keyFilter is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Map result = factory.get();
        if (input == null) {
            return result;
        }
        input.forEach((k, v) -> {
            if (keyFilter.test(k)) {
                result.put(k, v);
            }
        });
        return result;
    }

    public static <K, V> _Multimaps.ListMultimap<V, K> invertToListMultimap(Map<K, V> input) {
        _Multimaps.ListMultimap result = _Multimaps.newListMultimap();
        if (input == null) {
            return result;
        }
        input.forEach((k, v) -> result.putElement(v, k));
        return result;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> AliasMap<K, V> newAliasMap(final @NonNull Supplier<Map<K, V>> mapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        return new AliasMap<K, V>(){
            final Map<K, V> delegate;
            private final Map<K, KeyPair<K>> pairByAliasKey;
            {
                this.delegate = (Map)mapFactory.get();
                this.pairByAliasKey = _Maps.newHashMap();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<V> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public V put(K key, V value) {
                return this.put(key, Can.empty(), value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> other) {
                if (!_NullSafe.isEmpty(other)) {
                    other.forEach((k, v) -> this.put(k, v));
                }
            }

            @Override
            public V put(K key, Can<K> aliases, V value) {
                this.putAliasKeys(key, aliases, false);
                return this.delegate.put(key, value);
            }

            @Override
            public V remap(K key, Can<K> aliases, V value) {
                this.putAliasKeys(key, aliases, true);
                return this.delegate.put(key, value);
            }

            @Override
            public boolean containsKey(Object keyOrAliasKey) {
                return this.delegate.containsKey(keyOrAliasKey) || this.containsAliasKey(keyOrAliasKey);
            }

            @Override
            public V get(Object keyOrAliasKey) {
                Object v = this.delegate.get(keyOrAliasKey);
                if (v != null) {
                    return v;
                }
                return this.getByAliasKey(keyOrAliasKey);
            }

            @Override
            public V remove(Object key) {
                this.removeAliasKeysOf(key);
                return this.delegate.remove(key);
            }

            @Override
            public void clear() {
                this.delegate.clear();
                this.clearAliasKeys();
            }

            private void putAliasKeys(K key, Can<K> aliasKeys, boolean remap) {
                if (aliasKeys.isNotEmpty()) {
                    KeyPair keyPair = KeyPair.of(key, aliasKeys);
                    for (Object aliasKey : aliasKeys) {
                        KeyPair existingKeyPair = this.pairByAliasKey.put(aliasKey, keyPair);
                        if (existingKeyPair == null || remap) continue;
                        throw _Exceptions.illegalArgument("alias key collision on alias %s: existing-key=%s, new-key=%s", aliasKey, existingKeyPair.key, keyPair.key);
                    }
                }
            }

            private V getByAliasKey(Object aliasKey) {
                KeyPair keyPair = this.pairByAliasKey.get(aliasKey);
                if (keyPair != null) {
                    return this.delegate.get(keyPair.getKey());
                }
                return null;
            }

            private boolean containsAliasKey(Object aliasKey) {
                return this.pairByAliasKey.containsKey(aliasKey);
            }

            private void removeAliasKeysOf(Object key) {
                this.pairByAliasKey.entrySet().removeIf(entry -> {
                    KeyPair keyPair = (KeyPair)entry.getValue();
                    return keyPair.getKey().equals(key);
                });
            }

            private void clearAliasKeys() {
                this.pairByAliasKey.clear();
            }
        };
    }

    private static final class KeyPair<K> {
        private final K key;
        private final Can<K> aliasKeys;

        @Generated
        private KeyPair(K key, Can<K> aliasKeys) {
            this.key = key;
            this.aliasKeys = aliasKeys;
        }

        @Generated
        public static <K> KeyPair<K> of(K key, Can<K> aliasKeys) {
            return new KeyPair<K>(key, aliasKeys);
        }

        @Generated
        public K getKey() {
            return this.key;
        }

        @Generated
        public Can<K> getAliasKeys() {
            return this.aliasKeys;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyPair)) {
                return false;
            }
            KeyPair other = (KeyPair)o;
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Can<K> this$aliasKeys = this.getAliasKeys();
            Can<K> other$aliasKeys = other.getAliasKeys();
            return !(this$aliasKeys == null ? other$aliasKeys != null : !this$aliasKeys.equals(other$aliasKeys));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Can<K> $aliasKeys = this.getAliasKeys();
            result = result * 59 + ($aliasKeys == null ? 43 : $aliasKeys.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "_Maps.KeyPair(key=" + String.valueOf(this.getKey()) + ", aliasKeys=" + String.valueOf(this.getAliasKeys()) + ")";
        }
    }

    public static interface AliasMap<K, V>
    extends Map<K, V> {
        public V put(K var1, Can<K> var2, V var3);

        public V remap(K var1, Can<K> var2, V var3);
    }
}

