/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.memento;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.memento._Mementos;
import org.springframework.lang.Nullable;

class _MementoDefault
implements _Mementos.Memento {
    private final _Mementos.EncoderDecoder codec;
    private final _Mementos.SerializingAdapter serializer;
    private final HashMap<String, Serializable> valuesByKey;

    _MementoDefault(_Mementos.EncoderDecoder codec, _Mementos.SerializingAdapter serializer) {
        this(codec, serializer, _Maps.newHashMap());
    }

    private _MementoDefault(@NonNull _Mementos.EncoderDecoder codec, @NonNull _Mementos.SerializingAdapter serializer, @NonNull HashMap<String, Serializable> valuesByKey) {
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (valuesByKey == null) {
            throw new NullPointerException("valuesByKey is marked non-null but is null");
        }
        this.codec = codec;
        this.serializer = serializer;
        this.valuesByKey = valuesByKey;
    }

    @Override
    public _Mementos.Memento put(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            return this;
        }
        this.valuesByKey.put(name, this.serializer.write(value));
        return this;
    }

    @Override
    public <T> T get(String name, Class<T> cls) {
        Serializable value = this.valuesByKey.get(name);
        if (value == null) {
            return null;
        }
        return this.serializer.read(cls, value);
    }

    @Override
    public Set<String> keySet() {
        return _Sets.unmodifiable(this.valuesByKey.keySet());
    }

    @Override
    public String asString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
            oos.writeObject(this.valuesByKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to serialize memento", e);
        }
        return this.codec.encode(os.toByteArray());
    }

    static _Mementos.Memento parse(@NonNull _Mementos.EncoderDecoder codec, _Mementos.SerializingAdapter serializer, @Nullable String str) {
        _MementoDefault _MementoDefault2;
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (_NullSafe.isEmpty(str)) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(codec.decode(str))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                return Class.forName(name, false, _Context.getDefaultClassLoader());
            }
        };
        try {
            HashMap valuesByKey = (HashMap)_Casts.uncheckedCast(ois.readObject());
            _MementoDefault2 = new _MementoDefault(codec, serializer, valuesByKey);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw _Exceptions.illegalArgument(e, "failed to parse memento from serialized string '%s'", _Strings.ellipsifyAtEnd(str, 200, "..."));
            }
        }
        ois.close();
        return _MementoDefault2;
    }
}

