/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;

public final class TextUtils {
    public static Stream<String> streamLines(@Nullable String text) {
        return _Strings.splitThenStream(text, "\n").map(s -> s.replace("\r", ""));
    }

    public static Can<String> readLines(@Nullable String text) {
        return Can.ofStream(TextUtils.streamLines(text));
    }

    public static Can<String> readLinesFromInputStream(@Nullable InputStream input, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (input == null) {
            return Can.empty();
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(input, charset.name());){
            scanner.useDelimiter("\\n");
            while (scanner.hasNext()) {
                String line = scanner.next().replace("\r", "");
                if (lines.size() == 0) {
                    line = TextUtils.stripBom(line);
                }
                lines.add(line);
            }
        }
        return Can.ofCollection(lines);
    }

    public static Can<String> readLinesFromResource(@NonNull Class<?> resourceLocation, @NonNull String resourceName, @NonNull Charset charset) {
        Can<String> can;
        block11: {
            if (resourceLocation == null) {
                throw new NullPointerException("resourceLocation is marked non-null but is null");
            }
            if (resourceName == null) {
                throw new NullPointerException("resourceName is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            InputStream input = resourceLocation.getResourceAsStream(resourceName);
            try {
                can = TextUtils.readLinesFromInputStream(input, charset);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return can;
    }

    public static Can<String> readLinesFromUrl(@NonNull URL url, @NonNull Charset charset) {
        Can<String> can;
        block10: {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            InputStream input = url.openStream();
            try {
                can = TextUtils.readLinesFromInputStream(input, charset);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return can;
    }

    public static Can<String> readLinesFromFile(@NonNull File file, @NonNull Charset charset) {
        Can<String> can;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        try (FileInputStream input = new FileInputStream(file);){
            can = TextUtils.readLinesFromInputStream(input, charset);
        }
        return can;
    }

    public static Can<String> readLinesFromDataSource(@NonNull DataSource dataSource, @NonNull Charset charset) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return dataSource.tryReadAsLines(charset).valueAsNonNullElseFail();
    }

    public static void writeLinesToFile(@NonNull Iterable<String> lines, @NonNull File file, @NonNull Charset charset) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));){
            for (String line : lines) {
                bw.append(line).append("\n");
            }
        }
    }

    public static void writeLinesToDataSink(@NonNull Iterable<String> lines, @NonNull DataSink dataSink, @NonNull Charset charset) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (dataSink == null) {
            throw new NullPointerException("dataSink is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        dataSink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> {
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, charset));){
                for (String line : lines) {
                    bw.append(line).append("\n");
                }
            }
        }));
    }

    public static StringDelimiter delimiter(@NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        return StringDelimiter.of(delimiter, new String[0]);
    }

    public static StringCutter cutter(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return StringCutter.of(value);
    }

    private static String stripBom(String line) {
        if (line.length() > 0 && line.charAt(0) == '\ufeff') {
            return line.substring(1);
        }
        return line;
    }

    @Generated
    private TextUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class StringDelimiter {
        @NonNull
        private final String delimiter;
        @NonNull
        private final String[] elements;

        public StringDelimiter parse(@Nullable String string) {
            return new StringDelimiter(this.delimiter, _Strings.splitThenStream(string, this.delimiter).filter(_Strings::isNotEmpty).collect(_Arrays.toArray(String.class)));
        }

        public Stream<String> stream() {
            return this.elementCount() > 0 ? Stream.of(this.elements) : Stream.empty();
        }

        public StringDelimiter join(@Nullable StringDelimiter other) {
            return other != null ? new StringDelimiter(this.delimiter, _Arrays.combine(this.elements, other.elements)) : this;
        }

        public int elementCount() {
            return this.elements.length;
        }

        public String asDelimitedString() {
            return this.stream().collect(Collectors.joining(this.delimiter));
        }

        public String toString() {
            return String.format("StringDelimiter[delimiter=%s,elements=%s]", this.delimiter, Arrays.asList(this.elements));
        }

        public StringDelimiter withDelimiter(@NonNull String newDelimiter) {
            if (newDelimiter == null) {
                throw new NullPointerException("newDelimiter is marked non-null but is null");
            }
            return new StringDelimiter(newDelimiter, this.elements);
        }

        @Generated
        private StringDelimiter(@NonNull String delimiter, @NonNull String[] elements) {
            if (delimiter == null) {
                throw new NullPointerException("delimiter is marked non-null but is null");
            }
            if (elements == null) {
                throw new NullPointerException("elements is marked non-null but is null");
            }
            this.delimiter = delimiter;
            this.elements = elements;
        }

        @Generated
        private static StringDelimiter of(@NonNull String delimiter, @NonNull String[] elements) {
            if (delimiter == null) {
                throw new NullPointerException("delimiter is marked non-null but is null");
            }
            if (elements == null) {
                throw new NullPointerException("elements is marked non-null but is null");
            }
            return new StringDelimiter(delimiter, elements);
        }

        @NonNull
        @Generated
        public String getDelimiter() {
            return this.delimiter;
        }
    }

    public static final class StringCutter {
        @NonNull
        private final String value;

        public StringCutter map(@NonNull UnaryOperator<String> mapper) {
            if (mapper == null) {
                throw new NullPointerException("mapper is marked non-null but is null");
            }
            return StringCutter.of((String)mapper.apply(this.value));
        }

        public boolean contains(@Nullable CharSequence str) {
            return _Strings.isNullOrEmpty(str) ? false : this.value.contains(str);
        }

        public StringCutter dropBefore(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.indexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(index));
            }
            return this;
        }

        public StringCutter dropAfter(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.indexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(0, index + str.length()));
            }
            return this;
        }

        public StringCutter dropBeforeLast(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.lastIndexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(index));
            }
            return this;
        }

        public StringCutter dropAfterLast(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.lastIndexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(0, index + str.length()));
            }
            return this;
        }

        public StringCutter keepBefore(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.indexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(0, index));
            }
            return this;
        }

        public StringCutter keepAfter(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.indexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(index + str.length()));
            }
            return this;
        }

        public StringCutter keepBeforeLast(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.lastIndexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(0, index));
            }
            return this;
        }

        public StringCutter keepAfterLast(@NonNull String str) {
            if (str == null) {
                throw new NullPointerException("str is marked non-null but is null");
            }
            _Assert.assertNotEmpty(str, this::matcherNotEmptyMsg);
            int index = this.value.lastIndexOf(str);
            if (index > -1) {
                return StringCutter.of(this.value.substring(index + str.length()));
            }
            return this;
        }

        private String matcherNotEmptyMsg() {
            return "can only match search and match for non-empty string";
        }

        @Generated
        private StringCutter(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @Generated
        private static StringCutter of(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return new StringCutter(value);
        }

        @NonNull
        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

