/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings_CamelCase;
import org.apache.causeway.commons.internal.base._Strings_FastSplit;
import org.apache.causeway.commons.internal.base._Strings_HtmlEscaper;
import org.apache.causeway.commons.internal.base._Strings_KeyValuePair;
import org.apache.causeway.commons.internal.base._Strings_NaturalName;
import org.apache.causeway.commons.internal.base._Strings_SplitIterator;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _Strings {
    public static final String[] emptyArray = new String[0];
    public static final StringOperator asLowerCase = _Strings::lower;
    public static final StringOperator asUpperCase = _Strings::upper;
    public static final StringOperator asCapitalized = _Strings::capitalize;
    public static final StringOperator asDecapitalized = _Strings::decapitalize;
    public static final StringOperator asDoubleQuoted = _Strings.bracketed("\"", "\"");
    public static final StringOperator asSquareBracketed = _Strings.bracketed("[", "]");
    public static final StringOperator asParenthesisBracketed = _Strings.bracketed("(", ")");
    public static final StringOperator asCurlyBracketed = _Strings.bracketed("{", "}");
    public static final StringOperator asLowerDashed = asLowerCase.compose(s -> _Strings.condenseWhitespaces(s, "-"));
    public static final StringOperator asNormalized = s -> _Strings.condenseWhitespaces(s, " ");
    public static final StringOperator asNaturalName = s -> _Strings_NaturalName.naturalName(s, true);
    public static final StringOperator asCamelCase = s -> _Strings_CamelCase.camelCase(s, firstToken -> firstToken);
    public static final StringOperator asCamelCaseDecapitalized = s -> _Strings_CamelCase.camelCase(s, asDecapitalized);
    public static final StringOperator asCamelCaseCapitalized;
    public static final StringOperator asPascalCase;

    public static KeyValuePair pair(String key, String value) {
        return new _Strings_KeyValuePair(key, value);
    }

    public static Optional<KeyValuePair> parseKeyValuePair(@Nullable String keyValueLiteral, char separator) {
        return _Strings_KeyValuePair.parse(keyValueLiteral, separator);
    }

    public static String of(int length, char c) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    public static int compareNullsFirst(@Nullable String a, @Nullable String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int compareNullsLast(@Nullable String a, @Nullable String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo(b);
    }

    public static boolean isEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence x) {
        return x != null && x.length() != 0;
    }

    public static Optional<String> nonEmpty(@Nullable CharSequence x) {
        return _Strings.isEmpty(x) ? Optional.empty() : Optional.of(x.toString());
    }

    public static @Nullable String emptyToNull(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return null;
        }
        return input;
    }

    public static @Nullable String blankToNullOrTrim(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return null;
        }
        return input.isBlank() ? null : input.trim();
    }

    public static String nullToEmpty(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static String trim(@Nullable String input) {
        return _Strings.mapIfPresentElseNull(input, String::trim);
    }

    public static String lower(@Nullable String input) {
        return _Strings.mapIfPresentElseNull(input, String::toLowerCase);
    }

    public static String upper(@Nullable String input) {
        return _Strings.mapIfPresentElseNull(input, String::toUpperCase);
    }

    public static @Nullable String capitalize(@Nullable String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static @Nullable String decapitalize(@Nullable String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return input.toLowerCase();
        }
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    public static String requireNonEmpty(@Nullable String str, String identifier) {
        if (str == null) {
            throw new NullPointerException(String.format("'%s' is required to be present (not null).", identifier));
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(String.format("'%s' is required to be present and not empty.", identifier));
        }
        return str;
    }

    public static @Nullable String htmlEscape(@Nullable String source) {
        return _Strings_HtmlEscaper.htmlEscape(source);
    }

    public static boolean isUrlSafe(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return true;
        }
        try {
            URI testDummyUri = new URI("http://localhost/?" + input);
            String asQuery = testDummyUri.getQuery();
            return input.equals(asQuery);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String format(String template, Map<String, Object> parameters) {
        StringBuilder newTemplate = new StringBuilder(template);
        ArrayList<Object> valueList = new ArrayList<Object>();
        Matcher matcher = Pattern.compile("[$][{](\\w+)}").matcher(template);
        while (matcher.find()) {
            String key = matcher.group(1);
            String paramName = "${" + key + "}";
            int index = newTemplate.indexOf(paramName);
            if (index == -1) continue;
            newTemplate.replace(index, index + paramName.length(), "%s");
            valueList.add(parameters.get(key));
        }
        return String.format(newTemplate.toString(), valueList.toArray());
    }

    public static @Nullable String prefix(@Nullable String input, @NonNull String prefix) {
        if (input == null) {
            return null;
        }
        if (input.startsWith(prefix)) {
            return input;
        }
        return prefix + input;
    }

    public static @Nullable String suffix(@Nullable String input, @NonNull String suffix) {
        if (input == null) {
            return null;
        }
        if (input.endsWith(suffix)) {
            return input;
        }
        return input + suffix;
    }

    public static @Nullable String removePrefix(@Nullable String input, @NonNull String prefix) {
        if (input == null) {
            return null;
        }
        return input.startsWith(prefix) ? input.substring(prefix.length()) : input;
    }

    public static final StringOperator bracketed(@NonNull String prefix, @NonNull String suffix) {
        return s -> s != null ? prefix + s + suffix : null;
    }

    public static String combineWithDelimiter(@Nullable String left, @Nullable String right, String delimiter) {
        _Strings.requireNonEmpty(delimiter, "pathDelimiter");
        if (_Strings.isNullOrEmpty(left) && _Strings.isNullOrEmpty(right)) {
            return "";
        }
        if (_Strings.isNullOrEmpty(left)) {
            return right;
        }
        if (_Strings.isNullOrEmpty(right)) {
            return left;
        }
        if (left.endsWith(delimiter) || right.startsWith(delimiter)) {
            return left + right;
        }
        return left + delimiter + right;
    }

    public static String padStart(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.of(fillCount, c) + _Strings.nullToEmpty(str);
    }

    public static String padEnd(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.nullToEmpty(str) + _Strings.of(fillCount, c);
    }

    public static String substring(@Nullable String str, int beginIndex, int endIndex) {
        if (_Strings.isEmpty(str)) {
            return str;
        }
        int maxIndex = str.length() - 1;
        int i0 = beginIndex > 0 ? Math.min(beginIndex, maxIndex) : 0;
        int i1 = Math.min(maxIndex + 1, endIndex < 0 ? str.length() + endIndex : endIndex);
        return i0 < i1 ? str.substring(i0, i1) : "";
    }

    public static Stream<String> splitThenStream(@Nullable String input, String separator) {
        if (_Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("a non empty separator is required");
        }
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        if (!input.contains(separator)) {
            return Stream.of(input);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(_Strings_SplitIterator.splitIterator(input, separator), 16), false);
    }

    public static Stream<String> splitThenStream(@Nullable CharSequence input, @NonNull Pattern delimiterPattern) {
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        return delimiterPattern.splitAsStream(input);
    }

    public static <T> Optional<T> splitThenApplyRequireNonEmpty(@Nullable String input, String separator, BiFunction<String, String, T> onNonEmptySplit) {
        if (_Strings.isEmpty(input)) {
            return Optional.empty();
        }
        int p = input.indexOf(separator);
        if (p < 1) {
            return Optional.empty();
        }
        int q = p + separator.length();
        if (q == input.length()) {
            return Optional.empty();
        }
        return Optional.ofNullable(onNonEmptySplit.apply(input.substring(0, p), input.substring(q)));
    }

    public static void splitThenAccept(@Nullable String input, String separator, BiConsumer<String, String> onNonEmptySplit, Consumer<String> onNonEmptyLhs, Consumer<String> onNonEmptyRhs) {
        _Strings_FastSplit.splitThenAccept(input, separator, onNonEmptySplit, onNonEmptyLhs, onNonEmptyRhs);
    }

    public static void splitThenAcceptEmptyAsNull(@Nullable String input, String separator, BiConsumer<String, String> onSplit) {
        _Strings_FastSplit.splitThenAccept(input, separator, onSplit, lhs -> onSplit.accept((String)lhs, (String)null), rhs -> onSplit.accept((String)null, (String)rhs));
    }

    public static Stream<String> grep(@Nullable String input, @Nullable Predicate<String> matcher) {
        matcher = matcher != null ? matcher : _Predicates.alwaysTrue();
        return _Strings.splitThenStream(input, "\n").filter(_Strings::isNotEmpty).filter(matcher).map(s -> s.replace("\r", ""));
    }

    public static Stream<String> grep(@Nullable String input, @Nullable String contains) {
        Predicate<String> matcher = contains != null ? line -> line.contains(contains) : _Predicates.alwaysTrue();
        return _Strings.grep(input, matcher);
    }

    public static String condenseWhitespaces(@Nullable String input, @NonNull String replacement) {
        return _Strings.mapIfPresentElseNull(input, __ -> input.replaceAll("\\s+", replacement));
    }

    public static String ellipsifyAtStart(@Nullable CharSequence input, int maxLength, @NonNull CharSequence ellipsis) {
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input.toString();
        }
        int trimmedLength = maxLength - ellipsis.length();
        int end = input.length();
        int start = end - trimmedLength;
        return String.join((CharSequence)"", ellipsis, input.subSequence(start, end));
    }

    public static String ellipsifyAtEnd(@Nullable CharSequence input, int maxLength, @NonNull CharSequence ellipsis) {
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input.toString();
        }
        int trimmedLength = maxLength - ellipsis.length();
        return String.join((CharSequence)"", input.subSequence(0, trimmedLength), ellipsis);
    }

    public static String read(@Nullable InputStream input, @NonNull Charset charset) {
        if (input == null) {
            return "";
        }
        try (Scanner scanner = new Scanner(input, charset.name());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public static String readFromResource(@NonNull Class<?> resourceLocation, @NonNull String resourceName, @NonNull Charset charset) {
        String string;
        block8: {
            InputStream input = resourceLocation.getResourceAsStream(resourceName);
            try {
                string = _Strings.read(input, charset);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return string;
    }

    public static String print(@NonNull Consumer<PrintStream> printer, @NonNull Charset charset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, charset);){
            printer.accept(ps);
        }
        return baos.toString(charset);
    }

    public static String printUtf8(@NonNull Consumer<PrintStream> printer) {
        return _Strings.print(printer, StandardCharsets.UTF_8);
    }

    public static final byte[] toBytes(@Nullable String str, @NonNull Charset charset) {
        return Optional.ofNullable(str).map(s -> s.getBytes(charset)).orElse(null);
    }

    public static final String ofBytes(@Nullable byte[] bytes, @NonNull Charset charset) {
        return Optional.ofNullable(bytes).map(b -> new String((byte[])b, charset)).orElse(null);
    }

    public static final String ofCodePoints(@Nullable IntStream codePoints) {
        if (codePoints == null) {
            return null;
        }
        return codePoints.collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static final String convert(@Nullable String input, @NonNull _Bytes.BytesOperator converter, @NonNull Charset charset) {
        return _Strings.mapIfPresentElseNull(input, __ -> _Strings.ofBytes(converter.apply(_Strings.toBytes(input, charset)), charset));
    }

    public static final String asFileNameWithExtension(@NonNull String fileName, @NonNull String fileExtension) {
        return _Strings.suffix(fileName, _Strings.prefix(fileExtension, "."));
    }

    public static final String asFileNameWithExtension(@NonNull String fileName, @NonNull Can<String> proposedFileExtensions) {
        switch (proposedFileExtensions.getCardinality()) {
            case ZERO: {
                return fileName;
            }
            case ONE: {
                return _Strings.asFileNameWithExtension(fileName, proposedFileExtensions.getFirst().orElse(""));
            }
        }
        String fileNameLower = fileName.toLowerCase();
        boolean isAlreadyExended = proposedFileExtensions.stream().map(ext -> ext.toLowerCase()).anyMatch(ext -> fileNameLower.endsWith("." + ext));
        return isAlreadyExended ? fileName : _Strings.asFileNameWithExtension(fileName, proposedFileExtensions.getFirst().orElse(""));
    }

    public static String baseName(@NonNull String methodName) {
        String asPrefixDropped = _Strings.isNotEmpty(methodName) ? _Strings.ofCodePoints(methodName.codePoints().dropWhile(c -> c != 95 && Character.isLowerCase(c))) : "";
        String baseName = asPrefixDropped.isEmpty() ? methodName : asPrefixDropped;
        String javaBaseName = _Strings.capitalize(baseName.trim());
        _Assert.assertNotEmpty(javaBaseName, () -> String.format("framework bug: could not create a base name from '%s'", methodName));
        return javaBaseName;
    }

    public static final String asRegularSpaces(@Nullable CharSequence chars) {
        return _Strings.isNotEmpty(chars) ? _Strings.ofCodePoints(chars.codePoints().map(_Strings::toRegularSpaceCharacter)) : (chars != null ? "" : null);
    }

    public static Stream<String> splitThenStreamTrimmed(@Nullable String input, String separator) {
        return _Strings.splitThenStream(input, separator).map(String::trim).filter(_Predicates.not(String::isEmpty));
    }

    public static Stream<String> splitThenStreamTrimmed(@Nullable CharSequence input, Pattern delimiterPattern) {
        return _Strings.splitThenStream(input, delimiterPattern).map(String::trim).filter(_Predicates.not(String::isEmpty));
    }

    public static String base64UrlDecode(@Nullable String str) {
        return _Strings.convert(str, _Bytes.ofUrlBase64, StandardCharsets.UTF_8);
    }

    public static String base64UrlEncode(@Nullable String str) {
        return _Strings.convert(str, _Bytes.asUrlBase64, StandardCharsets.UTF_8);
    }

    public static String base64UrlDecodeZlibCompressed(@Nullable String str) {
        return _Strings.convert(str, _Bytes.ofZlibCompressedUrlBase64, StandardCharsets.UTF_8);
    }

    public static String base64UrlEncodeZlibCompressed(@Nullable String str) {
        return _Strings.convert(str, _Bytes.asZlibCompressedUrlBase64, StandardCharsets.UTF_8);
    }

    public static int toRegularSpaceCharacter(int codePoint) {
        switch (codePoint) {
            case 160: 
            case 8201: 
            case 8239: {
                return 32;
            }
        }
        return codePoint;
    }

    public static String trimmed(String str, int lengthOfField) {
        if (str == null) {
            return null;
        }
        if (str.length() > lengthOfField) {
            return str.substring(0, lengthOfField - 3) + "...";
        }
        return str;
    }

    public static String nullIfExceeds(String str, int maxLength) {
        return str == null || str.length() > maxLength ? null : str;
    }

    private static String mapIfPresentElseNull(@Nullable String obj, @NonNull UnaryOperator<String> mapper) {
        return obj != null ? (String)mapper.apply(obj) : null;
    }

    @Generated
    private _Strings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        asPascalCase = asCamelCaseCapitalized = s -> _Strings_CamelCase.camelCase(s, asCapitalized);
    }

    @FunctionalInterface
    public static interface StringOperator
    extends UnaryOperator<String> {
        default public StringOperator compose(UnaryOperator<String> andThen) {
            return str -> (String)this.andThen(andThen).apply((String)str);
        }

        public static StringOperator identity() {
            return s -> s;
        }
    }

    public static interface KeyValuePair {
        public String key();

        public String value();
    }
}

