/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.resources;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _Resources {
    private static final Predicate<String> externalResourcePattern = Pattern.compile("^\\w+?://.*$").asPredicate();

    public static URL url(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (_Strings.condenseWhitespaces(url.toLowerCase(), "").contains("javascript:")) {
            throw new IllegalArgumentException("Not parseable as an URL ('" + url + "').");
        }
        return new URI(url).toURL();
    }

    public static @Nullable InputStream load(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        String absoluteResourceName = _Resources.resolveName(contextClass, resourceName);
        return Optional.ofNullable(contextClass.getResourceAsStream(absoluteResourceName)).orElseGet(() -> _Context.getDefaultClassLoader().getResourceAsStream(absoluteResourceName));
    }

    public static @Nullable String loadAsString(@NonNull Class<?> contextClass, @NonNull String resourceName, @NonNull Charset charset) {
        InputStream inputStream = _Resources.load(contextClass, resourceName);
        return _Strings.ofBytes(_Bytes.of(inputStream), charset);
    }

    public static @Nullable String loadAsStringUtf8(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        return _Resources.loadAsString(contextClass, resourceName, StandardCharsets.UTF_8);
    }

    public static String loadAsStringUtf8ElseFail(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        try {
            String content = _Resources.loadAsStringUtf8(contextClass, resourceName);
            if (content == null) {
                throw _Exceptions.illegalState("Failed to locate resource '%s' relative to class %s", resourceName, contextClass.getName());
            }
            return content;
        }
        catch (Exception e) {
            throw _Exceptions.illegalState(e, "Failed to read resource '%s' relative to class %s", resourceName, contextClass.getName());
        }
    }

    public static @Nullable URL getResourceUrl(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        String absoluteResourceName = _Resources.resolveName(contextClass, resourceName);
        return Optional.ofNullable(contextClass.getResource(absoluteResourceName)).orElseGet(() -> _Context.getDefaultClassLoader().getResource(absoluteResourceName));
    }

    public static boolean isLocalResource(@NonNull String resourcePath) {
        return !externalResourcePattern.test(resourcePath);
    }

    public static String combinePath(@Nullable String extendee, @Nullable String suffix) {
        return _Strings.combineWithDelimiter(extendee, suffix, "/");
    }

    private static String resolveName(Class<?> contextClass, String name) {
        if (name == null) {
            return name;
        }
        if (!((String)name).startsWith("/")) {
            Class<?> c = contextClass;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + (String)name;
            }
        } else {
            name = ((String)name).substring(1);
        }
        return name;
    }
}

