/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;

public class _Serializables {
    public static byte[] write(@NonNull Serializable object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(65536);
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(object);
            oos.flush();
        }
        return bos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T read(@NonNull Class<T> requiredClass, @NonNull InputStream content) {
        try (ObjectInputStream ois = new ObjectInputStream(content);){
            Object pojo = ois.readObject();
            if (!requiredClass.isAssignableFrom(pojo.getClass())) {
                throw _Exceptions.unrecoverable("de-serializion of input stream did not yield an object of required type %s", requiredClass.getName());
            }
            Serializable serializable = (Serializable)_Casts.uncheckedCast(pojo);
            return (T)serializable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T read(@NonNull Class<T> requiredClass, @NonNull byte[] input) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(input);){
            T t = _Serializables.read(requiredClass, bis);
            return t;
        }
    }
}

