/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.apache.causeway.commons.io.DataPeer;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.util.function.ThrowingConsumer;

public final class ZipUtils {
    public static Stream<ZipEntryDataSource> streamZipEntries(@NonNull DataSource zippedSource, @NonNull ZipOptions zipOptions) {
        ArrayList zipEntryDataSources = _Lists.newArrayList();
        zippedSource.consumeAsFile((ThrowingConsumer<File>)((ThrowingConsumer)zipFile -> {
            try (FileSystem fs = FileSystems.newFileSystem(zipFile.toPath());
                 Stream<Path> entries = Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0]);){
                List filesInZip = entries.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path path : filesInZip) {
                    ZipEntry zipEntry = new ZipEntry(path.toString());
                    if (!zipOptions.zipEntryFilter().test(zipEntry)) continue;
                    byte[] bytes = Files.readAllBytes(path);
                    zipEntryDataSources.add(new ZipEntryDataSource(zipEntry, bytes));
                }
            }
        }));
        return zipEntryDataSources.stream();
    }

    public static Stream<ZipEntryDataSource> streamZipEntries(@NonNull DataSource zippedSource) {
        return ZipUtils.streamZipEntries(zippedSource, ZipOptions.builder().build());
    }

    public static Optional<ZipEntryDataSource> firstZipEntry(@NonNull DataSource zippedSource, @NonNull ZipOptions zipOptions) {
        ArrayList zipEntryDataSources = _Lists.newArrayList(1);
        zippedSource.tryReadAndAccept((ThrowingConsumer<InputStream>)((ThrowingConsumer)is -> {
            try (ZipInputStream in = new ZipInputStream((InputStream)new BufferedInputStream((InputStream)is, zipOptions.bufferSize()), zipOptions.zipEntryCharset());){
                ZipEntry zipEntry;
                while ((zipEntry = in.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipOptions.zipEntryFilter().test(zipEntry)) continue;
                    zipEntryDataSources.add(new ZipEntryDataSource(zipEntry, _Bytes.ofKeepOpen(in)));
                    return;
                }
            }
        })).ifFailureFail();
        return _Lists.firstElement(zipEntryDataSources);
    }

    public static Optional<ZipEntryDataSource> firstZipEntry(@NonNull DataSource zippedSource) {
        return ZipUtils.firstZipEntry(zippedSource, ZipOptions.builder().build());
    }

    public static byte[] zipToBytes(@NonNull Stream<ZipEntryDataSource> entryStream) {
        DataPeer buffer = DataPeer.inMemory(16384);
        ZipUtils.writeTo(entryStream, buffer);
        return buffer.bytes();
    }

    public static void writeTo(@NonNull Stream<ZipEntryDataSource> entryStream, @NonNull DataSink dataSink) {
        dataSink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> {
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
                entryStream.forEach(entry -> entry.writeTo(zos));
            }
        }));
    }

    public static EntryBuilder zipEntryBuilder() {
        return new EntryBuilder();
    }

    @Generated
    private ZipUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record ZipOptions(int bufferSize, @NonNull Charset zipEntryCharset, @NonNull Predicate<ZipEntry> zipEntryFilter) {
        public ZipOptions(int bufferSize, Charset zipEntryCharset, Predicate<ZipEntry> zipEntryFilter) {
            this.bufferSize = bufferSize > 0 ? bufferSize : 65536;
            this.zipEntryCharset = zipEntryCharset != null ? zipEntryCharset : StandardCharsets.UTF_8;
            this.zipEntryFilter = zipEntryFilter != null ? zipEntryFilter : _Predicates.alwaysTrue();
        }

        @Generated
        public static ZipOptionsBuilder builder() {
            return new ZipOptionsBuilder();
        }

        @Generated
        public static class ZipOptionsBuilder {
            @Generated
            private int bufferSize;
            @Generated
            private Charset zipEntryCharset;
            @Generated
            private Predicate<ZipEntry> zipEntryFilter;

            @Generated
            ZipOptionsBuilder() {
            }

            @Generated
            public ZipOptionsBuilder bufferSize(int bufferSize) {
                this.bufferSize = bufferSize;
                return this;
            }

            @Generated
            public ZipOptionsBuilder zipEntryCharset(@NonNull Charset zipEntryCharset) {
                if (zipEntryCharset == null) {
                    throw new NullPointerException("zipEntryCharset is marked non-null but is null");
                }
                this.zipEntryCharset = zipEntryCharset;
                return this;
            }

            @Generated
            public ZipOptionsBuilder zipEntryFilter(@NonNull Predicate<ZipEntry> zipEntryFilter) {
                if (zipEntryFilter == null) {
                    throw new NullPointerException("zipEntryFilter is marked non-null but is null");
                }
                this.zipEntryFilter = zipEntryFilter;
                return this;
            }

            @Generated
            public ZipOptions build() {
                return new ZipOptions(this.bufferSize, this.zipEntryCharset, this.zipEntryFilter);
            }

            @Generated
            public String toString() {
                return "ZipUtils.ZipOptions.ZipOptionsBuilder(bufferSize=" + this.bufferSize + ", zipEntryCharset=" + String.valueOf(this.zipEntryCharset) + ", zipEntryFilter=" + String.valueOf(this.zipEntryFilter) + ")";
            }
        }
    }

    public static class EntryBuilder {
        private final List<ZipEntryDataSource> entries = new ArrayList<ZipEntryDataSource>();

        public EntryBuilder add(@NonNull ZipEntryDataSource zipEntryDataSource) {
            this.entries.add(zipEntryDataSource);
            return this;
        }

        public EntryBuilder add(@NonNull String entryName, @Nullable byte[] bytes) {
            return this.add(ZipEntryDataSource.of(new ZipEntry(entryName), bytes));
        }

        public EntryBuilder add(@NonNull String entryName, @NonNull DataSource dataSource) {
            return this.add(entryName, dataSource.bytes());
        }

        public EntryBuilder add(@NonNull String entryName, @Nullable String string, @NonNull Charset charset) {
            return this.add(entryName, _Strings.toBytes(string, charset));
        }

        public EntryBuilder addAsUtf8(@NonNull String entryName, @Nullable String string) {
            return this.add(entryName, _Strings.toBytes(string, StandardCharsets.UTF_8));
        }

        public Stream<ZipEntryDataSource> stream() {
            return this.entries.stream();
        }

        public void writeTo(DataSink dataSink) {
            ZipUtils.writeTo(this.stream(), dataSink);
        }

        public byte[] toBytes() {
            return ZipUtils.zipToBytes(this.stream());
        }
    }

    public record ZipEntryDataSource(ZipEntry zipEntry, byte[] bytes) implements DataSource
    {
        @Override
        public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
            Try<T> try_;
            ByteArrayInputStream bis = new ByteArrayInputStream(this.bytes);
            try {
                try_ = consumingMapper.apply(bis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return Try.failure(e);
                }
            }
            bis.close();
            return try_;
        }

        public static ZipEntryDataSource of(@NonNull ZipEntry zipEntry, @Nullable byte[] bytes) {
            return new ZipEntryDataSource(zipEntry, _NullSafe.toNonNull(bytes));
        }

        public static ZipEntryDataSource of(@NonNull ZipEntry zipEntry, @NonNull DataSource dataSource) {
            return ZipEntryDataSource.of(zipEntry, dataSource.bytes());
        }

        void writeTo(ZipOutputStream zipOutputStream) {
            zipOutputStream.putNextEntry(this.zipEntry());
            if (!_NullSafe.isEmpty(this.bytes)) {
                zipOutputStream.write(this.bytes);
            }
            zipOutputStream.closeEntry();
        }
    }
}

