/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.primitives._Ints;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class _Images {
    private static final int[] BitMask8888 = new int[]{0xFF0000, 65280, 255, -16777216};

    public static byte[] toBytes(@NonNull BufferedImage image) {
        byte[] byArray;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);){
            ImageIO.write((RenderedImage)image, "png", bos);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    public static BufferedImage fromBytes(@NonNull byte[] imageData) {
        BufferedImage bufferedImage;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(imageData);){
            bufferedImage = ImageIO.read(bis);
        }
        return bufferedImage;
    }

    public static String toBase64(@NonNull BufferedImage image) {
        return new String(_Bytes.asUrlBase64.apply(_Images.toBytes(image)), StandardCharsets.UTF_8);
    }

    public static BufferedImage fromBase64(@NonNull String base64ImageData) {
        byte[] imageData = _Bytes.ofUrlBase64.apply(base64ImageData.getBytes(StandardCharsets.UTF_8));
        return _Images.fromBytes(imageData);
    }

    public static @Nullable int[][] toPixels(@Nullable BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] pixels = new int[height][width];
        for (int lineIndex = 0; lineIndex < height; ++lineIndex) {
            image.getRGB(0, lineIndex, width, 1, pixels[lineIndex], 0, width);
        }
        return pixels;
    }

    public static @Nullable BufferedImage fromPixels(@Nullable int[][] pixels) {
        int height = _NullSafe.size(pixels);
        int width = height > 0 ? _NullSafe.size(pixels[0]) : 0;
        int pixelCount = width * height;
        if (pixelCount > 0) {
            WritableRaster raster = _Images.createRasterARGB8888(pixels);
            return _Images.createImageARGB8888(raster);
        }
        return null;
    }

    private static WritableRaster createRasterARGB8888(int[][] pixels) {
        int height = pixels.length;
        int width = pixels[0].length;
        return _Images.createRasterARGB8888(width, height, _Ints.flatten(pixels));
    }

    private static WritableRaster createRasterARGB8888(int width, int height, int[] dataArray) {
        DataBufferInt dataBuffer = new DataBufferInt(dataArray, width * height);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), width, height, BitMask8888);
        return Raster.createWritableRaster(sampleModel, dataBuffer, null);
    }

    private static BufferedImage createImageARGB8888(WritableRaster raster) {
        DirectColorModel directColorModel = new DirectColorModel(32, BitMask8888[0], BitMask8888[1], BitMask8888[2], BitMask8888[3]);
        return new BufferedImage(directColorModel, raster, false, null);
    }

    public static int compare(BufferedImage a, BufferedImage b) {
        int c = Integer.compare(a.getWidth(), b.getWidth());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(a.getHeight(), b.getHeight());
        if (c != 0) {
            return c;
        }
        for (int x = 0; x < a.getWidth(); ++x) {
            for (int y = 0; y < a.getHeight(); ++y) {
                c = Integer.compare(a.getRGB(x, y), b.getRGB(x, y));
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    public static BufferedImage resizeToMaxHeight(BufferedImage originalImage, int maxHeight) {
        if (originalImage.getHeight() <= maxHeight) {
            return originalImage;
        }
        int targetHeight = maxHeight;
        int targetWidth = (int)((long)(originalImage.getWidth() * targetHeight) / (long)originalImage.getHeight());
        Image scaledImage = originalImage.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage virtualImage = new BufferedImage(targetWidth, targetHeight, 2);
        return _Images.draw(scaledImage, virtualImage);
    }

    private static BufferedImage draw(Image image, BufferedImage bufferedImage) {
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }
}

