/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._ClassCache;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.apache.causeway.commons.semantics.CollectionSemantics;
import org.jspecify.annotations.NonNull;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public final class _GenericResolver {
    public static ResolvedType forPluralType(@NonNull Class<?> pluralType, @NonNull CollectionSemantics collectionSemantics) {
        ResolvableType resolvablePluralType = ResolvableType.forClass(pluralType);
        ResolvableType genericTypeArg = resolvablePluralType.isArray() ? resolvablePluralType.getComponentType() : resolvablePluralType.getGeneric(new int[]{0});
        return ResolvedType.plural(genericTypeArg.toClass(), pluralType, collectionSemantics);
    }

    public static ResolvedType forConstructorParameter(ResolvedConstructor resolvedConstructor, int paramIndex) {
        Class<?> paramType = resolvedConstructor.paramType(paramIndex);
        return CollectionSemantics.valueOf(paramType).map(collectionSemantics -> ResolvedType.plural(resolvedConstructor.resolveFirstGenericTypeArgumentOnParameter(paramIndex), paramType, collectionSemantics)).orElseGet(() -> ResolvedType.singular(paramType));
    }

    public static ResolvedType forMethodReturn(ResolvedMethod resolvedMethod) {
        Class<?> methodReturn = resolvedMethod.returnType();
        return CollectionSemantics.valueOf(methodReturn).map(collectionSemantics -> ResolvedType.plural(resolvedMethod.resolveGenericTypeArgumentOnMethodReturn(collectionSemantics.genericTypeArgumentIndex()), methodReturn, collectionSemantics)).orElseGet(() -> ResolvedType.singular(methodReturn));
    }

    public static ResolvedType forMethodParameter(ResolvedMethod resolvedMethod, int paramIndex) {
        Class<?> paramType = resolvedMethod.paramType(paramIndex);
        return CollectionSemantics.valueOf(paramType).map(collectionSemantics -> ResolvedType.plural(resolvedMethod.resolveFirstGenericTypeArgumentOnParameter(paramIndex), paramType, collectionSemantics)).orElseGet(() -> ResolvedType.singular(paramType));
    }

    public static Optional<ResolvedMethod> resolveMethod(@NonNull Method method, @NonNull Class<?> implementationClass) {
        return new SimpleResolvedMethod(method, implementationClass).guardAgainstCannotResolve();
    }

    public static ResolvedConstructor resolveConstructor(@NonNull Constructor<?> constructor, @NonNull Class<?> implementationClass) {
        return new SimpleResolvedConstructor(constructor, implementationClass);
    }

    private static Class<?>[] resolveParameterTypes(Executable executable, Class<?> implementationClass) {
        Class[] array = new Class[executable.getParameterCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = GenericTypeResolver.resolveParameterType((MethodParameter)_GenericResolver.methodParameter(executable, i), implementationClass);
        }
        return array;
    }

    private static MethodParameter methodParameter(Executable executable, int paramIndex) {
        return executable instanceof Method ? new MethodParameter((Method)executable, paramIndex) : new MethodParameter((Constructor)executable, paramIndex);
    }

    private static ResolvedMethod mostSpecific(ResolvedMethod a, ResolvedMethod b) {
        if (a.equals(b)) {
            return b;
        }
        Class<?> implType = _Reflect.mostSpecificType(a.implementationClass(), b.implementationClass());
        Method m = BridgeMethodResolver.findBridgedMethod((Method)ClassUtils.getMostSpecificMethod((Method)a.method(), implType));
        if (m.isBridge()) {
            throw _Exceptions.unexpectedCodeReach();
        }
        if (a.method().equals(m)) {
            return a;
        }
        if (b.method().equals(m)) {
            return b;
        }
        return _GenericResolver.resolveMethod(m, implType).orElseThrow(() -> _Exceptions.illegalArgument("most specific method\n%s is not resolvable while deciding for methods\n%s or\n%s", m, a.method(), b.method()));
    }

    private static ResolvableType genericTypeArg(ResolvableType pluralType, int genericTypeArgumentIndex) {
        ResolvableType genericTypeArg = pluralType.isArray() ? pluralType.getComponentType() : pluralType.getGeneric(new int[]{genericTypeArgumentIndex});
        return genericTypeArg;
    }

    @Generated
    private _GenericResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface ResolvedType {
        public @NonNull Class<?> elementType();

        public @NonNull Optional<Class<?>> containerType();

        public @NonNull Optional<CollectionSemantics> collectionSemantics();

        default public boolean isSingular() {
            return this.containerType().isEmpty();
        }

        default public boolean isPlural() {
            return this.containerType().isPresent();
        }

        default public boolean isArray() {
            return this.containerType().map(Class::isArray).orElse(false);
        }

        default public boolean isSupportedForActionParameter() {
            return this.isSingular() || this.isArray() ? true : Objects.equals(this.containerType().orElse(null), this.collectionSemantics().map(CollectionSemantics::getContainerType).orElse(null));
        }

        default public ResolvedType withElementType(@NonNull Class<?> elementType) {
            return new SimpleTypeOfAnyCardinality(ResolvedType.assertSingular(elementType), this.containerType(), this.collectionSemantics());
        }

        public static ResolvedType singular(@NonNull Class<?> singularType) {
            return new SimpleTypeOfAnyCardinality(ResolvedType.assertSingular(singularType), Optional.empty(), Optional.empty());
        }

        public static ResolvedType plural(@NonNull Class<?> elementType, @NonNull Class<?> pluralType, @NonNull CollectionSemantics collectionSemantics) {
            if (CollectionSemantics.valueOf(elementType).isPresent()) {
                System.err.printf("nested plural detected %s: will fail later%n", elementType);
            }
            return new SimpleTypeOfAnyCardinality(ResolvedType.assertSingular(elementType), Optional.of(ResolvedType.assertPlural(pluralType)), Optional.of(collectionSemantics));
        }

        private static Class<?> assertSingular(@NonNull Class<?> singularType) {
            _Assert.assertEquals(Optional.empty(), CollectionSemantics.valueOf(singularType), () -> String.format("%s should not match any supported plural (collection) types", singularType));
            return singularType;
        }

        private static Class<?> assertPlural(@NonNull Class<?> pluralType) {
            _Assert.assertTrue(CollectionSemantics.valueOf(pluralType).isPresent(), () -> String.format("%s should match a supported plural (collection) type", pluralType));
            return pluralType;
        }
    }

    public static interface ResolvedConstructor {
        public Constructor<?> constructor();

        public Class<?> implementationClass();

        public Class<?>[] paramTypes();

        default public int paramCount() {
            return this.constructor().getParameterCount();
        }

        default public Class<?> paramType(int paramIndex) {
            return this.paramTypes()[paramIndex];
        }

        default public boolean isNoArg() {
            return this.paramCount() == 0;
        }

        default public boolean isSingleArg() {
            return this.paramCount() == 1;
        }

        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int var1);
    }

    public static interface ResolvedMethod {
        public Method method();

        public Stream<Annotation> streamAnnotations();

        public Class<?> implementationClass();

        public Class<?> returnType();

        public Class<?>[] paramTypes();

        default public String name() {
            return this.method().getName();
        }

        default public int paramCount() {
            return this.method().getParameterCount();
        }

        default public Class<?> paramType(int paramIndex) {
            return this.paramTypes()[paramIndex];
        }

        default public ResolvedMethod mostSpecific(ResolvedMethod other) {
            return _GenericResolver.mostSpecific(this, other);
        }

        default public boolean isStatic() {
            return Modifier.isStatic(this.method().getModifiers());
        }

        default public boolean isNoArg() {
            return this.paramCount() == 0;
        }

        default public boolean isSingleArg() {
            return this.paramCount() == 1;
        }

        default public boolean isReturnTypeATypeOf(Class<?> typeOf) {
            return typeOf.isAssignableFrom(this.returnType());
        }

        default public boolean isReturnTypeAnyTypeOf(Can<Class<?>> allowedReturnTypes) {
            return allowedReturnTypes.stream().anyMatch(this::isReturnTypeATypeOf);
        }

        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int var1);

        public Class<?> resolveGenericTypeArgumentOnMethodReturn(int var1);

        public static int methodCompare(ResolvedMethod a, ResolvedMethod b) {
            if (a.method().equals(b.method()) && a.implementationClass().equals(b.implementationClass())) {
                return 0;
            }
            int c = a.name().compareTo(b.name());
            if (c != 0) {
                return c;
            }
            c = Integer.compare(a.paramCount(), b.paramCount());
            if (c != 0) {
                return c;
            }
            Class<?>[] paramsA = a.paramTypes();
            Class<?>[] paramsB = b.paramTypes();
            for (int i = 0; i < a.paramCount(); ++i) {
                c = _Reflect.typesCompare(paramsA[i], paramsB[i]);
                if (c == 0) continue;
                return c;
            }
            c = _Reflect.typesCompare(a.returnType(), b.returnType());
            if (c != 0) {
                return _Reflect.shareSameTypeHierarchy(a.returnType(), b.returnType()) ? 0 : c;
            }
            return 0;
        }

        public static boolean methodsWeaklySame(ResolvedMethod a, ResolvedMethod b) {
            if (a.method().equals(b.method()) && a.implementationClass().equals(b.implementationClass())) {
                return true;
            }
            return a.name().equals(b.name()) && _Reflect.methodSignatureWeaklyMatch(a.paramTypes(), b.paramTypes());
        }
    }

    private record SimpleResolvedMethod(Method method, Class<?> implementationClass, Class<?>[] paramTypes, Class<?> returnType, boolean isResolved) implements ResolvedMethod
    {
        public SimpleResolvedMethod(Method method, Class<?> implementationClass) {
            this(method, implementationClass, _GenericResolver.resolveParameterTypes(method, implementationClass), GenericTypeResolver.resolveReturnType((Method)method, implementationClass), false);
        }

        public SimpleResolvedMethod(Method method, Class<?> implementationClass, Class<?>[] paramTypes, Class<?> returnType, boolean isResolved) {
            this.method = method;
            this.implementationClass = implementationClass;
            this.paramTypes = paramTypes;
            this.returnType = returnType;
            this.isResolved = this.isReturnTypeResolved() && this.areParamsResolved();
        }

        public Optional<ResolvedMethod> guardAgainstCannotResolve() {
            return this.isResolved ? Optional.of(this) : Optional.empty();
        }

        @Override
        public Class<?> resolveGenericTypeArgumentOnMethodReturn(int argumentIndex) {
            return _GenericResolver.genericTypeArg(ResolvableType.forMethodReturnType((Method)this.method, this.implementationClass), argumentIndex).toClass();
        }

        @Override
        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int paramIndex) {
            return _GenericResolver.genericTypeArg(ResolvableType.forMethodParameter((Method)this.method, (int)paramIndex, this.implementationClass), 0).toClass();
        }

        @Override
        public String toString() {
            return String.format("ResolvedMethod[%s#%s(%s)]", this.implementationClass.getName(), this.name(), Can.ofArray(this.paramTypes).stream().map(Class::getSimpleName).collect(Collectors.joining(",")));
        }

        @Override
        public final boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof SimpleResolvedMethod) {
                SimpleResolvedMethod other = (SimpleResolvedMethod)obj;
                bl = Objects.equals(this.method(), other.method()) && Objects.equals(this.implementationClass(), other.implementationClass());
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.method(), this.implementationClass());
        }

        private boolean areParamsResolved() {
            if (this.isNoArg()) {
                return true;
            }
            Type[] genericParameterTypes = this.method.getGenericParameterTypes();
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                if (!(genericParameterTypes[i] instanceof TypeVariable) || !this.paramTypes[i].equals(Object.class)) continue;
                return false;
            }
            return true;
        }

        private boolean isReturnTypeResolved() {
            if (!_Reflect.hasGenericReturn(this.method)) {
                return true;
            }
            return !this.returnType.equals(Object.class);
        }

        @Override
        public Stream<Annotation> streamAnnotations() {
            return Stream.concat(_NullSafe.stream(this.method().getAnnotatedReturnType().getAnnotations()), _NullSafe.stream(this.method().getAnnotations()));
        }
    }

    private static class SimpleResolvedConstructor
    implements ResolvedConstructor {
        private final Constructor<?> constructor;
        private final Class<?> implementationClass;
        private final Class<?>[] paramTypes;

        public SimpleResolvedConstructor(Constructor<?> constructor, Class<?> implementationClass) {
            this.constructor = constructor;
            this.implementationClass = implementationClass;
            this.paramTypes = _GenericResolver.resolveParameterTypes(constructor, implementationClass);
        }

        @Override
        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int paramIndex) {
            return _GenericResolver.genericTypeArg(ResolvableType.forConstructorParameter(this.constructor, (int)paramIndex, this.implementationClass), 0).toClass();
        }

        public String toString() {
            return String.format("ResolvedConstructor[%s(%s)]", this.implementationClass.getName(), Can.ofArray(this.paramTypes).stream().map(Class::getSimpleName).collect(Collectors.joining(",")));
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleResolvedConstructor)) {
                return false;
            }
            SimpleResolvedConstructor other = (SimpleResolvedConstructor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Constructor<?> this$constructor = this.constructor();
            Constructor<?> other$constructor = other.constructor();
            if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
                return false;
            }
            Class<?> this$implementationClass = this.implementationClass();
            Class<?> other$implementationClass = other.implementationClass();
            return !(this$implementationClass == null ? other$implementationClass != null : !this$implementationClass.equals(other$implementationClass));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleResolvedConstructor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Constructor<?> $constructor = this.constructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            Class<?> $implementationClass = this.implementationClass();
            result = result * 59 + ($implementationClass == null ? 43 : $implementationClass.hashCode());
            return result;
        }

        @Override
        @Generated
        public Constructor<?> constructor() {
            return this.constructor;
        }

        @Override
        @Generated
        public Class<?> implementationClass() {
            return this.implementationClass;
        }

        @Override
        @Generated
        public Class<?>[] paramTypes() {
            return this.paramTypes;
        }
    }

    public static final class testing {
        public static ResolvedMethod resolveMethod(@NonNull Class<?> implementationClass, @NonNull String methodName, Class<?> ... parameterTypes) {
            ResolvedMethod candidate = _ClassCache.getInstance().findMethodUniquelyByNameOrFail(implementationClass, methodName);
            Can<Class<?>> paramTypesFound = Can.ofArray(candidate.paramTypes());
            Can<Class<?>> paramTypesRequested = Can.ofArray(parameterTypes);
            _Assert.assertEquals(paramTypesFound, paramTypesRequested);
            return candidate;
        }

        @Generated
        private testing() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    private record SimpleTypeOfAnyCardinality(@NonNull Class<?> elementType, @NonNull Optional<Class<?>> containerType, @NonNull Optional<CollectionSemantics> collectionSemantics) implements ResolvedType
    {
    }
}

