/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.semantics;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableCollection;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.collections._Collections;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.semantics.MethodSets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CollectionSemantics {
    ARRAY((Class)Array.class, (InvocationHandlingPolicy)MethodSets.EMPTY){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return _Arrays.toArray((Collection)_Casts.uncheckedCast(plural), elementType);
        }
    }
    ,
    VECTOR((Class)Vector.class, (InvocationHandlingPolicy)MethodSets.LIST){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return new Vector(plural);
        }
    }
    ,
    LIST((Class)List.class, (InvocationHandlingPolicy)MethodSets.LIST){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return Collections.unmodifiableList(plural);
        }
    }
    ,
    SORTED_SET((Class)SortedSet.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return _Collections.asUnmodifiableSortedSet(plural);
        }
    }
    ,
    SET((Class)Set.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return _Collections.asUnmodifiableSet(plural);
        }
    }
    ,
    COLLECTION((Class)Collection.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return Collections.unmodifiableCollection(plural);
        }
    }
    ,
    CAN((Class)Can.class, (InvocationHandlingPolicy)MethodSets.CAN){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return Can.ofCollection(plural);
        }
    }
    ,
    IMMUTABLE_COLLECTION((Class)ImmutableCollection.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            return CAN.asContainerType(elementType, plural);
        }
    }
    ,
    MAP((Class)Map.class, (InvocationHandlingPolicy)MethodSets.MAP){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            throw new UnsupportedOperationException("A Map cannot be reconstructed from a Collection");
        }
    };

    private final Class<?> containerType;
    private final InvocationHandlingPolicy invocationHandlingPolicy;
    private static final ImmutableEnumSet<CollectionSemantics> all;
    private static final ImmutableEnumSet<CollectionSemantics> typeSubstitutors;

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isVector() {
        return this == VECTOR;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isCan() {
        return this == CAN;
    }

    public boolean isImmutableCollection() {
        return this == IMMUTABLE_COLLECTION;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isSetAny() {
        return this.isSet() || this.isSortedSet();
    }

    public static @Nullable Object toIterable(@Nullable Object pojo) {
        Collection collection;
        if (pojo instanceof Map) {
            Map map = (Map)((Object)pojo);
            collection = map.values();
        } else {
            collection = pojo;
        }
        return collection;
    }

    public static Optional<CollectionSemantics> valueOf(@Nullable Class<?> type) {
        if (type == null) {
            return Optional.empty();
        }
        return type.isArray() ? Optional.of(ARRAY) : all.stream().filter(collType -> collType.getContainerType().isAssignableFrom(type)).findFirst();
    }

    public static CollectionSemantics valueOfElseFail(@Nullable Class<?> type) {
        return CollectionSemantics.valueOf(type).orElseThrow(() -> _Exceptions.illegalArgument("failed to lookup CollectionSemantics for type %s", type));
    }

    public Object unmodifiableCopyOf(Class<?> elementType, @NonNull Iterable<?> nonScalar) {
        return this.asContainerType(elementType, _NullSafe.stream(nonScalar).collect(Collectors.toList()));
    }

    protected abstract Object asContainerType(Class<?> var1, @NonNull List<?> var2);

    public int genericTypeArgumentIndex() {
        return this.isMap() ? 1 : 0;
    }

    @Generated
    private CollectionSemantics(Class<?> containerType, InvocationHandlingPolicy invocationHandlingPolicy) {
        this.containerType = containerType;
        this.invocationHandlingPolicy = invocationHandlingPolicy;
    }

    @Generated
    public Class<?> getContainerType() {
        return this.containerType;
    }

    @Generated
    public InvocationHandlingPolicy getInvocationHandlingPolicy() {
        return this.invocationHandlingPolicy;
    }

    @Generated
    public static ImmutableEnumSet<CollectionSemantics> typeSubstitutors() {
        return typeSubstitutors;
    }

    static {
        all = ImmutableEnumSet.allOf(CollectionSemantics.class);
        typeSubstitutors = all.remove(ARRAY);
    }

    public static interface InvocationHandlingPolicy {
        public boolean intercepts(Method var1);

        public boolean vetoes(Method var1);
    }
}

