/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.causeway.commons.internal.base._Bytes_GZipCompressorSmart;
import org.apache.causeway.commons.internal.base._Bytes_ZLibCompressor;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _Bytes {
    private static final int BUFFER_SIZE = 16384;
    public static final BytesOperator asUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.encodeToBase64(Base64.getUrlEncoder(), bytes));
    public static final BytesOperator ofUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getUrlDecoder(), bytes));
    public static final BytesOperator asCompressedUrlBase64 = _Bytes.operator().andThen(_Bytes::compress).andThen(bytes -> _Bytes.encodeToBase64(Base64.getUrlEncoder(), bytes));
    public static final BytesOperator ofCompressedUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getUrlDecoder(), bytes)).andThen(_Bytes::decompress);
    public static final BytesOperator asZlibCompressedUrlBase64 = _Bytes.operator().andThen(_Bytes::compressZlib).andThen(bytes -> _Bytes.encodeToBase64(Base64.getUrlEncoder(), bytes));
    public static final BytesOperator ofZlibCompressedUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getUrlDecoder(), bytes)).andThen(_Bytes::decompressZlib);
    public static final BytesOperator asBase64 = _Bytes.operator().andThen(bytes -> _Bytes.encodeToBase64(Base64.getEncoder(), bytes));
    public static final BytesOperator ofBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getDecoder(), bytes));
    public static final BytesOperator asCompressedBase64 = _Bytes.operator().andThen(_Bytes::compress).andThen(bytes -> _Bytes.encodeToBase64(Base64.getEncoder(), bytes));
    public static final BytesOperator ofCompressedBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getDecoder(), bytes)).andThen(_Bytes::decompress);

    private _Bytes() {
    }

    public static byte[] of(@Nullable InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        try {
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int nRead;
                byte[] buffer = new byte[16384];
                while ((nRead = input.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, nRead);
                }
                bos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        finally {
            input.close();
        }
    }

    public static byte[] ofKeepOpen(@Nullable InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int nRead;
            byte[] buffer = new byte[16384];
            while ((nRead = input.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, nRead);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static IntStream streamAsInts(@Nullable byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return IntStream.empty();
        }
        return IntStream.range(0, bytes.length).map(index -> bytes[index] & 0xFF);
    }

    private static byte[] ofIntStream(@Nullable IntStream intStream) {
        if (intStream == null) {
            return new byte[0];
        }
        List listOfInts = intStream.boxed().collect(Collectors.toList());
        byte[] bytes = new byte[listOfInts.size()];
        IntStream.range(0, listOfInts.size()).forEach(index -> {
            bytes[index] = (byte)((Integer)listOfInts.get(index)).intValue();
        });
        return bytes;
    }

    public static String hexDump(@Nullable byte[] bytes, @Nullable String delimiter) {
        if (bytes == null) {
            return "";
        }
        return _Bytes.streamAsInts(bytes).mapToObj(Integer::toHexString).map(s -> s.length() == 1 ? "0" + s : s).collect(Collectors.joining(_Strings.nullToEmpty(delimiter)));
    }

    public static String hexDump(@Nullable byte[] bytes) {
        return _Bytes.hexDump(bytes, " ");
    }

    public static byte[] ofHexDump(@Nullable String hexDump, @Nullable String delimiter) {
        if (hexDump == null) {
            return new byte[0];
        }
        int delimLen = _NullSafe.size(delimiter);
        int stride = 2 + delimLen;
        IntStream intStream = IntStream.range(0, (hexDump.length() + delimLen) / stride).mapToObj(i -> {
            int start = i * stride;
            return hexDump.substring(start, start + 2);
        }).mapToInt(hex -> Integer.parseUnsignedInt(hex, 16));
        return _Bytes.ofIntStream(intStream);
    }

    public static byte[] ofHexDump(@Nullable String hexDump) {
        return _Bytes.ofHexDump(hexDump, " ");
    }

    public static byte[] nullToEmpty(byte[] bytes) {
        return bytes != null ? bytes : new byte[]{};
    }

    public static final byte[] prepend(@Nullable byte[] target, byte ... bytes) {
        if (target == null) {
            if (bytes == null) {
                return null;
            }
            return (byte[])bytes.clone();
        }
        if (bytes == null) {
            return (byte[])target.clone();
        }
        byte[] result = new byte[target.length + bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        System.arraycopy(target, 0, result, bytes.length, target.length);
        return result;
    }

    public static final byte[] append(@Nullable byte[] target, byte ... bytes) {
        if (target == null) {
            if (bytes == null) {
                return null;
            }
            return (byte[])bytes.clone();
        }
        if (bytes == null) {
            return (byte[])target.clone();
        }
        byte[] result = new byte[target.length + bytes.length];
        System.arraycopy(target, 0, result, 0, target.length);
        System.arraycopy(bytes, 0, result, target.length, bytes.length);
        return result;
    }

    public static final byte[] encodeToBase64(@NonNull Base64.Encoder encoder, @Nullable byte[] input) {
        return input != null ? encoder.encode(input) : null;
    }

    public static final byte[] decodeBase64(@NonNull Base64.Decoder decoder, @Nullable byte[] base64) {
        return base64 != null ? decoder.decode(base64) : null;
    }

    public static final byte[] compress(@Nullable byte[] input) {
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        try {
            return _Bytes_GZipCompressorSmart.compress(input);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] decompress(@Nullable byte[] compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length == 0) {
            return compressed;
        }
        try {
            return _Bytes_GZipCompressorSmart.decompress(compressed);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] compressZlib(@Nullable byte[] input) {
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        try {
            return _Bytes_ZLibCompressor.compress(input);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] decompressZlib(@Nullable byte[] compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length == 0) {
            return compressed;
        }
        try {
            return _Bytes_ZLibCompressor.decompress(compressed);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BytesOperator operator() {
        return new BytesOperator(UnaryOperator.identity());
    }

    public static final class BytesOperator {
        private final UnaryOperator<byte[]> operator;

        private BytesOperator(@NonNull UnaryOperator<byte[]> operator) {
            this.operator = operator;
        }

        public byte[] apply(byte[] input) {
            return (byte[])this.operator.apply(input);
        }

        public BytesOperator andThen(UnaryOperator<byte[]> andThen) {
            return new BytesOperator(s -> (byte[])andThen.apply((byte[])this.operator.apply((byte[])s)));
        }
    }
}

