/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collector;
import lombok.Generated;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Arrays_Collector;
import org.apache.causeway.commons.internal.collections._Arrays_CollectorUnknownSize;
import org.apache.causeway.commons.internal.collections._Collections;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ClassUtils;

public final class _Arrays {
    public static <T> boolean testAnyMatch(@Nullable T[] array1, @Nullable T[] array2, @NonNull BiPredicate<T, T> test) {
        int s2;
        int s1 = _NullSafe.size(array1);
        if (s1 != (s2 = _NullSafe.size(array2))) {
            throw new IllegalArgumentException("Array length missmatch");
        }
        if (s1 == 0) {
            return false;
        }
        for (int i = 0; i < s1; ++i) {
            if (!test.test(array1[i], array2[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean testAllMatch(@Nullable T[] array1, @Nullable T[] array2, @NonNull BiPredicate<T, T> test) {
        return !_Arrays.testAnyMatch(array1, array2, test.negate());
    }

    public static boolean isArrayType(@Nullable Class<?> cls) {
        return cls != null ? cls.isArray() : false;
    }

    public static boolean isCollectionOrArrayType(Class<?> cls) {
        return _Collections.isCollectionType(cls) || _Arrays.isArrayType(cls);
    }

    public static <T> Collector<T, ?, T[]> toArray(@NonNull Class<T> componentType, int length) {
        return new _Arrays_Collector<T>(_Arrays.resolvePrimitiveIfNecessary(componentType), length);
    }

    public static <T> Collector<T, ?, T[]> toArray(@NonNull Class<T> componentType) {
        return new _Arrays_CollectorUnknownSize<T>(_Arrays.resolvePrimitiveIfNecessary(componentType));
    }

    private static <T> Class<T> resolvePrimitiveIfNecessary(Class<T> componentType) {
        Class nonPrimitive = ClassUtils.resolvePrimitiveIfNecessary(componentType);
        return (Class)_Casts.uncheckedCast(nonPrimitive);
    }

    @SafeVarargs
    public static <T> T[] combine(@NonNull T first, T ... rest) {
        int restLength = _NullSafe.size(rest);
        Object[] all = (Object[])_Casts.uncheckedCast(Array.newInstance(first.getClass(), restLength + 1));
        all[0] = first;
        if (restLength > 0) {
            System.arraycopy(rest, 0, all, 1, restLength);
        }
        return all;
    }

    @SafeVarargs
    public static <T, X extends T, Y extends T> T[] combineWithExplicitType(@NonNull Class<T> type, @NonNull X first, Y ... rest) {
        int restLength = _NullSafe.size(rest);
        Object[] all = (Object[])_Casts.uncheckedCast(Array.newInstance(type, restLength + 1));
        all[0] = first;
        if (restLength > 0) {
            System.arraycopy(rest, 0, all, 1, restLength);
        }
        return all;
    }

    @SafeVarargs
    public static <T> T[] combine(T[] first, T ... rest) {
        int restLength;
        int firstLength = _NullSafe.size(first);
        if (firstLength + (restLength = _NullSafe.size(rest)) == 0) {
            return (Object[])_Casts.uncheckedCast(_Constants.emptyObjects);
        }
        Class<?> componentType = firstLength > 0 ? first[0].getClass() : rest[0].getClass();
        Object[] all = (Object[])_Casts.uncheckedCast(Array.newInstance(componentType, firstLength + restLength));
        System.arraycopy(first, 0, all, 0, firstLength);
        System.arraycopy(rest, 0, all, firstLength, restLength);
        return all;
    }

    public static <T> T[] toArray(@Nullable Collection<? extends T> collection, @NonNull Class<T> componentType) {
        return _NullSafe.stream(collection).collect(_Arrays.toArray(componentType, collection != null ? collection.size() : 0));
    }

    public static <T> T[] toArray(@Nullable Iterable<? extends T> iterable, @NonNull Class<T> componentType) {
        return _NullSafe.stream(iterable).collect(_Arrays.toArray(componentType));
    }

    public static <T> T[] removeByIndex(T[] array, int index) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException("Array must be of lenght 1 or larger.");
        }
        if (index < 0 || index >= array.length) {
            String msg = String.format("Array index %d is out of bounds [0, %d]", index, array.length - 1);
            throw new IllegalArgumentException(msg);
        }
        T[] result = Arrays.copyOf(array, array.length - 1);
        int remaining = result.length - index;
        System.arraycopy(array, index + 1, result, index, remaining);
        return result;
    }

    public static <T> @Nullable T[] emptyToNull(@Nullable T[] array) {
        if (array != null && array.length == 0) {
            return null;
        }
        return array;
    }

    public static <T> T[] subArray(@NonNull T[] array, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new ArrayIndexOutOfBoundsException(subLen);
        }
        return Arrays.copyOfRange(array, beginIndex, endIndex);
    }

    public static Optional<Class<?>> inferComponentType(@Nullable Class<?> arrayType) {
        if (!_Arrays.isArrayType(arrayType)) {
            return Optional.empty();
        }
        return Optional.ofNullable(arrayType.getComponentType());
    }

    public static <T> Optional<T> get(@Nullable T[] array, int index) {
        int size = _NullSafe.size(array);
        if (size == 0) {
            return Optional.empty();
        }
        int minIndex = 0;
        int maxIndex = size - 1;
        if (index < minIndex || index > maxIndex) {
            return Optional.empty();
        }
        return Optional.ofNullable(array[index]);
    }

    public static <T, R> @Nullable R[] map(@Nullable T[] array, @NonNull Class<R> resultElementType, @NonNull Function<T, R> mapper) {
        if (array == null) {
            return null;
        }
        Object[] mappedArray = (Object[])_Casts.uncheckedCast(Array.newInstance(resultElementType, array.length));
        int i = 0;
        for (T element : array) {
            mappedArray[i++] = mapper.apply(element);
        }
        return mappedArray;
    }

    public static <T> @Nullable Object[] map(@Nullable T[] array, @NonNull Function<T, ?> mapper) {
        if (array == null) {
            return null;
        }
        Object[] mappedArray = new Object[array.length];
        int i = 0;
        for (T element : array) {
            mappedArray[i++] = mapper.apply(element);
        }
        return mappedArray;
    }

    public static <T, R> @Nullable R[] mapCollection(@Nullable Collection<T> collection, @NonNull Class<R> resultElementType, @NonNull Function<T, R> mapper) {
        if (collection == null) {
            return null;
        }
        Object[] mappedArray = (Object[])_Casts.uncheckedCast(Array.newInstance(resultElementType, collection.size()));
        int i = 0;
        for (T element : collection) {
            mappedArray[i++] = mapper.apply(element);
        }
        return mappedArray;
    }

    public static <T> @Nullable Object[] mapCollection(@Nullable Collection<T> collection, @NonNull Function<T, ?> mapper) {
        if (collection == null) {
            return null;
        }
        Object[] mappedArray = new Object[collection.size()];
        int i = 0;
        for (T element : collection) {
            mappedArray[i++] = mapper.apply(element);
        }
        return mappedArray;
    }

    @Generated
    private _Arrays() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

