/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;

public record _BootstrapBadge(String caption, String faIcon, String href, String tooltip, String nestedCaption, List<String> cssClasses) {
    public String toHtml() {
        return _Strings.isNotEmpty(this.href()) ? this.link() : this.noLink();
    }

    public String noLink() {
        StringBuilder sb = new StringBuilder();
        sb.append("<span ").append("class=\"").append(this.classesLiteral("badge", "bg-light")).append("\"");
        if (_Strings.isNotEmpty(this.tooltip())) {
            sb.append(" data-bs-container=\"body\" data-bs-toggle=\"tooltip\" title=\"" + this.tooltip() + "\"");
        }
        sb.append(">");
        if (_Strings.isNotEmpty(this.faIcon())) {
            sb.append("<i class=\"").append(this.faIcon()).append("\"></i>");
        }
        sb.append(this.caption()).append("</span>");
        return sb.toString();
    }

    public String link() {
        StringBuilder sb = new StringBuilder();
        sb.append("<a ").append("class=\"").append(this.classesLiteral("btn", "btn-sm", "bg-light")).append("\"").append(" href=\"").append(this.href()).append("\"").append(" target=\"").append("_blank").append("\"");
        sb.append(">");
        sb.append(this.caption());
        if (_Strings.isNotEmpty(this.nestedCaption())) {
            sb.append(String.format(" <span class=\"badge text-sm text-bg-secondary\">%s</span>", this.nestedCaption()));
        }
        sb.append("</a>");
        return sb.toString();
    }

    private String classesLiteral(String ... primaryClasses) {
        return Stream.concat(_NullSafe.stream(primaryClasses), _NullSafe.stream(this.cssClasses)).collect(Collectors.joining(" "));
    }

    @Generated
    public static _BootstrapBadgeBuilder builder() {
        return new _BootstrapBadgeBuilder();
    }

    @Generated
    public static class _BootstrapBadgeBuilder {
        @Generated
        private String caption;
        @Generated
        private String faIcon;
        @Generated
        private String href;
        @Generated
        private String tooltip;
        @Generated
        private String nestedCaption;
        @Generated
        private ArrayList<String> cssClasses;

        @Generated
        _BootstrapBadgeBuilder() {
        }

        @Generated
        public _BootstrapBadgeBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder faIcon(String faIcon) {
            this.faIcon = faIcon;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder href(String href) {
            this.href = href;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder nestedCaption(String nestedCaption) {
            this.nestedCaption = nestedCaption;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder cssClass(String cssClass) {
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.add(cssClass);
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder cssClasses(Collection<? extends String> cssClasses) {
            if (cssClasses == null) {
                throw new NullPointerException("cssClasses cannot be null");
            }
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.addAll(cssClasses);
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder clearCssClasses() {
            if (this.cssClasses != null) {
                this.cssClasses.clear();
            }
            return this;
        }

        @Generated
        public _BootstrapBadge build() {
            return new _BootstrapBadge(this.caption, this.faIcon, this.href, this.tooltip, this.nestedCaption, switch (this.cssClasses == null ? 0 : this.cssClasses.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.cssClasses.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.cssClasses));
            });
        }

        @Generated
        public String toString() {
            return "_BootstrapBadge._BootstrapBadgeBuilder(caption=" + this.caption + ", faIcon=" + this.faIcon + ", href=" + this.href + ", tooltip=" + this.tooltip + ", nestedCaption=" + this.nestedCaption + ", cssClasses=" + String.valueOf(this.cssClasses) + ")";
        }
    }
}

