/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.causeway.commons.functional.Try;
import org.jspecify.annotations.NonNull;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingSupplier;

@FunctionalInterface
public interface DataSink {
    public void writeAll(@NonNull ThrowingConsumer<OutputStream> var1);

    public static DataSink none() {
        return consumingMapper -> {};
    }

    public static DataSink ofOutputStreamSupplier(final @NonNull ThrowingSupplier<OutputStream> outputStreamSupplier) {
        return new DataSink(){

            @Override
            public void writeAll(@NonNull ThrowingConsumer<OutputStream> outputStreamConsumer) {
                try (OutputStream os = (OutputStream)outputStreamSupplier.get();){
                    outputStreamConsumer.accept((Object)os);
                }
            }
        };
    }

    public static DataSink ofByteArrayConsumer(final @NonNull ThrowingConsumer<byte[]> byteArrayConsumer, final int initalBufferSize) {
        return new DataSink(){

            @Override
            public void writeAll(@NonNull ThrowingConsumer<OutputStream> outputStreamConsumer) {
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream(initalBufferSize);){
                    outputStreamConsumer.accept((Object)bos);
                    byteArrayConsumer.accept((Object)bos.toByteArray());
                }
            }
        };
    }

    public static DataSink ofByteArrayConsumer(@NonNull ThrowingConsumer<byte[]> byteArrayConsumer) {
        return DataSink.ofByteArrayConsumer(byteArrayConsumer, 32);
    }

    public static DataSink ofFile(@NonNull File file) {
        return DataSink.ofOutputStreamSupplier((ThrowingSupplier<OutputStream>)((ThrowingSupplier)() -> Try.call(() -> new FileOutputStream(file)).valueAsNonNullElseFail()));
    }

    public static DataSink ofStringConsumer(@NonNull Consumer<String> stringConsumer, @NonNull Charset charset) {
        return DataSink.ofByteArrayConsumer((ThrowingConsumer<byte[]>)((ThrowingConsumer)bytes -> stringConsumer.accept(new String((byte[])bytes, charset))));
    }

    public static DataSink ofStringUtf8Consumer(@NonNull Consumer<String> stringUtf8Consumer) {
        return DataSink.ofStringConsumer(stringUtf8Consumer, StandardCharsets.UTF_8);
    }

    public static DataSink ofStringConsumer(@NonNull StringBuilder stringConsumer, @NonNull Charset charset) {
        return DataSink.ofByteArrayConsumer((ThrowingConsumer<byte[]>)((ThrowingConsumer)bytes -> stringConsumer.append(new String((byte[])bytes, charset))));
    }

    public static DataSink ofStringUtf8Consumer(@NonNull StringBuilder stringUtf8Consumer) {
        return DataSink.ofStringConsumer(stringUtf8Consumer, StandardCharsets.UTF_8);
    }
}

