/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.commons.integration.changetracking;

import jakarta.inject.Provider;
import java.awt.Color;
import org.apache.causeway.applib.services.iactn.InteractionProvider;
import org.apache.causeway.commons.internal.debug._XrayEvent;
import org.apache.causeway.commons.internal.debug.xray.XrayUi;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.security.util.XrayUtil;
import org.apache.causeway.persistence.commons.integration.changetracking.EntityChangeTrackerDefault;

final class _Xray {
    _Xray() {
    }

    public static void publish(EntityChangeTrackerDefault entityChangeTrackerDefault, Provider<InteractionProvider> interactionProviderProvider) {
        if (!XrayUi.isXrayEnabled()) {
            return;
        }
        long propertyChangeRecordCount = entityChangeTrackerDefault.countPotentialPropertyChangeRecords();
        String enteringLabel = String.format("consider %d entity change records for publishing", propertyChangeRecordCount);
        XrayUtil.createSequenceHandle((InteractionProvider)((InteractionProvider)interactionProviderProvider.get()), (String[])new String[]{"ec-tracker"}).ifPresent(handle -> handle.submit(sequenceData -> {
            sequenceData.alias("ec-tracker", "EntityChange-\nTracker-\n(Default)");
            if (propertyChangeRecordCount == 0L) {
                sequenceData.setConnectionArrowColor(Color.GRAY);
                sequenceData.setConnectionLabelColor(Color.GRAY);
            }
            String callee = (String)handle.getCallees().getFirstElseFail();
            sequenceData.enter(handle.getCaller(), callee, enteringLabel);
        }));
    }

    public static void enlistCreated(ManagedObject entity, Provider<InteractionProvider> interactionProviderProvider) {
        _Xray.addSequence("enlistCreated", entity, interactionProviderProvider);
    }

    public static void enlistDeleting(ManagedObject entity, Provider<InteractionProvider> interactionProviderProvider) {
        _Xray.addSequence("enlistDeleting", entity, interactionProviderProvider);
    }

    public static void enlistUpdating(ManagedObject entity, Provider<InteractionProvider> interactionProviderProvider) {
        _Xray.addSequence("enlistUpdating", entity, interactionProviderProvider);
    }

    public static void recognizeLoaded(ManagedObject entity, Provider<InteractionProvider> interactionProviderProvider) {
        _Xray.addSequence("recognizeLoaded", entity, interactionProviderProvider);
    }

    private static void addSequence(String what, ManagedObject entity, Provider<InteractionProvider> interactionProviderProvider) {
        if (!XrayUi.isXrayEnabled()) {
            return;
        }
        String enteringLabel = String.format("%s %s", what, ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)entity) ? "<empty>" : String.format("%s:\n%s", entity.getSpecification().logicalTypeName(), String.valueOf(entity.getPojo())));
        _XrayEvent.event((String)enteringLabel, (Object[])new Object[0]);
        XrayUtil.createSequenceHandle((InteractionProvider)((InteractionProvider)interactionProviderProvider.get()), (String[])new String[]{"ec-tracker"}).ifPresent(handle -> handle.submit(sequenceData -> {
            sequenceData.alias("ec-tracker", "EntityChange-\nTracker-\n(Default)");
            String callee = (String)handle.getCallees().getFirstElseFail();
            sequenceData.enter(handle.getCaller(), callee, enteringLabel);
        }));
    }
}

