/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.commons.integration.changetracking;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.annotation.EntityChangeKind;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.TransactionScope;
import org.apache.causeway.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.iactn.Interaction;
import org.apache.causeway.applib.services.iactn.InteractionProvider;
import org.apache.causeway.applib.services.metrics.MetricsService;
import org.apache.causeway.applib.services.publishing.spi.EntityChanges;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.causeway.applib.services.xactn.TransactionId;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.execution.InteractionInternal;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facets.object.publish.entitychange.EntityChangePublishingFacet;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmEntityUtils;
import org.apache.causeway.core.metamodel.services.deadlock.DeadlockRecognizer;
import org.apache.causeway.core.metamodel.services.objectlifecycle.HasEnlistedEntityPropertyChanges;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PreAndPostValue;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecord;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecordId;
import org.apache.causeway.core.runtime.flushmgmt.FlushMgmt;
import org.apache.causeway.core.transaction.changetracking.EntityChangeTracker;
import org.apache.causeway.core.transaction.changetracking.EntityChangesPublisher;
import org.apache.causeway.core.transaction.changetracking.EntityPropertyChangePublisher;
import org.apache.causeway.core.transaction.changetracking.HasEnlistedEntityChanges;
import org.apache.causeway.persistence.commons.integration.changetracking.PreAndPostValueEvaluatorService;
import org.apache.causeway.persistence.commons.integration.changetracking._SimpleChangingEntities;
import org.apache.causeway.persistence.commons.integration.changetracking._Xray;
import org.apache.causeway.schema.chg.v2.ChangesDto;
import org.apache.causeway.schema.chg.v2.ObjectsDto;
import org.apache.causeway.schema.common.v2.OidDto;
import org.apache.causeway.schema.common.v2.OidsDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;

@Service
@TransactionScope
@Named(value="causeway.persistence.commons.EntityChangeTrackerDefault")
@Qualifier(value="default")
public class EntityChangeTrackerDefault
implements MetricsService,
EntityChangeTracker,
HasEnlistedEntityPropertyChanges,
HasEnlistedEntityChanges,
TransactionSynchronization,
Ordered {
    @Generated
    private static final Logger log = LogManager.getLogger(EntityChangeTrackerDefault.class);
    static AtomicInteger transactionCounter = new AtomicInteger(0);
    private final EntityPropertyChangePublisher entityPropertyChangePublisher;
    private final EntityChangesPublisher entityChangesPublisher;
    private final Provider<InteractionProvider> interactionProviderProvider;
    private final PreAndPostValueEvaluatorService preAndPostValueEvaluatorService;
    private final Map<PropertyChangeRecordId, PropertyChangeRecord> enlistedPropertyChangeRecordsById = _Maps.newLinkedHashMap();
    private final _Lazy<Changes> changes = _Lazy.of(this::evaluateChanges);
    private final Map<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter = _Maps.newHashMap();
    private final LongAdder numberEntitiesLoaded = new LongAdder();
    private final LongAdder entityChangeEventCount = new LongAdder();
    private final AtomicBoolean persistentChangesEncountered = new AtomicBoolean();
    @Inject
    private Configuration configuration;
    @Inject
    private CausewayConfiguration causewayConfiguration;
    @Inject
    private DeadlockRecognizer deadlockRecognizer;

    @Inject
    public EntityChangeTrackerDefault(EntityPropertyChangePublisher entityPropertyChangePublisher, EntityChangesPublisher entityChangesPublisher, Provider<InteractionProvider> interactionProviderProvider, PreAndPostValueEvaluatorService preAndPostValueEvaluatorService) {
        if (log.isDebugEnabled()) {
            UUID interactionId = ((InteractionProvider)interactionProviderProvider.get()).currentInteraction().map(Interaction::getInteractionId).orElseGet(null);
            log.debug("EntityChangeTrackerDefault.new xactn={} interactionId={} thread={}", (Object)transactionCounter.incrementAndGet(), (Object)interactionId, (Object)Thread.currentThread().getName());
        }
        this.entityPropertyChangePublisher = entityPropertyChangePublisher;
        this.entityChangesPublisher = entityChangesPublisher;
        this.interactionProviderProvider = interactionProviderProvider;
        this.preAndPostValueEvaluatorService = preAndPostValueEvaluatorService;
    }

    @Programmatic
    public int getOrder() {
        return 0x1FFFFFFF;
    }

    private void addPropertyChangeRecordIfAbsent(PropertyChangeRecordId pcrId, PropertyChangeRecord pcr) {
        this.enlistedPropertyChangeRecordsById.computeIfAbsent(pcrId, id -> pcr);
    }

    private void addPropertyChangeRecordIfAbsent(PropertyChangeRecordId pcrId, Function<PropertyChangeRecordId, PropertyChangeRecord> func) {
        this.enlistedPropertyChangeRecordsById.computeIfAbsent(pcrId, func);
    }

    private Changes evaluateChanges() {
        Set<PropertyChangeRecord> changedProperties = this.evaluateChangedProperties();
        boolean isCountersAndDetail = this.causewayConfiguration.getApplib().getService().getMetricsService().getLevel().isCountersAndDetail();
        Set<Bookmark> loadedBookmarks = isCountersAndDetail ? this.enlistedPropertyChangeRecordsById.keySet().stream().map(PropertyChangeRecordId::getBookmark).collect(Collectors.toSet()) : Collections.emptySet();
        Set<Bookmark> dirtiedBookmarks = isCountersAndDetail ? changedProperties.stream().map(PropertyChangeRecord::getBookmark).collect(Collectors.toSet()) : Collections.emptySet();
        this.enlistedPropertyChangeRecordsById.clear();
        return new Changes(changedProperties, loadedBookmarks, dirtiedBookmarks);
    }

    private Set<PropertyChangeRecord> evaluateChangedProperties() {
        Set<PropertyChangeRecord> dirtiedProperties;
        try {
            dirtiedProperties = this.changedRecords(this.enlistedPropertyChangeRecordsById.values());
        }
        catch (ConcurrentModificationException ex) {
            log.warn("A concurrent modification exception, one of these properties seemed to change as we looked at it :\n" + this.enlistedPropertyChangeRecordsById.keySet().stream().map(PropertyChangeRecordId::toString).collect(Collectors.joining("\n")));
            dirtiedProperties = this.changedRecords(new ArrayList<PropertyChangeRecord>(this.enlistedPropertyChangeRecordsById.values()));
        }
        return dirtiedProperties;
    }

    private Set<PropertyChangeRecord> changedRecords(Collection<PropertyChangeRecord> propertyChangeRecords) throws ConcurrentModificationException {
        return (Set)propertyChangeRecords.stream().peek(rec -> {
            if (MmEntityUtils.getEntityState((ManagedObject)rec.getEntity()).isTransientOrRemoved()) {
                rec.withPostValueSetToDeleted();
            } else {
                rec.withPostValueSetToCurrentElseUnknown(this.deadlockRecognizer);
            }
        }).filter(managedProperty -> this.shouldPublish(managedProperty.getPreAndPostValue())).collect(_Sets.toUnmodifiable());
    }

    private Changes memoizeChangesIfRequired() {
        return (Changes)this.changes.get();
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            UUID interactionId = ((InteractionProvider)this.interactionProviderProvider.get()).currentInteraction().map(Interaction::getInteractionId).orElse(null);
            log.debug("EntityChangeTrackerDefault.destroy xactn={} interactionId={} thread={}", (Object)transactionCounter.get(), (Object)interactionId, (Object)Thread.currentThread().getName());
        }
        this.clearAndReset();
    }

    private void clearAndReset() {
        this.enlistedPropertyChangeRecordsById.clear();
        this.changes.clear();
        this.changeKindByEnlistedAdapter.clear();
        this.numberEntitiesLoaded.reset();
        this.entityChangeEventCount.reset();
        this.persistentChangesEncountered.set(false);
    }

    private void suppressAutoFlushIfRequired(Runnable runnable) {
        if (this.configuration.isSuppressAutoFlush()) {
            FlushMgmt.suppressAutoFlush((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    private boolean shouldPublish(PreAndPostValue preAndPostValue) {
        return this.preAndPostValueEvaluatorService.differ(preAndPostValue);
    }

    private boolean isEntityExcludedForChangePublishing(ManagedObject entity) {
        if (!this.configuration.isEnabled()) {
            return true;
        }
        if (!EntityChangePublishingFacet.isPublishingEnabled((FacetHolder)entity.objSpec())) {
            return true;
        }
        if (ManagedObjects.bookmark((ManagedObject)entity).isEmpty()) {
            return true;
        }
        if (this.changes.isMemoized()) {
            throw _Exceptions.illegalState((String)"Cannot enlist additional changes for auditing, since changedObjectPropertiesRef was already prepared (memoized) for auditing.", (Object[])new Object[0]);
        }
        return false;
    }

    public void beforeCommit(boolean readOnly) {
        _Xray.publish(this, this.interactionProviderProvider);
        if (log.isDebugEnabled()) {
            UUID interactionId = ((InteractionProvider)this.interactionProviderProvider.get()).currentInteraction().map(Interaction::getInteractionId).orElse(null);
            log.debug("EntityChangeTrackerDefault.beforeCommit(readOnly={}) xactn={} interactionId={} thread={}", (Object)readOnly, (Object)transactionCounter.get(), (Object)interactionId, (Object)Thread.currentThread().getName());
        }
        this.memoizeChangesIfRequired();
        this.entityPropertyChangePublisher.publishChangedProperties();
        this.entityChangesPublisher.publishChangingEntities((HasEnlistedEntityChanges)this);
    }

    public void afterCompletion(int status) {
        if (log.isDebugEnabled()) {
            UUID interactionId = ((InteractionProvider)this.interactionProviderProvider.get()).currentInteraction().map(Interaction::getInteractionId).orElse(null);
            log.debug("EntityChangeTrackerDefault.afterCompletion(status={}) xactn={} interactionId={} thread={}", (Object)EntityChangeTrackerDefault.decodeStatus(status), (Object)transactionCounter.get(), (Object)interactionId, (Object)Thread.currentThread().getName());
        }
        this.clearAndReset();
    }

    private static String decodeStatus(int status) {
        if (status == 0) {
            return "STATUS_COMMITTED";
        }
        if (status == 1) {
            return "STATUS_ROLLED_BACK";
        }
        if (status == 2) {
            return "STATUS_UNKNOWN";
        }
        return status + " [not recognised]";
    }

    private void enableCommandPublishing() {
        boolean alreadySet = this.persistentChangesEncountered.getAndSet(true);
        if (!alreadySet) {
            Command command = this.currentInteraction().getCommand();
        }
    }

    public Optional<EntityChanges> getEntityChanges(Timestamp timestamp, String userName) {
        HashMap<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter = new HashMap<Bookmark, EntityChangeKind>(this.changeKindByEnlistedAdapter);
        if (changeKindByEnlistedAdapter.isEmpty()) {
            return Optional.empty();
        }
        Interaction interaction = this.currentInteraction();
        int numberEntitiesLoaded1 = this.numberEntitiesLoaded();
        int numberEntityPropertiesModified = this.memoizeChangesIfRequired().dirtiedProperties.size();
        UUID interactionId = interaction.getInteractionId();
        int nextEventSequence = ((InteractionInternal)interaction).getThenIncrementTransactionSequence();
        _SimpleChangingEntities changingEntities = new _SimpleChangingEntities(interactionId, nextEventSequence, userName, timestamp, numberEntitiesLoaded1, numberEntityPropertiesModified, () -> EntityChangeTrackerDefault.newDto(interactionId, nextEventSequence, userName, timestamp, numberEntitiesLoaded1, numberEntityPropertiesModified, changeKindByEnlistedAdapter));
        return Optional.of(changingEntities);
    }

    private static ChangesDto newDto(UUID interactionId, int transactionSequenceNum, String userName, Timestamp completedAt, int numberEntitiesLoaded, int numberEntityPropertiesModified, Map<Bookmark, EntityChangeKind> changeKindByEnlistedEntity) {
        ObjectsDto objectsDto = new ObjectsDto();
        objectsDto.setCreated(new OidsDto());
        objectsDto.setUpdated(new OidsDto());
        objectsDto.setDeleted(new OidsDto());
        changeKindByEnlistedEntity.forEach((bookmark, kind) -> {
            OidDto oidDto = bookmark.toOidDto();
            if (oidDto == null) {
                return;
            }
            switch (kind) {
                case CREATE: {
                    objectsDto.getCreated().getOid().add(oidDto);
                    return;
                }
                case UPDATE: {
                    objectsDto.getUpdated().getOid().add(oidDto);
                    return;
                }
                case DELETE: {
                    objectsDto.getDeleted().getOid().add(oidDto);
                    return;
                }
            }
        });
        objectsDto.setLoaded(numberEntitiesLoaded);
        objectsDto.setPropertiesModified(numberEntityPropertiesModified);
        ChangesDto changesDto = new ChangesDto();
        changesDto.setMajorVersion("2");
        changesDto.setMinorVersion("0");
        changesDto.setInteractionId(interactionId.toString());
        changesDto.setSequence(transactionSequenceNum);
        changesDto.setUsername(userName);
        changesDto.setCompletedAt(JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar((Timestamp)completedAt));
        changesDto.setObjects(objectsDto);
        return changesDto;
    }

    public Can<EntityPropertyChange> getPropertyChanges(Timestamp timestamp, String userName, TransactionId txId) {
        Set<PropertyChangeRecord> propertyChangeRecords = this.memoizeChangesIfRequired().getDirtiedProperties();
        return (Can)propertyChangeRecords.stream().map(propertyChangeRecord -> propertyChangeRecord.toEntityPropertyChange(timestamp, userName, txId)).collect(Can.toCan());
    }

    Interaction currentInteraction() {
        return ((InteractionProvider)this.interactionProviderProvider.get()).currentInteractionElseFail();
    }

    private boolean enlistForChangeKindPublishing(@NonNull ManagedObject entity, @NonNull EntityChangeKind changeKind) {
        this.entityChangeEventCount.increment();
        this.enableCommandPublishing();
        Bookmark bookmark = ManagedObjects.bookmarkElseFail((ManagedObject)entity);
        EntityChangeKind previousChangeKind = this.changeKindByEnlistedAdapter.get(bookmark);
        if (previousChangeKind == null) {
            this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
            return true;
        }
        switch (previousChangeKind) {
            case CREATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(bookmark);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return false;
    }

    long countPotentialPropertyChangeRecords() {
        return this.enlistedPropertyChangeRecordsById.size();
    }

    public void enlistCreated(ManagedObject entity) {
        _Xray.enlistCreated(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        log.debug("enlist entity's property changes for publishing {}", (Object)entity);
        this.suppressAutoFlushIfRequired(() -> {
            this.enlistForChangeKindPublishing(entity, EntityChangeKind.CREATE);
            MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).forEach(pcrId -> this.addPropertyChangeRecordIfAbsent((PropertyChangeRecordId)pcrId, PropertyChangeRecord.ofNew((PropertyChangeRecordId)pcrId)));
        });
    }

    public void enlistUpdating(ManagedObject entity, @Nullable Function<ManagedObject, Can<PropertyChangeRecord>> propertyChangeRecordSupplier) {
        _Xray.enlistUpdating(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("enlist entity's property changes for publishing {}", (Object)entity);
        }
        this.suppressAutoFlushIfRequired(() -> {
            Can ormPropertyChangeRecords;
            this.enlistForChangeKindPublishing(entity, EntityChangeKind.UPDATE);
            Can can = ormPropertyChangeRecords = propertyChangeRecordSupplier != null ? (Can)propertyChangeRecordSupplier.apply(entity) : null;
            if (ormPropertyChangeRecords != null) {
                ormPropertyChangeRecords.stream().forEach(pcr -> this.addPropertyChangeRecordIfAbsent(pcr.getId(), (PropertyChangeRecord)pcr));
            } else {
                MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).forEach(pcrId -> this.addPropertyChangeRecordIfAbsent((PropertyChangeRecordId)pcrId, PropertyChangeRecord.ofCurrent((PropertyChangeRecordId)pcrId, (DeadlockRecognizer)this.deadlockRecognizer)));
            }
        });
    }

    public void enlistDeleting(ManagedObject entity) {
        _Xray.enlistDeleting(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        this.suppressAutoFlushIfRequired(() -> {
            boolean enlisted = this.enlistForChangeKindPublishing(entity, EntityChangeKind.DELETE);
            if (enlisted) {
                if (log.isDebugEnabled()) {
                    log.debug("enlist entity's property changes for publishing {}", (Object)entity);
                }
                MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).forEach(pcrId -> this.addPropertyChangeRecordIfAbsent((PropertyChangeRecordId)pcrId, (PropertyChangeRecordId id) -> PropertyChangeRecord.ofDeleting((PropertyChangeRecordId)id, (DeadlockRecognizer)this.deadlockRecognizer)));
            }
        });
    }

    public void incrementLoaded(ManagedObject entity) {
        _Xray.recognizeLoaded(entity, this.interactionProviderProvider);
        this.numberEntitiesLoaded.increment();
    }

    public int numberEntitiesLoaded() {
        return Math.toIntExact(this.numberEntitiesLoaded.longValue());
    }

    public int numberEntitiesDirtied() {
        return this.changeKindByEnlistedAdapter.size();
    }

    public Set<Bookmark> entitiesLoaded() {
        return this.memoizeChangesIfRequired().getLoadedBookmarks();
    }

    public Set<Bookmark> entitiesDirtied() {
        return this.memoizeChangesIfRequired().getDirtiedBookmarks();
    }

    static class Changes {
        private final Set<PropertyChangeRecord> dirtiedProperties;
        private final Set<Bookmark> loadedBookmarks;
        private final Set<Bookmark> dirtiedBookmarks;

        @Generated
        public Changes(Set<PropertyChangeRecord> dirtiedProperties, Set<Bookmark> loadedBookmarks, Set<Bookmark> dirtiedBookmarks) {
            this.dirtiedProperties = dirtiedProperties;
            this.loadedBookmarks = loadedBookmarks;
            this.dirtiedBookmarks = dirtiedBookmarks;
        }

        @Generated
        public Set<PropertyChangeRecord> getDirtiedProperties() {
            return this.dirtiedProperties;
        }

        @Generated
        public Set<Bookmark> getLoadedBookmarks() {
            return this.loadedBookmarks;
        }

        @Generated
        public Set<Bookmark> getDirtiedBookmarks() {
            return this.dirtiedBookmarks;
        }
    }

    public static interface Configuration {
        public boolean isSuppressAutoFlush();

        public boolean isEnabled();
    }

    @Component
    @Priority(value=0x5FFFFFFF)
    @ConditionalOnMissingBean(value={Configuration.class})
    public static class ConfigurationDefault
    implements Configuration {
        private final CausewayConfiguration causewayConfiguration;

        @Override
        public boolean isSuppressAutoFlush() {
            return this.causewayConfiguration.getPersistence().getCommons().getEntityChangeTracker().isSuppressAutoFlush();
        }

        @Override
        public boolean isEnabled() {
            return this.causewayConfiguration.getPersistence().getCommons().getEntityChangeTracker().isEnabled();
        }

        @Inject
        @Generated
        public ConfigurationDefault(CausewayConfiguration causewayConfiguration) {
            this.causewayConfiguration = causewayConfiguration;
        }
    }
}

